<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1021924 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mpm_netware.xml.meta">
<name>mpm_netware</name>
<description>Module multi-processus implémentant un serveur web basé
exclusivement sur les threads et optimisé pour Novell
NetWare</description>
<status>MPM</status>
<sourcefile>mpm_netware.c</sourcefile>
<identifier>mpm_netware_module</identifier>

<summary>
    <p>Ce module multi-processus (MPM) implémente un serveur web basé
    exclusivement sur les threads et optimisé pour Novell NetWare.</p>

    <p>Le thread maître est chargé du lancement de threads esclaves qui
    attendent les connexions et les traitent au fur et à mesure de leur
    arrivée. Le serveur HTTP Apache essaie toujours de maintenir
    plusieurs threads
    esclaves en <dfn>spare</dfn> (en réserve) ou inactifs. De cette
    façon, les clients n'ont pas besoin d'attendre le lancement d'un
    nouveau thread enfant pour que leurs requêtes soient traitées.</p>

    <p>Les directives <directive
    module="mpm_common">StartThreads</directive>, <directive
    module="mpm_common">MinSpareThreads</directive>, <directive
    module="mpm_common">MaxSpareThreads</directive>, et <directive
    module="mpm_netware">MaxThreads</directive> contrôlent
    la manière dont le thread maître crée les threads esclaves afin de
    traiter les requêtes. En général, Apache httpd s'auto-régule correctement,
    et la plupart des sites ne nécessitent aucune modification des
    valeurs par défaut de ces directives. Pour les sites dont le serveur
    est limité en mémoire, il peut s'avérer nécessaire de diminuer la
    valeur de la directive <directive
    module="mpm_netware">MaxThreads</directive> afin d'éviter une
    hyper-activité du serveur (arrêts de threads inactifs et lancement incessant
    de nouveau threads). Vous trouverez plus d'informations à
    propos du contrôle de la création de processus dans le document <a
    href="../misc/perf-tuning.html">conseils en matière de
    performances</a>.</p>

    <p>La directive <directive
    module="mpm_common">MaxRequestsPerChild</directive>
    contrôle la fréquence à laquelle le serveur recycle ses processus
    en arrêtant les anciens et en en lançant de nouveaux. Sous le
    système d'exploitation NetWare, il est vivement recommandé de
    laisser cette directive à 0, ce qui permet aux threads esclaves de
    continuer à traiter les requêtes indéfiniment.</p>
</summary>
<seealso><a href="../bind.html">Définition des adresses et ports
qu'utilise Apache httpd</a>
</seealso>

<directivesynopsis location="mpm_common"><name>Listen</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ListenBacklog</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxMemFree</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxRequestsPerChild</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ReceiveBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>SendBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxSpareThreads</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MinSpareThreads</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>StartThreads</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadStackSize</name>
</directivesynopsis>

<directivesynopsis>
<name>MaxThreads</name>
<description>Définit le nombre maximum de threads esclaves</description>
<syntax>MaxThreads <var>nombre</var></syntax>
<default>MaxThreads 2048</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>MaxThreads</directive> définit
    le nombre maximum de threads esclaves que l'on désire autoriser. La
    valeur par défaut correspondant à la valeur codée en dur à la
    compilation, la valeur de cette directive ne peut donc qu'être
    diminuée, comme dans l'exemple suivant :</p>

    <example>
      MaxThreads 512
    </example>
</usage>
</directivesynopsis>

</modulesynopsis>
