<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1500428 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_session_dbd.xml.meta">

<name>mod_session_dbd</name>
<description>Support des session bas&eacute; sur DBD/SQL</description>
<status>Extension</status>
<sourcefile>mod_session_dbd.c</sourcefile>
<identifier>session_dbd_module</identifier>
<compatibility>Disponible depuis la version 2.3 d'Apache</compatibility>

<summary>
    <note type="warning"><title>Avertissement</title>
      <p>Les modules de session font usage des cookies HTTP, et peuvent
      &agrave; ce titre &ecirc;tre victimes d'attaques de type Cross Site Scripting,
      ou divulguer des informations &agrave; caract&egrave;re priv&eacute; aux clients.
      Veuillez vous assurer que les risques ainsi encourus ont &eacute;t&eacute; pris
      en compte avant d'activer le support des sessions sur votre
      serveur.</p>
    </note>

    <p>Ce sous-module du module <module>mod_session</module> fournit le
    support du stockage des sessions utilisateur dans une base de
    donn&eacute;es SQL en utilisant le module <module>mod_dbd</module>.</p>

    <p>Les sessions sont soit <strong>anonymes</strong>, et la session
    est alors identifi&eacute;e par un UUID unique stock&eacute; dans un cookie au
    niveau du navigateur, soit <strong>propres &agrave; l'utilisateur</strong>,
    et la session est alors identifi&eacute;e par l'identifiant de
    l'utilisateur connect&eacute;.</p>

    <p>Les sessions bas&eacute;es sur SQL sont dissimul&eacute;es au navigateur, et
    permettent ainsi de pr&eacute;server la confidentialit&eacute; sans avoir recours
    au chiffrement.</p>

    <p>Plusieurs serveurs web d'une for&ecirc;t de serveurs peuvent choisir de
    partager une base de donn&eacute;es, et ainsi partager les sessions entre
    eux.</p>

    <p>Pour plus de d&eacute;tails &agrave; propos de l'interface des sessions, voir
    la documentation du module <module>mod_session</module>.</p>

</summary>
<seealso><module>mod_session</module></seealso>
<seealso><module>mod_session_crypto</module></seealso>
<seealso><module>mod_session_cookie</module></seealso>
<seealso><module>mod_dbd</module></seealso>

    <section id="dbdconfig"><title>Configuration de DBD</title>

      <p>Pour que le module <module>mod_session_dbd</module> puisse &ecirc;tre
      configur&eacute; et maintenir une session, il faut tout d'abord
      configurer le module <module>mod_dbd</module> pour que le serveur
      puisse ex&eacute;cuter des requ&ecirc;tes vers la base de donn&eacute;es.</p>

      <p>Quatre types de requ&ecirc;tes sont n&eacute;cessaires pour maintenir une
      session, s&eacute;lectionner ou mettre &agrave; jour une session existante,
      ins&eacute;rer une nouvelle session et supprimer une session vide ou
      arriv&eacute;e &agrave; expiration. Ces requ&ecirc;tes sont configur&eacute;es comme dans
      l'exemple suivant :</p>

      <example><title>Exemple de configuration de DBD</title>
        <highlight language="config">
DBDriver pgsql
DBDParams "dbname=apachesession user=apache password=xxxxx host=localhost"
DBDPrepareSQL "delete from session where key = %s" deletesession
DBDPrepareSQL "update session set value = %s, expiry = %lld, key = %s where key = %s" updatesession
DBDPrepareSQL "insert into session (value, expiry, key) values (%s, %lld, %s)" insertsession
DBDPrepareSQL "select value from session where key = %s and (expiry = 0 or expiry &gt; %lld)" selectsession
DBDPrepareSQL "delete from session where expiry != 0 and expiry &lt; %lld" cleansession
    </highlight>
      </example>

    </section>

    <section id="anonymous"><title>Sessions anonymes</title>

      <p>Les sessions anonymes sont identifi&eacute;es par un UUID unique, et
      stock&eacute;es dans un cookie au niveau du navigateur. Cette m&eacute;thode est
      similaire &agrave; celle utilis&eacute;e par la plupart des serveurs
      d'applications pour stocker les informations de session.</p>

      <p>Pour cr&eacute;er une session anonyme, la stocker dans une table de
      base de donn&eacute;e postgres nomm&eacute;e <var>apachesession</var>, et
      sauvegarder l'identifiant de session dans un cookie nomm&eacute;
      <var>session</var>, configurez la session comme suit :</p>

      <example><title>Session anonyme bas&eacute;e sur SQL</title>
        <highlight language="config">
Session On
SessionDBDCookieName session path=/
        </highlight>
      </example>

      <p>Pour plus d'exemples sur la mani&egrave;re dont une application CGI
      peut acc&eacute;der aux informations de session, voir la section exemples
      de la documentation du module <module>mod_session</module>.</p>

      <p>Pour des d&eacute;tails sur la mani&egrave;re dont une session peut &ecirc;tre
      utilis&eacute;e pour stocker des informations de type nom
      d'utilisateur/mot de passe, voir la documentation du module
      <module>mod_auth_form</module>.</p>

    </section>

    <section id="peruser"><title>Sessions propres &agrave; un
    utilisateur</title>

      <p>Les sessions propres &agrave; un utilisateur sont identifi&eacute;es par le
      nom de l'utilisateur authentifi&eacute; avec succ&egrave;s. Ceci permet
      d'assurer une confidentialit&eacute; optimale, car aucun traitement
      externe &agrave; la session n'existe en dehors du contexte
      authentifi&eacute;.</p>

      <p>Les sessions propres &agrave; un utilisateur ne fonctionnent que dans
      un environnement d'authentification correctement configur&eacute;, qu'il
      s'agisse d'une authentification de base, &agrave; base de condens&eacute;s
      (digest) ou de certificats client SSL. Suite &agrave; des limitations
      dues &agrave; des d&eacute;pendances mutuelles, les sessions propres &agrave; un
      utilisateur ne peuvent pas &ecirc;tre utilis&eacute;es pour stocker les donn&eacute;es
      d'authentification en provenance d'un module comme
      <module>mod_auth_form</module>.</p>

      <p>Pour cr&eacute;er une session propre &agrave; un utilisateur, la stocker dans
      une table de base de donn&eacute;es postgres nomm&eacute;e
      <var>apachesession</var>, avec comme cl&eacute; de session l'identifiant
      utilisateur, ajoutez les lignes suivantes :</p>

      <example><title>Session propre &agrave; un utilisateur bas&eacute;e sur SQL</title>
        <highlight language="config">
Session On
SessionDBDPerUser On
        </highlight>
      </example>

    </section>

    <section id="housekeeping"><title>Nettoyage de la base de
    donn&eacute;es</title>
      <p>Avec le temps, la base de donn&eacute;es va commencer &agrave; accumuler des
      sessions expir&eacute;es. Pour le moment, le module
      <module>mod_session_dbd</module> n'est pas en mesure de g&eacute;rer
      automatiquement l'expiration des sessions.</p>

      <note type="warning"><title>Avertissement</title>
      <p>L'administrateur devra mettre en oeuvre un traitement externe
      via cron pour nettoyer les sessions expir&eacute;es.</p>
      </note>

    </section>

<directivesynopsis>
<name>SessionDBDCookieName</name>
<description>Nom et attributs du cookie RFC2109 qui contient
l'identifiant de session</description>
<syntax>SessionDBDCookieName <var>nom</var> <var>attributs</var></syntax>
<default>none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDCookieName</directive> permet
    de sp&eacute;cifier le nom et les attributs optionnels d'un cookie
    compatible RFC2109 qui contiendra l'identifiant de session. Les
    cookies RFC2109 sont d&eacute;finis &agrave; l'aide de l'en-t&ecirc;te HTTP
    <code>Set-Cookie</code>.
    </p>

    <p>Une liste optionnelle d'attributs peut &ecirc;tre sp&eacute;cifi&eacute;e pour ce
    cookie, comme dans l'exemple ci-dessous. Ces attributs sont ins&eacute;r&eacute;s
    dans le cookie tels quels, et ne sont pas interpr&eacute;t&eacute;s par Apache.
    Assurez-vous que vos attributs sont d&eacute;finis correctement selon la
    sp&eacute;cification des cookies.
    </p>

    <example><title>Cookie avec attributs</title>
      <highlight language="config">
Session On
SessionDBDCookieName session path=/private;domain=example.com;httponly;secure;version=1;
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDCookieName2</name>
<description>Nom et attributs du cookie RFC2965 qui contient
l'identifiant de session</description>
<syntax>SessionDBDCookieName2 <var>nom</var> <var>attributs</var></syntax>
<default>none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDCookieName2</directive> permet
    de sp&eacute;cifier le nom et les attributs optionnels d'un cookie
    compatible RFC2965 qui contiendra l'identifiant de session. Les
    cookies RFC2965 sont d&eacute;finis &agrave; l'aide de l'en-t&ecirc;te HTTP
    <code>Set-Cookie2</code>.
    </p>

    <p>Une liste optionnelle d'attributs peut &ecirc;tre sp&eacute;cifi&eacute;e pour ce
    cookie, comme dans l'exemple ci-dessous. Ces attributs sont ins&eacute;r&eacute;s
    dans le cookie tel quel, et ne sont pas interpr&eacute;t&eacute;s par Apache.
    Assurez-vous que vos attributs sont d&eacute;finis correctement selon la
    sp&eacute;cification des cookies.
    </p>

    <example><title>Cookie2 avec attributs</title>
      <highlight language="config">
Session On
SessionDBDCookieName2 session path=/private;domain=example.com;httponly;secure;version=1;
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDCookieRemove</name>
<description>D&eacute;termine si les cookies de session doivent &ecirc;tre supprim&eacute;s
des en-t&ecirc;tes HTTP entrants</description>
<syntax>SessionDBDCookieRemove On|Off</syntax>
<default>SessionDBDCookieRemove On</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDCookieRemove</directive> permet
    de d&eacute;terminer si les cookies contenant l'identifiant de session
    doivent &ecirc;tre supprim&eacute;s des en-t&ecirc;tes pendant le traitement de la
    requ&ecirc;te.</p>

    <p>Dans le cas d'un mandataire inverse o&ugrave; le serveur Apache sert de
    frontal &agrave; un serveur d'arri&egrave;re-plan, r&eacute;v&eacute;ler le contenu du cookie de
    session &agrave; ce dernier peut conduire &agrave; une violation de la
    confidentialit&eacute;. &Agrave; ce titre, si cette directive est d&eacute;finie &agrave; "on",
    le cookie de session sera supprim&eacute; des en-t&ecirc;tes HTTP entrants.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDPerUser</name>
<description>Active une session propre &agrave; un utilisateur</description>
<syntax>SessionDBDPerUser On|Off</syntax>
<default>SessionDBDPerUser Off</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDPerUser</directive> permet
    d'activer une session propre &agrave; un utilisateur, dont la cl&eacute; sera le
    nom de l'utilisateur connect&eacute;. Si l'utilisateur n'est pas connect&eacute;,
    la directive sera ignor&eacute;e.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDSelectLabel</name>
<description>La requ&ecirc;te SQL &agrave; utiliser pour s&eacute;lectionner des sessions
dans la base de donn&eacute;es</description>
<syntax>SessionDBDSelectLabel <var>&eacute;tiquette</var></syntax>
<default>SessionDBDSelectLabel selectsession</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDSelectLabel</directive> permet
    de d&eacute;finir l'&eacute;tiquette de la requ&ecirc;te de s&eacute;lection par d&eacute;faut &agrave;
    utiliser pour charger une session. Cette &eacute;tiquette doit avoir &eacute;t&eacute;
    d&eacute;finie au pr&eacute;alable via une directive <directive
    module="mod_dbd">DBDPrepareSQL</directive>.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDInsertLabel</name>
<description>La requ&ecirc;te SQL &agrave; utiliser pour ins&eacute;rer des sessions dans la
base de donn&eacute;es</description>
<syntax>SessionDBDInsertLabel <var>&eacute;tiquette</var></syntax>
<default>SessionDBDInsertLabel insertsession</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDInsertLabel</directive> permet
    de d&eacute;finir l'&eacute;tiquette de la requ&ecirc;te d'insertion par d&eacute;faut &agrave;
    charger dans une session. Cette
    &eacute;tiquette doit avoir &eacute;t&eacute; d&eacute;finie au pr&eacute;alable via une directive
    <directive module="mod_dbd">DBDPrepareSQL</directive>.</p>

    <p>Si une tentative de mise &agrave; jour d'une session ne concerne aucun
    enregistrement, c'est cette requ&ecirc;te qui sera utilis&eacute;e pour ins&eacute;rer
    la session dans la base de donn&eacute;es.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDUpdateLabel</name>
<description>La requ&ecirc;te SQL &agrave; utiliser pour mettre &agrave; jour des sessions
pr&eacute;existantes dans la base de donn&eacute;es</description>
<syntax>SessionDBDUpdateLabel <var>&eacute;tiquette</var></syntax>
<default>SessionDBDUpdateLabel updatesession</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDUpdateLabel</directive> permet
    de d&eacute;finir l'&eacute;tiquette de la requ&ecirc;te de mise &agrave; jour par d&eacute;faut &agrave;
    charger dans une session. Cette
    &eacute;tiquette doit avoir &eacute;t&eacute; d&eacute;finie au pr&eacute;alable via une directive
    <directive module="mod_dbd">DBDPrepareSQL</directive>.</p>

    <p>Si une tentative de mise &agrave; jour d'une session ne concerne aucun
    enregistrement, c'est la requ&ecirc;te d'insertion qui sera appel&eacute;e pour
    ins&eacute;rer la session dans la base de donn&eacute;es. Si la base de donn&eacute;es
    supporte InsertOrUpdate, modifiez cette requ&ecirc;te pour effectuer la
    mise &agrave; jour en une seule requ&ecirc;te au lieu de deux.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionDBDDeleteLabel</name>
<description>La requ&ecirc;te SQL &agrave; utiliser pour supprimer des sessions de la
base de donn&eacute;es</description>
<syntax>SessionDBDDeleteLabel <var>&eacute;tiquette</var></syntax>
<default>SessionDBDDeleteLabel deletesession</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionDBDDeleteLabel</directive> permet
    de d&eacute;finir l'&eacute;tiquette de la requ&ecirc;te de suppression &agrave; utiliser par
    d&eacute;faut pour supprimer une session vide ou expir&eacute;e. Cette
    &eacute;tiquette doit avoir &eacute;t&eacute; d&eacute;finie au pr&eacute;alable via une directive
    <directive module="mod_dbd">DBDPrepareSQL</directive>.</p>

</usage>
</directivesynopsis>

</modulesynopsis>
