<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1425939 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_xml2enc.xml.meta">

<name>mod_xml2enc</name>
<description>Support avancé de l'internationalisation et des jeux de
caractères pour les modules de filtrage basés sur libxml2</description>
<status>Base</status>
<sourcefile>mod_xml2enc.c</sourcefile>
<identifier>xml2enc_module</identifier>
<compatibility>Disponible depuis la version 2.4 du serveur HTTP Apache.
Disponible en tant que module tiers dans les versions 2.2.x</compatibility>

<summary>
    <p>Ce module fournit un support avancé de l'internationalisation
    pour les modules de filtrage supportant les balises (markup-aware)
    comme <module>mod_proxy_html</module>. Il est capable de détecter
    automatiquement l'encodage des données en entrée et de s'assurer
    qu'elle sont traitées correctement par l'interpréteur <a
    href="http://xmlsoft.org/">libxml2</a>, y compris la conversion en
    Unicode (UTF-8) si nécessaire. Il peut aussi convertir les données
    dans l'encodage de votre choix après le traitement des balises, et
    s'assurera que le <var>jeu de caractères</var> approprié sera défini
    dans l'en-tête HTTP <var>Content-Type</var>.</p>
</summary>

<section id="usage"><title>Utilisation</title>
    <p>Il existe deux scénarios d'utilisation : le cas des modules
    programmés pour travailler avec mod_xml2enc ; et les autres :</p>
    <dl>
    <dt>Modules de filtrages programmés pour mod_xml2enc</dt><dd>
    <p>Les modules comme <module>mod_proxy_html</module> versions 3.1 et
    supérieures utilisent la fonction optionnelle
    <code>xml2enc_charset</code> pour déterminer la valeur de l'argument
    "jeu de caractères" à transmettre à l'interpréteur libxml2, et
    disposent de la fonction optionnelle <code>xml2enc_filter</code>
    pour effectuer un encodage ultérieur éventuel. L'utilisation de
    mod_xml2enc avec un module préprogrammé à cet effet ne nécessite
    aucune configuration : ce dernier configurera mod_xml2enc pour vous
    (sachant que vous pouvez tout de même le personnaliser via les
    directives de configuration ci-dessous).</p>
    </dd>
    <dt>Modules de filtrages non programmés pour mod_xml2enc</dt><dd>
    <p>Pour utiliser mod_xml2enc avec un module basé sur libxml2 qui n'a
    pas été explicitement programmé pour mod_xml2enc, vous devrez
    configurer la chaîne de filtrage vous-même. Ainsi, pour utiliser
    mod_xml2enc avec un filtre <strong>foo</strong> fourni par un module
    <strong>mod_foo</strong> et pour
    améliorer le support i18n de ce dernier avec HTML et XML, vous
    pouvez utiliser les directives suivantes :</p>
    <pre><code>
    FilterProvider iconv    xml2enc Content-Type $text/html
    FilterProvider iconv    xml2enc Content-Type $xml
    FilterProvider markup   foo Content-Type $text/html
    FilterProvider markup   foo Content-Type $xml
    FilterChain     iconv markup
    </code></pre>
    <p><strong>mod_foo</strong> supportera alors tout jeu de caractère supporté soit par
    libxml2, soit par apr_xlate/iconv, soit par les deux.</p>
    </dd></dl>
</section>

<section id="api"><title>API de programmation</title>
    <p>Les programmeurs de modules de filtrage basés sur libxml2 sont
    encouragés à les préprogrammer pour mod_xml2enc, afin de fournir un
    support i18n solide aux utilisateurs sans avoir à réinventer la
    roue. L'API de programmation est décrite dans
    <var>mod_xml2enc.h</var>, et <module>mod_proxy_html</module> est un
    exemple de son utilisation.</p>
</section>

<section id="sniffing"><title>Détection et encodage</title>
    <p>A la différence de <module>mod_charset_lite</module>, mod_xml2enc
    est conçu pour travailler avec des données dont l'encodage ne peut
    pas être connu, et donc configuré, à l'avance. Il utilise donc les
    techniques de 'reniflage' suivantes pour détecter le type d'encodage
    des données HTTP :</p>
    <ol>
        <li>Si l'en-tête HTTP <var>Content-Type</var> contient un
	paramètre <var>charset</var>, c'est ce dernier qui sera utilisé.</li>
        <li>Si les données commancent par une balise XML concernant
	l'ordre des octets (BOM) ou par une déclaration d'encodage XML,
	c'est celle-ci qui sera utilisée.</li>
        <li>Si un type d'encodage est déclaré dans un élément HTML
	<code>&lt;META&gt;</code>, c'est ce dernier qui sera utilisé.</li>
        <li>Si aucun des éléments précédents n'est trouvé, c'est la
	valeur par défaut définie par la directive
	<directive>xml2EncDefault</directive> qui sera utilisée.</li>
    </ol>
    <p>Les conditions sont testées dans cet ordre . Dès qu'une règle
    s'applique, elle est utilisée et la détection est terminée.</p>
</section>

<section id="output"><title>Codage en sortie</title>
<p><a href="http://xmlsoft.org/">libxml2</a> utilise toujours UTF-8
(Unicode) en interne, et les modules de filtrage basés sur libxml2
utiliseront cet encodage en sortie par défaut. mod_xml2enc peut modifier
l'encodage en sortie via l'API, mais il n'y a actuellement aucun moyen de le
configurer directement.</p>
<p>La modification de l'encodage en sortie ne devrait (du moins en théorie)
jamais être nécessaire, et est même déconseillée à cause de la charge de
traitement supplémentaire imposée au serveur par une conversion non
nécessaire.</p>
</section>

<section id="alias"><title>Codages non supportés</title>
<p>Si vous travaillez avec des encodages non supportés par aucune des
méthodes de conversion disponibles sur votre plateforme, vous pouvez
tout de même leur associer un alias vers un code supporté via la
directive <directive>xml2EncAlias</directive>.</p>
</section>

<directivesynopsis>
<name>xml2EncDefault</name>
<description>Définit un encodage par défaut à utiliser lorsqu'aucune
information ne peut être <a href="#sniffing">automatiquement détectée</a></description>
<syntax>xml2EncDefault <var>nom</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<compatibility>Disponible depuis la version 2.4.0 du serveur HTTP Apache
; disponible depuis un module tiers dans les versions antérieures.</compatibility>

<usage>
    <p>Si vous traitez des données dont l'encodage est connu, mais ne
    contenant aucune information à propos de ce dernier, vous pouvez
    définir une valeur par défaut afin d'aider mod_xml2enc à traiter
    correctement les données. Par exemple, pour définir la valeur par
    défaut Latin1 (<var>iso-8859-1</var> specifiée dans HTTP/1.0),
    utilisez :</p>
    <highlight language="config">xml2EncDefault iso-8859-1</highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>xml2EncAlias</name>
<description>Définit des alias pour les valeurs d'encodage</description>
<syntax>xml2EncAlias <var>jeu-de-caractères alias [alias ...]</var></syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>Cette directive de niveau serveur permet de définir un ou
    plusieurs alias pour un encodage. Elle permet au support d'encodage de
    libxml2 de traiter en interne des encodages non reconnus par libxml2
    en utilisant la table de conversion pour un encodage reconnu. Elle
    permet d'atteindre deux objectifs : supporter des jeux (ou noms) de
    caractères non reconnus par libxml2 ou iconv, et éviter une
    conversion pour un encodage lorsque cela n'est pas nécessaire.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>xml2StartParse</name>
<description>Indique à l'interpréteur à partir de quelle balise il doit
commencer son traitement.</description>
<syntax>xml2StartParse <var>élément [élément ...]</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>

<usage>
    <p>Cette directive permet de spécifier à partir de quelle balise,
    parmi les éléments spécifiés, l'interpréteur de balise doit
    commencer son traitement. Ccei permet de contourner le problème des
    serveurs d'arrière-plan qui insèrent des éléments non conformes en
    début de données, ce qui a pour effet de perturber l'interpréteur (<a
    href="http://bahumbug.wordpress.com/2006/10/12/mod_proxy_html-revisited/"
    >voir un exemple ici</a>).</p>
    <p>Elle ne doit être utilisée ni pour les documents XML, ni pour les
    documents HTML correctement formatés.</p>
</usage>
</directivesynopsis>

</modulesynopsis>

