<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1334018 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_mime_magic.xml.meta">

<name>mod_mime_magic</name>
<description>Détermine le type MIME d'un fichier à partir de quelques
octets de son contenu</description>
<status>Extension</status>
<sourcefile>mod_mime_magic.c</sourcefile>
<identifier>mime_magic_module</identifier>

<summary>
    <p>Ce module permet de déterminer le <glossary ref="mime-type">type
    MIME</glossary> des fichiers de la même manière que la commande Unix
    <code>file(1)</code>, à savoir en se basant sur les premiers octets
    du fichier. Il est conçu comme une "seconde ligne de défense" pour
    les cas où <module>mod_mime</module> ne parvient pas à déterminer le
    type du fichier.</p>

    <p>Ce module est dérivé d'une version libre de la commande Unix
    <code>file(1)</code> qui utilise des "nombres magiques" et autres
    marques distinctives issus du contenu du fichier pour essayer de
    déterminer le type de contenu. Ce module n'est activé que si le
    fichier magique est spécifié par la directive <directive
    module="mod_mime_magic">MimeMagicFile</directive>.</p>
</summary>

<section id="format"><title>Format du fichier magique</title>

    <p>Le fichier contient du texte ASCII sur 4 à 5 colonnes. Les lignes
    vides sont autorisées mais ignorées. Toute ligne commençant par un
    dièse (<code>#</code>) est un commentaire. Les autres lignes sont
    interprétées en colonnes comme suit :</p>

    <table style="zebra" border="1">
    <columnspec><column width=".15"/><column width=".8"/></columnspec>
    <tr><th>Colonne</th><th>Description</th></tr>
    <tr><td>1</td>
        <td>numéro de l'octet à partir duquel la vérification débute<br />
         "<code>&gt;</code>" indique une dépendance par rapport à la
	 dernière ligne non-"<code>&gt;</code>"</td></tr>

    <tr><td>2</td>
        <td><p>type de donnée à rechercher</p>
        <table border="1">
        <columnspec><column width=".2"/><column width=".7"/></columnspec>
        <tr><td><code>byte</code></td>
            <td>caractère unique</td></tr>
        <tr><td><code>short</code></td>
            <td>entier sur 16 bits selon l'ordre de la machine</td></tr>
        <tr><td><code>long</code></td>
            <td>entier sur 32 bits selon l'ordre de la machine</td></tr>
        <tr><td><code>string</code></td>
            <td>chaîne de taille choisie</td></tr>
        <tr><td><code>date</code></td>
            <td>date au format entier long (secondes depuis le temps Unix epoch/1970)</td></tr>
        <tr><td><code>beshort</code></td>
            <td>entier 16 bits big-endian</td></tr>
        <tr><td><code>belong</code></td>
            <td>entier 32 bits big-endian</td></tr>
        <tr><td><code>bedate</code></td>
            <td>date au format entier 32 bits big-endian</td></tr>
        <tr><td><code>leshort</code></td>
            <td>entier 16 bits little-endian</td></tr>
        <tr><td><code>lelong</code></td>
            <td>entier 32 bits little-endian</td></tr>
        <tr><td><code>ledate</code></td>
            <td>date au format entier 32 bits little-endian</td></tr>
        </table></td></tr>

    <tr><td>3</td>
        <td>contenu des données à rechercher</td></tr>

    <tr><td>4</td>
        <td>type MIME si correspondance</td></tr>

    <tr><td>5</td>
        <td>codage MIME si correspondance (optionnel)</td></tr>
    </table>

    <p>Par exemple, les lignes du fichier magique suivantes
    permettraient de reconnaître certains formats audio :</p>

    <example>
<pre># Sun/NeXT audio data
0      string      .snd
&gt;12    belong      1       audio/basic
&gt;12    belong      2       audio/basic
&gt;12    belong      3       audio/basic
&gt;12    belong      4       audio/basic
&gt;12    belong      5       audio/basic
&gt;12    belong      6       audio/basic
&gt;12    belong      7       audio/basic
&gt;12    belong     23       audio/x-adpcm</pre>
    </example>

    <p>Et celles-ci permettraient de reconnaître la différence entre les
    fichiers <code>*.doc</code> qui contiennent des documents Microsoft
    Word et les documents FrameMaker (ce sont des formats de fichiers
    incompatibles qui possèdent le même suffixe).</p>

    <example>
<pre># Frame
0  string  \&lt;MakerFile        application/x-frame
0  string  \&lt;MIFFile          application/x-frame
0  string  \&lt;MakerDictionary  application/x-frame
0  string  \&lt;MakerScreenFon   application/x-frame
0  string  \&lt;MML              application/x-frame
0  string  \&lt;Book             application/x-frame
0  string  \&lt;Maker            application/x-frame

# MS-Word
0  string  \376\067\0\043            application/msword
0  string  \320\317\021\340\241\261  application/msword
0  string  \333\245-\0\0\0           application/msword</pre>
    </example>

    <p>Un champ optionnel codage MIME peut être ajouté dans la cinquième
    colonne. Par exemple, cette ligne permet de reconnaître les fichiers
    compressés par gzip et définissent le type de codage.</p>

    <example>
<pre># gzip (GNU zip, à ne pas confondre avec
#       l'archiveur zip [Info-ZIP/PKWARE])

0  string  \037\213  application/octet-stream  x-gzip</pre>
    </example>
</section>

<section id="performance"><title>Problèmes liés aux performances</title>
    <p>Ce module n'est pas fait pour tous les systèmes. Si votre système
    parvient à peine à supporter sa charge, ou si vous testez les
    performances d'un serveur web, il est déconseillé d'utiliser ce
    module car son fonctionnement a un prix en matière de ressources
    consommées.</p>

    <p>Des efforts ont cependant été fournis pour améliorer les
    performances du code original de la commande <code>file(1)</code> en
    l'adaptant pour fonctionner sur un serveur web à forte charge. Il a
    été conçu pour un serveur sur lequel des milliers d'utilisateurs
    publient leurs propres documents, ce qui est probablement très
    courant sur un intranet. Il s'avère souvent bénéfique qu'un serveur
    puisse prendre des décisions plus pertinentes à propos du contenu
    d'un fichier que celles se basant sur le nom du fichier seul, ne
    serait-ce que pour diminuer le nombre d'appels du type "pourquoi ma
    page ne s'affiche-t-elle pas ?" survenant lorsque les utilisateurs
    nomment leurs fichiers incorrectement. Vous devez déterminer si la
    charge supplémentaire convient à votre environnement.</p>
</section>

<section id="notes"><title>Notes</title>
    <p>Les notes suivantes s'appliquent au module
    <module>mod_mime_magic</module> et sont incluses ici pour
    conformité avec les restrictions de copyright des contributeurs
    qui requièrent de les accepter.</p>
    <p>Note de traduction : ces informations de type légal ne sont pas traductibles</p>

    <note>
      <p>mod_mime_magic: MIME type lookup via file magic numbers<br />
      Copyright (c) 1996-1997 Cisco Systems, Inc.</p>

      <p>This software was submitted by Cisco Systems to the Apache Group
      in July 1997. Future revisions and derivatives of this source code
      must acknowledge Cisco Systems as the original contributor of this
      module. All other licensing and usage conditions are those of the
      Apache Group.</p>

      <p>Some of this code is derived from the free version of the file
      command originally posted to comp.sources.unix. Copyright info for
      that program is included below as required.</p>
    </note>

    <note>
      <p> - Copyright (c) Ian F. Darwin, 1987. Written by Ian F. Darwin.</p>

      <p>This software is not subject to any license of the American
      Telephone and Telegraph Company or of the Regents of the University
      of California.</p>

      <p>Permission is granted to anyone to use this software for any
      purpose on any computer system, and to alter it and redistribute it
      freely, subject to the following restrictions:</p>

      <ol>
        <li>The author is not responsible for the consequences of use of
        this software, no matter how awful, even if they arise from flaws
        in it.</li>

        <li>The origin of this software must not be misrepresented, either
        by explicit claim or by omission. Since few users ever read
        sources, credits must appear in the documentation.</li>

        <li>Altered versions must be plainly marked as such, and must not
        be misrepresented as being the original software. Since few users
        ever read sources, credits must appear in the documentation.</li>

        <li>This notice may not be removed or altered.</li>
      </ol>
    </note>

    <note>
      <p>For compliance with Mr Darwin's terms: this has been very
      significantly modified from the free "file" command.</p>

      <ul>
        <li>all-in-one file for compilation convenience when moving from
        one version of Apache to the next.</li>

        <li>Memory allocation is done through the Apache API's pool
        structure.</li>

        <li>All functions have had necessary Apache API request or server
        structures passed to them where necessary to call other Apache API
        routines. (<em>i.e.</em>, usually for logging, files, or memory
        allocation in itself or a called function.)</li>

        <li>struct magic has been converted from an array to a single-ended
        linked list because it only grows one record at a time, it's only
        accessed sequentially, and the Apache API has no equivalent of
        <code>realloc()</code>.</li>

        <li>Functions have been changed to get their parameters from the
        server configuration instead of globals.  (It should be reentrant
        now but has not been tested in a threaded environment.)</li>

        <li>Places where it used to print results to stdout now saves them
        in a list where they're used to set the MIME type in the Apache
        request record.</li>

        <li>Command-line flags have been removed since they will never be
        used here.</li>
      </ul>
    </note>
</section>

<directivesynopsis>
<name>MimeMagicFile</name>
<description>Active la détermination du type MIME en se basant sur le
contenu du fichier et en utilisant le fichier magique
spécifié</description>
<syntax>MimeMagicFile <var>chemin-fichier</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>La directive <directive>MimeMagicFile</directive> permet
    d'activer ce module, le fichier par défaut fourni étant
    <code>conf/magic</code>. Les chemins sans slash '/' de début sont
    relatifs au répertoire défini par la directive <directive
    module="core">ServerRoot</directive>. Les serveurs virtuels
    utilisent le même fichier que le serveur principal sauf si un
    fichier spécifique a été défini pour ce serveur virtuel, auquel cas
    c'est ce dernier fichier qui sera utilisé.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      MimeMagicFile conf/magic
    </highlight>
    </example>
</usage>
</directivesynopsis>

</modulesynopsis>
