<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1796503 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="relevant_standards.xml.meta">
  <parentdocument href="./">Documentations diverses</parentdocument>

  <title>Standards applicables</title>

  <summary>
    <p>Cette page documente tous les standards applicables que suit le
    serveur HTTP Apache, accompagnés d'une brève description.</p>

    <p>Pour compléter les informations fournies ci-dessous, vous pouvez
    consulter les ressources suivantes :</p>

    <ul>
      <li>
        <a href="http://purl.org/NET/http-errata">
        http://purl.org/NET/http-errata</a> - Corrections de la
	spécification HTTP/1.1
      </li>
      <li>
      <a href="http://www.rfc-editor.org/errata.php">
        http://www.rfc-editor.org/errata.php</a>   - Corrections des RFCs
      </li>
      <li>
        <a href="http://ftp.ics.uci.edu/pub/ietf/http/#RFC">
        http://ftp.ics.uci.edu/pub/ietf/http/#RFC</a> - Une liste
	précompilée des RFCs en rapport avec HTTP
      </li>
    </ul>

    <note type="warning"><title>Avertissement</title>
    <p>Ce document n'est pas encore finalisé.</p>
    </note>

  </summary>

  <section id="http_recommendations"><title>Recommandations HTTP</title>

    <p>Indépendamment des modules compilés et utilisés, Apache en
    tant que serveur web de base respecte les recommandations IETF
    suivantes :</p>

    <dl>
      <dt><a href="http://www.rfc-editor.org/rfc/rfc1945.txt">RFC 1945</a>
      (Informations)</dt>

      <dd>Le Protocole de Transfert Hypertexte (Hypertext Transfer
      Protocol - HTTP) est un protocole de niveau application avec la
      clarté et la vitesse nécessaires pour les systèmes d'informations
      distribués, collaboratifs et hypermédia. Cette RFC documente le
      protocole HTTP/1.0.</dd>

      <dt><a href="http://www.rfc-editor.org/rfc/rfc2616.txt">RFC 2616</a>
      (Série de standards)</dt>

      <dd>Le Protocole de Transfert Hypertexte (Hypertext Transfer
      Protocol - HTTP) est un protocole de niveau application pour les
      systèmes d'informations distribués, collaboratifs et hypermédia.
      Cette RFC documente le protocole HTTP/1.1.</dd>

      <dt><a href="http://www.rfc-editor.org/rfc/rfc2396.txt">RFC 2396</a>
      (Série de standards)</dt>

      <dd>Un Identificateur de Ressource Uniforme (Uniform Resource
      Identifier - URI) est une chaîne de caractères compacte permettant
      d'identifier une ressource physique ou abstraite.</dd>

      <dt><a href="http://www.rfc-editor.org/rfc/rfc4346.txt">RFC 4346</a>
      (Série de standards)</dt>

      <dd>Le protocole TLS permet l'utilisation de communications
      sécurisées sur l'Internet. Il fournit le chiffrement, et a été
      conçu pour se prémunir contre l'interception, la modification et
      la falsification de messages.</dd>
    </dl>

  </section>

  <section id="html_recommendations"><title>Recommandations HTML</title>

    <p>En ce qui concerne le langage HTML, Apache respecte les
    recommandations IETF et W3C suivantes :</p>

    <dl>
      <dt><a href="http://www.rfc-editor.org/rfc/rfc2854.txt">RFC 2854</a>
      (Informations)</dt>

      <dd>Ce document résume l'historique du développement de HTML, et
      définit le type MIME "text/html" en pointant les recommandations
      W3C correspondantes.</dd>

      <dt><a href="http://www.w3.org/TR/html401">Spécification HTML
      4.01</a>
      (<a
      href="http://www.w3.org/MarkUp/html4-updates/errata">Corrections
      d'erreurs</a>)
      </dt>

      <dd>Cette spécification définit le Langage à Balises HyperTexte
      (HyperText Markup Language - HTML), le langage de publication du
      World Wide Web. Elle définit HTML 4.01, qui est une sous-version
      de HTML 4.</dd>

      <dt><a href="http://www.w3.org/TR/REC-html32">Référence HTML
      3.2</a></dt>

      <dd>Le langage à Balises HyperTexte (HyperText Markup Language -
      HTML) est un langage à balises simple permettant de créer des
      documents hypertextes portables. Les documents HTML sont aussi des
      documents SGML.</dd>

      <dt><a href="http://www.w3.org/TR/xhtml11/">XHTML 1.1 -
      XHTML sous forme de modules</a>
      (<a href="http://www.w3.org/MarkUp/2009/xhtml11-2nd-edition-errata.html">Corrections
      d'erreurs</a>)
      </dt>

      <dd>Cette recommandation définit un nouveau type de document XHTML
      basé sur le cadre de développement des modules et les modules
      définis dans la modularisation de XHTML.</dd>

      <dt><a href="http://www.w3.org/TR/xhtml1">XHTML 1.0, le Langage à
      Balises Hypertexte Extensible (Extensible HyperText Markup
      Language) - Seconde édition</a>
      (<a href="http://www.w3.org/2002/08/REC-xhtml1-20020801-errata/">Corrections
      d'erreurs</a>)
      </dt>

      <dd>Cette spécification définit la seconde édition de XHTML 1.0,
      une reformulation de HTML 4 en tant qu'application XML 1.0, ainsi
      que trois DTDs correspondant à celles définies par HTML 4.</dd>
    </dl>

  </section>

  <section id="authentication"><title>Authentification</title>

    <p>En ce qui concerne les différentes méthodes d'authentification,
    Apache respecte les recommandations IETF suivantes :</p>

    <dl>
      <dt><a href="http://www.rfc-editor.org/rfc/rfc2617.txt">RFC 2617</a>
      (Le track des standards)</dt>

      <dd>"HTTP/1.0", y compris la spécification d'un protocole basique
      d'authentification et de contrôle d'accès.</dd>

    </dl>

  </section>

  <section id="language_country_codes"><title>Codes de langues et de
  pays</title>

    <p>Les liens suivants fournissent des informations à propos des
    codes de langues et de pays aux normes ISO ou autres :</p>

    <dl>
      <dt><a href="http://www.loc.gov/standards/iso639-2/">ISO 639-2</a></dt>

      <dd>ISO 639 fournit deux jeux de codes de langues permettant de
      représenter les noms des langues ; le premier est
      un jeu de codes sur deux lettres (639-1), le second (celui
      présenté dans le lien ci-dessus), est un jeu de codes sur trois
      lettres (639-2).</dd>

      <dt><a href="http://www.iso.org/iso/country_codes">
      ISO 3166-1</a></dt>

      <dd>Ce document présente les noms de pays (les noms raccourcis
      officiels en anglais) dans l'ordre alphabétique, tels qu'ils sont
      présentés dans la norme ISO 3166-1 et les éléments de codes
      correspondants de la norme ISO 3166-1-alpha-2.</dd>

      <dt><a href="http://www.rfc-editor.org/rfc/bcp/bcp47.txt">BCP 47</a>
      (Les meilleurs pratiques courantes),
      <a href="http://www.rfc-editor.org/rfc/rfc3066.txt">RFC 3066</a></dt>

      <dd>Ce document décrit une balise de langue permettant de
      spécifier la langue utilisé dans un objet contenant des
      informations, la manière d'enregistrer des valeurs à utiliser dans
      cette balise de langage, et une méthode pour comparer les balises
      de langue de ce style.</dd>

      <dt><a href="http://www.rfc-editor.org/rfc/rfc3282.txt">RFC 3282</a>
      (Série de standards)</dt>

      <dd>Ce document définit un en-tête "Content-language:" permettant
      de spécifier le langage d'un élément possédant des en-têtes du
      style RFC 822, comme les portions de corps MIME ou les documents
      Web, et un en-tête "Accept-Language:" permettant de spécifier des
      préférences en matière de langue.</dd>
    </dl>

  </section>

</manualpage>
