<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1779470 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="httpd.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

  <title>httpd - Le serveur HTTP d'Apache</title>

<summary>
     <p><code>httpd</code> est le programme du serveur HTTP d'Apache. Il
     a été conçu pour fonctionner sous forme de processus démon
     indépendant. Lorsqu'il est utilisé ainsi, il va créer un jeu de
     processus enfants ou de threads qui traiteront les requêtes.</p>

     <p>En général, <code>httpd</code> n'est pas invoqué directement,
     mais plutôt via <program>apachectl</program> sur les systèmes de
     style Unix ou <a
     href="../platform/windows.html#winsvc">en tant que service sous
     Windows NT, 2000 et XP</a> et <a
     href="../platform/windows.html#wincons">comme application de
     console sous Windows 9x et ME</a>.</p>
</summary>

<seealso><a href="../invoking.html">Démarrer Apache httpd</a></seealso>
<seealso><a href="../stopping.html">Arrêter Apache httpd</a></seealso>
<seealso><a href="../configuring.html">Fichiers de configuration</a></seealso>
<seealso><a href="../platform/">Documentations spécifiques aux
plates-formes</a></seealso>
<seealso><program>apachectl</program></seealso>

<section id="synopsis"><title>Syntaxe</title>
     <p><code><strong>httpd</strong> [ -<strong>d</strong>
     <var>racine-serveur</var> ] [ -<strong>f</strong> <var>config</var> ]
     [ -<strong>C</strong> <var>directive</var> ] [ -<strong>c</strong>
     <var>directive</var> ] [ -<strong>D</strong> <var>paramètre</var> ]
     [ -<strong>e</strong> <var>niveau</var> ] [ -<strong>E</strong>
     <var>fichier</var> ]
     [ <strong>-k</strong> start|restart|graceful|stop|graceful-stop ]
     [ -<strong>h</strong> ]
     [ -<strong>l</strong> ] [ -<strong>L</strong> ] [ -<strong>S</strong> ]
     [ -<strong>t</strong> ] [ -<strong>v</strong> ] [ -<strong>V</strong> ]
     [ -<strong>X</strong> ] [ -<strong>M</strong> ] [ -<strong>T</strong> ]
     </code></p>

     <p>Sur les <a href="../platform/windows.html">systèmes Windows</a>,
     les options additionnelles suivantes sont disponibles :</p>

     <p><code><strong>httpd</strong> [ -<strong>k</strong>
     install|config|uninstall ] [ -<strong>n</strong> <var>nom</var> ]
     [ -<strong>w</strong> ]</code></p>
</section>

<section id="options"><title>Options</title>

<dl>
<dt><code>-d <var>racine-serveur</var></code></dt>

<dd>Définit la valeur initiale de la directive <directive
module="core">ServerRoot</directive> à <var>racine-serveur</var>. Cette
valeur peut être écrasée par la directive ServerRoot du fichier de
configuration. La valeur par défaut est
<code>/usr/local/apache2</code>.</dd>

<dt><code>-f <var>config</var></code></dt>

<dd>Utilise les directives du fichier <var>config</var> au démarrage. Si
<var>config</var> ne commence pas par un '/', il est considéré comme
relatif au chemin défini par la directive <directive
module="core">ServerRoot</directive>. La valeur par défaut est
<code>conf/httpd.conf</code>.</dd>

<dt><code>-k <code>start|restart|graceful|stop|graceful-stop</code></code></dt>

<dd>Permet de démarrer, redémarrer ou arrêter <code>httpd</code>. Voir <a
href="../stopping.html">Arrêter Apache httpd</a> pour plus d'informations.</dd>

<dt><code>-C <var>directive</var></code></dt>

<dd>Exécute la directive de configuration <var>directive</var> avant de
lire les fichiers de configurations.</dd>

<dt><code>-c <var>directive</var></code></dt>

<dd>Exécute la directive de configuration <var>directive</var> après
avoir lu les fichiers de configurations.</dd>


<dt><code>-D <var>paramètre</var></code></dt>

<dd>Définit un <var>paramètre</var> de configuration à utiliser dans les
sections <directive type="section" module="core">IfDefine</directive>
des fichiers de configuration, ces dernières permettant d'exécuter ou
non des
commandes au démarrage ou au redémarrage du serveur. Sert aussi à
définir certains paramètres de démarrage moins courants comme
<code>-DNO_DETACH</code> (empêche le processus parent de lancer des
processus enfants) et <code>-DFOREGROUND</code> (empêche le processus
parent d'appeler <code>setsid()</code> et autres).</dd>

<dt><code>-e <var>niveau</var></code></dt>

<dd>Définit la directive <directive module="core">LogLevel</directive> à
<var>niveau</var> pendant le démarrage du serveur. Ceci permet
d'augmenter temporairement la verbosité des messages d'erreur afin de
déterminer les problèmes de démarrage.</dd>

<dt><code>-E <var>fichier</var></code></dt>

<dd>Envoie les messages d'erreur de démarrage vers le fichier
<var>fichier</var>.</dd>

<dt><code>-h</code></dt>

<dd>Affiche un bref résumé des options de ligne de commande
disponibles.</dd>

<dt><code>-l</code></dt>

<dd>Affiche la liste des modules compilés dans le le serveur. Ce
paramètre n'affiche <strong>pas</strong> les modules chargés
dynamiquement via la directive <directive
module="mod_so">LoadModule</directive>.</dd>

<dt><code>-L</code></dt>

<dd>Affiche une liste des directives fournies par les modules statiques
avec les arguments associés, ainsi que les contextes dans lesquels elles
sont valides. Les directives fournies par les modules partagés
(dynamiques) ne sont pas affichées).</dd>

<dt><code>-M</code></dt>

<dd>Affiche une liste des modules statiques et des modules chargés
dynamiquement.</dd>

<dt><code>-S</code></dt>

<dd>Affiche la configuration telle qu'elle est issue de l'interprétation
du fichier de configuration (actuellement, seule la configuration des
serveurs virtuels est affichée).</dd>

<dt><code>-T</code> (disponible depuis la version 2.3.8)</dt>

<dd>Empêche la vérification de la racine des documents (DocumentRoot) au
démarrage/redémarrage.</dd>

<dt><code>-t</code></dt>

<dd>Exécute une vérification de syntaxe pour les fichiers de
configuration seulement. Le programme se termine immédiatement après ces
tests de vérification de syntaxe avec soit un code de retour de 0
(syntaxe OK), soit un code de retour différent de 0 (erreur de
syntaxe). Si -D <var>DUMP</var>_<var>VHOSTS </var> est défini, les
détails de la configuration des serveurs virtuels seront affichés. Si -D
<var>DUMP</var>_<var>MODULES </var> est défini, tous les modules chargés
seront affichés.</dd>

<dt><code>-v</code></dt>

<dd>Print the version of <code>httpd</code>, and then exit.</dd>

<dt><code>-V</code></dt>

<dd>Le programme affiche la version et les paramètres de compilation de
<code>httpd</code>, puis se termine.</dd>

<dt><code>-X</code></dt>

<dd>Exécute httpd en mode debug. Un seul processus sera démarré, et le
serveur ne rendra pas la main à la console.</dd>

</dl>

<p>Les arguments suivants ne sont disponibles que sur la <a
href="../platform/windows.html">plate-forme Windows</a> :</p>

<dl>

<dt><code>-k install|config|uninstall</code></dt>

<dd>Respectivement : installe Apache httpd en tant que service Windows NT ;
modifie les options de démarrage du service Apache httpd ; désinstalle le
service Apache httpd.</dd>

<dt><code>-n <var>nom</var></code></dt>

<dd>Le <var>nom</var> du service Apache httpd à actionner.</dd>

<dt><code>-w</code></dt>

<dd>Garde la console Windows ouverte en cas de problème de façon à ce
que le message d'erreur puisse être lu.</dd>

</dl>

</section>

</manualpage>
