<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1420732 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2013010601 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="htdbm.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>htdbm - Manipuler des bases de données DBM de mots de
passe</title>

<summary>
    <p><code>htdbm</code> permet de manipuler des fichiers au format DBM
    ou sont stockés des nom d'utilisateurs et mots de passe à des fins
    d'authentification de base des utilisateurs HTTP via le module
    <module>mod_authn_dbm</module>. Voir la documentation de
    <program>dbmmanage</program> pour plus de détails à propos de ces
    fichiers DBM.</p>
</summary>
<seealso><program>httpd</program></seealso>
<seealso><program>dbmmanage</program></seealso>
<seealso><module>mod_authn_dbm</module></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>htdbm</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>i</strong> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>b</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
    -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var> <var>mot-de-passe</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>n</strong>
    [ -<strong>i</strong> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>nb</strong>
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-utilisateur</var> <var>mot-de-passe</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>v</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>i</strong> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>vb</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>t</strong> ]
    [ -<strong>v</strong> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var> <var>mot-de-passe</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>x</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    <var>nom-fichier</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htdbm</strong> -<strong>l</strong>
    [ -<strong>T</strong><var>DBTYPE</var> ]
    </code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code>-b</code></dt>
    <dd>Utilise le mode batch ; en d'autres termes, le mot de passe est
    extrait de la ligne de commande au lieu d'être demandé à
    l'opérateur. Cette option doit être utilisée avec la plus grande
    prudence, car <strong>le mot de passe est visible en clair</strong>
    dans la ligne de commande. Pour utiliser un script, voir l'option
    <code>-i</code>.</dd>

    <dt><code>-i</code></dt>
    <dd>Lit le mot de passe depuis stdin sans vérification (à utiliser
    dans le cadre d'un script).</dd>

    <dt><code>-c</code></dt>
    <dd>Crée le <var>fichier-mots-de-passe</var>. Si
    <var>fichier-mots-de-passe</var> existe déjà, il est réécrit et
    tronqué. Cette option ne peut pas être combinée avec l'option
    <code>-n</code>.</dd>

    <dt><code>-n</code></dt>
    <dd>Affiche les résultats sur la sortie standard et ne met pas à
    jour la base de données. Cette option modifie la syntaxe de la ligne
    de commande, car l'argument <var>fichier-mots-de-passe</var> (en
    général le premier) est omis. Elle ne peut pas être combinée avec
    l'option <code>-c</code>.</dd>

    <dt><code>-m</code></dt>
    <dd>Utilise un chiffrement MD5 pour les mots de passe. Sous Windows
    et Netware, c'est l'option par défaut..</dd>

    <dt><code>-B</code></dt>
    <dd>Utilise l'algorythme de chiffrement bcrypt pour les mots de
    passe. C'est un algorythme actuellement considéré comme sûr.</dd>

    <dt><code>-C</code></dt>
    <dd>Ce drapeau n'est autorisé qu'en conjonction avec le drapeau
    <code>-B</code> (chiffrement bcrypt). Il permet de définir la durée
    de traitement pour l'algorythme de chiffrement bcrypt (plus elle est
    longue, plus la sécurité est élevée, mais la rapidité est diminuée
    d'autant) ; la valeur par défaut est 5, les valeurs valides vont de
    4 à 31.</dd>


    <dt><code>-d</code></dt>
    <dd>Utilise un chiffrement <code>crypt()</code> pour les mots de
    passe. C'est l'option par défaut sur toutes les plates-formes, sauf
    Windows et Netware. Bien que <code>htdbm</code> supporte ce
    chiffrement sur toutes les plates-formes, il n'est pas supporté par
    le serveur <program>httpd</program> sous Windows et Netware. Cet
    algorythme est considéré comme <strong>non sûr</strong> selon les
    standards actuels.</dd>

    <dt><code>-s</code></dt>
    <dd>Utilise le chiffrement SHA pour les mots de passe. Facilite la
    migration vers/depuis les serveurs Netscape qui utilisent le format
    LDAP Directory Interchange (ldif). Cet
    algorythme est considéré comme <strong>non sûr</strong> selon les
    standards actuels.</dd>

    <dt><code>-p</code></dt>
    <dd>Utilise des mots de passe au format texte en clair. Bien que
    <code>htdbm</code> supporte ce format sur toutes les plates-formes,
    le démon <program>httpd</program> n'accepte les mots de passe au
    format texte en clair que sous Windows et Netware.</dd>

    <dt><code>-l</code></dt>
    <dd>Affiche chaque nom d'utilisateur de la base de données
    accompagné de son commentaire sur la sortie standard.</dd>

    <dt><code>-v</code></dt>
    <dd>Vérifie une association nom d'utilisateur/mot de passe. Le
    programme affichera un message indiquant si le mot de passe fourni
    est valide. Si le mot de passe n'est pas valide, le programme
    s'arrête et renvoie un code d'erreur 3.</dd>

    <dt><code>-x</code></dt>
    <dd>Supprime l'utilisateur. Si le nom d'utilisateur existe dans le
    fichier DBM spécifié, il sera supprimé.</dd>

    <dt><code>-t</code></dt>
    <dd>Interprète le dernier paramètre en tant que commentaire. Avec
    cette option, il est possible d'ajouter une chaîne supplémentaire à
    la fin de la ligne de commande ; le contenu de cette chaîne sera
    stocké dans la base de données dans le champ "Comment" associé au
    nom d'utilisateur spécifié.</dd>

    <dt><code><var>nom-fichier</var></code></dt>
    <dd>Le nom du fichier au format DBM en général sans l'extension
    <code>.db</code>, <code>.pag</code>, ou <code>.dir</code>. Avec
    l'option <code>-c</code>, le fichier DBM est mis à jour s'il existe
    ou créé dans le cas contraire.</dd>

    <dt><code><var>nom-utilisateur</var></code></dt>
    <dd>Le nom d'utilisateur à créer ou mettre à jour dans le
    <var>fichier-mots-de-passe</var>. Si <var>nom-utilisateur</var>
    n'existe pas dans ce fichier, une entrée est ajoutée. S'il existe,
    son mot de passe est modifié.</dd>

    <dt><code><var>mot-de-passe</var></code></dt>
    <dd>Le mot de passe en clair destiné à être chiffré et stocké dans
    le fichier DBM. Ne s'utilise qu'avec l'option <code>-b</code>.</dd>

    <dt><code>-T<var>DBTYPE</var></code></dt>
    <dd>Type de fichier DBM (SDBM, GDBM, DB, ou "default").</dd>
    </dl>
</section>

<section id="bugs"><title>Bugs</title>
    <p>Vous devez garder à l'esprit qu'il existe de nombreux formats de
    fichiers DBM différents, et que selon toute vraisemblance, des
    bibliothèques pour plus d'un format sont présentes sur votre
    système. Les trois exemples de base sont SDBM, NDBM, le projet GNU
    GDBM, et Berkeley/Sleepycat DB 2/3/4. Malheureusement, toutes ces
    bibliothèques
    utilisent des formats de fichiers différents, et vous devez vous
    assurer que le format de fichier utilisé par <var>nom-fichier</var>
    correspond au format attendu par <code>htdbm</code>.
    Actuellement, <code>htdbm</code> n'a aucun moyen de savoir à
    quel type de fichier DBM il a à faire. S'il est utilisé avec un
    format inapproprié, il ne renverra rien, ou pourra créer un fichier
    DBM différent avec un nom différent, ou au pire, va corrompre le
    fichier DBM si vous avez tenté de le modifier.</p>

    <p>Vous pouvez utiliser le programme <code>file</code> fourni par la
    plupart des systèmes Unix pour déterminer le format d'un fichier
    DBM.</p>
</section>

<section id="exit"><title>Valeur renvoyée</title>
    <p><code>htdbm</code> renvoie 0 ("true") si les nom d'utilisateur et
    mot de passe ont été créés ou mis à jour avec succès dans le fichier
    DBM. <code>htdbm</code> renvoie <code>1</code> s'il a rencontré un
    problème d'accès aux fichiers, <code>2</code> si la ligne de
    commande comportait une erreur de syntaxe, <code>3</code> si le mot
    de passe a été fourni interactivement et s'il est invalide pour
    l'entrée considérée, <code>4</code> si l'opération a été
    interrompue, <code>5</code> si une valeur est trop longue (nom
    utilisateur, nom fichier, mot de passe, ou l'enregistrement après
    son élaboration), <code>6</code> si le nom d'utilisateur contient
    des caractères illégaux (voir la section <a
    href="#restrictions">Restrictions</a>), et <code>7</code> si le
    fichier n'est pas un fichier de mots de passe DBM valide.</p>
</section>

<section id="examples"><title>Exemples</title>
    <example>
      htdbm /usr/local/etc/apache/.utilisateurs-htdbm jsmith
    </example>

    <p>Ajoute ou modifie le mot de passe de l'utilisateur
    <code>jsmith</code>. Le mot de passe est demandé à l'opérateur. Sous
    Windows, le mot de passe sera chiffré en utilisant l'algorithme MD5
    Apache modifié ; dans les autres cas, c'est la routine
    <code>crypt()</code> du système qui sera utilisée. Si le fichier
    n'existe pas, <code>htdbm</code> s'arrêtera et renverra une
    erreur.</p>

    <example>
      htdbm -c /home/doe/public_html/.htdbm jane
    </example>

    <p>Crée un nouveau fichier et y enregistre une entrée pour
    l'utilisateur <code>jane</code>. Le mot de passe est demandé à
    l'opérateur. Si le fichier existe et ne peut pas être lu, ou ne peut
    pas être écrit, il ne sera pas modifié et
    <code>htdbm</code> affichera un message et renverra un code
    d'erreur.</p>

    <example>
      htdbm -mb /usr/web/.htdbm-tous jones Pwd4Steve
    </example>

    <p>Chiffre le mot de passe entré avec la ligne de commande
    (<code>Pwd4Steve</code>) à l'aide de l'algorithme MD5, et
    l'enregistre dans le fichier spécifié.</p>
</section>

<section id="security"><title>Considérations à propos de sécurité</title>
    <p>Les fichiers de mots de passe Web tels que ceux que gère
    <code>htdbm</code> ne doivent <em>pas</em> être stockés dans
    l'espace d'URI du serveur Web -- en d'autres termes, il ne doit pas
    être possible d'y accéder à l'aide d'un navigateur.</p>

    <p>L'utilisation de l'option <code>-b</code> est déconseillée, car
    lorsqu'il est utilisé, le mot de passe apparaît en clair dans la
    ligne de commande.</p>

    <p>Notez que lorsque vous utilisez l'algorythme
    <code>crypt()</code>, seuls les 8 premiers caractères du mot de
    passe sont pris en compte. Si le mot de passe fourni est plus long,
    les caractères supplémentaires seront ignorés sans avertissement.</p>

    <p>L'algorythme SHA ne permet pas de spécifier une valeur
    d'initialisation pour la génération de nombres aléatoires (salting)
    : un mot de passe donné ne possède ainsi qu'une réprésentation
    chiffrée. Les algorythmes <code>crypt()</code> et MD5 permettent quant à
    eux des représentations chiffrées multiples en acceptant comme
    paramètre une chaîne d'initialisation (salt), rendant les attaques à
    base de dictionnaires contre les mots de passe plus difficiles.</p>

    <p>Les algorythmes SHA et <code>crypt()</code> sont considérés comme
    non sûrs selon les standards actuels.</p>
</section>

<section id="restrictions"><title>Restrictions</title>
    <p>Sur la plate-forme Windows, les mots de passe chiffrés avec
    <code>htdbm</code> ont une taille limitée à <code>255</code>
    caractères. Si le mot de passe fourni est plus long, il sera tronqué
    à 255 caractères.</p>

    <p>L'algorithme MD5 utilisé par <code>htdbm</code> est spécifique à
    Apache ; les mots de passe chiffrés en utilisant cet algorithme
    seront inutilisables sur d'autres serveurs Web.</p>

    <p>Les noms d'utilisateurs ont une taille limitée à <code>255</code>
    octets et ne doivent pas contenir de caractère <code>:</code>.</p>
</section>

</manualpage>
