<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1420732 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2013010501 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="dbmmanage.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>dbmmanage - Gestion des fichiers d'authentification des
utilisateurs au format DBM</title>

<summary>
    <p><code>dbmmanage</code> permet de créer et de maintenir les
    fichiers au format DBM où sont stockés les noms d'utilisateurs et
    mots de passe à des fins d'authentification de base des utilisateurs
    HTTP via le module <module>mod_authn_dbm</module>. Il est possible
    de restreindre l'accès aux ressources disponibles sur le serveur
    HTTP Apache aux seuls utilisateurs spécifiés dans les fichiers créés
    par <code>dbmmanage</code>. Ce programme ne peut être utilisé
    qu'avec des fichiers d'utilisateurs au format DBM. Pour
    l'utilisation de fichiers textes, voir le programme
    <program>htpasswd</program>.</p>

    <p>Le programme <program>htdbm</program> est aussi un utilitaire
    permettant de maintenir une base de données de mots de passe DBM.</p>

    <p>Cette page de manuel ne décrit que les arguments de la ligne de
    commande. Pour plus de détails à propos des directives nécessaires
    pour configurer l'authentification des utilisateurs dans
    <program>httpd</program>, voir le manuel httpd qui est fourni avec
    la distribution d'Apache, ou peut être consulté à <a
    href="http://httpd.apache.org/">http://httpd.apache.org/</a>.</p>
</summary>
<seealso><program>httpd</program></seealso>
<seealso><program>htdbm</program></seealso>
<seealso><module>mod_authn_dbm</module></seealso>
<seealso><module>mod_authz_dbm</module></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>dbmmanage</strong> [ <var>codage</var> ]
    <var>nom-fichier</var> add|adduser|check|delete|update
    <var>nom-utilisateur</var>
    [ <var>mot-de-passe-chiffré</var>
      [ <var>groupe</var>[,<var>groupe</var>...]
        [ <var>commentaire</var> ] ] ]</code></p>

    <p><code><strong>dbmmanage</strong> <var>nom-fichier</var>
    view [ <var>nom-utilisateur</var> ]</code></p>

    <p><code><strong>dbmmanage</strong> <var>nom-fichier</var>import</code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code><var>nom-fichier</var></code></dt>
    <dd>Le nom du fichier au format DBM, en général sans l'extension
    <code>.db</code>, <code>.pag</code>, ou <code>.dir</code>.</dd>

    <dt><code><var>nom-utilisateur</var></code></dt>
    <dd>L'utilisateur concerné par l'opération effectuée. Le
    <var>nom-utilisateur</var> ne doit pas contenir de caractère
    <code>:</code>.</dd>

    <dt><code><var>mot-de-passe-chiffré</var></code></dt>
    <dd>C'est le mot de passe sous sa forme chiffrée à utiliser avec les
    commandes <code>update</code> et <code>add</code>. Vous pouvez
    utiliser un tiret (<code>-</code>) si vous voulez que le mot de
    passe vous soit demandé, mais remplissez les champs par la suite. En
    outre, avec la commande <code>update</code>, un point
    (<code>.</code>) permet de conserver le mot de passe original.</dd>

    <dt><code><var>groupe</var></code></dt>
    <dd>Un groupe dont l'utilisateur est membre. Un nom de groupe ne
    doit pas contenir de caractère (<code>:</code>). Vous pouvez
    utiliser un tiret (<code>-</code>) si vous ne voulez pas associer
    l'utilisateur à un groupe, mais remplissez le champ commentaire. En
    outre, avec la commande <code>update</code>, un point
    (<code>.</code>) permet de conserver le groupe original.</dd>

    <dt><code><var>commentaire</var></code></dt>
    <dd>C'est l'endroit où vous pouvez enregistrer diverses informations
    à propos de l'utilisateur telles que son nom réel, sont e-mail,
    etc... Le serveur ignore ce champ.</dd>
    </dl>

    <section id="options.encodings"><title>Codages</title>
      <dl>
      <dt><code>-d</code></dt>
      <dd>chiffrement crypt (chiffrement par défaut sauf sous Win32,
      Netware)</dd>

      <dt><code>-m</code></dt>
      <dd>chiffrement MD5 (chiffrement par défaut sous Win32,
      Netware)</dd>

      <dt><code>-s</code></dt>
      <dd>chiffrement SHA1</dd>

      <dt><code>-p</code></dt>
      <dd>en clair (<em>déconseillé</em>)</dd>
      </dl>
    </section>

    <section id="options.commands"><title>Commandes</title>
      <dl>
      <dt><code>add</code></dt>
      <dd>Ajoute une entrée pour <var>nom-utilisateur</var> à
      <var>nom-fichier</var> en utilisant le mot de passe chiffré
      <var>mot-de-passe-chiffré</var>.

      <example>dbmmanage passwords.dat add rbowen foKntnEF3KSXA</example>
      </dd>

      <dt><code>adduser</code></dt>
      <dd>Demande un mot de passe puis ajoute une entrée pour
      <var>nom-utilisateur</var> à <var>nom-fichier</var>.

      <example>dbmmanage passwords.dat adduser krietz</example>
      </dd>

      <dt><code>check</code></dt>
      <dd>Demande un mot de passe puis vérifie si
      <var>nom-utilisateur</var> est présent dans <var>nom-fichier</var>
      et si son mot de passe correspond au mot de passe fourni.

      <example>dbmmanage passwords.dat check rbowen</example>
      </dd>

      <dt><code>delete</code></dt>
      <dd>Supprime l'entrée <var>nom-utilisateur</var> de
      <var>nom-fichier</var>.

      <example>dbmmanage passwords.dat delete rbowen</example>
      </dd>

      <dt><code>import</code></dt>
      <dd>Lit les entrées
      <code><var>nom-utilisateur</var>:<var>mot-de-passe</var></code>
      (une par ligne) depuis <code>STDIN</code>, et les ajoute à
      <var>nom-fichier</var>. Les mots de passe doivent être déjà
      chiffrés.</dd>

      <dt><code>update</code></dt>
      <dd>Identique à la commande <code>adduser</code>, à l'exception
      que la présence de <var>nom-utilisateur</var> dans
      <var>nom-fichier</var> est vérifiée.

      <example>dbmmanage passwords.dat update rbowen</example>
      </dd>

      <dt><code>view</code></dt>
      <dd>Affiche le contenu du fichier DBM. Si vous spécifiez un
      <var>nom-utilisateur</var>, seule l'entrée correspondante est
      affichée.

      <example>dbmmanage passwords.dat view</example>
      </dd>
      </dl>
    </section>
</section>

<section id="bugs"><title>Bogues</title>
    <p>Vous devez garder à l'esprit qu'il existe de nombreux formats de
    fichiers DBM différents, et que selon toute vraisemblance, des
    bibliothèques pour plus d'un format sont présentes sur votre
    système. Les trois exemples de base sont SDBM, NDBM, le projet GNU
    GDBM, et Berkeley DB 2. Malheureusement, toutes ces bibliothèques
    utilisent des formats de fichiers différents, et vous devez vous
    assurer que le format de fichier utilisé par <var>nom-fichier</var>
    correspond au format attendu par <code>dbmmanage</code>.
    Actuellement, <code>dbmmanage</code> n'a aucun moyen de savoir à
    quel type de fichier DBM il a à faire. S'il est utilisé avec un
    format inapproprié, il ne renverra rien, ou pourra créer un fichier
    DBM différent avec un nom différent, ou au pire, va corrompre le
    fichier DBM si vous avez tenté de le modifier.</p>

    <p><code>dbmmanage</code> possède une liste de préférences en
    matière de formats DBM, définies dans le tableau
    <code>@AnyDBM::ISA</code> au début du programme. Comme nous
    préférons le format de fichier Berkeley DB 2, l'ordre dans lequel
    <code>dbmmanage</code> va rechercher les bibliothèques système est
    Berkeley DB 2, puis NDBM, GDBM et enfin SDBM. La première
    bibliothèque trouvée sera celle que <code>dbmmanage</code> tentera
    d'utiliser pour toutes les opérations sur les fichiers DBM. Cette
    ordre est sensiblement différent de l'ordre standard de Perl
    <code>@AnyDBM::ISA</code>, et de l'ordre utilisé par l'appel
    <code>dbmopen()</code> de Perl ; si vous utilisez un autre
    utilitaire pour gérer vos fichiers DBM, il doit donc se conformer à
    l'ordre de préférence indiqué précédemment. Vous devez prêter la
    même attention si vous utilisez des programmes écrits dans d'autres
    langages, comme C, pour accéder à ces fichiers.</p>

    <p>Vous pouvez utiliser le programme <code>file</code> fourni par la
    plupart des systèmes Unix pour déterminer le format d'un fichier
    DBM.</p>
</section>

</manualpage>
