<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 772682 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_request.xml.meta">

<name>mod_request</name>
<description>Filtres permettant de traiter et de mettre &agrave; disposition
les corps de requ&ecirc;tes HTTP</description>
<status>Base</status>
<sourcefile>mod_request.c</sourcefile>
<identifier>request_module</identifier>
<compatibility>Disponible depuis la version 2.3 d'Apache</compatibility>

<directivesynopsis>
<name>KeptBodySize</name>
<description>Conserve le corps de la requ&ecirc;te &agrave; concurrence de la taille
maximale sp&eacute;cifi&eacute;e, pour une utilisation &eacute;ventuelle par des filtres
comme mod_include.</description>
<syntax>KeptBodySize <var>taille maximale en octets</var></syntax>
<default>KeptBodySize 0</default>
<contextlist><context>directory</context>
</contextlist>

<usage>
    <p>Dans une situation normale, les gestionnaires de requ&ecirc;te tels que
    le gestionnaire par d&eacute;faut des fichiers statiques suppriment le
    corps de la requ&ecirc;te s'il n'est pas n&eacute;cessaire au gestionnaire de
    requ&ecirc;te. Il en r&eacute;sulte que les filtres comme mod_include sont
    limit&eacute;s &agrave; des requ&ecirc;tes <code>GET</code> lors de l'inclusion d'autres
    URLs en tant que sous-requ&ecirc;tes, et ceci m&ecirc;me si la requ&ecirc;te originale
    &eacute;tait une requ&ecirc;te <code>POST</code>, car le corps de la requ&ecirc;te a
    &eacute;t&eacute; supprim&eacute; et n'est donc plus disponible une fois le traitement du
    filtre mis en oeuvre.</p>

    <p>Lorsque l'argument de cette directive a une valeur sup&eacute;rieure &agrave;
    z&eacute;ro, les gestionnaires de requ&ecirc;te qui suppriment habituellement les
    corps de requ&ecirc;te vont alors conserver ces corps de requ&ecirc;te, &agrave;
    concurrence de la taille maximale sp&eacute;cifi&eacute;e, pour &ecirc;tre
    &eacute;ventuellement utilis&eacute;s par des filtres. Dans le cas du filtre
    mod_include, une tentative de requ&ecirc;te <code>POST</code> pour un
    fichier shtml statique se traduira par des sous-requ&ecirc;tes
    <code>POST</code>, et non par des sous-requ&ecirc;tes <code>GET</code>
    comme avant.</p>

    <p>Cette fonctionnalit&eacute; permet de d&eacute;couper des pages web complexes
    et des applications web en petits &eacute;l&eacute;ments individuels, et de
    combiner ces &eacute;l&eacute;ments avec la structure de la page web sous-jacente
    en utilisant <module>mod_include</module>. Les &eacute;l&eacute;ments peuvent se
    pr&eacute;senter sous la forme de programmes CGI, de langages de scripts,
    ou d'URLs issues d'un mandataire inverse dans l'espace d'URL d'un
    autre serveur en utilisant <module>mod_proxy</module>.</p>

    <p><strong>Note :</strong> Chaque requ&ecirc;te dont le corps est ainsi
    conserv&eacute; doit &ecirc;tre enregistr&eacute;e temporairement en m&eacute;moire vive
    jusqu'&agrave; la fin du traitement de la requ&ecirc;te. Il faut donc s'assurer
    que la m&eacute;moire RAM du serveur est suffisante pour pouvoir supporter
    la charge induite. L'utilisation de cette directive doit &ecirc;tre
    limit&eacute;e &agrave; certaines portions de votre espace d'URL bien pr&eacute;cises qui
    le n&eacute;cessitent, et en sp&eacute;cifiant comme taille maximale une valeur la
    plus petite possible, mais tout de m&ecirc;me suffisante pour un corps de
    requ&ecirc;te.</p>

    <p>Si la taille de la requ&ecirc;te envoy&eacute;e par le client d&eacute;passe la taille
    maximale autoris&eacute;e par cette directive, le serveur renverra l'erreur
    <code>413 Request Entity Too Large</code>.</p>

</usage>

<seealso>la documentation de <a href="mod_include.html">mod_include</a></seealso>
<seealso>la documentation de <a href="mod_auth_form.html">mod_auth_form</a></seealso>
</directivesynopsis>

</modulesynopsis>
