<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1334016 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_file_cache.xml.meta">

<name>mod_file_cache</name>
<description>Mise en cache m&eacute;moire d'une liste statique de
fichiers</description>
<status>Experimental</status>
<sourcefile>mod_file_cache.c</sourcefile>
<identifier>file_cache_module</identifier>

<summary>

    <note type="warning">
      Ce module doit &ecirc;tre utilis&eacute; avec pr&eacute;cautions. Il est recommand&eacute; de
      lire attentivement ce document, car l'utilisation de
      <module>mod_file_cache</module> peut facilement conduire &agrave; la
      cr&eacute;ation d'un site inop&eacute;rant.
    </note>

    <p>La mise en cache de fichiers souvent demand&eacute;s mais rarement
    modifi&eacute;s est une technique permettant de r&eacute;duire la charge du
    serveur. <module>mod_file_cache</module> met en oeuvre deux
    techniques de mise en cache de fichiers <em>statiques</em>
    fr&eacute;quemment demand&eacute;s. Des directives de configuration vous
    permettent d'indiquer &agrave; <module>mod_file_cache</module> soit
    d'ouvrir et de charger une image en m&eacute;moire d'un fichier avec
    <code>mmap()</code>, soit de pr&eacute;ouvrir un fichier et de maintenir en
    service le <em>gestionnaire</em> du fichier. Les deux techniques
    permettent de r&eacute;duire la charge du serveur lors du traitement des
    requ&ecirc;tes concernant ces fichiers, en accomplissant une partie du
    travail n&eacute;cessaire &agrave; la mise &agrave; disposition de ces fichiers (en
    particulier les op&eacute;rations d'entr&eacute;es/sorties sur les fichiers) au
    d&eacute;marrage du serveur, plut&ocirc;t qu'au cours de chaque requ&ecirc;te.</p>

    <p>Note : ces techniques sont inutilisables pour acc&eacute;l&eacute;rer des
    programmes CGI ou d'autres fichiers servis par des gestionnaires de
    contenu sp&eacute;ciaux. Elles ne peuvent &ecirc;tre utilis&eacute;es que pour des
    fichiers standards, normalement servis par le gestionnaire de contenu
    de base d'Apache.</p>

    <p>Ce module est une extension du module
    d'Apache 1.3 <code>mod_mmap_static</code>et s'en inspire
    fortement .</p>
</summary>

<section id="using"><title>Utilisation de mod_file_cache</title>

    <p><module>mod_file_cache</module> g&egrave;re la mise en cache d'une liste
    de fichiers d&eacute;finie de mani&egrave;re statique via une des directives
    <directive module="mod_file_cache">MMapFile</directive> ou
    <directive module="mod_file_cache">CacheFile</directive> au niveau
    de la configuration du serveur principal.</p>

    <p>Les deux directives ne sont pas support&eacute;es par toutes les
    plates-formes. Par exemple, Apache pour Windows ne supporte pas
    actuellement la directive <directive
    module="mod_file_cache">MMapFile</directive>, alors que d'autres
    plates-formes, comme AIX, supportent les deux. Vous recevrez un
    message d'erreur dans le journal des erreurs du serveur si vous
    essayez d'utiliser une directive non support&eacute;e. Si vous utilisez une
    directive non support&eacute;e, le serveur d&eacute;marrera, mais les fichiers ne
    seront pas mis en cache. Sur les plates-formes qui supportent les
    deux directives, vous devez faire des essais afin de d&eacute;terminer
    quelle directive vous convient le mieux.</p>

    <section><title>Directive MMapFile</title>

      <p>La directive <directive
      module="mod_file_cache">MMapFile</directive> du module
      <module>mod_file_cache</module> permet de transf&eacute;rer en m&eacute;moire
      une liste statique de fichiers &agrave; l'aide de l'appel syst&egrave;me
      <code>mmap()</code>. Cet appel syst&egrave;me est disponible sur la
      plupart des plates-formes de style Unix, mais pas sur toutes. Il
      existe parfois des limites sp&eacute;cifiques au syst&egrave;me quant &agrave; la
      taille et au nombre de fichiers qui peuvent &ecirc;tre
      <code>mmap()</code>&eacute;s, et l'exp&eacute;rimentation est probablement la
      m&eacute;thode la plus simple pour d&eacute;terminer ces limites.</p>

      <p>Ce <code>mmap()</code>age n'est effectu&eacute; qu'une seul fois au
      d&eacute;marrage ou red&eacute;marrage du serveur. Ainsi, chaque fois qu'un des
      fichiers charg&eacute;s en m&eacute;moire est modifi&eacute; au niveau du syst&egrave;me de
      fichiers, vous <em>devez</em> red&eacute;marrer le serveur (voir la
      documentation sur l'<a
      href="../stopping.html">Arr&ecirc;t et red&eacute;marrage</a>). Pour bien
      insister sur ce point, si des fichiers sont modifi&eacute;s <em>sur
      disque</em>, et si vous ne red&eacute;marrez pas le serveur, vous allez
      finir par servir des contenus compl&egrave;tement obsol&egrave;tes. Vous devez
      mettre &agrave; jour les fichiers en renommant l'ancienne version et en
      enregistrant la nouvelle sur disque. Pour y parvenir, on peut
      utiliser des outils comme <code>rdist</code> et <code>mv</code>.
      La raison pour laquelle ce module ne prend pas en compte les
      modifications de fichiers r&eacute;side dans le fait que cette
      v&eacute;rification n&eacute;cessiterait un appel &agrave; <code>stat()</code> &agrave; chaque
      acc&egrave;s, et en fin de compte, l'augmentation de la consommation de
      ressources finirait par aller contre le but initial de
      r&eacute;duire les entr&eacute;es/sorties.</p>
    </section>

    <section><title>Directive CacheFile</title>

      <p>La directive <directive
      module="mod_file_cache">CacheFile</directive> du module
      <module>mod_file_cache</module> permet d'associer un
      <em>gestionnaire</em> ou <em>descripteur de fichier</em> &agrave; chaque
      fichier &eacute;num&eacute;r&eacute; dans la directive de configuration et place ces
      gestionnaires de fichiers ouverts dans le cache. Lorsqu'un des
      fichier est demand&eacute;, le serveur s&eacute;lectionne son gestionnaire dans
      le cache et le transmet &agrave; l'API <code>sendfile()</code> (ou
      <code>TransmitFile()</code> sous Windows).</p>

      <!-- XXX
      <p>Insert more details about sendfile API...</p>
      -->

      <p>Cette mise en cache des gestionnaire n'est effectu&eacute;e qu'une
      seule fois au d&eacute;marrage ou red&eacute;marrage du syst&egrave;me. Ainsi, chaque
      fois qu'un des fichiers charg&eacute;s en m&eacute;moire est modifi&eacute; au niveau
      du syst&egrave;me de fichiers, vous <em>devez</em> red&eacute;marrer le serveur
      (voir la documentation sur l'<a
      href="../stopping.html">Arr&ecirc;t et red&eacute;marrage</a>).
      Pour bien
      insister sur ce point, si des fichiers sont modifi&eacute;s <em>sur
      disque</em>, et si vous ne red&eacute;marrez pas le serveur, vous allez
      finir par servir des contenus compl&egrave;tement obsol&egrave;tes. Vous devez
      mettre &agrave; jour les fichiers en renommant l'ancienne version et en
      enregistrant la nouvelle sur disque. Pour y parvenir, on peut
      utiliser des outils comme <code>rdist</code> et
      <code>mv</code>.</p>
    </section>

    <note><title>Note</title>
      <p>Ne cherchez pas &agrave; trouver de directive qui met tous les
      fichiers d'un r&eacute;pertoire en cache, de mani&egrave;re r&eacute;cursive. Pour y
      parvenir, vous pouvez vous reporter &agrave; la directive <directive
      module="core">Include</directive> directive, et consid&eacute;rer cette
      commande :</p>

      <example>
        find /www/htdocs -type f -print \<br />
        | sed -e 's/.*/mmapfile &amp;/' &gt; /www/conf/mmap.conf
      </example>
    </note>
</section>

<directivesynopsis>
<name>MMapFile</name>
<description>Charge au d&eacute;marrage une liste de fichiers en m&eacute;moire</description>
<syntax>MMapFile <var>chemin fichier</var> [<var>chemin fichier</var>] ...</syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>MMapFile</directive> permet de charger un
    ou plusieurs fichiers (s&eacute;par&eacute;s par des espaces) en m&eacute;moire au
    d&eacute;marrage du serveur. Ceux-ci sont automatiquement d&eacute;charg&eacute;s de la
    m&eacute;moire &agrave; l'arr&ecirc;t du serveur. Lorsqu'un ou plusieurs fichiers ont
    &eacute;t&eacute; modifi&eacute;s sur disque, on doit au minimum envoyer un signal
    <code>HUP</code> ou <code>USR1</code> au serveur afin de les
    re<code>mmap()</code>er.</p>

    <p>Soyez prudent avec les arguments <var>chemin fichier</var> : ils
    doivent correspondre exactement au chemin du syst&egrave;me de fichier que
    cr&eacute;ent les gestionnaires de traduction URL-vers-nom-fichier
    d'Apache. On ne peut pas comparer des inodes ou autres identifiants
    pour mettre en correspondance des chemins &agrave; l'aide de liens
    symboliques <em>(etc...)</em>, car l&agrave; encore, ceci n&eacute;cessiterait un
    appel &agrave; <code>stat()</code> suppl&eacute;mentaire, ce qui n'est pas
    acceptable.
    Il n'est pas garanti que ce module fonctionne avec des noms de
    fichiers r&eacute;&eacute;crits par <module>mod_alias</module> ou
    <module>mod_rewrite</module>.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      MMapFile /usr/local/apache/htdocs/index.html
      </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>CacheFile</name>
<description>Met en cache une liste de gestionnaires de fichiers au
d&eacute;marrage</description>
<syntax>CacheFile <var>chemin fichier</var> [<var>chemin fichier</var>] ...</syntax>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>CacheFile</directive> permet d'associer
    des gestionnaires &agrave; un ou plusieurs fichiers (s&eacute;par&eacute;s par des
    espaces), et de placer ceux-ci dans le cache au d&eacute;marrage du
    serveur. Les gestionnaires des fichiers mis en cache sont
    automatiquement ferm&eacute;s &agrave; l'arr&ecirc;t du serveur. Lorsqu'un ou plusieurs
    fichiers ont &eacute;t&eacute; modifi&eacute;s sur disque, le serveur doit &ecirc;tre red&eacute;marr&eacute;
    afin que les modifications soient prises en compte par le cache.</p>

    <p>Soyez prudent avec les arguments <var>chemin fichier</var> : ils
    doivent correspondre exactement au chemin du syst&egrave;me de fichier que
    cr&eacute;ent les gestionnaires de traduction URL-vers-nom-fichier
    d'Apache. On ne peut pas comparer des inodes ou autres identifiants
    pour mettre en correspondance des chemins &agrave; l'aide de liens
    symboliques <em>(etc...)</em>, car l&agrave; encore, ceci n&eacute;cessiterait un
    appel &agrave; <code>stat()</code> suppl&eacute;mentaire, ce qui n'est pas acceptable.
    Il n'est pas garanti que ce module fonctionne avec des noms de
    fichiers r&eacute;&eacute;crits par <module>mod_alias</module> ou
    <module>mod_rewrite</module>.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      CacheFile /usr/local/apache/htdocs/index.html
      </highlight>
    </example>
</usage>
</directivesynopsis>

</modulesynopsis>
