<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1437838 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->


<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_dav_lock.xml.meta">

<name>mod_dav_lock</name>
<description>Module de verrouillage g&eacute;n&eacute;rique pour
<module>mod_dav</module></description>
<status>Extension</status>
<sourcefile>mod_dav_lock.c</sourcefile>
<identifier>dav_lock_module</identifier>
<compatibility>Disponible depuis la version 2.1 d'Apache</compatibility>

<summary>
    <p>ce module impl&eacute;mente une API de verrouillage g&eacute;n&eacute;rique que tout
    fournisseur support de <module>mod_dav</module> peut utiliser. Son
    activation n&eacute;cessite l'utilisation de <module>mod_dav</module>. Mais
    sans fournisseur support pour l'utiliser, il n'est d'aucun service
    et ne doit pas &ecirc;tre charg&eacute; dans le serveur. <a
    href="http://subversion.apache.org/">mod_dav_svn</a>, le module qui
    impl&eacute;mente le fournisseur subversion, est un exemple
    de module de support qui utilise effectivement
    <module>mod_dav_lock</module>.</p>

    <p>Notez que <module>mod_dav_fs</module> n'a <em>pas</em> besoin de
    ce module de verrouillage g&eacute;n&eacute;rique, car il utilise sa propre
    version plus sp&eacute;cifique.</p>

    <p>Pour que <module>mod_dav_lock</module> puisse fonctionner, il
    vous suffit de sp&eacute;cifier le chemin de la base de donn&eacute;es des verrous
    &agrave; l'aide de la directive <directive
    module="mod_dav_lock">DavGenericLockDB</directive> d&eacute;crite
    ci-dessous.</p>

    <note><title>Note du d&eacute;veloppeur</title>
      <p>Pour d&eacute;terminer le pointeur de la fonction du fournisseur de
      verrouillage, vous devez utiliser l'API
      <code>ap_lookup_provider</code> avec les arguments
      <code>dav-lock</code>, <code>generic</code> et <code>0</code>.</p>
    </note>
</summary>
<seealso><module>mod_dav</module></seealso>

<directivesynopsis>
<name>DavGenericLockDB</name>
<description>Chemin de la base de donn&eacute;es des verrous DAV</description>
<syntax>DavGenericLockDB <var>chemin fichier</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>La directive <directive>DavLockDB</directive> permet de sp&eacute;cifier
    le chemin complet de la base de donn&eacute;es des verrous, sans extension.
    Si le chemin n'est pas absolu, il sera consid&eacute;r&eacute; comme relatif au
    r&eacute;pertoire d&eacute;fini par la directive <directive
    module="core">ServerRoot</directive>. L'impl&eacute;mentation de
    <module>mod_dav_lock</module> utilise une base de donn&eacute;es SDBM pour
    surveiller les verrous utilisateurs.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      DavGenericLockDB var/DavLock
      </highlight>
    </example>

    <p>Les utilisateur et groupe sous lesquels Apache s'ex&eacute;cute et qui
    sont respectivement d&eacute;finis par les directives <directive
    module="mod_unixd">User</directive> et <directive
    module="mod_unixd">Group</directive> doivent pouvoir &eacute;crire dans le
    r&eacute;pertoire qui contient le fichier de la base de donn&eacute;es des
    verrous. Pour des raisons de s&eacute;curit&eacute;, il est recommand&eacute; de cr&eacute;er un
    r&eacute;pertoire d&eacute;di&eacute; &agrave; la base de donn&eacute;es des verrous, plut&ocirc;t que de
    modifier les permissions d'un r&eacute;pertoire existant. Dans l'exemple
    ci-dessus, Apache va cr&eacute;er des fichiers dans le r&eacute;pertoire
    <code>var/</code>, lui-m&ecirc;me sous-r&eacute;pertoire du r&eacute;pertoire d&eacute;fini par
    la directive <directive
    module="core">ServerRoot</directive>, avec le nom de base
    <code>DavLock</code> suivi d'une extension choisie par le
    serveur.</p>

</usage>
</directivesynopsis>

</modulesynopsis>

