<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1735957 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authz_host.xml.meta">

<name>mod_authz_host</name>
<description>Autorisations de groupe basées sur l'hôte (nom ou adresse
IP)</description>
<status>Base</status>
<sourcefile>mod_authz_host.c</sourcefile>
<identifier>authz_host_module</identifier>
<compatibility>Le fournisseur <code>forward-dns</code> est disponible à partir
de la version 2.4.19 du serveur HTTP Apache</compatibility>

<summary>
    <p>Les fournisseurs d'autorisation implémentés par le module
    <module>mod_authz_host</module> sont enregistrés à l'aide de
    la directive <directive module="mod_authz_core">Require</directive>. On peut
    utiliser cette directive à l'intérieur de sections <directive
    module="core" type="section">Directory</directive>, <directive
    module="core" type="section">Files</directive>, ou <directive
    module="core" type="section">Location</directive> ou de fichiers
    <code><a href="core.html#accessfilename">.htaccess</a> </code> pour
    contrôler l'accès à certaines zones du serveur. Le contrôle d'accès
    peut être effectué en fonction du nom d'hôte ou de l'adresse IP.</p>

    <p>En général, les directives de restriction d'accès s'appliquent à
    toutes les méthodes d'accès (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de ne restreindre
    l'accès que pour certaines méthodes, tout en laissant les autres
    méthodes sans protection, en plaçant les directives dans une section
    <directive module="core" type="section">Limit</directive>.</p>
</summary>

<seealso><a href="../howto/auth.html">Authentification, autorisation et
contrôle d'accès</a></seealso>
<seealso><directive module="mod_authz_core">Require</directive></seealso>

<section id="requiredirectives"><title>Les directives Require</title>

    <p>La directive Apache <directive
    module="mod_authz_core">Require</directive> est utilisée au cours de
    la phase d'autorisation pour vérifier si un utilisateur se voit
    accorder ou refuser l'accès à une ressource. mod_authz_host fournit
    les types d'autorisation <code>ip</code>, <code>host</code>,
    <code>forward-dns</code> et <code>local</code>. D'autres
    types d'autorisation sont aussi disponibles, mais nécessitent le chargement
    des modules d'autorisation appropriés.</p>

    <p>Ces fournisseurs d'autorisation permettent de déterminer quels
    hôtes peuvent accéder à une zone du serveur. On peut contrôler
    l'accès en fonction du nom d'hôte, de l'adresse IP, ou d'un intervalle
    d'adresses IP.</p>

    <p>A partir de la version 2.4.8, les directives require host
    supportent les <a href="../expr.html">expressions</a>.</p>

<section id="reqip"><title>Require ip</title>

    <p>Le fournisseur <code>ip</code> permet de contrôler l'accès au
    serveur en fonction de l'adresse IP du client distant. Lorsque
    <code>Require ip <var>adresse-ip</var></code> est spécifié, la
    requête est autorisée si l'adresse IP du client distant correspond
    à</p>

    <p>Une adresse IP complète :</p>

    <highlight language="config">
Require ip 10.1.2.3
Require ip 192.168.1.104 192.168.1.205
    </highlight>

    <p>L'adresse IP d'un hôte pour qui l'accès est accordé</p>

    <p>Une adresse IP partielle :</p>

    <highlight language="config">
Require ip 10.1
Require ip 10 172.20 192.168.2
    </highlight>
    <p>Les 1 à 3 premiers octets d'une adresse IP, pour une restriction
    à un sous-réseau.</p>

    <p>Une paire réseau/masque de sous-réseau :</p>

    <highlight language="config">
      Require ip 10.1.0.0/255.255.0.0
    </highlight>
    <p>Un réseau a.b.c.d, et un masque de sous-réseau w.x.y.z. pour une
    restriction de sous-réseau plus fine.</p>

    <p>Une spécification CIDR réseau/nnn :</p>

    <highlight language="config">
      Require ip 10.1.0.0/16
    </highlight>
    <p>Identique au cas précédent, excepté que le masque de sous-réseau
    représente les nnn premiers bits de poids fort.</p>

    <p>Notez que les trois derniers exemples correspondent exectement au
    même ensemble d'hôtes.</p>

    <p>On peut spécifier des adresses et des sous-réseaux IPv6 comme
    suit :</p>

    <highlight language="config">
Require ip 2001:db8::a00:20ff:fea7:ccea
Require ip 2001:db8:1:1::a
Require ip 2001:db8:2:1::/64
Require ip 2001:db8:3::/48
    </highlight>

    <p>Note: comme les adresses IP sont lues au démarrage, les
    expressions ne sont pas évaluées au moment de la requête.</p>

</section>

<section id="reqhost"><title>Require host</title>

    <p>Le fournisseur <code>host</code> permet de contrôler l'accès au
    serveur en fonction du nom d'hôte du client distant. Lorsque
    <code>Require host <var>nom-hôte</var></code> est spécifié, la
    requête est autorisée si le nom d'hôte correspond à</p>

    <p>Un nom de domaine (éventuellement partiel)</p>

    <highlight language="config">
Require host example.org
Require host .net example.edu
    </highlight>

    <p>Les hôtes dont les noms correspondent ou se terminent par la
    chaîne spécifiée se voient accorder l'accès. Seuls les élément de
    nom de domaine complets sont mis en correspondance ; ainsi,
    l'exemple ci-dessus correspondra à <code>foo.example.org</code>, mais
    ne correspondra pas à <code>fooexample.org</code>. Avec cette
    configuration, Apache va effectuer une double recherche DNS sur
    l'adresse IP du client, sans tenir compte de la définition de la
    directive  <directive module="core">HostnameLookups</directive>. Il
    va effectuer une recherche DNS inverse sur l'adresse IP pour trouver
    le nom d'hôte associé, puis une recherche DNS directe sur le nom
    d'hôte pour vérifier qu'il correspond bien à l'adresse IP originale.
    L'accès ne sera accordé que si le nom d'hôte correspond et si les
    recherches DNS inverse et directe sont cohérentes.</p>

</section>

<section id="reqfwddns"><title>Require forward-dns</title>

    <p>Le fournisseur <code>forward-dns</code> permet d'accéder au serveur
    sécurisé en fonction de simples noms d'hôte. Lorsque <code>Require
    forward-dns <var>host-name</var></code> est spécifié, toute adresse IP
    correspondant à <code><var>host-name</var></code> se voit autoriser l'accès.</p>

    <p>A la différence du fournisseur <code>host</code>, ce fournisseur
    n'effectue pas de recherche DNS inverse : il effectue simplement une requête
    DNS directe pour le nom d'hôte spécifié et donne accès au client si son
    adresse IP correspond. Il ne fonctionnera donc qu'avec des noms d'hôte, et
    non avec des noms de domaine. Par contre, comme le DNS inverse n'est pas
    sollicité, il fonctionnera avec des clients qui utilisent un service de DNS
    dynamique.</p>

    <highlight language="config">
Require forward-dns bla.example.org
    </highlight>

    <p>Un client dont l'adresse IP correspond au nom d'hôte
    <code>bla.example.org</code> se verra autoriser l'accès.</p>

</section>

<section id="reqlocal"><title>Require local</title>

    <p>Le fournisseur <code>local</code> autorise l'accès au serveur si
    l'une au moins de ces conditions est satisfaite :</p>

    <ul>
        <li>l'adresse IP du client correspond à 127.0.0.0/8</li>
        <li>l'adresse IP du client est ::1</li>
        <li>les adresses IP du client et du serveur sont identiques</li>
    </ul>

    <p>L'exemple suivant montre une méthode simple pour sélectionner les
    connexions en provenance de l'hôte local :</p>

    <highlight language="config">
    Require local
    </highlight>

</section>

<section id="proxy"><title>Note concernant la sécurité</title>

    <p>Si le contenu de votre serveur est mandaté, vous devez garder à
    l'esprit que l'adresse client correspondra à l'adresse de votre
    serveur mandataire et non à l'adresse du client, et l'utilisation de
    la directive <code>Require</code> dans ce contexte ne provoquera pas
    forcément l'effet désiré. Voir <module>mod_remoteip</module> pour
    une solution possible à ce problème.</p>
    
</section>

</section>

</modulesynopsis>
