<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1786684 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="ssi.xml.meta">
<parentdocument href="./">Recettes et tutoriels</parentdocument>

<title>Tutoriel Apache httpd : Introduction aux "Inclusions Côté Serveur"
(Server Side Includes - SSI)</title>

<summary>
<p>Les SSI permettent d'ajouter du contenu dynamique à des documents
HTML préexistants.</p>
</summary>

<section id="related"><title>Introduction</title>
 <related>
    <modulelist>
    <module>mod_include</module>
    <module>mod_cgi</module>
    <module>mod_expires</module>
    </modulelist>

    <directivelist>
    <directive module="core">Options</directive>
    <directive module="mod_include">XBitHack</directive>
    <directive module="mod_mime">AddType</directive>
    <directive module="core">SetOutputFilter</directive>
    <directive module="mod_setenvif">BrowserMatchNoCase</directive>
    </directivelist>
</related>

    <p>Cet article traite des Inclusions Côté Serveur (Server Side
    Includes), plus communément appelés SSI. Vous trouverez ici la
    manière de configurer votre serveur pour permettre les SSI, ainsi
    qu'une introduction à quelques techniques SSI de base permettant
    d'ajouter du contenu dynamique à vos pages HTML préexistantes.</p>

    <p>La dernière partie de cet article sera consacrée aux
    configurations SSI plus avancées, telles que les expressions
    conditionnelles dans les directives SSI.</p>

</section>

<section id="what"><title>Qu'est-ce que SSI ?</title>

    <p>SSI (Server Side Includes) est constitué de directives placées dans
    des pages HTML, et évaluées par le serveur au moment où les pages
    sont servies. Elles vous permettent d'ajouter du contenu généré
    dynamiquement à une page HTML préexistante, sans avoir à servir la
    page entière via un programme CGI, ou toute autre technologie de
    contenu dynamique.</p>

    <p>Par exemple, vous pouvez insérer la directive suivante dans une
    page HTML existante :</p>

    <example>
    &lt;!--#echo var="DATE_LOCAL" --&gt;
    </example>

    <p>Ainsi, lorsque la page sera servie, la directive sera évaluée et
    remplacée par sa valeur :</p>

    <example>
    Tuesday, 15-Jan-2013 19:28:54 EST
    </example>

    <p>Le choix entre l'utilisation des SSI et la génération entière de
    la page par un programme quelconque, est en général dicté par la
    proportion de contenu statique et de contenu devant être généré
    chaque fois que la page est servie. SSI est idéal pour ajouter de
    petites quantités d'information, comme l'heure courante dans
    l'exemple précédent. Mais si la
    plus grande partie de votre page est générée au moment où elle est
    servie, vous devez vous tourner vers une autre solution.</p>
</section>

<section id="configuring">
<title>Configurer votre serveur pour permettre les SSI</title>

    <p>Pour permettre l'utilisation des SSI sur votre serveur, vous
    devez ajouter la directive suivante dans votre fichier
    <code>httpd.conf</code>, ou dans un fichier <code>.htaccess</code>
    :</p>
<highlight language="config">
        Options +Includes
</highlight>

    <p>Cette directive indique à Apache que vous désirez permettre la
    recherche de directives SSI lors de l'interprétation des fichiers.
    Notez cependant que la plupart des configurations contiennent de
    nombreuses directives <directive module="core">Options</directive>
    qui peuvent s'écraser les unes les autres. Vous devrez probablement
    appliquer ces directives <code>Options</code> au répertoire
    spécifique pour lequel vous voulez activer les SSI, afin d'être sûr
    qu'elles y seront bien activées.</p>

    <p>Tout fichier ne fera cependant pas l'objet de recherche de
    directives SSI. Vous devez indiquer à Apache quels fichiers seront
    concernés. Vous pouvez y parvenir en indiquant une extension, comme
    <code>.shtml</code>, à l'aide des directives suivantes :</p>
<highlight language="config">
AddType text/html .shtml
AddOutputFilter INCLUDES .shtml        
</highlight>

    <p>Un des désavantages de cette approche réside dans le fait que si
    vous voulez ajouter des directives SSI à une page préexistante, vous
    devrez changer le nom de cette page, et donc tout lien qui la
    contient, de façon à ce qu'elle possède l'extension
    <code>.shtml</code>, condition nécessaire pour que les directives
    SSI qu'elle contient soient traitées.</p>

    <p>Une autre méthode consiste à utiliser la directive <directive
    module="mod_include">XBitHack</directive> :</p>
<highlight language="config">
        XBitHack on
</highlight>

    <p>La directive <directive module="mod_include">XBitHack</directive>
    indique à Apache qu'il doit rechercher des directivves SSI dans les
    fichiers si leur bit d'exécution est positionné. Il n'est ainsi plus
    nécessaire de changer le nom du fichier pour ajouter des directives
    SSI à une page préexistante ; vous devez simplement attribuer les
    droits d'exécution au fichier à l'aide de <code>chmod</code>.</p>
<example>
        chmod +x pagename.html
</example>

    <p>Un bref commentaire sur ce qu'il ne faut pas faire. Certaines
    personnes peuvent vous conseiller de tout simplement indiquer à
    Apache de rechercher des directives SSI dans tous les fichiers
    <code>.html</code>, ce qui vous évite d'avoir à gérer les noms de
    fichiers avec extension <code>.shtml</code>. Ils n'ont probablement
    pas entendu parler de la directive <directive
    module="mod_include">XBitHack</directive>. En effet, vous devez
    garder à l'esprit qu'en faisant ceci, Apache va devoir rechercher
    des directives SSI dans chaque fichier qu'il sert, même s'il n'en
    contient aucune. Ce n'est donc pas une bonne idée car les
    performances peuvent en être sensiblement affectées.</p>

    <p>Bien entendu, sous Windows, il n'y a pas de bit d'exécution à
    positionner, ce qui limite un peu vos choix.</p>

    <p>Dans sa configuration par défaut, Apache n'envoie pas la date de
    dernière modification ou les en-têtes HTTP relatifs à la taille des
    contenus dans les pages SSI, car ses valeurs sont difficiles à
    calculer pour les contenus dynamiques. Ceci peut induire une
    impression de diminution des performances côté client, en empêchant
    la mise en cache de votre document. Il existe deux méthodes pour
    résoudre ce problème :</p>

    <ol>
      <li>Utilisez la configuration <code>XBitHack Full</code>. Elle
      indique à Apache de déterminer la date de dernière modification en
      ne regardant que la date du fichier à l'origine de la requête,
      tout en ignorant la date de modification de tout fichier inclus.</li>

      <li>Utilisez les directives fournies par le module
      <module>mod_expires</module> pour définir de manière explicite la
      date d'expiration de vos fichiers, laissant par la-même
      aux navigateurs et aux mandataires le soin de déterminer s'il est
      opportun ou non de les mettre en cache.</li>
    </ol>
</section>

<section id="basic"><title>Directives SSI de base</title>

    <p>Les directives SSI adoptent la syntaxe suivante :</p>
<example>
        &lt;!--#fonction attribut=valeur attribut=valeur ... --&gt;
</example>

    <p>Le format d'une directive SSI étant similaire à celui d'un
    commentaire HTML, si vous n'avez pas activé correctement SSI, le
    navigateur l'ignorera, mais elle sera encore visible dans le source
    HTML. Si SSI est correctement configuré, la directive sera remplacée
    par ses résultats.</p>

    <p>"fonction" peut prendre de nombreuses formes, et nous décrirons
    plus précisément la plupart d'entre eux dans la prochaine version de
    ce document. Pour le moment, voici quelques exemples de ce que vous
    pouvez faire avec SSI.</p>

<section id="todaysdate"><title>La date courante</title>

<example>
        &lt;!--#echo var="DATE_LOCAL" --&gt;
</example>

    <p>La fonction <code>echo</code> permet d'afficher la valeur d'une
    variable. Il existe un grand nombre de variables standards, y
    compris l'ensemble des variables d'environnement disponibles pour
    les programmes CGI. De plus, vous pouvez définir vos propres
    variables à l'aide de la fonction <code>set</code>.</p>

    <p>Si vous n'aimez pas le format sous lequel la date s'affiche, vous
    pouvez utiliser la fonction <code>config</code> avec un attribut
    <code>timefmt</code>, pour le modifier.</p>

<example>
        &lt;!--#config timefmt="%A %B %d, %Y" --&gt;<br />
        Today is &lt;!--#echo var="DATE_LOCAL" --&gt;
</example>
</section>

<section id="lastmodified"><title>Date de modification du fichier</title>

<example>
        Dernière modification du document &lt;!--#flastmod file="index.html" --&gt;
</example>

    <p>Le format peut là aussi être modifié à l'aide de l'attribut
    <code>timefmt</code>.</p>
</section>

<section id="cgi"><title>Inclusion des résultats d'un programme CGI</title>

    <p>C'est le cas le plus courant d'utilisation des SSI - afficher les
    résultats d'un programme CGI, comme l'universellement adoré
    "compteur d'accès".</p>

<example>
        &lt;!--#include virtual="/cgi-bin/counter.pl" --&gt;
</example>

</section>
</section>

<section id="additionalexamples">
<title>Exemples additionnels</title>

    <p>Vous trouverez dans ce qui suit quelques exemples spécifiques de
    ce que vous pouvez faire de vos documents HTML avec SSI.</p>

<section id="docmodified"><title>Quand ce document a-t-il été modifié ?</title>

    <p>Nous avons mentionné plus haut que vous pouviez utiliser SSI pour
    informer l'utilisateur de la date de dernière modification du
    document. Cependant, la méthode pour y parvenir n'a pas été vraiment
    abordée. Placé dans votre document HTML, le code suivant va insérer
    un repère de temps dans votre page. Bien entendu, SSI devra avoir
    été correctement activé, comme décrit plus haut.</p>
<example>
        &lt;!--#config timefmt="%A %B %d, %Y" --&gt;<br />
        Dernière modification du fichier &lt;!--#flastmod file="ssi.shtml" --&gt;
</example>

    <p>Bien entendu, vous devez remplacer <code>ssi.shtml</code> par le
    nom du fichier auquel vous faites référence. Ceci ne conviendra pas
    si vous recherchez un morceau de code générique que vous pourrez
    insérer dans tout fichier ; dans ce cas, il est préférable
    d'utiliser la variable <code>LAST_MODIFIED</code> :</p>
<example>
        &lt;!--#config timefmt="%D" --&gt;<br />
        This file last modified &lt;!--#echo var="LAST_MODIFIED" --&gt;
</example>

    <p>Pour plus de détails sur le format <code>timefmt</code>, tapez
    <code>strftime</code> dans votre moteur de recherche préferé. La
    syntaxe est identique.</p>
</section>

<section id="standard-footer">
<title>Inclusion d'un pied de page standard</title>

    <p>Si le site que vous gérez comporte plus que quelques pages, vous
    allez vite vous apercevoir qu'effectuer des modifications sur toutes
    ces pages peut devenir très contraignant, en particulier si vous
    voulez qu'elles conservent un aspect homogène.</p>

    <p>Inclure un fichier pour un en-tête et/ou un pied de page peut
    simplifier cette corvée de mises à jour. Il vous suffit de
    confectionner un fichier de pied de page, et de l'inclure dans
    chaque page à l'aide de l'élément SSI <code>include</code>. Pour
    définir le fichier à inclure, la fonction <code>include</code> peut
    utiliser soit l'attribut <code>file</code>, soit l'attribut
    <code>virtual</code>. L'attribut <code>file</code> est un chemin de
    fichier <em>relatif au répertoire courant</em>. C'est à dire qu'il
    ne peut ni avoir pour valeur un chemin absolu (commençant par /), ni
    comporter "../" dans son chemin. L'attribut <code>virtual</code> est
    probablement plus commode, et peut spécifier une URL relative au
    document servi. Elle peut commencer par un /, mais le fichier inclus
    et le fichier servi doivent résider sur le même serveur.</p>
<example>
        &lt;!--#include virtual="/footer.html" --&gt;
</example>

    <p>Je combinerai souvent ces deux derniers points, en ajoutant une
    directive <code>LAST_MODIFIED</code> dans un fichier de pied de page
    destiné à être inclus. Le fichier inclus peut contenir des
    directives SSI, et les inclusions peuvent être imbriquées - à
    savoir, le fichier inclus peut inclure un autre fichier, etc...</p>
</section>

</section>

<section id="config">
<title>Que puis-je configurer d'autre ?</title>

    <p>En plus du format de date, vous pouvez utiliser l'élément
    <code>config</code> pour configurer deux autres choses.</p>

    <p>En général, lorsque quelque chose se passe mal avec votre
    directive SSI, vous recevez le message :</p>
<example>
        [an error occurred while processing this directive]
</example>

    <p>Pour modifier ce message, vous pouvez utiliser l'attribut
    <code>errmsg</code> avec la fonction <code>config</code> :</p>
<example>
        &lt;!--#config errmsg="[Il semblerait que vous ne sachiez pas
	utiliser les SSI]" --&gt;
</example>

    <p>Il est cependant probable que les utilisateurs finaux ne voient
    jamais ce message, car vous aurez résolu tous les problèmes issus de
    vos directives SSI avant que votre site ne soit mis en production.
    (N'est-ce pas ?)</p>

    <p>Vous pouvez aussi modifier le format sous lequel les tailles de
    fichiers sont affichées à l'aide de l'attribut <code>sizefmt</code>.
    Vous pouvez spécifier <code>bytes</code> pour un affichage en
    octets, ou <code>abbrev</code> pour un affichage plus concis en Ko
    ou Mo, selon le cas.</p>
    </section>

<section id="exec">
    <title>Exécution de commandes</title>

    <p>Voici autre chose que vous pouvez faire avec la fonction
    <code>exec</code>. Vous pouvez vraiment faire exécuter une commande
    par SSI en utilisant le shell (<code>/bin/sh</code>, pour être plus
    précis - ou le shell DOS, si vous êtes sous Win32). Par exemple, ce
    qui suit vous permet d'afficher le contenu d'un répertoire.</p>
<example>
        &lt;pre&gt;<br />
        &lt;!--#exec cmd="ls" --&gt;<br />
        &lt;/pre&gt;
</example>

    <p>ou, sous Windows</p>
<example>
        &lt;pre&gt;<br />
        &lt;!--#exec cmd="dir" --&gt;<br />
        &lt;/pre&gt;
</example>

    <p>Vous noterez probablement l'étrange formatage provoqué par cette
    directive sous Windows, car la sortie de <code>dir</code> contient
    la chaîne  de caractères "&lt;<code>dir</code>&gt;", ce qui trompe le
    navigateur.</p>

    <p>Notez que cette fonctionnalité est très dangereuse, car elle va
    permettre d'exécuter tout code associé à l'élément
    <code>exec</code>. Si vous êtes dans la situation où les
    utilisateurs peuvent éditer le contenu de vos pages web, dans le cas
    d'un "livre d'or" par exemple, assurez-vous de désactiver cette
    fonctionnalité. Vous pouvez, tout en permettant les SSI, désactiver
    la fonctionnalité <code>exec</code> à l'aide de l'argument
    <code>IncludesNOEXEC</code> de la directive
    <code>Options</code>.</p>
    </section>

<section id="advanced">
<title>Techniques SSI avancées</title>

    <p>Outre l'affichage de contenu, les SSI d'Apache vous permettent de
    définir des variables, et de les utiliser dans des comparaisons et
    des conditions.</p>

<section id="variables"><title>Définition de variables</title>

    <p>Avec l'élément <code>set</code>, vous pouvez définir des
    variables pour un usage ultérieur. Comme nous en aurons besoin plus
    loin, nous allons en parler tout de suite. La syntaxe se présente
    comme suit :</p>
<example>
        &lt;!--#set var="name" value="Rich" --&gt;
</example>

    <p>Pour affecter une valeur à vos variables, en plus de la
    définition littérale de l'exemple ci-dessus, vous pouvez utiliser
    une autre variable, y compris les <a
    href="../env.html">variables d'environnement</a>, ou les variables
    décrites plus haut (comme <code>LAST_MODIFIED</code> par exemple).
    Pour indiquer qu'il s'agit d'une variable et non d'une chaîne, vous
    devez utiliser le symbole dollar ($) devant le nom de la
    variable.</p>

    <example> &lt;!--#set var="modified" value="$LAST_MODIFIED" --&gt;
    </example>

    <p>Pour insérer un caractère $ dans la valeur de votre variable,
    vous devez l'échapper à l'aide d'un backslash.</p>
<example>
        &lt;!--#set var="cost" value="\$100" --&gt;
</example>

    <p>Enfin, si vous voulez insérer une variable dans une chaîne, et
    s'il y a une chance pour que le nom de la variable se confonde avec
    le reste de la chaîne, vous pouvez l'entourer d'accolades pour
    eviter toute confusion (Il est difficile de trouver un bon exemple
    pour illustrer ceci, mais j'espère que vous comprendrez).</p>
<example>
        &lt;!--#set var="date" value="${DATE_LOCAL}_${DATE_GMT}" --&gt;
</example>
</section>

<section id="conditional">
<title>Expressions conditionnelles</title>

    <p>Maintenent que nous avons des variables, et que nous pouvons
    définir et comparer leurs valeurs, nous sommes à même de les
    utiliser dans des expressions conditionnelles. Ceci confère à SSI le
    statut de petit langage de programmation.
    <module>mod_include</module> fournit une structure <code>if</code>,
    <code>elif</code>, <code>else</code>, <code>endif</code> pour la
    construction d'expressions conditionnelles, ce qui vous permet de
    générer plusieurs pages logiques à partir d'une seule vraie
    page.</p>

    <p>La structure de l'expression conditionnelle est :</p>
<example>
    &lt;!--#if expr="condition" --&gt;<br />
    &lt;!--#elif expr="condition" --&gt;<br />
    &lt;!--#else --&gt;<br />
    &lt;!--#endif --&gt;
</example>

    <p>Une <em>condition</em> peut revêtir la forme de toute comparaison
    logique - soit une comparaison de valeurs avec une autre, soit une
    vérification de la "vérité" d'une valeur particulière (Une chaîne
    donnée est vraie si elle n'est pas vide). Pour une liste exhaustive
    des opérateurs de comparaison disponibles, voir la documentation du
    module <module>mod_include</module>.</p>

    <p>Par exemple, spour insérer l'heure du jour dans votre page web,
    vous pouvez ajouter ces lignes dans la page HTML :</p>

    <example>
    Good
    &lt;!--#if expr="%{TIME_HOUR} &lt;12" --&gt;<br />
    morning!<br />
    &lt;!--#else --&gt;<br />
    afternoon!<br />
    &lt;!--#endif --&gt;<br />
    </example>    

    <p>Toute autre variable (que vous avez définie, ou une variable
    d'environnement normale) peut être utilisée dans les expressions
    conditionnelles. Voir le document <a href="../expr.html">Expressions
    rationnelles dans le serveur HTTP Apache</a> pour plus de détails à
    propos du fonctionnement du moteur d'évaluation des expressions
    rationnelles.</p>
    
    <p>Associée à la possibilité avec Apache de définir
    des variables d'environnement à l'aide de directives
    <code>SetEnvIf</code>, ainsi que d'autres directives en rapport,
    cette fonctionnalité vous permet d'ajouter une grande variété
    de contenus dynamiques côté serveur sans avoir à concevoir une
    application web de A à Z.</p>
</section>
</section>

<section id="conclusion"><title>Conclusion</title>

    <p>SSI ne remplace certainement pas CGI, ou d'autres technologies
    utilisées pour la génération de pages web dynamiques. Mais c'est une
    bonne méthode pour ajouter des petits contenus dynamiques à vos
    pages, sans devoir fournir un gros effort supplémentaire.</p>
</section>

</manualpage>
