<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1780218 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="glossary.xml.meta">

  <title>Glossaire</title>

  <summary>
    <p>Ce glossaire définit la terminologie courante relative à Apache en
    particulier, et aux serveurs web en général. Vous trouverez plus
    d'informations sur chaque concept dans les liens fournis.</p>
  </summary>

<section id="definitions"><title>Définitions</title>
<dl>
<dt><a name="algorithm" id="algorithm">Algorithme</a></dt>

    <dd>Une formule sans ambiguité ou un jeu de règles destinées à
    résoudre un problème en un nombre fini d'étapes. Les algorithmes de
    chiffrement sont en général appelés
      <dfn>Ciphers</dfn>.
    </dd>

    <dt><a name="cipher" id="cipher">Algorithme de chiffrement
    (Cipher)</a></dt>
    <dd>Un algorithme ou un système de chiffrement des données.
    Quelques exemples : DES, IDEA, RC4, etc.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="apr" id="APR">APR</a></dt>
    <dd>Voir "Bibliothèques pour la portabilité d'Apache"
    </dd>

    <dt><a name="tarball" id="tarball">Archive Tar (Tarball)</a></dt>
  <dd>Un paquetage de fichiers rassemblés dans une archive
  à l'aide de l'utilitaire <code>tar</code>.
    Les distributions d'Apache sont stockées dans des Archives Tar compressées
    ou en utilisant pkzip.
  </dd>

    <dt><a name="authentication" id="authentication">Authentification </a></dt>
    <dd>L'identification formelle d'une entité du réseau comme un serveur, un
    client, ou un utilisateur.<br />
      Voir : <a href="howto/auth.html">Authentification, Autorisation, et
      contrôle d'accès</a>
    </dd>

    <dt><a name="certificationauthority"
        id="certificationauthority">Autorité de Certification
	(Certification Authority)</a>
      <a name="ca" id="ca">(CA)</a></dt>
    <dd>Un tiers de confiance habilité à signer des certificats pour des entités
    du réseau qu'il a authentifiées selon des critères basés sur la sécurité.
    Les autres entités du réseau peuvent alors utiliser la signature pour
    vérifier qu'une CA a authentifié le porteur du certificat.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="apacheportableruntime"
       id="apacheportableruntime">Bibliothèques pour la portabilité d'Apache
       (Apache Portable Runtime)</a> <a
       name="apr" id="apr">(APR)</a></dt>
    <dd>Un jeu de bibliothèques qui fournit la plupart des interfaces de base
      entre le serveur et le système d'exploitation.  APR est développé
      parallèlement au serveur HTTP Apache comme projet indépendant.<br />
      Voir : <a href="http://apr.apache.org/">Apache Portable Runtime
      Project</a>
    </dd>


<dt><a name="certificate" id="certificate">Certificat (Certificate)</a></dt>
    <dd>Un ensemble de données servant à authentifier des entités du
    réseau comme un serveur ou un client. Un certificat contient des ensembles
    d'informations X509 à propos de son propriétaire (appelé sujet/subject)
    et de l'<glossary
      ref="certificationauthority">Autorité de Certification
      (Certification Authority) ou CA</glossary> signataire (appelée
      le fournisseur/issuer), ainsi que la
      <glossary ref="publickey">clé publique (public
      key)</glossary> du propriétaire et la
      signature de la CA. Les entités du réseau vérifient ces signatures
      en utilisant les certificats des Autorités de Certification.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="publickeycryptography"
      id="publickeycryptography">Chiffrement à Clé Publique
      (Public Key Cryptography)</a></dt>
    <dd>L'étude et l'application des systèmes de chiffrement asymétriques,
    qui utilisent une clé pour le chiffrement et une autre pour le
    déchiffrement. Les deux clés correspondantes constituent une paire de clés.
    Appelé aussi chiffrement asymétrique.
      <br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="privatekey" id="privatekey">Clé Privée (Private Key)</a></dt>
    <dd>La clé secrète dans un système de
    <glossary ref="publickeycryptography">chiffrement à clé publique</glossary>,
    utilisée pour déchiffrer les messages entrants et signer
    les messages sortants.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

<dt><a name="publickey" id="publickey">Clé Publique (Public Key)</a></dt>
    <dd>La clé accessible au public dans un système de <glossary
      ref="publickeycryptography">Chiffrement à clé publique</glossary>,
      utilisée pour chiffrer les messages destinés uniquement à son
      propriétaire et déchiffrer les signatures
      faites par son propriétaire.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

<dt><a name="connect" id="connect">CONNECT</a></dt>
    <dd>Une <glossary ref="method">méthode</glossary> HTTP pour encapsuler
    des données brutes dans HTTP. Elle peut aussi être utilisée pour encapsuler
    d'autres protocoles, comme le protocole SSL.
    </dd>

    <dt><a name="context" id="context">Contexte (Context)</a></dt>
    <dd>Une portion des <glossary ref="configurationfile">
    fichiers de configuration</glossary> dans laquelle certains types de
    <glossary ref="directive">directives</glossary> sont autorisés.<br />
      Voir : <a href="mod/directive-dict.html#Context">Termes utilisés
      pour décrire les directives d'Apache</a>
    </dd>

    <dt><a name="accesscontrol" id="accesscontrol">Contrôle d'accès
    (Access Control)</a></dt>
    <dd>La restriction d'accès à des zones du réseau. Habituellement
    dans un contexte Apache,
      la restriction d'accès à certaines <em>URLs</em>.<br />
      Voir :  <a
      href="howto/auth.html">Authentification, Autorisation et
      Contrôle d'accès</a>
    </dd>

    <dt><a name="securesocketslayer" id="securesocketslayer">
    Couche des Points de connexion Sécurisés
    (Secure Sockets Layer)
      </a> <a name="ssl" id="ssl">(SSL)</a></dt>
  <dd>Un protocole créé par Netscape Communications Corporation pour
  l'authentification et le chiffrement généraux des communications dans les
  réseaux TCP/IP.  L'utilisation la plus connue est <em>HTTPS</em>, autrement dit
  le Protocole de Transfert Hypertexte (HTTP) au dessus de SSL.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>

  <dt><a name="subrequest" id="subrequest">Sous-requête</a></dt>
    <dd>Apache possède une API des sous-requêtes pour les modules qui
    permettent l'évaluation complète ou partielle par le serveur de
    chemins d'autres systèmes de fichiers ou d'URL. Par exemple, la
    directive <directive module="mod_dir">DirectoryIndex</directive>,
    les modules <module>mod_autoindex</module> et
    <module>mod_include</module> utilisent cette API.
    </dd>

  <dt><a name="symmetriccryptophraphy" id="symmetriccryptophraphy">
  Cryptographie Symétrique (Symmetric Cryptography)</a></dt>
  <dd>L'étude et l'application des <em>Algorithmes de chiffrement</em> qui
  utilisent une clé secrète unique pour les opérations de chiffrement et de
  déchiffrement.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>


    <dt><a name="export-crippled" id="export-crippled">
    Dégradé pour l'exportation
    (Export-Crippled)</a></dt>
    <dd>Diminué en terme de puissance cryptographique (et de sécurité)
    afin de respecter les Règles de l'Administration des Exportations
     des Etats-Unis (Export Administration Regulations ou EAR).
      Les logiciels de cryptographie dégradés pour l'exportation sont limités
      à une clé de petite taille, et produisent un
      <em>Texte crypté</em> qui peut en général être décrypté
      par force brute.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>


    <dt><a name="certificatsigningrequest"
      id="certificatsigningrequest">Demande de signature de certificat
      (Certificate Signing Request)</a>
      <a name="csr" id="csr">(CSR)</a></dt>
    <dd>La soumission d'un <glossary ref="certificate">certificat</glossary>
    non signé à une <glossary ref="certificationauthority">Autorité de
    certification</glossary>, qui le signe avec la <glossary
      ref="privatekey">Clé privée</glossary> de leur
      <em>Certificat</em> de CA. Une fois le CSR signé, il devient un vrai
      certificat.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="directive" id="directive">Directive</a></dt>
    <dd>Une commande de configuration qui contrôle un ou plusieurs aspects du
    comportement d'Apache.  Les directives sont placées dans le <glossary
      ref="configurationfile">Fichier de configuration</glossary><br />
    Voir : <a href="mod/directives.html">Index des directives</a>
    </dd>

<dt><a name="configurationdirective"
        id="configurationdirective">Directive de configuration
	(Configuration Directive)</a></dt>
    <dd>Voir : <glossary ref="directive">Directive</glossary></dd>

    <dt><a name="header" id="header">En-tête (Header)</a></dt>
    <dd>La partie de la requête et de la réponse
    <glossary ref="http">HTTP</glossary> qui est envoyée avant le contenu
    proprement dit, et contient des méta-informations décrivant le contenu.
    </dd>

    <dt><a name="regularexpression" id="regularexpression">Expression Rationnelle
    (Regular Expression)</a>
      <a name="regex" id="regex">(Regex)</a></dt>
    <dd>Une méthode pour décrire un modèle sous forme de texte - par exemple,
    "tous les mots qui commencent par la lettre A" ou "tous les numéros de
    téléphone à 10 chiffres" ou encore "Toutes les phrases contenant 2 virgules,
    et aucun Q majuscule". Les expressions rationnelles sont très utiles dans
    Apache car elles vous permettent d'appliquer certains attributs à des
    ensembles de fichiers ou ressources avec une grande flexibilité
      - par exemple, tous les fichiers .gif et .jpg situés dans tout répertoire
      nommé "images", pourraient être enregistrés comme
      "<code>/images/.*(jpg|gif)$</code>".  Lorsque l'on utilise des
      expressions rationnelles pour la substitution de chaînes, les
      variables spéciales $1 ... $9 contiennent des références arrières
      vers les parties regroupées (entre parenthèses) de l'expression
      qui correspond. La variable spéciale $0 contient une référence
      arrière vers l'ensemble de l'expression qui correspond. Pour
      insérer un caractère littéral "dollar" dans la chaîne de
      remplacement, il faut l'échapper avec un anti-slash. Pour des
      raisons historiques, la variable &amp; peut être utilisée en tant
      qu'alias de $0 dans certains cas, mais ceci n'est plus possible
      depuis la version 2.3.6. Apache utilise les Expressions
      Rationnelles Compatibles avec Perl fournies par la librairie <a
      href="http://www.pcre.org/">PCRE</a>. Vous trouverez plus
      d'information à propos de la syntaxe des expressions rationnelles
      PCRE sur ce site, ou dans le <a
      href="http://en.wikipedia.org/wiki/PCRE">Wikipedia de la PCRE</a>.
  </dd>

    <dt><a name="configurationfile" id="configurationfile">
    Fichier de configuration
    (Configuration File)</a></dt>
    <dd>Un fichier texte contenant des
    <glossary ref="directive">Directives</glossary>
      qui contrôlent la configuration d'Apache.<br />
      Voir : <a href="configuring.html">Fichiers de configuration</a>
    </dd>

    <dt><a name="filter" id="filter">Filtre (Filter)</a></dt>
    <dd>Un traitement appliqué aux données envoyées ou reçues par le serveur.
      Les filtres en entrée traitent les données envoyées au serveur par le
      client, alors que les filtres en sortie traitent les documents sur le
      serveur avant qu'ils soient envoyés au client.
      Par exemple, le filtre en sortie
      <code>INCLUDES</code>
      traite les documents pour les
      <glossary ref="ssi">Server Side Includes (Inclusions côté Serveur)
      </glossary>.<br />
      Voir : <a href="filter.html">Filtres</a>
    </dd>

<dt><a name="handler" id="handler">Gestionnaire (Handler)</a></dt>
    <dd>Une représentation interne à Apache de l'action à entreprendre
    quand un fichier est appelé. En général, les fichiers ont des gestionnaires
    implicites, basés sur le type de fichier. Normalement, tous les
    fichiers sont directement servis par le serveur, mais certains
    types de fichiers sont "gérés" séparément.  Par exemple, le gestionnaire
      <code>cgi-script</code> désigne les fichiers qui doivent être traités
      comme <glossary ref="cgi">CGIs</glossary>.<br />
      Voir : <a href="handler.html">Utilisation des gestionnaires d'Apache</a>
    </dd>

    <dt><a name="hash" id="hash">Hachage (Hash)</a></dt>
    <dd>Un algorithme mathématique à sens unique, irréversible, générant une
    chaîne de longueur fixe à partir d'une autre chaîne de longueur quelconque.
    Des chaînes différentes en entrée vont normalement produire des chaînes
    différentes en sortie (selon la fonction de hachage).
    </dd>

    <dt><a name="virtualhosting" id="virtualhosting">Hébergement Virtuel
    (Virtual Hosting)</a></dt>
  <dd>Servir des sites web multiples en utilisant une seule instance d'Apache.
  Les <em>Hôtes virtuels basés sur IP</em> différencient les sites web en se
  basant sur leur adresse IP, alors que les
  <em>Hôtes virtuels basés sur le nom</em> utilisent uniquement le nom d'hôte
  et peuvent en conséquence héberger de nombreux sites avec la même
  adresse IP.<br />
    Voir la <a href="vhosts/">Documentation des Hôtes Virtuels d'Apache</a>
  </dd>


    <dt><a name="htaccess" id="htaccess">.htaccess</a></dt>
    <dd>Un <glossary ref="configurationfile">fichier de configuration</glossary>
    placé à un certain niveau de l'arborescence du site web, et appliquant des
    <glossary ref="directive">directives</glossary> de configuration au
    répertoire dans lequel il est placé, ainsi qu'à tous ses sous-répertoires.
    En dépit de son nom, ce fichier peut contenir pratiquement tout type de
    directive, et pas seulement des directives de contrôle d'accès.<br />
      Voir : <a href="configuring.html">Fichiers de configuration</a>
    </dd>

<dt><a name="httpd.conf" id="httpd.conf">httpd.conf</a></dt>
    <dd>Le <glossary ref="configurationfile">fichier de configuration
    </glossary> principal d'Apache.  Sa localisation par défaut est
      <code>/usr/local/apache2/conf/httpd.conf</code>, mais ceci peut être
      changé en utilisant des options de compilation ou d'exécution.<br />
      Voir : <a href="configuring.html">Fichiers de configuration</a>
    </dd>

     <dt><a name="https" id="https">HTTPS</a></dt>
    <dd>Le Protocole de Transfert Hypertexte (Sécurisé), le mécanisme de
    communication cryptée standard sur le World Wide Web.
    Il s'agit en fait de HTTP au dessus de
    <glossary ref="ssl">SSL</glossary>.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="uniformresourceidentifier"
    id="uniformresourceidentifier">Identificateur de Ressource Uniformisé
    (Uniform Resource Identifier)</a>
    <a name="URI" id="URI">(URI)</a></dt>
  <dd>Une chaîne de caractères compacte servant à identifier une ressource
  abstraite ou physique.  Elle est formellement définie par la <a
      href="http://www.ietf.org/rfc/rfc2396.txt">RFC 2396</a>.  Les URIs
      utilisées sur le world-wide web sont souvent appelées <glossary
      ref="url">URLs</glossary>.
  </dd>

    <dt><a name="serversideincludes" id="serversideincludes">
    Inclusions Côté Serveur
    (Server Side Includes)</a> <a name="ssi" id="ssi">(SSI)
      </a></dt>
  <dd>Une technique permettant d'englober des directives de traitement dans
  des fichiers HTML.<br />
    Voir : <a href="howto/ssi.html">Introduction aux Inclusions Côté Serveur</a>
  </dd>

  <dt><a name="servernameindication"
  id="servernameindication">Indication du nom du serveur</a> <a
  name="sni" id="sni">(SNI)</a></dt>
    <dd>Une fonctionnalité SSL permettant de spécifier le
    nom du serveur désiré dans le message initial de la
    négociation SSL, de façon à ce que le serveur web
    puisse choisir la bonne configuration de serveur virtuel à
    utiliser pendant le déroulement de la négociation SSL.
    Cette fonctionnalité a été ajoutée
    à SSL lorsque sont apparues les extensions TLS, RFC 3546.<br />
      Voir <a href="ssl/ssl_faq.html">la FAQ SSL</a>
      et <a href="http://www.ietf.org/rfc/rfc3546.txt">la RFC 3546</a>
    </dd>



<dt><a name="commongatewayinterface" id="commongatewayinterface">
Interface commune avec les programmes externes
(Common Gateway Interface)</a>
	 <a name="cgi" id="cgi">(CGI)</a></dt>
    <dd>La définition standard d'une interface entre un serveur web et un
    programme externe pour permettre à ce dernier de traiter des requêtes.
     Il existe une <a href="http://www.ietf.org/rfc/rfc3875">RFC
     informationnelle</a> qui en couvre les spécificités.<br />
      Voir : <a href="howto/cgi.html">Contenu dynamique avec CGI</a>
    </dd>



<dt><a name="uniformresourcelocator" id="uniformresourcelocator">
Localisation de Ressource Uniformisée
(Uniform Resource Locator)
      </a> <a name="url" id="url">(URL)</a></dt>
  <dd>Le nom/adresse d'une ressource sur l'Internet.  Il s'agit du terme
  informel commun pour ce qui est formellement défini comme <glossary
      ref="uniformresourceidentifier">
      Identificateur de Ressource Uniformisé</glossary>.
    Les URLs sont généralement construites selon un schéma, comme
    <code>http</code> ou
    <code>https</code>, un nom d'hôte, et un chemin.  Une URL pour cette page
    pourrait être
    <code>http://httpd.apache.org/docs/&httpd.docs;/glossary.html</code>.
  </dd>


    <dt><a name="proxy" id="proxy">Mandataire (Proxy)</a></dt>
    <dd>Un serveur intermédiaire qui se situe entre le client et le
    <em>serveur d'origine</em>.
    Il prend en compte les requêtes des clients, les transmet au serveur
    d'origine, puis renvoie la réponse du serveur d'origine au client.
    Si plusieurs clients demandent le même contenu, le mandataire peut l'extraire
    de son cache, plutôt que le demander au serveur d'origine
    à chaque fois, ce qui réduit le temps de réponse.<br />
      Voir : <a href="mod/mod_proxy.html">mod_proxy</a>
    </dd>

    <dt><a name="reverseproxy" id="reverseproxy">Mandataire inverse
    (Reverse Proxy)</a></dt>
  <dd>Un serveur <glossary ref="proxy">mandataire</glossary> qui est vu du client
    comme un <em>serveur d'origine</em>.  Ceci peut s'avérer utile pour
    dissimuler le serveur d'origine réel au client pour des raisons de sécurité,
    ou pour répartir la charge.
  </dd>

    <dt><a name="method" id="method">Méthode (Method)</a></dt>
    <dd>Dans le contexte <glossary ref="http">HTTP</glossary>, une action à
      effectuer sur une ressource spécifiée dans la ligne de requête
      par le client.  Parmi les méthodes disponibles dans HTTP, on trouve
      <code>GET</code>, <code>POST</code>,
      et <code>PUT</code>.
    </dd>

    <dt><a name="module" id="module">Module</a></dt>
    <dd>Une partie indépendante d'un programme.  De nombreuses fonctionnalités
    d'Apache sont fournies par des modules que vous pouvez choisir d'inclure
    ou d'exclure.  Les modules qui sont compilés dans le binaire
    <program>httpd</program> sont appelés <dfn>modules statiques</dfn>, alors
    que les modules qui existent séparément et peuvent être chargés
    optionnellement à l'exécution sont appelés
      <dfn>modules dynamiques</dfn> ou <glossary ref="dso">DSOs</glossary>.
      Les modules qui sont inclus par défaut sont appelés
      <dfn>modules de base</dfn>. De nombreux modules disponibles pour Apache
      ne se trouvent pas dans l'<glossary ref="tarball">archive</glossary>
      du Serveur HTTP Apache .  Il sont appelés
      <dfn>modules tiers</dfn>.<br />
      Voir : <a href="mod/">Index des modules</a>
    </dd>

<dt><a name="passphrase" id="passphrase">Mot de Passe (Pass Phrase)</a></dt>
    <dd>Le mot ou la phrase qui protège les fichiers de clés privées.
    Il empêche les utilisateurs non autorisés de les déchiffrer. En général,
    il s'agit simplement de la clé secrète de chiffrement/déchiffrement
      utilisée pour les <glossary
      ref="cipher">Algorithmes de chiffrement</glossary>.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="fully-qualifieddomain-name"
        id="fully-qualifieddomain-name">Nom de domaine entièrement qualifié
	(Fully-Qualified Domain-Name)</a>
      <a name="fqdn" id="fqdn">(FQDN)</a></dt>
    <dd>Le nom unique d'une entité du réseau, comprenant un nom d'hôte et un
    nom de domaine qui peuvent être résolus en une adresse IP. Par exemple,
      <code>www</code> est un nom d'hôte, <code>example.com</code> est un nom
      de domaine, et <code>www.example.com</code> est un nom de domaine
      entièrement qualifié.
    </dd>

    <dt><a name="modulemagicnumber" id="modulemagicnumber">
    Nombre Magique des Modules
    (Module Magic Number)</a>
      (<a name="mmn" id="mmn">MMN</a>)</dt>
    <dd>Le Nombre Magique des Modules est une constante définie dans le code
    source d'Apache et associée à la compatibilité binaire des modules.
    Sa valeur est modifiée quand des structures internes d'Apache, des appels
    de fonctions et d'autres parties significatives de l'API sont modifiées
    de telle façon que la compatibilité binaire ne peut plus être garantie.
    En cas de changement de MMN, tous les modules tiers doivent être au
    moins recompilés, et parfois même légèrement modifiés afin de pouvoir
    fonctionner avec la nouvelle version d'Apache.
    </dd>

    <dt><a name="dynamicsharedobject" id="dynamicsharedobject">
    Objet Dynamique Partagé (Dynamic Shared Object)
	</a> <a name="dso" id="dso">(DSO)</a></dt>
    <dd><glossary ref="module">Modules</glossary> compilés en dehors du binaire
      Apache <program>httpd</program> et qui peuvent être
      chargés à la demande.<br />
      Voir : <a href="dso.html">Support des objets dynamiques partagés</a>
    </dd>

<dt><a name="openssl" id="openssl">OpenSSL</a></dt>
    <dd>L'ensemble d'outils Open Source pour SSL/TLS<br />
      Voir <a href="http://www.openssl.org/">http://www.openssl.org/</a>#
    </dd>

<dt><a name="apacheextensiontool" id="apacheextensiontool">
    Outil de gestion des extensions Apache
    (APache eXtension Tool)</a>
    <a name="apxs" id="apxs">(apxs)</a></dt>
    <dd>Un script Perl qui aide à la compilation des sources de <glossary
      ref="module">module</glossary> sous forme d'Objets Dynamiques Partagés
      (Dynamic Shared Objects ou
      <glossary ref="dso">DSO</glossary>s) et facilite leur installation
      dans le serveur Web Apache.<br />
      Voir : Page de manuel : <program>apxs</program>
    </dd>

<dt><a name="plaintext" id="plaintext">Plein Texte (Plaintext)</a></dt>
    <dd>Le texte non chiffré.</dd>



    <dt><a name="hypertexttransferprotocol"
      id="hypertexttransferprotocol">Protocole de Transfert Hypertexte
      (HyperText Transfer Protocol)</a>
      <a name="http" id="hhtp">(HTTP)</a></dt>
    <dd>Le protocole de transmission standard utilisé sur le World Wide Web.
    Apache implémente la version 1.1 du protocole, référencée comme HTTP/1.1 et
      définie par la
      <a href="http://ietf.org/rfc/rfc2616.txt">RFC 2616</a>.
    </dd>

    <dt><a name="messagedigest" id="messagedigest">Résumé de message
    (Message Digest)</a></dt>
    <dd>Un hachage du message, qui peut être utilisé pour vérifier
    que son contenu n'a pas été altéré durant le transfert.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="transportlayersecurity" id="transportlayersecurity">
    Sécurité de la couche Transport
    (Transport Layer Security)
      </a> <a name="tls" id="tls">(TLS)</a></dt>
  <dd>Le protocole successeur de SSL, créé par l'Internet Engineering Task
    Force (IETF) pour l'authentification et le chiffrement généraux des
    communications dans les réseaux TCP/IP. TLS version 1 est pratiquement
    identique à SSL version 3.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>

    <dt><a name="session" id="session">Session</a></dt>
  <dd>Les informations sur le contexte d'une communication en général.</dd>

    <dt><a name="digitalsignature" id="digitalsignature">Signature numérique
    (Digital Signature)</a></dt>
    <dd>Un bloc de texte crypté qui valide un certificat ou un autre fichier.
    Une <glossary ref="certificationauthority">Autorité de certification</glossary>
      crée une signature en générant une empreinte de la <em>Clé publique</em>
      fournie avec le <em>Certificat</em>; la CA chiffre ensuite l'empreinte
      avec sa propre <em>Clé privée</em>. Seule la clé publique de la CA
      peut décrypter la signature, ce qui permet de vérifier que la CA a bien
      authentifié l'entité du réseau qui possède le
      <em>Certificat</em>.<br />
      Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

<dt><a name="ssleay" id="ssleay">SSLeay</a></dt>
  <dd>La bibliothèque originelle d'implémentation de SSL/TLS développée par
  Eric A. Young
  </dd>

<dt><a name="ciphertext" id="ciphertext">Texte crypté
(Ciphertext)</a></dt>
    <dd>Le résultat du passage d'un document
    <glossary ref="plaintext">Plaintext</glossary> (Plein texte) par un
    <glossary ref="cipher">Cipher</glossary>.<br />
    Voir : <a href="ssl/">chiffrement SSL/TLS</a>
    </dd>

    <dt><a name="mime-type" id="mime-type">Type MIME (MIME-type)</a></dt>
    <dd>Une méthode pour décrire le type de document transmis.  Son nom
    vient du fait que son format est issu des Multipurpose
      Internet Mail Extensions (Extensions Multi-usages de la
      Messagerie par Internet) .  Il comprend un type majeur et un type
      mineur, séparés par un slash (barre oblique).  On trouve
      entre autres types <code>text/html</code>,
      <code>image/gif</code>, et <code>application/octet-stream</code>. Dans
      HTTP, le type MIME est transmis dans l'
      <glossary ref="header">en-tête</glossary> <code>Content-Type</code>.<br />
      Voir : <a href="mod/mod_mime.html">mod_mime</a>
    </dd>


    <dt><a name="environmentvariable" id="environmentvariable">
    Variable d'environnement
    (Environment Variable)</a> <a name="env-variable"
        id="env-variable">(env-variable)</a></dt>
    <dd>Ce sont des variables nommées gérées par le shell du système
    d'exploitation, et servant au stockage d'informations et à la
    communication entre les programmes. Apache possède aussi des variables
    internes considérées comme variables d'environnement, mais stockées dans
    des structures internes à Apache, et non dans l'environnement
    du shell.<br />
      Voir : <a href="env.html">Les variables d'environnement dans Apache</a>
    </dd>

     <dt><a name="x.509" id="x.509">X.509</a></dt>
  <dd>Une norme de certificat d'authentification recommandée par l'International
    Telecommunication Union (ITU-T) et utilisée pour
    l'authentification SSL/TLS.<br
    /> Voir : <a href="ssl/">chiffrement SSL/TLS</a>
  </dd>
</dl>
</section>
</manualpage>


