<?xml version="1.0" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="env.xml.meta">

  <title>Apache et les variables d'environnement</title>

  <summary>
     <p>Deux types de variables d'environnement affectent le serveur
     HTTP Apache.</p>

    <p>Le premier type correspond aux variables d'environnement
    contr&ocirc;l&eacute;es par le syst&egrave;me d'exploitation sous-jacent et d&eacute;finies
    avant le d&eacute;marrage du serveur. Leurs valeurs peuvent &ecirc;tre utilis&eacute;es
    directement dans les fichiers de configuration, et peuvent
    &eacute;ventuellement &ecirc;tre transmises aux scripts CGI et SSI via la
    directive PassEnv.</p>

    <p>Le second type correspond aux variables nomm&eacute;es appel&eacute;es aussi
    <em>variables d'environnement</em> dans lesquelles le serveur HTTP
    Apache stocke des informations via un m&eacute;canisme sp&eacute;cial. Ces
    informations peuvent servir &agrave; contr&ocirc;ler diverses op&eacute;rations comme
    l'enregistrement des traces ou le contr&ocirc;le d'acc&egrave;s. On utilise aussi ces
    variables dans le m&eacute;canisme de communication avec les programmes externes
    comme les scripts CGI. Ce document pr&eacute;sente diff&eacute;rentes m&eacute;thodes pour
    manipuler et utiliser ces variables.</p>

    <p>Bien que ces variables soient r&eacute;f&eacute;renc&eacute;es comme <em>variables
    d'environnement</em>, il ne faut pas les confondre avec les variables
    d'environnement contr&ocirc;l&eacute;es par le syst&egrave;me d'exploitation sous-jacent.
    En fait, ces variables sont stock&eacute;es et manipul&eacute;es dans une structure
    interne &agrave; Apache. Elles ne deviennent de v&eacute;ritables variables
    d'environnement du syst&egrave;me d'exploitation que lorsqu'elles sont mises &agrave; la
    disposition de scripts CGI et de scripts inclus c&ocirc;t&eacute; serveur (SSI). Si vous
    souhaitez manipuler l'environnement du syst&egrave;me d'exploitation sous lequel
    le serveur s'ex&eacute;cute, vous devez utiliser les m&eacute;canismes standards de
    manipulation de l'environnement fournis par l'interpr&eacute;teur de commandes
    (shell) de votre syst&egrave;me d'exploitation.</p>
  </summary>

  <section id="setting">
    <title>D&eacute;finition des variables d'environnement</title>
    <related>
      <modulelist>
        <module>mod_cache</module>
        <module>mod_env</module>
        <module>mod_rewrite</module>
        <module>mod_setenvif</module>
        <module>mod_unique_id</module>
      </modulelist>
      <directivelist>
        <directive module="mod_setenvif">BrowserMatch</directive>
        <directive module="mod_setenvif">BrowserMatchNoCase</directive>
        <directive module="mod_env">PassEnv</directive>
        <directive module="mod_rewrite">RewriteRule</directive>
        <directive module="mod_env">SetEnv</directive>
        <directive module="mod_setenvif">SetEnvIf</directive>
        <directive module="mod_setenvif">SetEnvIfNoCase</directive>
        <directive module="mod_env">UnsetEnv</directive>
      </directivelist>
    </related>

    <section id="basic-manipulation">
        <title>Manipulations de base de l'environnement</title>

        <p>La m&eacute;thode la plus &eacute;l&eacute;mentaire pour d&eacute;finir une variable
	d'environnement au niveau d'Apache consiste &agrave; utiliser la directive
	inconditionnelle <directive module="mod_env"
        >SetEnv</directive>. Les variables peuvent aussi &ecirc;tre transmises depuis
	l'environnement du shell &agrave; partir duquel le serveur a &eacute;t&eacute; d&eacute;marr&eacute; en
	utilisant la directive
        <directive module="mod_env">PassEnv</directive>.</p>

    </section>
    <section id="conditional">
        <title>D&eacute;finitions conditionnelles en fonction des requ&ecirc;tes</title>

        <p>Pour plus de souplesse, les directives fournies par le module
        <module>mod_setenvif</module> permettent de d&eacute;finir les
	variables d'environnement en tenant compte des caract&eacute;ristiques
	de chaque requ&ecirc;te. Par exemple, une
	variable pourrait n'&ecirc;tre d&eacute;finie que lorsqu'un navigateur sp&eacute;cifique
	(User-Agent) a g&eacute;n&eacute;r&eacute; la requ&ecirc;te, ou seulement quand un en-t&ecirc;te
	Referer particulier est pr&eacute;sent. La directive
	<directive module="mod_rewrite">RewriteRule</directive> du module
	<module>mod_rewrite</module> qui utilise l'option
	<code>[E=...]</code> pour d&eacute;finir
	les variables d'environnement apporte encore plus de souplesse.</p>

    </section>
    <section id="unique-identifiers">
        <title>Identifiants uniques</title>

        <p>Finalement, le module <module>mod_unique_id</module> d&eacute;finit la variable
	d'environnement <code>UNIQUE_ID</code> pour chaque requ&ecirc;te &agrave; une valeur
	qui est garantie unique parmi "toutes" les requ&ecirc;tes sous des
	conditions tr&egrave;s sp&eacute;cifiques.</p>

    </section>
    <section id="standard-cgi">
        <title>Variables CGI standards</title>

        <p>En plus de l'ensemble des variables d'environnement internes &agrave; la
	configuration d'Apache et de celles transmises depuis le shell,
	les scripts CGI	et les pages SSI
	se voient affect&eacute;s un ensemble de variables
	d'environnement contenant des m&eacute;ta-informations &agrave; propos de la requ&ecirc;te
	comme pr&eacute;conis&eacute; dans la
	<a href="http://www.ietf.org/rfc/rfc3875">sp&eacute;cification
	sur les CGIs</a>.</p>

    </section>
    <section id="caveats">
        <title>Quelques mises en garde</title>

        <ul>
          <li>Les directives de manipulation de l'environnement ne permettent
	  pas de supplanter ou modifier les variables CGI standards.</li>

          <li>Lorsqu'on utilise <program>suexec</program> pour ex&eacute;cuter des
	  scripts CGI, l'environnement est nettoy&eacute; et r&eacute;duit &agrave; un ensemble de
	  variables <em>s&ucirc;res</em> avant l'ex&eacute;cution du script. La liste des
	  variables <em>s&ucirc;res</em> est d&eacute;finie &agrave; la compilation dans
          <code>suexec.c</code>.</li>

          <li>Pour des raisons de portabilit&eacute;, les noms des variables
	  d'environnement ne peuvent contenir que des lettres, des chiffres, et
	  le caract&egrave;re "souslign&eacute;". En outre, le premier caract&egrave;re ne doit pas
	  &ecirc;tre un chiffre. Les caract&egrave;res qui ne satisfont pas &agrave; ces conditions
	  seront remplac&eacute;s par un caract&egrave;re "souslign&eacute;" quand ils seront
	  transmis aux scripts CGI et aux pages SSI.</li>

	  <li>Les contenus d'en-t&ecirc;tes HTTP transmis aux scripts de type
	  CGI ou autre via des variables d'environnement constituent un
	  cas particulier (voir plus loin). Leur nom est converti en
	  majuscules et seuls les tirets sont remplac&eacute;s par des
	  caract&egrave;res '_' ("soulign&eacute;") ; si le format du nom de l'en-t&ecirc;te
	  n'est pas valide, celui-ci est ignor&eacute;. Voir <a
	  href="#fixheader">plus loin</a> pour une solution de
	  contournement du probl&egrave;me.</li>

          <li>La directive <directive
	  module="mod_env">SetEnv</directive> s'ex&eacute;cute assez tard au
	  cours du traitement de la requ&ecirc;te, ce qui signifie que des
	  directives telles que <directive
	  module="mod_setenvif">SetEnvIf</directive> et <directive
          module="mod_rewrite">RewriteCond</directive> ne verront pas
	  les variables qu'elle aura d&eacute;finies.</li>

	  <li>Lorsque le serveur cherche un chemin via une <glossary
   ref="subrequest">sous-requ&ecirc;te</glossary> interne (par exemple la
   recherche d'un <directive
   module="mod_dir">DirectoryIndex</directive>), ou lorsqu'il g&eacute;n&egrave;re un
   listing du contenu d'un r&eacute;pertoire via le module
   <module>mod_autoindex</module>, la sous-requ&ecirc;te n'h&eacute;rite pas des
   variables d'environnement sp&eacute;cifiques &agrave; la requ&ecirc;te. En outre, &agrave; cause
   des phases de l'API auxquelles <module>mod_setenvif</module> prend
   part, les directives <directive
   module="mod_setenvif">SetEnvIf</directive> ne sont pas &eacute;valu&eacute;es
   s&eacute;par&eacute;ment dans la sous-requ&ecirc;te.</li>
        </ul>
    </section>
  </section>
  <section id="using">
    <title>Utilisation des variables d'environnement</title>

    <related>
      <modulelist>
        <module>mod_authz_host</module>
        <module>mod_cgi</module>
        <module>mod_ext_filter</module>
        <module>mod_headers</module>
        <module>mod_include</module>
        <module>mod_log_config</module>
        <module>mod_rewrite</module>
      </modulelist>
      <directivelist>
        <directive module="mod_authz_core">Require</directive>
        <directive module="mod_log_config">CustomLog</directive>
        <directive module="mod_access_compat">Deny</directive>
        <directive module="mod_ext_filter">ExtFilterDefine</directive>
        <directive module="mod_headers">Header</directive>
        <directive module="mod_log_config">LogFormat</directive>
        <directive module="mod_rewrite">RewriteCond</directive>
        <directive module="mod_rewrite">RewriteRule</directive>
      </directivelist>
    </related>

    <section id="cgi-scripts">
        <title>Scripts CGI</title>

        <p>La communication d'informations aux scripts CGI constitue une des
	principales utilisations des variables d'environnement. Comme indiqu&eacute;
	plus haut, l'environnement transmis aux scripts CGI comprend des
	m&eacute;ta-informations standards &agrave; propos de la requ&ecirc;te, en plus des
	variables d&eacute;finies dans la configuration d'Apache. Pour plus de
	d&eacute;tails, se r&eacute;f&eacute;rer au
        <a href="howto/cgi.html">tutoriel CGI</a>.</p>

    </section>
    <section id="ssi-pages">
        <title>Pages SSI</title>

        <p>Les documents inclus c&ocirc;t&eacute; serveur (SSI) trait&eacute;s par le filtre
        <code>INCLUDES</code> du module <module>mod_include</module>,
	peuvent afficher les
	variables d'environnement &agrave; l'aide de l'&eacute;l&eacute;ment <code>echo</code>,
	et peuvent utiliser des variables d'environnement dans les &eacute;l&eacute;ments
	de contr&ocirc;le de flux pour rendre certaines parties d'une page
        conditionnelles en fonction des caract&eacute;ristiques de la requ&ecirc;te.
	Apache fournit aussi les variables d'environnement CGI standards
	aux pages SSI
	comme indiqu&eacute; plus haut. Pour plus de d&eacute;tails, se r&eacute;f&eacute;rer au
	<a href="howto/ssi.html">tutoriel SSI</a>.</p>

    </section>
    <section id="access-control">
        <title>Contr&ocirc;le d'acc&egrave;s</title>

        <p>L'acc&egrave;s au serveur peut &ecirc;tre contr&ocirc;l&eacute; en fonction de la valeur de
	variables d'environnement &agrave; l'aide des directives
	<code>allow from env=</code> et <code>deny from env=</code>.
	En association avec la directive
        <directive module="mod_setenvif">SetEnvIf</directive>, ceci conf&egrave;re une
	grande souplesse au contr&ocirc;le d'acc&egrave;s au serveur en fonction des
	caract&eacute;ristiques du client. Par exemple, vous pouvez utiliser ces
        directives pour interdire l'acc&egrave;s depuis un navigateur particulier
	(User-Agent).
        </p>

    </section>
    <section id="logging">
        <title>Enregistrement conditionnel des traces</title>

        <p>Les variables d'environnement peuvent &ecirc;tre enregistr&eacute;es dans le
	fichier de log des acc&egrave;s &agrave; l'aide de l'option <code>%e</code> de la
	directive <directive module="mod_log_config">LogFormat</directive>.
	En outre, la d&eacute;cision de tracer ou non les requ&ecirc;tes peut &ecirc;tre prise
	en fonction de l'&eacute;tat de variables d'environnement en utilisant la
	forme conditionnelle de la directive
        <directive module="mod_log_config">CustomLog</directive>. En
	association avec la directive <directive module="mod_setenvif"
        >SetEnvIf</directive>, ceci conf&egrave;re une grande souplesse au contr&ocirc;le
	du tra&ccedil;age des requ&ecirc;tes. Par exemple, vous pouvez choisir de ne pas
	tracer les requ&ecirc;tes pour des noms de fichiers se terminant par
	<code>gif</code>, ou encore de ne tracer que les requ&ecirc;tes des clients
	n'appartenant pas &agrave; votre sous-r&eacute;seau.</p>

    </section>
    <section id="response-headers">
        <title>En-t&ecirc;tes de r&eacute;ponse conditionnels</title>

        <p>La directive <directive module="mod_headers">Header</directive>
        peut se baser sur la pr&eacute;sence ou l'absence d'une variable
	d'environnement pour d&eacute;cider si un certain en-t&ecirc;te HTTP sera plac&eacute;
	dans la r&eacute;ponse au client. Ceci permet, par exemple, de n'envoyer un
	certain en-t&ecirc;te de r&eacute;ponse que si un en-t&ecirc;te correspondant est pr&eacute;sent
	dans la requ&ecirc;te du client.</p>

    </section>

    <section id="external-filter">
        <title>Activation de filtres externes</title>

        <p>Les filtres externes configur&eacute;s par le module
	<module>mod_ext_filter</module> &agrave; l'aide de la directive <directive
        module="mod_ext_filter">ExtFilterDefine</directive> peuvent &ecirc;tre
	activ&eacute;s de mani&egrave;re conditionnelle en fonction d'une variable
	d'environnement &agrave; l'aide des options
        <code>disableenv=</code> et <code>enableenv=</code>.</p>
    </section>

    <section id="url-rewriting">
        <title>R&eacute;&eacute;criture d'URL</title>

        <p>La forme <code>%{ENV:<em>variable</em>}</code> de
	<em>TestString</em> dans la
	directive <directive module="mod_rewrite">RewriteCond</directive>
        permet au moteur de r&eacute;&eacute;criture du module
	<module>mod_rewrite</module> de prendre des
	d&eacute;cisions conditionn&eacute;es par des variables d'environnement.
        Notez que les variables accessibles dans
	<module>mod_rewrite</module> sans le pr&eacute;fixe
        <code>ENV:</code> ne sont pas de v&eacute;ritables variables
	d'environnement. Ce sont plut&ocirc;t des variables sp&eacute;cifiques &agrave;
	<module>mod_rewrite</module>
        qui ne sont pas accessibles pour les autres modules.</p>
    </section>
  </section>

  <section id="special">
    <title>Variables d'environnement &agrave; usage sp&eacute;cial</title>

        <p>Des probl&egrave;mes d'interop&eacute;rabilit&eacute; ont conduit &agrave; l'introduction de
	m&eacute;canismes permettant de modifier le comportement d'Apache lorsqu'il
	dialogue avec certains clients. Afin de rendre ces m&eacute;canismes aussi
	souples que possible, ils sont invoqu&eacute;s en d&eacute;finissant des variables
	d'environnement, en g&eacute;n&eacute;ral &agrave; l'aide de la directive
	<directive module="mod_setenvif">BrowserMatch</directive>, bien que les
	directives <directive module="mod_env">SetEnv</directive> et
	<directive module="mod_env">PassEnv</directive> puissent aussi &ecirc;tre
	utilis&eacute;es, par exemple.</p>

    <section id="downgrade">
        <title>downgrade-1.0</title>

        <p>Ceci force le traitement d'une requ&ecirc;te comme une requ&ecirc;te HTTP/1.0
        m&ecirc;me si elle a &eacute;t&eacute; r&eacute;dig&eacute;e dans un langage plus r&eacute;cent.</p>

    </section>
    <section id="force-gzip">
        <title>force-gzip</title>
          <p>Si le filtre <code>DEFLATE</code> est activ&eacute;, cette variable
	  d'environnement ignorera les r&eacute;glages accept-encoding de votre
	  navigateur et enverra une sortie compress&eacute;e inconditionnellement.</p>
    </section>
    <section id="force-no-vary">
        <title>force-no-vary</title>

        <p>Cette variable entra&icirc;ne la suppression de tout champ
	<code>Vary</code> des en-t&ecirc;tes de la r&eacute;ponse avant que cette derni&egrave;re
	soit renvoy&eacute;e au client. Certains clients n'interpr&egrave;tent pas ce champ
	correctement, et la d&eacute;finition de cette variable permet de contourner
	ce probl&egrave;me, mais implique aussi la d&eacute;finition de
	<strong>force-response-1.0</strong>.</p>

    </section>
    <section id="force-response">
        <title>force-response-1.0</title>

      <p>Cette variable force une r&eacute;ponse en langage HTTP/1.0 aux clients
      qui envoient des requ&ecirc;tes dans le m&ecirc;me langage. Elle fut impl&eacute;ment&eacute;e &agrave;
      l'origine suite &agrave; des probl&egrave;mes avec les mandataires d'AOL. Certains
      clients en langage HTTP/1.0 ne r&eacute;agissent pas correctement face &agrave; une
      r&eacute;ponse en langage HTTP/1.1, et cette variable peut &ecirc;tre utilis&eacute;e pour
      assurer l'interop&eacute;rabilit&eacute; avec eux.</p>

    </section>

    <section id="gzip-only-text-html">
        <title>gzip-only-text/html</title>

        <p>Positionn&eacute;e &agrave; "1", cette variable d&eacute;sactive le filtre en sortie
	<code>DEFLATE</code> fourni par le module <module>mod_deflate</module> pour les
	types de contenu autres que <code>text/html</code>. Si vous pr&eacute;f&eacute;rez
	utiliser des fichiers compress&eacute;s statiquement,
	<module>mod_negotiation</module> &eacute;value aussi la variable (non
	seulement pour gzip, mais aussi pour tous les encodages autres que
	"identity").</p>
    </section>

    <section id="no-gzip"><title>no-gzip</title>

        <p>Quand cette variable est d&eacute;finie, le filtre <code>DEFLATE</code> du
	module <module>mod_deflate</module> est d&eacute;sactiv&eacute;, et
        <module>mod_negotiation</module> refusera de d&eacute;livrer des ressources
	encod&eacute;es.</p>

    </section>

    <section id="no-cache"><title>no-cache</title>
    	<p><em>Disponible dans les versions 2.2.12 et ult&eacute;rieures d'Apache</em></p>

        <p>Lorsque cette variable est d&eacute;finie,
	<module>mod_cache</module> ne sauvegardera pas de r&eacute;ponse
	susceptible d'&ecirc;tre mise en cache. Cette variable d'environnement
	n'a aucune incidence sur le fait qu'une r&eacute;ponse d&eacute;j&agrave; enregistr&eacute;e
	dans la cache soit utilis&eacute;e ou non pour la requ&ecirc;te courante.</p>

    </section>

    <section id="nokeepalive">
        <title>nokeepalive</title>

        <p>Quand cette variable est d&eacute;finie, la directive
	<directive module="core">KeepAlive</directive> est d&eacute;sactiv&eacute;e.</p>

    </section>

    <section id="prefer-language"><title>prefer-language</title>

        <p>Cette variable modifie le comportement du module
	<module>mod_negotiation</module>. Si elle contient un symbole de
	langage (tel que <code>en</code>, <code>ja</code>
        ou <code>x-klingon</code>), <module>mod_negotiation</module> essaie de
	d&eacute;livrer une variante dans ce langage. S'il n'existe pas de telle
	variante, le processus normal de
	<a href="content-negotiation.html">n&eacute;gociation</a> s'applique.</p>

    </section>

    <section id="redirect-carefully">
        <title>redirect-carefully</title>

        <p>Cette variable force le serveur &agrave; &ecirc;tre plus prudent lors de l'envoi
	d'une redirection au client. Elle est en g&eacute;n&eacute;ral utilis&eacute;e quand un
	client pr&eacute;sente un probl&egrave;me connu avec les redirections. Elle fut
	impl&eacute;ment&eacute;e &agrave; l'origine suite a un probl&egrave;me rencontr&eacute; avec le logiciel
	WebFolders de Microsoft qui ne g&egrave;re pas correctement les redirections
	vers des ressources de type r&eacute;pertoire via des m&eacute;thodes DAV.</p>

    </section>

   <section id="suppress-error-charset">
       <title>suppress-error-charset</title>

    <p><em>Disponible dans les versions post&eacute;rieures &agrave; 2.0.54</em></p>

    <p>Quand Apache g&eacute;n&egrave;re une redirection en r&eacute;ponse &agrave; une requ&ecirc;te client,
    la r&eacute;ponse inclut un texte destin&eacute; &agrave; &ecirc;tre affich&eacute; au cas o&ugrave; le client ne
    suivrait pas, ou ne pourrait pas suivre automatiquement la redirection.
    Habituellement, Apache marque ce texte en accord avec le jeu de caract&egrave;res
    qu'il utilise, &agrave; savoir ISO-8859-1.</p>
    <p> Cependant, si la redirection fait r&eacute;f&eacute;rence &agrave; une page qui utilise un
    jeu de caract&egrave;res diff&eacute;rent, certaines versions de navigateurs obsol&egrave;tes
    essaieront d'utiliser le jeu de caract&egrave;res du texte de la redirection
    plut&ocirc;t que celui de la page r&eacute;elle.
    Ceci peut entra&icirc;ner, par exemple, un rendu incorrect du Grec.</p>
    <p>Si cette variable d'environnement est d&eacute;finie, Apache omettra le jeu de
    caract&egrave;res pour le texte de la redirection, et les navigateurs obsol&egrave;tes
    pr&eacute;cit&eacute;s utiliseront correctement celui de la page de destination.</p>

    <note type="warning">
      <title>Note concernant la s&eacute;curit&eacute;</title>

      <p>L'envoi de pages d'erreur sans sp&eacute;cifier un jeu de caract&egrave;res peut
      conduire &agrave; des attaques de type "cross-site-scripting" pour les
      navigateurs qui ne respectent pas la sp&eacute;cification HTTP/1.1 (MSIE) et
      tentent de d&eacute;duire le jeu de caract&egrave;res &agrave; partir du contenu. De tels
      navigateurs peuvent &ecirc;tre facilement tromp&eacute;s et utiliser le jeu de
      caract&egrave;res UTF-7 ; les contenus des donn&eacute;es en entr&eacute;e de type UTF-7
      (comme les URI de requ&ecirc;te) ne seront alors plus prot&eacute;g&eacute;s par les
      m&eacute;canismes d'&eacute;chappement usuels con&ccedil;us pour pr&eacute;venir les attaques
      de type "cross-site-scripting".</p>
    </note>

   </section>

   <section id="proxy"><title>force-proxy-request-1.0, proxy-nokeepalive, proxy-sendchunked,
   proxy-sendcl, proxy-chain-auth, proxy-interim-response, proxy-initial-not-pooled</title>

   <p>Ces directives modifient le comportement protocolaire du module
   <module>mod_proxy</module>.  Voir la documentation sur
   <module>mod_proxy</module> et <module>mod_proxy_http</module> pour plus de d&eacute;tails.</p>
   </section>

  </section>

  <section id="examples">
    <title>Exemples</title>

    <section id="fixheader">
      <title>Transmission du contenu d'en-t&ecirc;tes non valides aux scripts
      CGI</title>

      <p>Avec la version 2.4, Apache est plus strict avec la conversion
      des en-t&ecirc;tes HTTP en variables d'environnement dans
      <module>mod_cgi</module> et d'autres modules : dans les versions
      pr&eacute;c&eacute;dentes, tout caract&egrave;re invalide dans les noms d'en-t&ecirc;tes
      &eacute;tait tout simplement remplac&eacute; par un caract&egrave;re '_', ce qui
      pouvait exposer &agrave; des attaques de type cross-site-scripting via
      injection d'en-t&ecirc;tes (voir <a
      href="http://events.ccc.de/congress/2007/Fahrplan/events/2212.en.html">Bogues
      du Web inhabituelles</a>, planche 19/20).</p>

      <p>Si vous devez supporter un client qui envoie des en-t&ecirc;tes non
      conformes et si ceux-ci ne peuvent pas &ecirc;tre corrig&eacute;s, il existe
      une solution de contournement simple mettant en jeu les modules
      <module>mod_setenvif</module> et <module>mod_headers</module>,
      et permettant de prendre en compte ces en-t&ecirc;tes :</p>

<highlight language="config">
# L'exemple suivant montre comment prendre en compte un en-t&ecirc;te<br />
# Accept_Encoding non conforme envoy&eacute; par un client.
#
SetEnvIfNoCase ^Accept.Encoding$ ^(.*)$ fix_accept_encoding=$1
RequestHeader set Accept-Encoding %{fix_accept_encoding}e env=fix_accept_encoding
</highlight>

    </section>

    <section id="misbehaving">
        <title>Modification du comportement protocolaire face &agrave; des clients
	r&eacute;agissant de mani&egrave;re non conforme</title>

        <p>Les versions ant&eacute;rieures recommandaient l'ajout de ces lignes dans
        httpd.conf pour tenir compte de probl&egrave;mes connus avec certains clients.
	Comme les clients concern&eacute;s sont maintenant tr&egrave;s peu utilis&eacute;s, cet
	ajout n'est pratiquement plus n&eacute;cessaire.</p>
<highlight language="config">
#
# The following directives modify normal HTTP response behavior.
# The first directive disables keepalive for Netscape 2.x and browsers that
# spoof it. There are known problems with these browser implementations.
# The second directive is for Microsoft Internet Explorer 4.0b2
# which has a broken HTTP/1.1 implementation and does not properly
# support keepalive when it is used on 301 or 302 (redirect) responses.
#
BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0

#
# The following directive disables HTTP/1.1 responses to browsers which
# are in violation of the HTTP/1.0 spec by not being able to grok a
# basic 1.1 response.
#
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0
</highlight>

    </section>
    <section id="no-img-log">
        <title>Ne pas tracer les requ&ecirc;tes pour des images dans le fichier de
	trace des acc&egrave;s</title>

        <p>Dans cet exemple, les requ&ecirc;tes pour des images n'apparaissent pas
	dans le fichier de trace des acc&egrave;s. Il peut &ecirc;tre facilement adapt&eacute; pour
	emp&ecirc;cher le tra&ccedil;age de r&eacute;pertoires particuliers, ou de requ&ecirc;tes
        en provenance de certains h&ocirc;tes.</p>
         <highlight language="config">
SetEnvIf Request_URI \.gif image-request
SetEnvIf Request_URI \.jpg image-request
SetEnvIf Request_URI \.png image-request
CustomLog logs/access_log common env=!image-request
        </highlight>

    </section>
    <section id="image-theft">
        <title>Pr&eacute;vention du "Vol d'image"</title>

        <p>Cet exemple montre comment emp&ecirc;cher les utilisateurs ne faisant pas
	partie de votre serveur d'utiliser des images de votre serveur comme
	images en ligne dans leurs pages. Cette configuration n'est pas
	recommand&eacute;e, mais elle peut fonctionner dans des circonstances bien
	d&eacute;finies. Nous supposons que toutes vos images sont enregistr&eacute;es dans
	un r&eacute;pertoire nomm&eacute; <code>/web/images</code>.</p>
    	<highlight language="config">
SetEnvIf Referer "^http://www\.example\.com/" local_referal
# Autorise les navigateurs qui n'envoient aucune information de Referer
SetEnvIf Referer "^$" local_referal
&lt;Directory "/web/images"&gt;
    Require env local_referal
&lt;/Directory&gt;
        </highlight>

        <p>Pour plus d'informations sur cette technique, voir le tutoriel sur
	ServerWatch
	"<a href="http://www.serverwatch.com/tutorials/article.php/1132731"
	>Keeping Your Images from Adorning Other Sites</a>".</p>
    </section>
  </section>
</manualpage>
