<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1787941 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="new_features_2_4.xml.meta">

<title>Vue d'ensemble des nouvelles fonctionnalités de la version 2.4 du
serveur HTTP Apache</title>

<summary>
  <p>Ce document décrit les modifications majeures apportées par
  la version 2.4 du serveur HTTP Apache. Pour les nouvelles fonctionnalités
  ajoutées par la version 2.2, se référer au document
  <a href="new_features_2_2.html">Nouvelles fonctionnalités
  de la version 2.2</a>.</p>
</summary>

  <section id="core">
    <title>Améliorations du noyau</title>
    <dl>
      <dt>Modules multiprocessus (MPMs) chargeables à l'exécution</dt>
      <dd>Plusieurs MPMs peuvent maintenant être <a
      href="mpm.html#dynamic">compilés en tant que modules
      chargeables</a>. Le choix du MPM à utiliser s'effectue
      à l'exécution via la directive <directive
      module="mod_so">LoadModule</directive>.</dd>

      <dt>MPM Event</dt>
      <dd>Le <a href="mod/event.html">MPM Event</a> n'en est plus au stade expérimental et est
      maintenant pleinement supporté.</dd>

      <dt>Support du mode asynchrone</dt>
      <dd>Le support des lectures/écritures asynchrones pour les MPMs et
      les plateformes qui l'implémentent a été amélioré.</dd>

      <dt>Configuration du niveau de journalisation (LogLevel) par
      module et par répertoire</dt>
      <dd>La directive <directive module="core">LogLevel</directive>
      peut maintenant être définie par module et par répertoire. Les
      nouveaux niveaux <code>trace1</code> à <code>trace8</code> ont été
      ajoutés au dessus du niveau de journalisation <code>debug</code>.</dd>

      <dt>Sections de configuration au niveau requête</dt>
      <dd>Les sections <directive module="core">If</directive>,
      <directive module="core" type="section">ElseIf</directive> et
      <directive module="core" type="section">Else</directive>
      permettent de définir une configuration en fonction de critères
      liés à la requête.</dd>

      <dt>Interpréteur d'expressions à usage général</dt>
      <dd>Un nouvel interpréteur d'expressions permet de spécifier des
      <a href="expr.html">conditions complexes</a> via des directives à
      syntaxe commune comme <directive
      module="mod_setenvif">SetEnvIfExpr</directive>, <directive
      module="mod_rewrite">RewriteCond</directive>, <directive
      module="mod_headers">Header</directive>,
      <directive module="core" type="section">If</directive>, etc...
      </dd>

      <dt>KeepAliveTimeout en millisecondes</dt>
      <dd>Il est maintenant possible de définir la directive <directive
      module="core">KeepAliveTimeout</directive> en millisecondes.
      </dd>

      <dt>Directive NameVirtualHost</dt>
      <dd>Cette directive n'est plus nécessaire et est maintenant obsolète.</dd>

      <dt>Directives autorisées dans les fichiers <code>.htaccess</code></dt>
      <dd>La nouvelle directive <directive
      module="core">AllowOverrideList</directive> permet de contrôler de
      manière plus précise la liste des directives autorisées dans les
      fichiers <code>.htaccess</code>.</dd>

      <dt>Variables dans les fichiers de configuration</dt>
      <dd>La directive <directive module="core">Define</directive>
      permet de définir des variables dans les fichiers de
      configuration, améliorant ainsi la clareté de la présentation si
      la même valeur est utilisée en plusieurs points de la
      configuration.
      </dd>

      <dt>Diminution de la mémoire utilisée</dt>
      <dd>Bien qu'elle propose de nombreuses nouvelles fonctionnalités,
      la version 2.4.x tend à utiliser moins de mémoire que la version
      2.2.x.</dd>

    </dl>
  </section>

  <section id="newmods">
    <title>Nouveau modules</title>
    <dl>      

      <dt><module>mod_proxy_fcgi</module></dt>
      <dd>Mise à disposition du protocole FastCGI pour
      <module>mod_proxy</module>.</dd>

      <dt><module>mod_proxy_scgi</module></dt>
      <dd>Mise à disposition du protocole SCGI pour
      <module>mod_proxy</module>.</dd>

      <dt><module>mod_proxy_express</module></dt>
      <dd>Ajoute à <module>mod_proxy</module> la configuration dynamique
      de mandataires inverses en masse.</dd>

      <dt><module>mod_remoteip</module></dt>
      <dd>Remplace l'adresse IP distante et le nom d'hôte apparents du
      client pour la requête courante par la liste d'adresses IP
      présentée par un mandataire ou un répartiteur de charge via les
      en-têtes de la requête.</dd>

      <dt><module>mod_heartmonitor</module>,
          <module>mod_lbmethod_heartbeat</module></dt>
      <dd>Permet à <module>mod_proxy_balancer</module> de répartir la
      charge en fonction du nombre de connexions actives sur les
      serveurs d'arrière-plan.</dd>

      <dt><module>mod_proxy_html</module></dt>
      <dd>Anciennement module tiers, il supporte la correction des liens
      HTML dans une situation de mandat inverse, où le serveur
      d'arrière-plan génère des URLs qui ne sont pas valides du point de
      vue des clients du mandataire.</dd>

      <dt><module>mod_sed</module></dt>
      <dd>Une amélioration de <module>mod_substitute</module> qui permet
      d'éditer le corps de la réponse avec toute la puissance de la
      commande sed.</dd>

      <dt><module>mod_auth_form</module></dt>
      <dd>Implémente une authentification à base de formulaire.</dd>

      <dt><module>mod_session</module></dt>
      <dd>Permet de conserver les données de sessions des clients sous
      forme de cookies ou dans une base de données.</dd>

      <dt><module>mod_allowmethods</module></dt>
      <dd>Permet de restreindre l'utilisation de
      certaines méthodes HTTP sans interférer avec l'authentification et
      l'autorisation.</dd>      

      <dt><module>mod_lua</module></dt>
      <dd>Embarque le langage <a href="http://www.lua.org/">Lua</a> dans
      httpd pour la configuration et les fonctions logiques courantes
      (Expérimental).</dd>

      <dt><module>mod_log_debug</module></dt>
      <dd>Permet d'introduire une journalisation personnalisée à
      différentes phases du traitement de la requête.</dd>

      <dt><module>mod_buffer</module></dt>
      <dd>Fournit un tampon pour les piles des filtres en entrée et en
      sortie.</dd>

      <dt><module>mod_data</module></dt>
      <dd>Convertit un corps de réponse en URL de type données RFC2397.</dd>

      <dt><module>mod_ratelimit</module></dt>
      <dd>Permet de limiter la bande passante pour certains
      clients.</dd>

      <dt><module>mod_request</module></dt>
      <dd>Fournit des filtres permettant de gérer et de mettre à
      disposition les corps des requêtes HTTP.</dd>

      <dt><module>mod_reflector</module></dt>
      <dd>Permet de renvoyer comme réponse le corps de la requête via la
      pile du filtre de sortie.</dd>
      
      <dt><module>mod_slotmem_shm</module></dt>
      <dd>Met à disposition un fournisseur de mémoire partagée à base de
      slots (du style tableau de bord).</dd>

      <dt><module>mod_xml2enc</module></dt>
      <dd>Anciennement module tiers, il supporte l'internationalisation
      dans les modules de filtrage basés sur libxml2 (support du
      markup)</dd>

      <dt><module>mod_macro</module> (disponible à partir de la version 2.4.5)</dt>
      <dd>Permet d'utiliser des macros au sein des fichiers de
      configuration.</dd>

      <dt><module>mod_proxy_wstunnel</module> (disponible à partir de la version 2.4.5)</dt>
      <dd>Support des tunnels web-socket.</dd>

      <dt><module>mod_authnz_fcgi</module> (disponible à partir de la version 2.4.10)</dt>
      <dd>Permet aux applications d'autorisation FastCGI d'authentifier
      et/ou autoriser les clients.</dd>

      <dt><module>mod_http2</module> (disponible à partir de la version 2.4.17)</dt>
      <dd>Support de la couche transport HTTP/2.</dd>

      <dt><module>mod_proxy_hcheck</module> (disponible à partir de la version 2.4.21)</dt>
      <dd>Support d'un bilan de santé dynamique indépendant pour les serveurs
      d'arrière-plan mandatés distants.</dd>

    </dl>
  </section>

  <section id="module">
    <title>Améliorations des modules</title>
    <dl>
      <dt><module>mod_ssl</module></dt>

      <dd><module>mod_ssl</module> peut maintenant vérifier la
      validité des certificats clients en se connectant à
      un serveur OCSP. Il est possible de définir un
      répondeur par défaut, et de choisir si l'on
      préfère le répondeur désigné
      dans le certificat client.</dd>

	<dd>En outre, <module>mod_ssl</module> supporte maintenant
	l'estampillage OCSP (OCSP stapling), qui permet au serveur
	d'attester la validité de son certificat auprès du client au
	cours de la phase de négociation de la connexion.</dd>

      <dd>Enfin, <module>mod_ssl</module> peut maintenant être configuré pour
      que celui-ci partage les données de session SSL entre les serveurs
      via memcached.</dd>

      <dd>Le support des clés EC a été ajouté à celui des clés RSA et
      DSA.</dd>

      <dd>Support de TLS-SRP (disponible à partir de la version 2.4.4).</dd>

      <dt><module>mod_proxy</module></dt>

      <dd>La directive <directive
      module="mod_proxy">ProxyPass</directive> est maintenant configurée
      de manière optimale dans les sections <directive
      module="core">Location</directive> ou <directive
      module="core">LocationMatch</directive>, et offre un gain de
      performances important par rapport à la syntaxe traditionnelle à
      deux paramètres lorsqu'elle est présente en grand nombre.</dd>

      <dd>Il est maintenant possible de configurer l'adresse source dans
      les requêtes mandatées.</dd>

      <dd>Support des sockets de type Unix vers le serveur
      d'arrière-plan (disponible à partir de la version 2.4.7).</dd>

      <dt><module>mod_proxy_balancer</module></dt>

      <dd>Le gestionnaire de répartition de charge propose de nouvelles
      fonctionnalités. Ainsi, les possibilités de configuration des
      membres du groupe de répartition de charge pendant l'exécution ont
      été améliorées (possibilité d'ajout d'un membre supplémentaire).</dd>

      <dd>Configuration à l'exécution d'un sous-ensemble de paramètres
      de répartition de charge.</dd>

      <dd>Les membres du groupe de répartition peuvent être définis à
      'Drain' de façon à ce qu'ils ne répondent qu'aux sessions
      persistantes existantes, ce qui permet de les mettre hors ligne en
      douceur.</dd>

      <dd>Les règlages du répartiteur de charge peuvent être rendus
      persistants après redémarrage.</dd>

      <dt><module>mod_cache</module></dt>

      <dd>Le filtre CACHE du module <module>mod_cache</module> peut être
      inséré à un certain point de la chaîne de filtrage pour contrôler
      plus finement la mise en cache.
      </dd>

      <dd><module>mod_cache</module> peut maintenant mettre en cache des
      requêtes HEAD.</dd>

      <dd>Chaque fois que cela est possible, les directives de
      <module>mod_cache</module> peuvent maintenant être définies au
      niveau du répertoire, et non plus seulement au niveau du serveur
      principal.</dd>

      <dd>L'URL de base des URLs en cache peut être personnalisée de
      façon à ce qu'un cluster de caches puisse partager le même préfixe
      d'URL.</dd>

      <dd><module>mod_cache</module> peut maintenant servir du contenu
      non mis à jour lorsqu'un serveur d'arrière-plan n'est pas
      disponible (erreur 5xx).</dd>

      <dd><module>mod_cache</module> peut maintenant insérer
      HIT/MISS/REVALIDATE dans un en-tête X-Cache.</dd>

      <dt><module>mod_include</module></dt>
      <dd>Support de l'attribut 'onerror' dans un élément 'include',
      permettant de renvoyer un message d'erreur personnalisé à la place
      du message d'erreur par défaut.</dd>

      <dt><module>mod_cgi</module>, <module>mod_include</module>,
          <module>mod_isapi</module>, ...</dt>
      <dd>La traduction des en-têtes en variables d'environnement est
      plus stricte qu'avant, ce qui permet de diminuer l'exposition aux attaques
      de type cross-site-scripting via injection d'en-têtes. Les
      en-têtes contenant des caractères invalides (comme les caractères
      de soulignement) sont maintenant ignorés. Le document <a
      href="env.html">Les variables d'environnement dans Apache</a>
      présente quelques pistes pour contourner ce problème avec les
      clients anciens qui nécessitent de tels en-têtes (Ceci affecte
      tous les modules qui utilisent ces variables d'environnement).</dd>

      <dt><module>mod_authz_core</module> Conteneurs de logique d'autorisation</dt>

      <dd>La directive <directive
      module="mod_authz_core">Require</directive> et les directives de
      conteneurs associées, comme <directive module="mod_authz_core"
      type="section">RequireAll</directive>, permettent de définir une
      logique d'autorisation avancée.</dd>

      

      <dt><module>mod_rewrite</module></dt>
      <dd>La directive <directive
      module="mod_rewrite">RewriteRule</directive> dispose maintenant
      des drapeaux <code>[QSD]</code> (Query String Discard) et
      <code>[END]</code> qui permettent de simplifier les scénarios de
      réécriture courants.</dd>
      <dd>Possibilité d'utiliser des expressions booléennes complexes
      dans la directive <directive
      module="mod_rewrite">RewriteCond</directive>.</dd>
      <dd>Possibilité d'utiliser des requêtes SQL en tant que fonctions
      dans la directive <directive
      module="mod_rewrite">RewriteMap</directive>.</dd>

      <dt><module>mod_ldap</module>, <module>mod_authnz_ldap</module></dt>
      <dd><module>mod_authnz_ldap</module> ajoute le support des
      groupes imbriqués.</dd>
      <dd><module>mod_ldap</module> apporte les directives <directive
      module="mod_ldap">LDAPConnectionPoolTTL</directive> et <directive
      module="mod_ldap">LDAPTimeout</directive>, ainsi que d'autres
      améliorations dans le traitement des délais. Ceci s'avère utile
      pour les configurations où un pare-feu à mémoire d'état (stateful)
      rejète les connexions inactives vers le serveur LDAP.</dd>
      <dd><module>mod_ldap</module> propose la directive <directive
      module="mod_ldap">LDAPLibraryDebug</directive> qui permet de
      journaliser les informations de débogage fournies par la boîte à
      outils LDAP utilisée.</dd>

      <dt><module>mod_info</module></dt>
      <dd><module>mod_info</module> est maintenant capable d'afficher la
      configuration préinterprétée sur stdout au cours du démarrage du
      serveur.</dd>

      <dt><module>mod_auth_basic</module></dt>
      <dd>Nouveau mécanisme générique permettant d'effectuer une
      authentification basique (disponible à partir de la version 2.4.5).</dd>

    </dl>
  </section>

  <section id="programs">
    <title>Améliorations des programmes</title>
    <dl>
        <dt><program>fcgistarter</program></dt>
        <dd>Nouvel utilitaire pour le démarrage des démons
	FastCGI.</dd>
	<dt><program>htcacheclean</program></dt>
        <dd>Les URLs présentes dans le cache peuvent maintenant être
	affichées, accompagnées éventuellement de leurs métadonnées.</dd>
        <dd>Possibilité de supprimer explicitement des URLs individuelles
	présentes dans le cache.</dd>
        <dd>Les tailles de fichiers peuvent maintenant être arrondies au
	multiple de la taille de bloc donnée, les limites de taille
	collant de ce fait d'avantage à la taille réelle sur disque.</dd>
        <dd>La taille du cache peut maintenant être limitée par le
	nombre d'inodes, en plus de la possibilité de limitation par la
	taille des fichiers.</dd>

	<dt><program>rotatelogs</program></dt>
        <dd>Possibilité de créer un lien vers le fichier journal
	courant.</dd>
        <dd>Possibilité d'invoquer un script personnalisé après la
	rotation.</dd>

	<dt><program>htpasswd</program>, <program>htdbm</program></dt>
        <dd>Support de l'algorithme bcrypt (disponible à partir de la
	version 2.4.4).
        </dd>
    </dl>
  </section>

  <section id="documentation">
    <title>Documentation</title>
    <dl>
        <dt>mod_rewrite</dt>
        <dd>La documentation du module <module>mod_rewrite</module> a
	été réorganisée et presque entièrement réécrite en mettant
	l'accent sur les exemples et l'utilisation courante, ainsi que
	sur l'incitation à utiliser d'autres solutions lorsque cela
	s'avère plus approprié. Le document <a href="rewrite/">Rewrite
	Guide</a> constitue maintenant une section de premier niveau ;
	il est mieux organisé et contient beaucoup plus de détails.</dd>

        <dt>mod_ssl</dt>
        <dd>La documentation du module <module>mod_ssl</module> a été
	grandement améliorée, avec plus d'exemples et un niveau "Bien
	démarrer" qui s'ajoutent aux détails techniques déjà présents
	dans la précédente documentation.</dd>

        <dt>Caching Guide</dt>
        <dd>Le <a href="caching.html">Guide de la mise en cache</a> a
	été réécrit afin de bien faire la différence entre les
	fonctionnalités de mise en cache de la RFC2616 HTTP/1.1 fournies
	par le module <module>mod_cache</module>, et la mise en cache
	générique de type clé/valeur fournie par l'interface <a
	href="socache.html">socache</a>, mais aussi pour couvrir la mise
	en cache spécialisée fournie par des mécanismes tels que ceux du
	module <module>mod_file_cache</module>.</dd>
    </dl>
    </section>

  <section id="developer">
    <title>Modifications concernant les développeur de modules</title>
    <dl>
      <dt>Ajout de code pour la vérification de la configuration</dt>

      <dd>Une nouvelle fonction, <code>check_config</code>, a été ajoutée et
      s'exécute entre les fonctions <code>pre_config</code> et
      <code>open_logs</code>. Elle s'exécute aussi avant la fonction
      <code>test_config</code> si l'option <code>-t</code> est passée au
      démon <program>httpd</program>. La fonction <code>check_config</code>
      permet aux modules de vérifier l'interdépendance des valeurs des
      directives de configuration et d'ajuster ces valeurs, alors que les
      messages du serveur peuvent encore être affichés sur la console.
      L'utilisateur est ainsi averti des erreurs de configuration avant que la
      fonction du noyau <code>open_logs</code> ne redirige les sorties de la
      console vers le journal des erreurs.</dd>

      <dt>Ajout d'un analyseur syntaxique d'expressions</dt>
      <dd>Nous disposons à présent d'un analyseur générique d'expressions, dont l'API
      est décrite dans <var>ap_expr.h</var>. Il s'agit d'une adaptation de
      l'analyseur qu'on trouvait auparavant dans <module>mod_ssl</module>.</dd>

      <dt>Conteneurs de logique d'autorisation</dt>

      <dd>Afin de fournir une logique d'autorisation avancée via des
      directives telles que <directive module="mod_authz_core"
      type="section">RequireAll</directive>, les modules d'autorisation
      s'enregistrent maintenant en tant
      que fournisseur par le biais de ap_register_auth_provider().</dd>

      <dt>Interface de mise en cache des petits objets</dt>

      <dd>Le fichier d'en-têtes <var>ap_socache.h</var> fournit une
      interface à base de fournisseur pour la mise en cache des petits
      objets de données, en s'inspirant de
      l'implémentation précédente
      du cache de session par <module>mod_ssl</module>. Sont supportés
      actuellement : les fournisseurs utilisant un tampon cyclique en
      mémoire partagée, les fichiers dbm sur disque, et les caches
      distribués de type memcache.</dd>

      <dt>Ajout du point d'ancrage Cache Status</dt>

      <dd>Le module <module>mod_cache</module> inclut maintenant un
      nouveau point d'ancrage, <code>cache_status</code>, qui est appelé
      lorsque la décision à propos de la mise en cache est connue. Il en
      existe une implémentation par défaut qui ajoute les en-têtes
      optionnels <code>X-Cache</code> et <code>X-Cache-Detail</code> à
      la réponse.</dd>


    </dl>
    <p>La documentation du développeur contient une <a
    href="developer/new_api_2_4.html">liste détaillée des modifications
    de l'API</a>.</p>
  </section>

</manualpage>
