<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1334024 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_session_cookie.xml.meta">

<name>mod_session_cookie</name>
<description>Support des sessions bas&eacute; sur les cookies</description>
<status>Extension</status>
<sourcefile>mod_session_cookie.c</sourcefile>
<identifier>session_cookie_module</identifier>
<compatibility>Disponible depuis la version 2.3 d'Apache</compatibility>

<summary>
    <note type="warning"><title>Avertissement</title>
      <p>Les modules de session font usage des cookies HTTP, et peuvent
      &agrave; ce titre &ecirc;tre victimes d'attaques de type Cross Site Scripting,
      ou divulguer des informations &agrave; caract&egrave;re priv&eacute; aux clients.
      Veuillez vous assurer que les risques ainsi encourus ont &eacute;t&eacute; pris
      en compte avant d'activer le support des sessions sur votre
      serveur.</p>
    </note>

    <p>Ce sous-module du module <module>mod_session</module> fournit le
    support du stockage des sessions utilisateur au niveau du navigateur
    distant dans des cookies HTTP.</p>

    <p>L'utilisation de cookies pour stocker les sessions d&eacute;charge le
    serveur ou le groupe de serveurs de la n&eacute;cessit&eacute; de stocker les
    sessions localement, ou de collaborer pour partager les sessions, et
    peut &ecirc;tre utile dans les environnements &agrave; fort trafic o&ugrave; le stockage
    des sessions sur le serveur pourrait s'av&eacute;rer trop consommateur de
    ressources.</p>

    <p>Si la confidentialit&eacute; de la session doit &ecirc;tre pr&eacute;serv&eacute;e, le
    contenu de cette derni&egrave;re peut &ecirc;tre chiffr&eacute; avant d'&ecirc;tre enregistr&eacute;
    au niveau du client &agrave; l'aide du module
    <module>mod_session_crypto</module>.</p>

    <p>Pour plus de d&eacute;tails &agrave; propos de l'interface des sessions, voir
    la documentation du module <module>mod_session</module>.</p>

</summary>
<seealso><module>mod_session</module></seealso>
<seealso><module>mod_session_crypto</module></seealso>
<seealso><module>mod_session_dbd</module></seealso>

    <section id="basicexamples"><title>Exemples simples</title>

      <p>Pour cr&eacute;er une session et la stocker dans un cookie nomm&eacute;
      <var>session</var>, configurez-la comme suit :</p>

      <example><title>Session stock&eacute;e au niveau du navigateur</title>
        <highlight language="config">
Session On
SessionCookieName session path=/
        </highlight>
      </example>

      <p>Pour plus d'exemples sur la mani&egrave;re dont une session doit &ecirc;tre
      configur&eacute;e pour qu'une application CGI puisse l'utiliser, voir la
      section exemples de la documentation du module
      <module>mod_session</module>.</p>

      <p>Pour des d&eacute;tails sur la mani&egrave;re dont une session peut &ecirc;tre
      utilis&eacute;e pour stocker des informations de type nom
      d'utilisateur/mot de passe, voir la documentation du module
      <module>mod_auth_form</module>.</p>

    </section>

<directivesynopsis>
<name>SessionCookieName</name>
<description>Nom et attributs du cookie RFC2109 dans lequel la session
est stock&eacute;e</description>
<syntax>SessionCookieName <var>nom</var> <var>attributs</var></syntax>
<default>none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionCookieName</directive> permet de
    sp&eacute;cifier le nom et les attributs optionnels d'un cookie compatible
    RFC2109 dans lequel la session sera stock&eacute;e. Les cookies RFC2109
    sont d&eacute;finis en utilisant l'en-t&ecirc;te HTTP <code>Set-Cookie</code>.
    </p>

    <p>Une liste optionnelle d'attributs peut &ecirc;tre sp&eacute;cifi&eacute;e, comme dans
    l'exemple suivant. Ces attributs sont ins&eacute;r&eacute;s tels quels dans le
    cookie, et ne sont pas interpr&eacute;t&eacute;s par Apache. Assurez-vous que vos
    attributs soient d&eacute;finis correctement selon la sp&eacute;cification des
    cookies.
    </p>

    <example><title>Cookie avec attributs</title>
      <highlight language="config">
Session On
SessionCookieName session path=/private;domain=example.com;httponly;secure;version=1;
      </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionCookieName2</name>
<description>Nom et attributs pour le cookie RFC2965 dans lequel est
stock&eacute;e la session</description>
<syntax>SessionCookieName2 <var>nom</var> <var>attributs</var></syntax>
<default>none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionCookieName2</directive> permet de
    sp&eacute;cifier le nom et les attributs optionnels d'un cookie compatible
    RFC2965 dans lequel la session sera stock&eacute;e. Les cookies RFC2965
    sont d&eacute;finis en utilisant l'en-t&ecirc;te HTTP
    <code>Set-Cookie2</code>.
    </p>

    <p>Une liste optionnelle d'attributs peut &ecirc;tre sp&eacute;cifi&eacute;e, comme dans
    l'exemple suivant. Ces attributs sont ins&eacute;r&eacute;s tels quels dans le
    cookie, et ne sont pas interpr&eacute;t&eacute;s par Apache. Assurez-vous que vos
    attributs soient d&eacute;finis correctement selon la sp&eacute;cification des
    cookies.
    </p>

    <example><title>Cookie2 avec attributs</title>
      <highlight language="config">
Session On
SessionCookieName2 session path=/private;domain=example.com;httponly;secure;version=1;
    </highlight>
    </example>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SessionCookieRemove</name>
<description>D&eacute;termine si les cookies de session doivent &ecirc;tre supprim&eacute;s
des en-t&ecirc;tes HTTP entrants</description>
<syntax>SessionCookieRemove On|Off</syntax>
<default>SessionCookieRemove Off</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>SessionCookieRemove</directive> permet de
    d&eacute;terminer si les cookies contenant la session doivent &ecirc;tre
    supprim&eacute;s des en-t&ecirc;tes pendant le traitement de la requ&ecirc;te.</p>

    <p>Dans le cas d'un mandataire inverse o&ugrave; le serveur Apache sert de
    frontal &agrave; un serveur d'arri&egrave;re-plan, r&eacute;v&eacute;ler le contenu du cookie de
    session &agrave; ce dernier peut conduire &agrave; une violation de la
    confidentialit&eacute;. &Agrave; ce titre, si cette directive est d&eacute;finie &agrave; "on",
    le cookie de session sera supprim&eacute; des en-t&ecirc;tes HTTP entrants.</p>

</usage>
</directivesynopsis>

</modulesynopsis>
