<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1599013 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mpm_winnt.xml.meta">

<name>mpm_winnt</name>
<description>Module multi-processus optimisé pour Windows
NT.</description>
<status>MPM</status>
<sourcefile>mpm_winnt.c</sourcefile>
<identifier>mpm_winnt_module</identifier>

<summary>
    <p>Ce module multi-processus (MPM) est le module par défaut pour les
    systèmes d'exploitation de style Windows NT. Il consiste en un
    processus de contrôle unique qui lance un processus enfant unique,
    ce dernier créant à son tour des threads pour traiter les
    requêtes.</p>

    <p>La directive <directive
    module="mpm_common">ThreadsPerChild</directive> définit le
    nombre maximal de connexions clientes simultanées.</p>

    <p>Ce MPM utilise par défaut les APIs Windows avancées pour accepter
    les nouvelles connexions des clients. Avec certaines configurations,
    des produits tiers peuvent interférer avec cette implémentation, et
    provoquer l'enregistrement des messages suivants dans les journaux
    du serveur :</p>

    <example>
        Child: Encountered too many AcceptEx faults accepting client connections.<br />
        winnt_mpm: falling back to 'AcceptFilter none'.
    </example>

    <p>Le MPM se rabat sur une implémentation plus sûre, mais certaines
    requêtes n'ont pas été traitées correctement. Pour éviter cette
    erreur, définissez la directive <directive
    module="core">AcceptFilter</directive> à <code>none</code>.</p>

    <highlight language="config">
AcceptFilter http none
AcceptFilter https none
    </highlight>

    <p><em>Avec les versions 2.0 et 2.2 d'Apache httpd, c'est la directive
    <directive>Win32DisableAcceptEx</directive> qui était utilisée à cet
    effet.</em></p>

    <p>Le MPM WinNT diffère des autres MPMs Unix comme worker et event
    à bien des égards :</p>

    <ul>
      <li>Lorsqu'un processus enfant s'arrête suite à un arrêt ou
      redémarrage du serveur, ou lorsque que la limite <directive
      module="mpm_common">MaxConnectionsPerChild</directive> est
      atteinte, les requêtes en cours de traitement par ce processus en
      cours d'arrêt n'ont que <directive
      module="core">TimeOut</directive> secondes pour s'exécuter avant
      l'arrêt du processus. Les autres types de redémarrage ou arrêt ne
      sont pas implémentés.</li>

      <li>Les nouveau processus enfants relisent les fichiers de
      configuration au lieu d'en hériter du parent. Ce comportement ne
      pose pas de problème si le processus enfant est créé au démarrage
      ou redémarrage, mais dans le cas où un processus enfant est créé
      parce qu'un autre processus enfant s'est arrêté ou a atteint la
      limite <directive
      module="mpm_common">MaxConnectionsPerChild</directive>, tout
      changement survenu entre temps dans la configuration sera alors
      pris en compte dans le processus enfant, et parent et enfant
      utiliseront une configuration différente. Si des modifications
      planifiées de la configuration ont été partiellement effectuées,
      et si la configuration courante n'est pas interprétable, le
      processus enfant de remplacement ne pourra pas démarrer, et le
      serveur s'arrêtera. En conséquence, toute modification des
      fichiers de configuration doit être accompagnée d'un redémarrage
      du serveur.</li>

      <li>Les hooks <code>monitor</code> et <code>fatal_exception</code>
      ne sont pas encore implémentés.</li>

      <li>La directive <directive>AcceptFilter</directive> est
      implémentée par le MPM et fournit un type de contrôle différent
      sur le traitement des nouvelles connexions (Voir la documentation
      de la directive <directive module="core">AcceptFilter</directive>
      pour plus de détails).</li>
    </ul>

</summary>

<seealso><a href="../platform/windows.html">Utiliser le serveur HTTP
Apache sous Microsoft Windows</a></seealso>

<directivesynopsis location="core"><name>AcceptFilter</name>
</directivesynopsis>

<directivesynopsis location="mpm_common"><name>CoreDumpDirectory</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>PidFile</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>Listen</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ListenBacklog</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxConnectionsPerChild</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>MaxMemFree</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ScoreBoardFile</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ReceiveBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>SendBufferSize</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadLimit</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadsPerChild</name>
</directivesynopsis>
<directivesynopsis location="mpm_common"><name>ThreadStackSize</name>
</directivesynopsis>

</modulesynopsis>
