<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1825468 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_remoteip.xml.meta">

<name>mod_remoteip</name>
<description>Remplace l'adresse IP du client
pour la requête par l'adresse IP présentée par un mandataire ou un
répartiteur de charge via les en-têtes de la requête.
</description>

<status>Base</status>
<sourcefile>mod_remoteip.c</sourcefile>
<identifier>remoteip_module</identifier>

<summary>
    <p>Ce module permet de traiter le client qui a initié la
    requête en tant que client original du point de vue de httpd à
    des fins d'autorisation et de connexion, même si ce client se
    trouve derrière un répartiteur de charge, un serveur frontal, ou un
    serveur mandataire.</p>

    <p>Le module remplace l'adresse IP du client
    pour la connexion par l'adresse IP indiquée dans
    l'en-tête de requête configuré via la directive
    <directive module="mod_remoteip">RemoteIPHeader</directive>.</p>

    <p>Ce module implémente aussi la partie serveur du <a
    href="http://blog.haproxy.com/haproxy/proxy-protocol/">protocole PROXY</a>
    de HAProxy via la directive <directive
    module="mod_remoteip">RemoteIPProxyProtocol</directive>.</p>

    <p>Une fois sa valeur modifiée comme indiqué, cette adresse IP client est
    utilisée pour la fonctionnalité <directive module="mod_authz_core"
    name="require">Require ip</directive> de <module>mod_authz_host</module> ;
    elle est aussi affichée par <module>mod_status</module>, et enregistrée via
    les chaînes de formatage <code>%a</code> des modules
    <module>mod_log_config</module> et <module>core</module>.  L'adresse IP
    client sous-jacente de la connexion est enregistrée via la chaîne de
    formatage <code>%{c}a</code>.  </p>

    <note type="warning">Il est essentiel de n'activer cette
    fonctionnalité que pour les requêtes en provenance des serveurs
    intermédiaires (mandataires, etc...) auxquels le serveur peut faire
    confiance, car il est trivial pour le client distant d'usurper
    l'identité d'un autre client.</note>
</summary>

<seealso><module>mod_authz_host</module></seealso>
<seealso><module>mod_status</module></seealso>
<seealso><module>mod_log_config</module></seealso>
<seealso><a
href="http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt">Proxy Protocol
Spec</a></seealso>

<section id="processing"><title>Traitement des adresses distantes</title>

    <p>Par défaut, Apache identifie le client via la valeur client_ip de la
    connexion, et de cette valeur découlent les valeurs remote_host et
    remote_logname de la connexion. Ces champs jouent un rôle
    dans l'authentification, l'autorisation et la journalisation, ainsi que
    dans d'autres traitements effectués par d'autres modules
    chargeables.</p>

    <p>mod_remoteip remplace l'adresse IP client de la connexion par l'adresse IP client
    indiquée par exemple par un mandataire ou un répartiteur de charge
    pour toute la durée de la requête. Un répartiteur de charge pourra ainsi
    établir une connexion keepalive de longue durée avec le serveur, chaque
    requête conservant alors l'adresse IP client correcte bien que l'adresse IP
    client sous-jacente du répartiteur de charge reste inchangée.</p>

    <p>Lorsque la valeur de l'en-tête comporte plusieurs adresses IP
    client séparées par des virgules, celles-ci sont traitées de la
    droite vers la gauche. Le traitement s'arrête lorsque l'adresse IP
    client courante n'est pas digne de confiance pour présenter
    l'adresse IP précédente. Le champ d'en-tête est alors mis à jour de
    façon à ne contenir que cette liste d'adresses non confirmées, ou
    bien, si toutes les adresses IP sont dignes de confiance, cet
    en-tête est tout bonnement supprimé de la requête.</p>

    <p>Lors du remplacement de l'adresse IP client, le module stocke
    la liste des hôtes intermédiaires dans un mémo
    remoteip-proxy-ip-list, que l'on peut faire enregistrer par
    <module>mod_log_config</module> en utilisant le symbole de format
    <code>%{remoteip-proxy-ip-list}n</code>. Si l'administrateur doit
    stocker ceci dans un en-tête additionnel, la même valeur peut aussi
    être enregistrée sous la forme d'un en-tête en utilisant la
    directive <directive module="mod_remoteip">RemoteIPProxiesHeader</directive>.</p>

    <note><title>Adresses IPv4 converties au format IPv6</title>
    Avec httpd, d'une manière générale, toute adresse IPv4 convertie au
    format IPv6 est enregistrée sous sa forme IPv4.</note>

    <note><title>Adresses internes (privées)</title>
    Tous les blocs d'adresses internes 10/8, 172.16/12, 192.168/16,
    169.254/16 and 127/8 (ainsi que les adresses IPv6 en dehors du bloc
    public 2000::/3 block) ne sont évaluées par mod_remoteip que lorsque
    des mandataires internes (intranet)
    <directive module="mod_remoteip">RemoteIPInternalProxy</directive> sont enregistrés.</note>

</section>

<directivesynopsis>
<name>RemoteIPHeader</name>
<description>Définit le champ d'en-tête qui contiendra les adresses IP
du client</description>
<syntax>RemoteIPHeader <var>en-tête</var></syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive module="mod_remoteip">RemoteIPHeader</directive> indique à
    <module>mod_remoteip</module> de traiter la valeur de
    l'<var>en-tête</var> spécifié comme l'adresse IP du client, ou comme
    une liste d'adresses IP clients intermédiaires, en fonction de la
    configuration des directives
    <directive module="mod_remoteip">RemoteIPInternalProxy</directive> et
    <directive module="mod_remoteip">RemoteIPTrustedProxy</directive>. Si ces
    deux dernières directives ne sont pas utilisées,
    <module>mod_remoteip</module> traitera tout hôte présentant une adresse non
    interne dans l'en-tête <directive
    module="mod_remoteip">RemoteIPHeader</directive> comme hôte de confiance.</p>
    
    <note type="warning">Si ces deux dernières
    directives ne sont pas utilisées, <module>mod_remoteip</module>
    traitera tout hôte présentant une adresse non interne
    dans l'en-tête <directive
    module="mod_remoteip">RemoteIPHeader</directive> comme hôte de
    confiance.</note>

    <example><title>Exemple à usage interne (répartiteur de
    charge)</title>
    <highlight language="config">
        RemoteIPHeader X-Client-IP
	</highlight>
    </example>

    <example><title>Exemple dans le cas d'un mandataire</title>
    <highlight language="config">
        RemoteIPHeader X-Forwarded-For
	</highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPInternalProxy</name>
<description>Déclare les adresses IP intranet clients comme dignes de
confiance pour présenter la valeur RemoteIPHeader</description>
<syntax>RemoteIPInternalProxy
<var>ip-mandataire</var>|<var>ip-mandataire/sous-réseau</var>|<var>nom-hôte</var> ...</syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive module="mod_remoteip">RemoteIPInternalProxy</directive> permet
    d'ajouter une ou plusieurs adresses (ou blocs d'adresses) auxquelles
    on peut faire confiance pour présenter une valeur RemoteIPHeader
    valide de l'adresse IP du client. A la différence de la directive
    <directive module="mod_remoteip">RemoteIPTrustedProxy</directive>, toute adresse IP
    présentée dans cet en-tête, y comprises les adresses intranet
    privées, sont considérées comme dignes de confiance lorsqu'elles
    sont indiquées par ces mandataires.</p>

    <example><title>Exemple à usage interne (répartiteur de
    charge)</title>
        <highlight language="config">
RemoteIPHeader X-Client-IP
RemoteIPInternalProxy 10.0.2.0/24
RemoteIPInternalProxy gateway.localdomain
        </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPInternalProxyList</name>
<description>Déclare les adresses IP intranet clients comme dignes de
confiance pour présenter la valeur RemoteIPHeader</description>
<syntax>RemoteIPInternalProxyList <var>nom-fichier</var></syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive module="mod_remoteip">RemoteIPInternalProxyList</directive>
    permet de spécifier un fichier parcouru au démarrage du serveur pour
    construire une liste d'adresses (ou blocs d'adresses), auxquelles
    on peut faire confiance pour présenter une valeur RemoteIPHeader
    valide de l'adresse IP du client.</p>

    <p>Le caractère '<code>#</code>' indique une ligne de commentaires,
    sinon, toutes les lignes séparées par un caractère <code>nouvelle
    ligne</code> ou
    tous les éléments d'une ligne séparés par un espace sont traités de
    la même façon qu'avec la directive
    <directive module="mod_remoteip">RemoteIPInternalProxy</directive>.</p>

    <example><title>Exemple à usage interne (répartiteur de
    charge)</title>
        <highlight language="config">
RemoteIPHeader X-Client-IP
RemoteIPInternalProxyList conf/trusted-proxies.lst
        </highlight>
    </example>

    <example><title>contenu de conf/mandataires-de-confiance.lst</title>
    <pre>
         # Nos mandataires internes de confiance
         10.0.2.0/24         # Tout le monde dans le groupe de test
         passerelle.domaine-local # Le frontal répartiteur de charge
    </pre>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPProxiesHeader</name>
<description>Déclare le champ d'en-tête qui contiendra toutes les
adresses IP intermédiaires</description>
<syntax>RemoteIPProxiesHeader <var>Nom_en-tête</var></syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive module="mod_remoteip">RemoteIPProxiesHeader</directive> permet
    de spécifier l'en-tête dans lequel <module>mod_remoteip</module> va
    collecter une liste de toutes les adresses IP clients intermédiaires
    auxquelles on pourra faire confiance pour résoudre l'adresse IP
    client de la requête. Notez que les adresses intermédiaires
    <directive module="mod_remoteip">RemoteIPTrustedProxy</directive> sont enregistrées dans
    cet en-tête, alors que toute adresse intermédiaire
    <directive module="mod_remoteip">RemoteIPInternalProxy</directive> est omise.</p>

    <example><title>Exemple</title>
        <highlight language="config">
RemoteIPHeader X-Forwarded-For
RemoteIPProxiesHeader X-Forwarded-By
    </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPProxyProtocol</name>
<description>Active ou désactive la gestion du protocole PROXY</description>
<syntax>RemoteIPProxyProtocol On|Off</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.31 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>RemoteIPProxyProtocol</directive> permet
    d'activer ou de désactiver la prise en compte et la gestion de l'en-tête de
    connexion du protocole PROXY. Si elle est définie à <code>On</code>, la
    demande du client <em>doit</em> envoyer l'en-tête approprié pour chaque
    nouvelle connexion, sinon cette dernière sera fermée à moins qu'il ne fasse
    partie de la liste, définie via la directive <directive
    module="mod_remoteip">RemoteIPProxyProtocolDisableHosts</directive>, des
    hôtes pour lesquels le protocole PROXY est désactivé.</p>

    <p>Bien que cette directive peut être définie au niveau de n'importe quel
    serveur virtuel, il est important de garder à l'esprit que, étant donné que
    le protocole PROXY est basé sur la connexion et agnostique quant au
    protocle, son activation/désactivation est basée sur le couple adresse
    IP/port. Cela signifie que si plusieurs serveurs virtuels à base de nom sont
    configurés avec le même couple adresse IP/port, et si vous activez le
    protocole PROXY pour l'un d'entre eux, il le sera aussi pour tous les autres
    (avec le même couple adresse IP/port). Cela signifie aussi que si vous
    tentez d'activer le protocole PROXY pour un serveur virtuel et de le
    désactiver pour un autre, cela ne marchera pas ; dans ce dernier cas, la
    dernière directive l'emporte sur les autres et une notification sera
    enregistrée dans le journal pour indiquer les réglages qui ont été annulés.</p>

    <highlight language="config">
Listen 80
&lt;VirtualHost *:80&gt;
    ServerName www.example.com
    RemoteIPProxyProtocol On

    #Les requêtes pour ce serveur virtuel doivent contenir un en-tête du
    #protocole PROXY. Si ce n'est pas le cas, la connexion sera fermée.
&lt;/VirtualHost&gt;

Listen 8080
&lt;VirtualHost *:8080&gt;
    ServerName www.example.com
    RemoteIPProxyProtocol On
    RemoteIPProxyProtocolExceptions 127.0.0.1 10.0.0.0/8

    #Les requêtes pour ce serveur virtuel doivent contenir un en-tête du
    #protocole PROXY. Si ce n'est pas le cas, la connexion sera fermée à moins
    que sa source ne soit localhost ou la gamme d'adresses RFC1918 10.x.x.x
&lt;/VirtualHost&gt;
    </highlight>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPProxyProtocolExceptions</name>
<description>Désactive la prise en compte de l'en-tête PROXY pour certains hôtes
ou réseaux</description>
<syntax>RemoteIPProxyProtocolExceptions host|range [host|range] [host|range]</syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>
<compatibility>RemoteIPProxyProtocolExceptions est disponible à partir de la
version 2.4.31 du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>RemoteIPProxyProtocol</directive> permet de
    contrôler la prise en compte de l'en-tête de connexion du protocole PROXY.
    Il est parfois souhaitable d'exiger pour certains clients la
    présence de l'en-tête PROXY, mais aussi de permettre aux autres clients de
    se connecter sans ce dernier. Cette directive permet à l'administrateur du
    serveur d'autoriser cette possibilité à un hôte isolé ou à une gamme d'hôtes
    au format CIDR.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPTrustedProxy</name>
<description>Déclare les adresses IP clientes de l'intranet dignes de
confiance pour présenter la valeur RemoteIPHeader</description>
<syntax>RemoteIPTrustedProxy
<var>ip-mandataire</var>|<var>ip-mandataire/sous-réseau</var>|<var>nom-hôte</var> ...</syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive module="mod_remoteip">RemoteIPTrustedProxy</directive> permet
    d'ajouter une ou plusieurs adresses, ou blocs d'adresses, auxquelles
    on peut faire confiance pour présenter une valeur RemoteIPHeader
    valide de l'adresse IP du client. A la différence de la directive
    <directive module="mod_remoteip">RemoteIPInternalProxy</directive>, toutes les adresses IP
    intranet ou privées indiquées par de tels mandataires, y compris les
    blocs d'adresses 10/8, 172.16/12, 192.168/16, 169.254/16 et 127/8
    (ou située en dehors du bloc IPv6 public 2000::/3), ne sont pas
    dignes de confiance en tant qu'adresses IP distantes, et se situent
    à gauche dans le contenu de l'en-tête
    <directive module="mod_remoteip">RemoteIPHeader</directive>.</p>

    <example><title>Exemple d'adresse de confiance (répartiteur de
    charge</title>
        <highlight language="config">
RemoteIPHeader X-Forwarded-For
RemoteIPTrustedProxy 10.0.2.16/28
RemoteIPTrustedProxy proxy.example.com
        </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoteIPTrustedProxyList</name>
<description>Déclare les adresses IP intranet clients comme dignes de
confiance pour présenter la valeur RemoteIPHeader</description>
<syntax>RemoteIPTrustedProxyList <var>nom-fichier</var></syntax>
<contextlist><context>server config</context><context>virtual host</context></contextlist>

<usage>
    <p>La directive <directive module="mod_remoteip">RemoteIPTrustedProxyList</directive>
    permet de spécifier un fichier parcouru au démarrage du serveur pour
    construire une liste d'adresses (ou blocs d'adresses), auxquelles
    on peut faire confiance pour présenter une valeur RemoteIPHeader
    valide de l'adresse IP du client.</p>

    <p>Le caractère '<code>#</code>' indique une ligne de commentaires,
    sinon, toutes les lignes séparées par un caractère nouvelle ligne ou
    tous les éléments d'une ligne séparés par un espace sont traités de
    la même façon qu'avec la directive
    <directive module="mod_remoteip">RemoteIPTrustedProxy</directive>.</p>

    <example><title>Exemple d'adresse de confiance (répartiteur de
    charge</title>
        <highlight language="config">
RemoteIPHeader X-Forwarded-For
RemoteIPTrustedProxyList conf/trusted-proxies.lst
        </highlight>
    </example>

    <example><title>conf/mandataires-de-confiance.lst contents</title>
       # Mandataires externes identifiés<br/>
       192.0.2.16/28         #groupe wap phone de mandataires<br/>
       proxy.isp.example.com #un FAI bien connu
    </example>
</usage>
</directivesynopsis>


</modulesynopsis>

