<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1798491 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_proxy_http2.xml.meta">

<name>mod_proxy_http2</name>
<description>Support de HTTP/2 pour <module>mod_proxy</module></description>
<status>Extension</status>
<sourcefile>mod_proxy_http2.c</sourcefile>
<identifier>proxy_http2_module</identifier>

<summary>
    <p><module>mod_proxy_http2</module> ne
    supporte que HTTP/2 et ne permet pas de rétrogradation vers HTTP/1.1. Cela
    signifie que le serveur d'arrière-plan doit supporter HTTP/2 car HTTP/1.1 ne
    pourra alors pas être utilisé.</p>

    <p>Ce module <em>nécessite</em> la présence de <module>mod_proxy</module> ;
    pour pouvoir traiter les requêtes mandatées HTTP/2,
    <module>mod_proxy</module> et <module>mod_proxy_http2</module> doivent donc
    être chargés par le serveur.</p>

    <p><module>mod_proxy_http2</module> travaille avec des requêtes entrantes en
    HTTP/1.1 ou HTTP/2. Dans les deux cas, les requêtes vers le même serveur
    d'arrière-plan sont envoyées
    via une seule connexion TCP, dans la mesure du possible (autrement dit
    lorsque la connexion peut être réutilisée).</p>

    <p>Avertissement : il ne sera effectué aucune tentative de fusion de
    plusieurs requêtes entrantes HTTP/1 (devant être mandatées vers le même
    serveur d'arrière-plan) vers des flux HTTP/2 appartenant à la même requête
    HTTP/2.  Chaque requête HTTP/1 entrante sera mandatée vers le serveur
    d'arrière-plan en utilisant une requête HTTP/2 séparée (tout en réutilisant
    si possible la même connexion TCP).</p>

    <p>Ce module s'appuie sur <a href="http://nghttp2.org/">libnghttp2</a> pour
    fournir le moteur central http/2.</p>

    <note type="warning"><title>Avertissement</title>
    <p>Ce module en est au
    stade expérimental. Ses comportement, directives et valeurs par défauts sont
    donc susceptibles de modifications d'une version à l'autre plus fréquentes
    que pour les autres modules. A ce titre, il est fortement conseillé aux
    utilisateurs de consulter le fichier "CHANGES" pour prendre connaissance de
    ces modifications.</p> </note>

    <note type="warning"><title>Avertissement</title>
      <p>N'activez pas le mandatement avant d'avoir <a
      href="mod_proxy.html#access">sécurisé votre serveur</a>. Les serveurs
      mandataires ouverts sont dangereux non seulement pour votre propre réseau,
      mais aussi pour l'Internet au sens large.</p>
    </note>
</summary>
<seealso><module>mod_http2</module></seealso>
<seealso><module>mod_proxy</module></seealso>
<seealso><module>mod_proxy_connect</module></seealso>

    <section id="examples"><title>Exemples de base</title>

    <p>Les exemples ci-dessous montrent comment configurer HTTP/2 pour des
    connexions d'arrière-plan vers un mandataire inverse.</p>

    <example><title>HTTP/2 (TLS)</title>
    <highlight language="config">
ProxyPass "/app" "h2://app.example.com"
ProxyPassReverse "/app" "https://app.example.com"
    </highlight>
    </example>

    <example><title>HTTP/2 (non sécurisé)</title>
    <highlight language="config">
ProxyPass "/app" "h2c://app.example.com"
ProxyPassReverse "/app" "http://app.example.com"
    </highlight>
    </example>

    <note>
      <p>Pour mandater en inverse les protocoles <code>h2</code> ou
      <code>h2c</code>, on utilise la directive
      <directive>ProxyPassReverse</directive> avec les schèmes habituels
      <code>https</code> et respectivement
      <code>http</code> qui sont connus et utilisés par l'agent utilisateur.</p>
    </note>
    </section> <!-- /examples -->

<section id="notes"><title>Informations sur les requêtes</title>
    <p><module>mod_proxy_http</module> fournit les informations sur les requêtes
    suivantes pour enregistrement dans les journaux en utilisant le format
    <code>%{VARNAME}n</code> avec les directives <directive
    module="mod_log_config">LogFormat</directive> ou <directive
    module="core">ErrorLogFormat</directive> :
    </p>
    <dl>
        <dt>proxy-source-port</dt>
        <dd>Le numéro de port local utilisé pour la connexion vers le serveur
	d'arrière-plan.</dd>
        <dt>proxy-status</dt>
        <dd>Le statut HTTP/2 en provenance du serveur d'arrière-plan.</dd>
    </dl>
</section>

</modulesynopsis>
