<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1796131 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_info.xml.meta">

<name>mod_info</name>
<description>Affiche une présentation complète de la configuration du
serveur</description>
<status>Extension</status>
<sourcefile>mod_info.c</sourcefile>
<identifier>info_module</identifier>

<summary>
    <p>Pour activer <module>mod_info</module>, ajoutez les lignes
    suivantes à votre fichier <code>httpd.conf</code>.</p>

    <highlight language="config">
&lt;Location "/server-info"&gt;
    SetHandler server-info
&lt;/Location&gt;
    </highlight>

    <p>Il est recommandé d'utiliser <module>mod_authz_host</module> à
    l'intérieur de la section <directive type="section"
    module="core">Location</directive> afin de restreindre l'accès aux
    informations de configuration de votre serveur :</p>

    <highlight language="config">
&lt;Location "/server-info"&gt;
    SetHandler server-info
    Require host example.com
&lt;/Location&gt;
    </highlight>

    <p>Une fois cette configuration effectuée, les informations du
    serveur sont disponibles à l'adresse
    <code>http://votre-serveur.com/infos-serveur</code>.</p>
</summary>

<section id="security"><title>Problèmes liés à la sécurité</title>
    <p>Une fois <module>mod_info</module> chargé dans le serveur, sa
    fonctionnalité de gestionnaire est disponible dans <em>tous</em> les
    fichiers de configuration, y compris les fichiers de configuration
    des répertoires (par exemple <code>.htaccess</code>). Ceci peut
    avoir des répercutions en matière de sécurité pour votre site.</p>

    <p>En particulier, l'utilisation de ce module peut conduire à la
    divulgation d'informations sensibles à partir des directives de
    configuration d'autres modules Apache comme des chemins systèmes,
    des couples nom d'utilisateur/mot de passe, des noms de bases de
    données, etc... C'est pourquoi ce module ne doit être utilisé
    <strong>que</strong> dans un environnement sous contrôle et toujours
    avec les plus grandes précautions.</p>

    <p>Il est recommandé d'utiliser <module>mod_authz_host</module> pour
    restreindre l'accès aux informations de configuration de votre
    serveur.</p>

    <example><title>Contrôle d'accès</title>
      <highlight language="config">
&lt;Location "/server-info"&gt;
    SetHandler server-info
    # Autorisation d'accès depuis le serveur lui-même
    Require ip 127.0.0.1

    # Autorisation d'accès depuis une station de travail du réseau
# local
    Require ip 192.168.1.17
&lt;/Location&gt;
      </highlight>
    </example>
</section>

<section id="queries"><title>Filtrage des informations affichées</title>
    <p>Par défaut, les informations affichées comprennent une liste de
    tous les modules activés, et pour chaque module, une description des
    directives qu'il accepte, les branchements (hooks) qu'il
    implémente, ainsi que les directives concernées dans la
    configuration courante.</p>

    <p>Il est possible d'afficher d'autres vues de la configuration en
    ajoutant un argument à la requête <code>infos-serveur</code>. Par
    exemple, <code>http://votre-serveur.com/infos-serveur?config</code>
    affichera toutes les directives de configuration.</p>

    <dl>
        <dt><code>?&lt;module-name&gt;</code></dt>
            <dd>Uniquement les informations relatives au module
	    spécifié</dd>
        <dt><code>?config</code></dt>
            <dd>Uniquement les directives de configuration, non triées
	    par module</dd>
        <dt><code>?hooks</code></dt>
            <dd>Uniquement la liste des branchements (hooks)
	    auxquels le module est attaché</dd>
        <dt><code>?list</code></dt>
            <dd>Une simple liste des modules activés</dd>
        <dt><code>?server</code></dt>
            <dd>Uniquement des informations de base sur le serveur</dd>
        <dt><code>?providers</code></dt>
            <dd>Liste des fournisseurs disponibles sur votre serveur</dd>	    
    </dl>
</section>

<section id="startup"><title>Affichage de la configuration au démarrage</title>
    <p>Si la directive de configuration define
    <code>-DDUMP_CONFIG</code> est utilisée, <module>mod_info</module> va
    envoyer la configuration préinterprétée vers <code>stdout</code> au
    cours du démarrage du serveur.</p>
    
    <highlight language="sh">
    httpd -DDUMP_CONFIG -k start
    </highlight>    
    
    <p>"Préinterprétée" signifie que
    les directives telles que <directive type="section"
    module="core">IfDefine</directive> et <directive type="section"
    module="core">IfModule</directive> sont évaluées et les variables
    d'environnement remplacées par leurs valeurs. Cela ne représente
    cependant pas la configuration définitive. En particulier, les
    fusions ou écrasementsde définitions en cas de directives multiples ne sont pas
    représentés.</p>

    <p>Le résultat est équivalent à celui de la requête
    <code>?config</code>.</p>
    
</section>

<section id="limitations"><title>Limitations connues</title>
    <p><module>mod_info</module> tire ses informations de
    la configuration interprétée, et non du fichier de configuration
    original. La manière dont l'arbre de configuration interprété est
    créé induit quelques limitations :</p>
    <ul>
      <li>Les directives qui sont traitées immédiatement sans être
      enregistrées dans l'arbre de configuration interprété ne sont pas
      prises en compte. Celles-ci comprennent <directive
      module="core">ServerRoot</directive>, <directive
      module="mod_so">LoadModule</directive> et <directive
      module="mod_so">LoadFile</directive>.</li>
      <li>Les directives qui contrôlent le fichier de configuration
      lui-même, comme <directive module="core">Include</directive>,
      <directive type="section" module="core">IfModule</directive> et
      <directive type="section" module="core">IfDefine</directive> ne
      sont pas prises en compte, mais les directives de configuration
      incluses le sont.</li>
      <li>Les commentaires ne sont pas pris en compte (Ce qui peut être
      considéré comme une fonctionnalité).</li>
      <li>Les directives de configuration des fichiers
      <code>.htaccess</code> ne sont pas prises en compte (car elles ne
      font pas partie de la configuration permanente du serveur).</li>
      <li>Les directives de conteneur comme <directive type="section"
      module="core">Directory</directive> sont affichées
      normalement, mais <module>mod_info</module> est incapable de
      déterminer le numéro de ligne de la balise fermante
      <directive type="section" module="core"
      name="Directory">/Directory</directive>.</li>
      <li>Les directives générées par des modules tiers comme
      <a href="http://perl.apache.org">mod_perl</a> peuvent ne pas être
      prises en compte.</li>
    </ul>
</section>

<directivesynopsis>
<name>AddModuleInfo</name>
<description>Ajoute des données supplémentaires aux informations de
module affichées par le gestionnaire server-info</description>
<syntax>AddModuleInfo <var>nom-module</var> <var>chaîne</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive permet d'afficher le contenu de <var>chaîne</var>
    en tant qu'<strong>Information supplémentaire</strong> interprétée
    en HTML pour le module <var>nom-module</var>. Exemple :</p>

    <highlight language="config">
AddModuleInfo mod_deflate.c 'See &lt;a \
    href="http://httpd.apache.org/docs/&httpd.docs;/mod/mod_deflate.html"&gt;\
    http://httpd.apache.org/docs/&httpd.docs;/mod/mod_deflate.html&lt;/a&gt;'
    </highlight>
</usage>

</directivesynopsis>
</modulesynopsis>
