<?xml version="1.0" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="security_tips.xml.meta">
  <parentdocument href="./">Documentations diverses</parentdocument>

  <title>Conseils sur la s&eacute;curit&eacute;</title>

  <summary>
    <p>Ce document propose quelques conseils et astuces concernant les
    probl&egrave;mes de s&eacute;curit&eacute; li&eacute;s
    &agrave; l'installation d'un serveur web. Certaines suggestions seront &agrave; caract&egrave;re
    g&eacute;n&eacute;ral, tandis que d'autres seront sp&eacute;cifiques &agrave; Apache.</p>
  </summary>

  <section id="uptodate"><title>Maintenez votre serveur &agrave; jour</title>

    <p>Le serveur HTTP Apache a une bonne r&eacute;putation en mati&egrave;re de s&eacute;curit&eacute;
    et poss&egrave;de une communaut&eacute; de d&eacute;veloppeurs tr&egrave;s sensibilis&eacute;s aux probl&egrave;mes
    de s&eacute;curit&eacute;. Mais il est in&eacute;vitable de trouver certains probl&egrave;mes
    -- petits ou grands -- une fois le logiciel mis &agrave; disposition. C'est pour
    cette raison qu'il est crucial de se tenir inform&eacute; des mises &agrave; jour. Si
    vous avez obtenu votre version du serveur HTTP directement depuis Apache,
    nous vous conseillons grandement de vous abonner &agrave; la <a
    href="http://httpd.apache.org/lists.html#http-announce">Liste de diffusion
    des annonces du serveur HTTP</a> qui vous informera de
    la parution des nouvelles versions et des mises &agrave; jour de s&eacute;curit&eacute;. La
    plupart des distributeurs tiers d'Apache fournissent des services
    similaires.</p>

    <p>Gardez cependant &agrave; l'esprit que lorsqu'un serveur web est compromis, le
    code du serveur HTTP n'est la plupart du temps pas en cause. Les probl&egrave;mes
    proviennent plut&ocirc;t de code ajout&eacute;, de scripts CGI, ou du syst&egrave;me
    d'exploitation sous-jacent. Vous devez donc vous tenir inform&eacute; des
    probl&egrave;mes et mises &agrave; jour concernant tous les logiciels pr&eacute;sents sur
    votre syst&egrave;me.</p>

  </section>

  <section id="dos">

    <title>Attaques de type "D&eacute;ni de service"
    (Denial of Service - DoS)</title>

    <p>Tous les services r&eacute;seau peuvent faire l'objet d'attaques de type
    "D&eacute;ni de service" qui tentent de les emp&ecirc;cher de r&eacute;pondre aux clients en
    saturant leurs ressources. Il est impossible de se pr&eacute;munir totalement
    contre ce type d'attaques, mais vous pouvez accomplir certaines actions
    afin de minimiser les probl&egrave;mes qu'elles cr&eacute;ent.</p>

    <p>Souvent, l'outil anti-DoS le plus efficace sera constitu&eacute; par le
    pare-feu ou certaines configurations du syst&egrave;me d'exploitation. Par
    exemple, la plupart des pare-feu peuvent &ecirc;tre configur&eacute;s de fa&ccedil;on &agrave;
    limiter le nombre de connexions simultan&eacute;es depuis une adresse IP ou un
    r&eacute;seau, ce qui permet de pr&eacute;venir toute une gamme d'attaques simples.
    Bien s&ucirc;r, ceci n'est d'aucun secours contre les attaques de type
    "D&eacute;ni de service" distribu&eacute;es (DDoS).</p>

    <p>Certains r&eacute;glages de la configuration d'Apache peuvent aussi
    minimiser les probl&egrave;mes :</p>

    <ul>
      <li>La directive <directive
      module="mod_reqtimeout">RequestReadTimeout</directive> permet de
      limiter le temps que met le client pour envoyer sa requ&ecirc;te.</li>

      <li>La valeur de la directive
      <directive module="core">TimeOut</directive> doit &ecirc;tre diminu&eacute;e sur les
      sites sujets aux attaques DoS. Une valeur de quelques secondes devrait
      convenir. Cependant, comme <directive module="core">TimeOut</directive>
      est actuellement concern&eacute; par de nombreuses op&eacute;rations diff&eacute;rentes, lui
      attribuer une valeur trop faible peut provoquer des probl&egrave;mes avec les
      scripts CGI qui pr&eacute;sentent un long temps de r&eacute;ponse.</li>

      <li>La valeur de la directive
      <directive module="core">KeepAliveTimeout</directive> doit aussi &ecirc;tre
      diminu&eacute;e sur les sites sujets aux attaques DoS. Certains sites
      d&eacute;sactivent m&ecirc;me compl&egrave;tement le "maintien en vie" (keepalives)
      &agrave; l'aide de la directive
      <directive module="core">KeepAlive</directive>, ce qui bien s&ucirc;r
      pr&eacute;sente des inconv&eacute;nients en mati&egrave;re de performances.</li>

      <li>Les valeurs des diff&eacute;rentes directives fournies par d'autres modules
      et en rapport avec des d&eacute;lais doivent aussi &ecirc;tre v&eacute;rifi&eacute;es.</li>

      <li>Les directives
      <directive module="core">LimitRequestBody</directive>,
      <directive module="core">LimitRequestFields</directive>,
      <directive module="core">LimitRequestFieldSize</directive>,
      <directive module="core">LimitRequestLine</directive>, et
      <directive module="core">LimitXMLRequestBody</directive> doivent &ecirc;tre
      configur&eacute;es avec prudence afin de limiter la consommation de ressources
      induite par les demandes des clients.
      </li>

      <li>Sur les syst&egrave;mes d'exploitation qui le supportent, assurez-vous que
      la directive <directive module="core">AcceptFilter</directive> est
      activ&eacute;e afin de d&eacute;l&eacute;guer une partie du traitement des requ&ecirc;tes au
      syst&egrave;me d'exploitation. Elle est activ&eacute;e par d&eacute;faut dans le d&eacute;mon httpd
      d'Apache, mais peut n&eacute;cessiter une reconfiguration de votre noyau.</li>

      <li>Optimisez la directive <directive
      module="mpm_common">MaxRequestWorkers</directive> de fa&ccedil;on &agrave; d&eacute;finir le nombre
      maximum de connexions simultan&eacute;es au dessus duquel les ressources
      s'&eacute;puisent. Voir aussi la <a
      href="perf-tuning.html">documentation sur l'optimisation des
      performances</a>.</li>

      <li>L'utilisation d'un <a href="../mpm.html">module mpm</a> thread&eacute;
      vous permet de traiter d'avantage de connexions simultan&eacute;es, ce qui
      minimise l'effet des attaques DoS. Dans le futur, le module mpm
      <module>event</module> utilisera un traitement asynchrone afin de ne pas
      d&eacute;dier un thread &agrave; chaque connexion. De par la
      nature de la biblioth&egrave;que OpenSSL, le module mpm <module>event</module> est actuellement incompatible
      avec le module <module>mod_ssl</module> ainsi que d'autres filtres
      en entr&eacute;e. Dans ces cas, son comportement se ram&egrave;ne &agrave; celui
      du module mpm <module>worker</module>.</li>

      <li>Il existe de nombreux modules tiers disponibles &agrave; <a
      href="http://modules.apache.org/">http://modules.apache.org/</a> qui
      peuvent retreindre les comportements de certains clients et ainsi
      minimiser les probl&egrave;mes de DoS.</li>

    </ul>

  </section>


  <section id="serverroot">

    <title>Permissions sur les r&eacute;pertoires de la racine du serveur</title>

    <p>Typiquement, Apache est d&eacute;marr&eacute; par l'utilisateur root, puis il devient
    la propri&eacute;t&eacute; de l'utilisateur d&eacute;fini par la directive <directive
    module="mod_unixd">User</directive> afin de r&eacute;pondre aux demandes. Comme
    pour toutes les commandes ex&eacute;cut&eacute;es par root, vous devez vous assurer
    qu'elle n'est pas modifiable par les utilisateurs autres que root. Les
    fichiers eux-m&ecirc;mes, mais aussi les r&eacute;pertoires ainsi que leurs parents ne
    doivent &ecirc;tre modifiables que par root. Par exemple, si vous avez choisi de
    placer la racine du serveur dans <code>/usr/local/apache</code>, il est conseill&eacute; de
    cr&eacute;er le r&eacute;pertoire en tant que root, avec des commandes du style :</p>

    <example>
      mkdir /usr/local/apache <br />
      cd /usr/local/apache <br />
      mkdir bin conf logs <br />
      chown 0 . bin conf logs <br />
      chgrp 0 . bin conf logs <br />
      chmod 755 . bin conf logs
    </example>

    <p>Nous supposerons que <code>/</code>, <code>/usr</code> et
    <code>/usr/local</code> ne sont modifiables que par
    root. Quand vous installez l'ex&eacute;cutable <program>httpd</program>, vous
    devez vous assurer qu'il poss&egrave;de des protections similaires :</p>

    <example>
      cp httpd /usr/local/apache/bin <br />
      chown 0 /usr/local/apache/bin/httpd <br />
      chgrp 0 /usr/local/apache/bin/httpd <br />
      chmod 511 /usr/local/apache/bin/httpd
    </example>

    <p>Vous pouvez cr&eacute;er un sous-r&eacute;pertoire htdocs modifiable par d'autres
    utilisateurs -- car root ne cr&eacute;e ni ex&eacute;cute aucun fichier dans ce
    sous-r&eacute;pertoire.</p>

    <p>Si vous permettez &agrave; des utilisateurs non root de modifier des fichiers
    que root &eacute;crit ou ex&eacute;cute, vous exposez votre syst&egrave;me &agrave; une compromission
    de l'utilisateur root. Par exemple, quelqu'un pourrait remplacer le binaire
    <program>httpd</program> de fa&ccedil;on &agrave; ce que la prochaine fois que vous le
    red&eacute;marrerez, il ex&eacute;cutera un code arbitraire. Si le r&eacute;pertoire des
    journaux a les droits en &eacute;criture (pour un utilisateur non root), quelqu'un
    pourrait remplacer un fichier journal par un lien symbolique vers un autre
    fichier syst&egrave;me, et root pourrait alors &eacute;craser ce fichier avec des donn&eacute;es
    arbitraires. Si les fichiers journaux eux-m&ecirc;mes ont des droits en
    &eacute;criture (pour un utilisateur non root), quelqu'un pourrait
    modifier les journaux eux-m&ecirc;mes avec des donn&eacute;es fausses.</p>

  </section>

  <section id="ssi">

    <title>Inclusions c&ocirc;t&eacute; serveur</title>

    <p>Les inclusions c&ocirc;t&eacute; serveur (Server Side Includes - SSI) exposent
    l'administrateur du serveur &agrave; de nombreux risques potentiels en mati&egrave;re de
    s&eacute;curit&eacute;.</p>

    <p>Le premier risque est l'augmentation de la charge du serveur. Tous les
    fichiers o&ugrave; SSI est activ&eacute; doivent &ecirc;tre analys&eacute;s par Apache, qu'ils
    contiennent des directives SSI ou non. L'augmentation de la charge induite
    est minime, mais peut devenir significative dans le contexte d'un
    serveur partag&eacute;.</p>

    <p>Les fichiers SSI pr&eacute;sentent les m&ecirc;mes risques que les scripts CGI en
    g&eacute;n&eacute;ral. Les fichiers o&ugrave; SSI est activ&eacute; peuvent ex&eacute;cuter tout script CGI
    ou autre programme &agrave; l'aide de la commande <code>"exec cmd"</code> avec les permissions
    des utilisateur et groupe sous lesquels Apache s'ex&eacute;cute, comme d&eacute;fini
    dans <code>httpd.conf</code>.</p>

    <p>Des m&eacute;thodes existent pour am&eacute;liorer la s&eacute;curit&eacute; des fichiers SSI, tout
    en tirant parti des b&eacute;n&eacute;fices qu'ils apportent.</p>

    <p>Pour limiter les dommages qu'un fichier SSI agressif pourrait causer,
    l'administrateur du serveur peut activer<a href="../suexec.html">suexec</a>
    comme d&eacute;crit dans la section <a href="#cgi">Les CGI en g&eacute;n&eacute;ral</a>.</p>

    <p>L'activation des SSI pour des fichiers poss&eacute;dant des extensions
    <code>.html</code> ou
    <code>.htm</code> peut s'av&eacute;rer dangereux. Ceci est particuli&egrave;rement vrai dans un
    environnement de serveur partag&eacute; ou &eacute;tant le si&egrave;ge d'un traffic &eacute;lev&eacute;. Les
    fichiers o&ugrave; SSI est activ&eacute; doivent poss&eacute;der une extension sp&eacute;cifique, telle
    que la conventionnelle <code>.shtml</code>. Ceci permet de limiter la charge du serveur
    &agrave; un niveau minimum et de simplifier la gestion des risques.</p>

    <p>Une autre solution consiste &agrave; interdire l'ex&eacute;cution de scripts et
    programmes &agrave; partir de pages SSI. Pour ce faire, remplacez
    <code>Includes</code> par <code>IncludesNOEXEC</code> dans la directive
    <directive module="core">Options</directive>. Notez que les utilisateurs
    pourront encore utiliser <code>&lt;--#include virtual="..." --&gt;</code> pour ex&eacute;cuter
    des scripts CGI si ces scripts sont situ&eacute;s dans des r&eacute;pertoires sp&eacute;cifi&eacute;s
    par une directive
    <directive module="mod_alias">ScriptAlias</directive>.</p>

  </section>

  <section id="cgi">

    <title>Les CGI en g&eacute;n&eacute;ral</title>

    <p>Tout d'abord, vous devez toujours garder &agrave; l'esprit que vous devez
    faire confiance aux d&eacute;veloppeurs de scripts ou programmes CGI ainsi qu'&agrave;
    vos comp&eacute;tences pour d&eacute;celer les trous de s&eacute;curit&eacute; potentiels dans les
    CGI, que ceux-ci soient d&eacute;lib&eacute;r&eacute;s ou accidentels. Les scripts CGI peuvent
    essentiellement ex&eacute;cuter des commandes arbitraires sur votre syst&egrave;me avec
    les droits de l'utilisateur du serveur web, et peuvent par cons&eacute;quent &ecirc;tre
    extr&egrave;mement dangereux s'ils ne sont pas v&eacute;rifi&eacute;s avec soin.</p>

    <p>Tous les scripts CGI s'ex&eacute;cutent sous le m&ecirc;me utilisateur, il peuvent
    donc entrer en conflit (accidentellement ou d&eacute;lib&eacute;r&eacute;ment) avec d'autres
    scripts. Par exemple, l'utilisateur A hait l'utilisateur B, il &eacute;crit donc
    un script qui efface la base de donn&eacute;es CGI de l'utilisateur B. Vous pouvez
    utiliser le programme <a href="../suexec.html">suEXEC</a> pour faire en
    sorte que les scripts s'ex&eacute;cutent sous des utilisateurs diff&eacute;rents. Ce
    programme est inclus dans la distribution d'Apache depuis la version 1.2
    et est appel&eacute; &agrave; partir de certaines portions de code du serveur Apache. Une
    autre m&eacute;thode plus connue est l'utilisation de
    <a href="http://cgiwrap.sourceforge.net/">CGIWrap</a>.</p>

  </section>

  <section id="nsaliasedcgi">

    <title>CGI sans alias de script</title>

    <p>Vous ne devez permettre aux utilisateurs d'ex&eacute;cuter des scripts CGI
    depuis n'importe quel r&eacute;pertoire que dans l'&eacute;ventualit&eacute; o&ugrave; :</p>

    <ul>
      <li>Vous faites confiance &agrave; vos utilisateurs pour ne pas &eacute;crire de
      scripts qui vont d&eacute;lib&eacute;r&eacute;ment ou accidentellement exposer votre
      syst&egrave;me &agrave; une attaque.</li>
      <li>Vous estimez que le niveau de s&eacute;curit&eacute; dans les autres parties de
      votre site est si faible qu'un trou de s&eacute;curit&eacute; de plus ou de moins
      n'est pas tr&egrave;s important.</li>
      <li>Votre syst&egrave;me ne comporte aucun utilisateur, et personne ne visite
      jamais votre site.</li>
    </ul>

  </section>

  <section id="saliasedcgi">

    <title>CGI avec alias de script</title>

    <p>Le confinement des CGI dans des r&eacute;pertoires sp&eacute;cifiques permet &agrave;
    l'administrateur de contr&ocirc;ler ce que l'on met dans ces r&eacute;pertoires. Ceci
    est bien entendu mieux s&eacute;curis&eacute; que les CGI sans alias de script, mais
    seulement &agrave; condition que les utilisateurs avec les droits en &eacute;criture sur
    les r&eacute;pertoires soient dignes de confiance, et que l'administrateur ait la
    volont&eacute; de tester chaque programme ou script CGI &agrave; la recherche d'&eacute;ventuels
    trous de s&eacute;curit&eacute;.</p>

    <p>La plupart des sites choisissent cette approche au d&eacute;triment des CGI
    sans alias de script.</p>

  </section>

   <section id="dynamic">

  <title>Autres sources de contenu dynamique</title>

  <p>
  Les options de scripting int&eacute;gr&eacute;es qui s'ex&eacute;cutent en tant que partie du
  serveur lui-m&ecirc;me, comme <code>mod_php</code>, <code>mod_perl</code>,
  <code>mod_tcl</code>, et <code>mod_python</code>,
  s'ex&eacute;cutent sous le m&ecirc;me utilisateur que le serveur (voir la directive
  <directive module="mod_unixd">User</directive>), et par cons&eacute;quent,
  les scripts que ces moteurs ex&eacute;cutent peuvent acc&eacute;der aux m&ecirc;mes ressources
  que le serveur. Certains moteurs de scripting peuvent proposer des
  restrictions, mais pour plus de s&ucirc;ret&eacute;, il vaut mieux partir du principe
  que ce n'est pas le cas.</p>

  </section>

  <section id="systemsettings">

    <title>Protection de la configuration du syst&egrave;me</title>

    <p>Pour contr&ocirc;ler &eacute;troitement votre serveur, vous pouvez interdire
    l'utilisation des fichiers <code>.htaccess</code> qui permettent de
    passer outre les fonctionnalit&eacute;s de s&eacute;curit&eacute; que vous avez configur&eacute;es.
    Voici un moyen pour y parvenir :</p>

    <p>Ajoutez dans le fichier de configuration du serveur</p>

    <highlight language="config">
&lt;Directory "/"&gt;
    AllowOverride None
&lt;/Directory&gt;
    </highlight>

    <p>Ceci interdit l'utilisation des fichiers <code>.htaccess</code> dans
    tous les r&eacute;pertoires, sauf ceux pour lesquels c'est explicitement
    autoris&eacute;.</p>

    <p>Notez que c'est la configuration par d&eacute;faut depuis Apache 2.3.9.</p>

  </section>

  <section id="protectserverfiles">

    <title>Protection par d&eacute;faut des fichiers du serveur</title>

    <p>Le concept d'acc&egrave;s par d&eacute;faut est un aspect d'Apache qui est parfois mal
    compris. C'est &agrave; dire que, &agrave; moins que vous ne changiez explicitement ce
    comportement, si le serveur trouve son chemin vers un fichier en suivant
    les r&egrave;gles normales de correspondance URL - fichier, il peut le retourner
    aux clients.</p>

    <p>Consid&eacute;rons l'exemple suivant :</p>

    <example>
      # cd /; ln -s / public_html <br />
      puis acc&egrave;s &agrave; <code>http://localhost/~root/</code>
    </example>

    <p>Ceci permettrait aux clients de parcourir l'ensemble du syst&egrave;me de
    fichiers. Pour l'&eacute;viter, ajoutez le bloc suivant &agrave; la configuration
    de votre serveur :</p>

    <highlight language="config">
&lt;Directory "/"&gt;
    Require all denied
&lt;/Directory&gt;
    </highlight>

    <p>ceci va interdire l'acc&egrave;s par d&eacute;faut &agrave; tous les fichiers du syst&egrave;me de
    fichiers. Vous devrez ensuite ajouter les blocs
    <directive module="core">Directory</directive> appropri&eacute;s correspondant
    aux r&eacute;pertoires auxquels vous voulez autorisez l'acc&egrave;s. Par exemple,</p>

    <highlight language="config">
&lt;Directory "/usr/users/*/public_html"&gt;
    Require all granted
&lt;/Directory&gt;
&lt;Directory "/usr/local/httpd"&gt;
    Require all granted
&lt;/Directory&gt;
    </highlight>

    <p>Portez une attention particuli&egrave;re aux interactions entre les directives
    <directive module="core">Location</directive> et
    <directive module="core">Directory</directive> ; par exemple, si une
    directive <code>&lt;Directory ""/&gt;</code> interdit un acc&egrave;s, une
    directive <code>&lt;Location "/"&gt;</code> pourra passer outre.</p>

    <p>De m&ecirc;me, soyez m&eacute;fiant en jouant avec la directive
    <directive module="mod_userdir">UserDir</directive> ; la positionner &agrave;
    <code>"./"</code> aurait le m&ecirc;me effet, pour root, que le premier exemple plus haut.
    Nous vous conseillons
    fortement d'inclure la ligne suivante dans le fichier de configuration de
    votre serveur :</p>

    <highlight language="config">UserDir disabled root</highlight>

  </section>

  <section id="watchyourlogs">

    <title>Surveillez vos journaux</title>

    <p>Pour vous tenir inform&eacute; de ce qui se passe r&eacute;ellement dans votre
    serveur, vous devez consulter vos
    <a href="../logs.html">fichiers journaux</a>. M&ecirc;me si les fichiers journaux
    ne consignent que des &eacute;v&egrave;nements qui se sont d&eacute;j&agrave; produits, ils vous
    informeront sur la nature des attaques qui sont lanc&eacute;es contre le serveur
    et vous permettront de v&eacute;rifier si le niveau de s&eacute;curit&eacute; n&eacute;cessaire est
    atteint.</p>

    <p>Quelques exemples :</p>

    <example>
      grep -c "/jsp/source.jsp?/jsp/ /jsp/source.jsp??" access_log <br />
      grep "client denied" error_log | tail -n 10
    </example>

    <p>Le premier exemple listera les attaques essayant d'exploiter la
    <a href="http://online.securityfocus.com/bid/4876/info/">vuln&eacute;rabilit&eacute;
    d'Apache Tomcat pouvant provoquer la divulgation d'informations par des
    requ&ecirc;tes Source.JSP mal form&eacute;es</a>, le second donnera la liste des dix
    derni&egrave;res interdictions client ; par exemple :</p>

    <example>
      [Thu Jul 11 17:18:39 2002] [error] [client foo.example.com] client denied
      by server configuration: /usr/local/apache/htdocs/.htpasswd
    </example>

    <p>Comme vous le voyez, les fichiers journaux ne consignent que ce qui
    s'est d&eacute;j&agrave; produit ; ainsi, si le client a pu acc&eacute;der au fichier
    <code>.htpasswd</code>, vous devriez avoir quelque chose du style :</p>

    <example>
      foo.example.com - - [12/Jul/2002:01:59:13 +0200] "GET /.htpasswd HTTP/1.1"
    </example>

    <p>dans votre <a href="../logs.html#accesslog">journal des acc&egrave;s</a> ; ce
    qui signifie que vous avez probablement mis en commentaire ce qui suit dans
    le fichier de configuration de votre serveur :</p>

    <highlight language="config">
&lt;Files ".ht*"&gt;
    Require all denied
&lt;/Files&gt;
    </highlight>

  </section>
  <section id="merging">

    <title>Fusion des sections de configuration</title>

    <p>La fusion des sections de configuration est complexe et d&eacute;pend
    souvent des directives utilis&eacute;es. Vous devez syst&eacute;matiquement tester
    vos modifications pour v&eacute;rifier la mani&egrave;re dont les directives sont
    fusionn&eacute;es.</p>

    <p>Concernant les modules qui n'impl&eacute;mentent aucune logique de
    fusion, comme <directive>mod_access_compat</directive>, le
    comportement des sections suivantes est tributaire de la pr&eacute;sence
    dans ces derni&egrave;res de directives appartenant &agrave; ces modules. La
    configuration est h&eacute;rit&eacute;e jusqu'&agrave; ce qu'une modification soit
    effectu&eacute;e ; &agrave; ce moment, la configuration est <em>remplac&eacute;e</em> et
    non fusionn&eacute;e.</p>
  </section>

</manualpage>
