<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1174747 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="htcacheclean.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>htcacheclean - Nettoyage du cache sur disque</title>

<summary>
    <p><code>htcacheclean</code> permet de maintenir la taille de
    l'espace de stockage réservé à <module>mod_disk_cache</module> en
    dessous d'une limite de taille donnée ou d'inodes utilisés. Cet
    utilitaire peut s'exécuter
    soit manuellement, soit en mode démon. Lorsqu'il fonctionne en mode
    démon, il se met en attente en arrière-plan et recherche à
    intervalles réguliers dans le répertoire du cache les contenus à
    supprimer. Pour arrêter proprement le démon, vous pouvez lui envoyer
    un signal TERM ou INT. Lorsqu'il est lancé manuellement, une
    recherche des contenus du cache qui peuvent être supprimés est
    effectuée une seule fois. Si une ou plusieurs URLs sont spécifiées,
    chacune d'entre elles sera supprimée du cache, si elle est présente.</p>
</summary>
<seealso><module>mod_disk_cache</module></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>htcacheclean</strong>
    [ -<strong>D</strong> ]
    [ -<strong>v</strong> ]
    [ -<strong>t</strong> ]
    [ -<strong>r</strong> ]
    [ -<strong>n</strong> ]
    [ -<strong>R</strong><var>arrondi</var> ]
    -<strong>p</strong><var>chemin</var>
    [-<strong>l</strong><var>limite</var>|
    -<strong>L</strong><var>limite</var>]</code></p>

    <p><code><strong>htcacheclean</strong>
    [ -<strong>n</strong> ]
    [ -<strong>t</strong> ]
    [ -<strong>i</strong> ]
    [ -<strong>P</strong><var>fichier-pid</var> ]
    [ -<strong>R</strong><var>arrondi</var> ]
    -<strong>d</strong><var>intervalle</var>
    -<strong>p</strong><var>chemin</var>
    [-<strong>l</strong><var>limite</var>|
    -<strong>L</strong><var>limite</var>]</code></p>

    <p><code><strong>htcacheclean</strong>
    [ -<strong>v</strong> ]
    [ -<strong>R</strong><var>arrondi</var> ]
    -<strong>p</strong><var>chemin</var>
    [ -<strong>a</strong> ]
    [ -<strong>A</strong> ]</code></p>

    <p><code><strong>htcacheclean</strong>
    [ -<strong>D</strong> ]
    [ -<strong>v</strong> ]
    [ -<strong>t</strong> ]
    [ -<strong>R</strong><var>arrondi</var> ]
    -<strong>p</strong><var>chemin</var>
    <var>url</var></code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code>-d<var>intervalle</var></code></dt>
    <dd>Configure en mode démon et planifie le nettoyage du cache toutes
    les <var>intervalle</var> minutes. Cette option et les options
    <code>-D</code>, <code>-v</code> et <code>-r</code> s'excluent
    mutuellement. Pour arrêter le démon proprement, il suffit de lui
    envoyer un signal <code>SIGTERM</code> ou <code>SIGINT</code>.</dd>

    <dt><code>-D</code></dt>
    <dd>Le programme s'exécute mais ne supprime aucun contenu ("dry run"). Cette
    option et l'option <code>-d</code> s'excluent mutuellement. Si ce mode
    est combiné avec la suppression des répertoires avec
    <code>-t</code>, les inodes signalés comme supprimés dans les
    statistiques ne peuvent pas prendre en compte les répertoires
    supprimés, et seront marqués en tant qu'estimation.</dd>

    <dt><code>-v</code></dt>
    <dd>Exécution verbeuse et affichage de statistiques. Cette
    option et l'option <code>-d</code> s'excluent mutuellement.</dd>

    <dt><code>-r</code></dt>
    <dd>Nettoyage en profondeur. Le serveur web Apache doit être arrêté
    (dans le cas contraire, il risque de rester des déchets dans le
    cache). Cette option implique l'option <code>-t</code> et s'exclue
    mutuellement avec l'option <code>-d</code>.</dd>

    <dt><code>-n</code></dt>
    <dd>Exécution en retrait. L'exécution du programme est ralentie en
    faveur des autres processus. <code>htcacheclean</code> s'interrompt
    de temps en temps de façon à ce que a) les entrées/sorties disque
    soient retardées et b) que le noyau puisse mettre ce temps
    processeur à disposition des autres processus.</dd>

    <dt><code>-t</code></dt>
    <dd>Supprime tous les répertoires vides. Par défaut, seuls les
    fichiers sont supprimés du cache ; avec certaines configurations,
    cependant, un grand nombre de répertoires sont créés et méritent que
    l'on y prête attention. Si votre configuration nécessite un grand
    nombre de répertoires, au point que le remplissage de la table
    d'inodes ou d'allocation de fichiers puisse poser problème,
    l'utilisation de cette option est conseillée.</dd>

    <dt><code>-p<var>chemin</var></code></dt>
    <dd>Définit <var>chemin</var> comme répertoire racine du cache sur
    disque. Cette valeur doit correspondre à celle spécifiée par la
    directive <directive
    module="mod_disk_cache">CacheRoot</directive>.</dd>

    <dt><code>-P<var>fichier-pid</var></code></dt>
    <dd>Permet de spécifier <var>fichier-pid</var> comme nom du fichier
    dans le lequel sera enregistré l'identifiant du processus en mode
    démon.</dd>

    <dt><code>-R<var>round</var></code></dt>
    <dd>Permet de spécifier le plus petit commun multiple de la taille
    du cache, afin de tenir compte de la taille des blocs. Définir ce
    paramètre à la taille d'un bloc de la partition du cache.</dd>

    <dt><code>-l<var>limite</var></code></dt>
    <dd>Définit <var>limite</var> comme la taille maximale du cache sur
    disque. La valeur s'exprime par défaut en octets (ou en ajoutant le
    suffixe <code>B</code> à la valeur). Ajoutez le suffixe
    <code>K</code> pour KOctets ou <code>M</code> pour MOctets.</dd>

    <dt><code>-L<var>limite</var></code></dt>
    <dd>Spécifie <var>limite</var> comme la limite totale en inodes du
    cache disque.</dd>

    <dt><code>-i</code></dt>
    <dd>Exécution intelligente. Le programme ne s'exécute que lorsque le
    cache sur disque a été modifié. Cette option ne peut s'utiliser
    qu'avec l'option <code>-d</code>.</dd>

    <dt><code>-a</code></dt>
    <dd>Affiche la liste des URLs actuellement stockées dans le cache.
    Les variantes de la même URL seront listées une seule fois par
    variante.</dd>

    <dt><code>-A</code></dt>
    <dd>Affiche la liste des URLs actuellement stockées dans le cache,
    ainsi que leurs attributs dans l'ordre suivant : url, header size,
    body size, status, entity version, date, expiry, request time,
    response time, body present, head request.</dd>
    </dl>
</section>

<section id="delete"><title>Suppression d'une URL particulière</title>
    <p>Si une ou plusieurs URLs sont passées en argument à
    <code>htcacheclean</code>, chacune d'entre elles sera supprimée du
    cache. S'il existe plusieurs variantes de ces URLs, elles seront
    toutes supprimées.</p>

    <p>Lorsqu'une URL mandatée en inverse doit être supprimée, l'URL
    effective est construite à partir de l'en-tête
    <strong>Host</strong>, du <strong>port</strong>, du
    <strong>chemin</strong> et de la <strong>requête</strong>. Notez que
    le '?' doit toujours être spécifié explicitement dans l'URL, qu'une
    chaîne de paramètres soit présente ou non. Par exemple, pour
    supprimer le chemin <strong>/</strong> du serveur
    <strong>localhost</strong>, l'URL devra être spécifiée comme suit :
    <strong>http://localhost:80/?</strong>.</p>

</section>

<section id="list"><title>Affichage des URLs présentes dans le cache</title>
    <p>Les options <code>-a</code> ou <code>-A</code> permettent
    d'afficher les URLs présentes dans le cache telles qu'elles s'y
    trouvent, une URL par ligne. L'option <code>-A</code> affiche
    l'entrée du cache complète pour chaque URL, avec ses différents
    champs dans l'ordre suivant :</p>

    <dl>
        <dt>url</dt><dd>L'URL de l'entrée considérée.</dd>
        <dt>header size</dt><dd>La taille de l'en-tête en octets.</dd>
        <dt>body size</dt><dd>La taille du corps en octets.</dd>
        <dt>status</dt><dd>Etat de la réponse en cache.</dd>
        <dt>entity version</dt><dd>Le nombre de fois que cette entrée a
	été revalidée sans être effacée.</dd>
        <dt>date</dt><dd>Date de la réponse.</dd>
        <dt>expiry</dt><dd>Date d'expiration de la réponse.</dd>
        <dt>request time</dt><dd>Date du début de la requête.</dd>
        <dt>response time</dt><dd>Date de la fin de la requête.</dd>
        <dt>body present</dt><dd>Ce champ contient la valeur 0 si aucun
	corps n'est stocké avec cette requête, 1 dans le cas contraire.</dd>
        <dt>head request</dt><dd>Ce champ contient la valeur 1 si
	l'entrée comporte une requête HEAD en cache sans corps, 0 dans
	le cas contraire.</dd>
    </dl>

</section>

<section id="exit"><title>Valeur renvoyée</title>
    <p><code>htcacheclean</code> renvoie zéro ("true") si toutes les
    opérations se sont déroulées normalement, et <code>1</code> dans le
    cas contraire. Si une URL est spécifiée, et si cette URL était
    présente dans le cache et a été supprimée avec succès,
    <code>htcacheclean</code> renvoie <code>0</code>, et <code>2</code>
    dans le cas contraire. Si une erreur est survenue au cours de la
    suppression de l'URL, <code>htcacheclean</code> renvoie
    <code>1</code>.</p>
</section>

</manualpage>
