<?xml version='1.0' encoding='UTF-8' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1676925 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="ab.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>ab - L'outil de test des performances du serveur HTTP
Apache</title>

<summary>
    <p><code>ab</code> est un utilitaire qui vous permet de tester les
    performances de votre serveur HTTP Apache. Il a été conçu pour vous
    donner une idée du degré de performances de votre installation
    d'Apache. Il vous permet en particulier de déterminer le nombre de
    réquêtes que votre installation d'Apache est capable de servir par
    seconde.</p>
</summary>
<seealso><program>httpd</program></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>ab</strong>
    [ -<strong>A</strong> <var>nom-utilisateur</var>:<var>mot-de-passe</var> ]
    [ -<strong>b</strong> <var>taille-tampon</var> ]
    [ -<strong>B</strong> <var>adresse-locale</var> ]
    [ -<strong>c</strong> <var>simultanéité</var> ]
    [ -<strong>C</strong> <var>nom-cookie</var>=<var>valeur</var> ]
    [ -<strong>d</strong> ]
    [ -<strong>e</strong> <var>fichier-csv</var> ]
    [ -<strong>f</strong> <var>protocole</var> ]
    [ -<strong>g</strong> <var>fichier-gnuplot</var> ]
    [ -<strong>h</strong> ]
    [ -<strong>H</strong> <var>en-tête-personnalisé</var> ]
    [ -<strong>i</strong> ]
    [ -<strong>k</strong> ]
    [ -<strong>l</strong> ]
    [ -<strong>m</strong> <var>HTTP-method</var> ]
    [ -<strong>n</strong> <var>requêtes</var> ]
    [ -<strong>p</strong> <var>fichier-POST</var> ]
    [ -<strong>P</strong>
    <var>nom-utilisateur-mandataire</var>:<var>mot-de-passe</var> ]
    [ -<strong>q</strong> ]
    [ -<strong>r</strong> ]
    [ -<strong>s</strong> <var>timeout</var> ]
    [ -<strong>S</strong> ]
    [ -<strong>t</strong> <var>limite-de-durée</var> ]
    [ -<strong>T</strong> <var>type-de-contenu</var> ]
    [ -<strong>u</strong> <var>fichier PUT</var> ]
    [ -<strong>v</strong> <var>verbosité</var>]
    [ -<strong>V</strong> ]
    [ -<strong>w</strong> ]
    [ -<strong>x</strong> <var>&lt;table&gt;-attributs</var> ]
    [ -<strong>X</strong> <var>mandataire</var>[:<var>port</var>] ]
    [ -<strong>y</strong> <var>&lt;tr&gt;-attributs</var> ]
    [ -<strong>z</strong> <var>&lt;td&gt;-attributs</var> ]
    [ -<strong>Z</strong> <var>algorithme-chiffrement</var> ]
    [http[s]://]<var>nom-serveur</var>[:<var>port</var>]/<var>chemin</var></code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code>-A <var>nom-utilisateur</var>:<var>mot-de-passe</var></code></dt>
    <dd>Fournit le support d'une authentification de base vers le
    serveur. Les nom-utilisateur et mot-de-passe sont séparés par un
    seul caractère <code>:</code> et transmis sous forme codée base64.
    La chaîne est envoyée que le serveur en ait besoin ou non (qu'il ait
    renvoyé un code "401 authentication needed" ou non).</dd>

    <dt><code>-b <var>taille-tampon</var></code></dt>
    <dd>Taille du tampon d'émission/réception TCP, en octets.</dd>

    <dt><code>-B <var>adresse-locale</var></code></dt>
    <dd>Adresse à laquelle se rattacher lors des connexions sortantes.</dd>

    <dt><code>-c <var>simultanéité</var></code></dt>
    <dd>Nombre de requêtes à effectuer simultanément. Par défaut, une
    seule requête est effectuée à la fois.</dd>

    <dt><code>-C <var>nom-cookie</var>=<var>valeur</var></code></dt>
    <dd>Ajoute une ligne <code>Cookie:</code> à la requête. L'argument
    se présente en général sous la forme d'une
    paire <code><var>nom</var>=<var>valeur</var></code>. Ce champ peut
    être répété.</dd>

    <dt><code>-d</code></dt>
    <!-- traduction à confirmer -->
    <dd>N'affiche pas le "pourcentage servi dans la table XX [ms]".
    (support de l'héritage).</dd>

    <dt><code>-e <var>fichier-csv</var></code></dt>
    <dd>Enregistre des valeurs séparées par des virgules (CSV) dans un
    fichier, indiquant pour chaque pourcentage (de 1% à 100 %), le temps
    (en millisecondes) mis pour servir ce pourcentage de requêtes. Ce
    fichier est en général plus utile qu'un fichier 'gnuplot', car les
    résultats sont déjà sous forme binaire.</dd>

    <dt><code>-f <var>protocole</var></code></dt>
    <dd>Spécifie le protocole SSL/TLS (SSL2, SSL3, TLS1, TLS1.1, TLS1.2, or ALL).
    TLS1.1 et TLS1.2 sont supportés à partir de la version 2.4.4 du
    serveur HTTP Apache.</dd>

    <dt><code>-g <var>fichier-gnuplot</var></code></dt>
    <dd>Enregistre toutes les valeurs mesurées dans un fichier 'gnuplot'
    ou TSV (valeurs séparées par des tabulations). Ce fichier peut être
    facilement importé dans des programmes comme Gnuplot, IDL,
    Mathematica, Igor ou même Excel. La première ligne du fichier
    contient les noms des valeurs.</dd>

    <dt><code>-h</code></dt>
    <dd>Affiche une aide à propos de l'utilisation du programme.</dd>

    <dt><code>-H <var>en-tête-personnalisé</var></code></dt>
    <dd>Ajoute des en-têtes supplémentaires à la requête. L'argument se
    présente sous la forme d'une ligne d'en-tête valide, autrement dit
    une paire champ/valeur séparés par un caractère ':' (par exemple
    <code>"Accept-Encoding: zip/zop;8bit"</code>).</dd>

    <dt><code>-i</code></dt>
    <dd>Effectue des requêtes <code>HEAD</code> plutôt que
    <code>GET</code>.</dd>

    <dt><code>-k</code></dt>
    <dd>Active la fonctionnalité des connexions HTTP persistantes
    (KeepAlive), c'est à dire effectue plusieurs requêtes au cours d'une
    seule session HTTP. Cette fonctionnalité est désactivée par
    défaut.</dd>

    <dt><code>-l</code></dt>
    <dd>Ne signale pas les erreurs si la taille de la réponse n'est pas
    constante. Cette option peut s'avérer utile pour les pages
    dynamiques. Disponible à partir de la version 2.4.7 du serveur HTTP
    Apache.
    </dd>

    <dt><code>-m <var>HTTP-method</var></code></dt>
    <dd>Méthode HTTP personnalisée à utiliser pour les requêtes.
    Disponible à partir de la version 2.4.10 du serveur HTTP
    Apache.</dd>

    <dt><code>-n <var>requêtes</var></code></dt>
    <dd>Nombre de requêtes à effectuer au cours du test de performances.
    Par défaut, une seule requête est effectuée, ce qui ne permet pas
    d'obtenir des résultats représentatifs.</dd>

    <dt><code>-p <var>fichier-POST</var></code></dt>
    <dd>Fichier contenant les données pour les requêtes POST.
    Assurez-vous de spécifier aussi le paramètre <code>-T</code>.</dd>

    <dt><code>-P <var>nom-utilisateur-mandataire</var>:<var>mot-de-passe</var></code></dt>
    <dd>Fournit les informations d'authentification basique pour un
    mandataire en-route. Les nom d'utilisateur et mot de passe sont
    séparés par un simple caractère <code>:</code> et envoyés sur le
    réseau codés en base64. La chaîne est envoyée, que le mandataire en
    ait besoin ou non (qu'il ait renvoyé un code "407 proxy
    authentication needed" ou non).</dd>

    <dt><code>-q</code></dt>
    <dd>Lorsque plus de 150 requêtes sont traitées, <code>ab</code>
    affiche la progression du traitement sur <code>stderr</code> tous
    les 10% du nombre total ou toutes les 100 requêtes. Le drapeau
    <code>-q</code> permet de supprimer ces messages.</dd>

    <dt><code>-r</code></dt>
    <dd>Ne s'arrête pas en cas d'erreur de réception du socket.</dd>

    <dt><code>-s <var>timeout</var></code></dt>
    <dd>Temps maximum d'attente en secondes du socket avant de considérer
    le délai comme dépassé. La valeur par défaut est de 30 secondes.
    Disponible à partir de la version 2.4.4 du serveur HTTP
    Apache.</dd>

    <dt><code>-S</code></dt>
    <dd>N'affiche ni les valeurs de déviation standards et médianes, ni
    les messages d'erreur et d'avertissement lorsque les valeurs
    médianes et moyennes sont égales à une ou deux fois la valeur de
    déviation standard. Par défaut les valeurs mini/moyenne/maxi sont
    affichées (support de l'héritage).</dd>
    <!-- dernière phrase à confirmer -->

    <dt><code>-t <var>limite-durée</var></code></dt>
    <dd>Durée maximale en secondes du test de performances. Ceci
    implique un <code>-n 50000</code> en interne. Utilisez cette option
    si vous souhaitez tester les performances du serveur pendant une
    durée fixée à l'avance. Par défaut, il n'y a pas de limite de
    durée.</dd>

    <dt><code>-T <var>type-contenu</var></code></dt>
    <dd>Valeur de l'en-tête Content-type à utiliser pour les données
    POST/PUT, par exemple
    <code>application/x-www-form-urlencoded</code>.
    La valeur par défaut est <code>text/plain</code>.</dd>

    <dt><code>-u <var>fichier PUT</var></code></dt>
    <dd>Fichier contenant des données PUT.  Ne pas oublier de spécifier
    aussi <code>-T</code>.</dd>

    <dt><code>-v <var>verbosité</var></code></dt>
    <dd>Définit le niveau de verbosité - les niveaux <code>4</code> et
    supérieurs permettent d'afficher des informations à propos des
    en-têtes, les niveaux <code>3</code> et supérieurs les codes de
    réponse (404, 200, etc...), et les niveaux <code>2</code> et
    supérieurs les messages d'avertissement et d'information.</dd>

    <dt><code>-V</code></dt>
    <dd>Affiche le numéro de version et s'arrête.</dd>

    <dt><code>-w</code></dt>
    <dd>Affiche les résultats dans des tables HTML. La table par défaut
    comporte deux colonnes sur fond blanc.</dd>

    <dt><code>-x <var>&lt;table&gt;-attributs</var></code></dt>
    <dd>La chaîne à utiliser comme attributs pour
    <code>&lt;table&gt;</code>. Les attributs sont insérés
    <code>&lt;table <var>ici</var> &gt;</code>.</dd>

    <dt><code>-X <var>mandataire</var>[:<var>port</var>]</code></dt>
    <dd>Utilise un serveur mandataire pour les requêtes.</dd>

    <dt><code>-y <var>&lt;tr&gt;-attributs</var></code></dt>
    <dd>La chaîne à utiliser comme attributs pour
    <code>&lt;tr&gt;</code>.</dd>

    <dt><code>-z <var>&lt;td&gt;-attributs</var></code></dt>
    <dd>La chaîne à utiliser comme attributs pour
    <code>&lt;td&gt;</code>.</dd>

    <dt><code>-Z <var>algorithme-chiffrement</var></code></dt>
    <dd>Spécifie l'algorithme de chiffrement SSL/TLS (Voir les
    algorithme de chiffrement openssl).</dd>
    </dl>
</section>

<section id="output"><title>Sortie</title>
    <p>Vous touverez dans ce qui suit la liste des valeurs retournées
    par <code>ab</code> :
    </p>

    <dl>
        <dt>Server Software</dt>
        <dd>La valeur, si elle existe, de l'en-tête HTTP
	<var>server</var> renvoyée dans la première réponse réussie.
	Elle comporte tous les caractères de l'en-tête jusqu'à ce qu'un
	caractère de valeur décimale 32 soit rencontré (le plus souvent
	un espace ou une fin de ligne).</dd>

        <dt>Server Hostname</dt>
        <dd>Le nom DNS ou l'adresse IP fourni dans la ligne de commande.</dd>

        <dt>Server Port</dt>
        <dd>Le port auquel ab est connecté. Si la ligne de commande ne
	spécifie aucun port, le port par défaut sera 80 pour http et 443
	pour https.</dd>

        <dt>SSL/TLS Protocol</dt>
        <dd>Les paramètres de protocole négociés entre le client et le
	serveur. Uniquement si SSL est utilisé.</dd>

        <dt>Document Path</dt>
        <dd>L'URI de la requête interprété à partir de la chaîne de la
	ligne de commande.</dd>

        <dt>Document Length</dt>
        <dd>Il s'agit de la taille en octets du premier document renvoyé
	avec succès. Si la taille du document est modifiée au cours
	du test, la réponse est considérée comme une erreur.</dd>

        <dt>Concurrency Level</dt>
        <dd>Le nombre de clients simultanés utilisés au cours du test.</dd>

        <dt>Time taken for tests</dt>
        <dd>Il s'agit du temps écoulé entre le moment de la première
	connexion au socket et la réception de la dernière
	réponse.</dd>

        <dt>Complete requests</dt>
        <dd>Le nombre de réponses reçues avec succès.</dd>

        <dt>Failed requests</dt>
        <dd>Le nombre de requêtes considérées comme erronées. Si ce
	nombre est différent de 0, une ligne supplémentaire indiquera le
	nombre de requêtes ayant échoué suite à un problème de
	connexion, de lecture, de taille de contenu erronée ou
	d'exceptions.</dd>

        <dt>Write errors</dt>
        <dd>Le nombre d'erreurs rencontrées en cours d'écriture (broken pipe).</dd>

        <dt>Non-2xx responses</dt>
        <dd>Le nombre de réponses dont le code était en dehors de la
	série 200. Si toutes les réponses appartiennent à la série 200,
	cette ligne est absente.</dd>

        <dt>Keep-Alive requests</dt>
        <dd>Le nombre de connexions promues à l'état de connexions
	persistantes.</dd>

        <dt>Total body sent</dt>
        <dd>Si le test a été configuré dans ce sens, il s'agit du nombre
	total d'octets envoyés au cours du test. Ce champ est omis si le
	test ne prévoyait pas d'envoi de corps.</dd>

        <dt>Total transferred</dt>
        <dd>Le nombre total d'octets reçus du serveur. Ce nombre
	correspond à peu près au nombre d'octets envoyés sur la ligne.</dd>

        <dt>HTML transferred</dt>
        <dd>Le nombre total d'octets utiles (contenus) reçus du serveur.
	Ce nombre n'inclut pas les octets correspondant aux en-têtes
	HTTP.</dd>

        <dt>Requests per second</dt>
        <dd>Il s'agit du nombre de requêtes par seconde. Il correspond
	au nombre de requêtes divisé par la durée totale du traitement.</dd>

        <dt>Time per request</dt>
        <dd>La durée moyenne du traitement d'une requête. La première
	valeur est calculée selon la formule <code>concurrency *
	timetaken * 1000 / done</code>, alors que la seconde valeur est
	calculée selon la formule <code>timetaken * 1000 / done</code>.</dd>

        <dt>Transfer rate</dt>
        <dd>Le taux de transfert calculé selon la formule
	<code>totalread / 1024 / timetaken</code>.</dd>
    </dl>
</section>

<section id="bugs"><title>Bogues</title>
    <p>De nombreux tampons de taille fixe sont déclarés statiquement.
    Combiné avec l'interprétation poussive des arguments de la ligne de
    commande, les en-têtes de réponse du serveur et autres entrées
    externes, ceci peut vous affecter.</p>

    <p>HTTP/1.x n'est pas complètement implémenté ; seules certaines
    formes de réponses 'attendues' sont acceptées. L'utilisation
    relativement intense de <code>strstr(3)</code> provoque un affichage
    en tête de profil, ce qui peut faire croire à un problème de
    performances ; en d'autres termes, vous mesurez les performances de
    <code>ab</code> plutôt que celles du serveur.</p>
</section>

</manualpage>
