<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1422580 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_slotmem_shm.xml.meta">

<name>mod_slotmem_shm</name>
<description>Fournisseur de m&eacute;moire partag&eacute;e bas&eacute;e sur les
slots.</description>
<status>Extension</status>
<sourcefile>mod_slotmem_shm.c</sourcefile>
<identifier>slotmem_shm_module</identifier>

<summary>
    <p><code>mod_slotmem_shm</code> est un fournisseur de m&eacute;moire qui
    permet la cr&eacute;ation et l'acc&egrave;s &agrave; un segment de m&eacute;moire partag&eacute;e dans
    lequel les ensembles de donn&eacute;es sont organis&eacute;s en "slots".
    </p>

    <p>L'ensemble de la m&eacute;moire partag&eacute;e est effac&eacute; &agrave; chaque
    red&eacute;marrage, que ce dernier soit <code>graceful</code> ou non. Les donn&eacute;es sont
    stock&eacute;es et restitu&eacute;es dans et &agrave; partir d'un fichier d&eacute;fini par le
    param&egrave;tre <code>name</code> des appels <code>create</code> et
    <code>attach</code>. Si son chemin absolu n'est pas sp&eacute;cifi&eacute;, le
    chemin du fichier sera relatif au chemin d&eacute;fini par la directive
    <directive module="core">DefaultRuntimeDir</directive>.
    </p>

    <p><code>mod_slotmem_shm</code> fournit les fonctions d'API suivantes
    :
    </p>

    <dl>
      <dt>apr_status_t doall(ap_slotmem_instance_t *s, ap_slotmem_callback_fn_t *func, void *data, apr_pool_t *pool)</dt>
      <dd>appelle le callback pour tous les slots actifs</dd>

      <dt>apr_status_t create(ap_slotmem_instance_t **new, const char *name, apr_size_t item_size, unsigned int item_num, ap_slotmem_type_t type, apr_pool_t *pool)</dt>
      <dd>cr&eacute;e un nouveau slot de m&eacute;moire dont chaque taille d'objet est
      item_size. <code>name</code> est utilis&eacute; pour g&eacute;n&eacute;rer le nom du fichier
      permettant de stocker/restaurer le contenu de la m&eacute;moire partag&eacute;e
      si la configuration le sp&eacute;cifie. Les valeurs possibles sont :
      <dl>
         <dt><code>"none"</code></dt>
         <dd><code>M&eacute;moire partag&eacute;e anonyme et pas de stockage
	 persistant</code></dd>
         <dt><code>"file-name"</code></dt>
         <dd><code>[DefaultRuntimeDir]/file-name</code></dd>
         <dd><code>Absolute file name</code></dd>
         <dd><code>$absolute-file-name</code></dd>
       </dl>
      </dd>

      <dt>apr_status_t attach(ap_slotmem_instance_t **new, const char *name, apr_size_t *item_size, unsigned int *item_num, apr_pool_t *pool)</dt>
      <dd>attache &agrave; un slot de m&eacute;moire existant. Voir
      <code>create</code> pour la description du param&egrave;tre
      <code>name</code>.</dd>

      <dt>apr_status_t dptr(ap_slotmem_instance_t *s, unsigned int item_id, void**mem)</dt>
      <dd>obtient la m&eacute;moire associ&eacute;e &agrave; ce slot actif.</dd>

      <dt>apr_status_t get(ap_slotmem_instance_t *s, unsigned int item_id, unsigned char *dest, apr_size_t dest_len)</dt>
      <dd>lit la m&eacute;moire depuis ce slot et la transf&egrave;re vers dest</dd>

      <dt>apr_status_t put(ap_slotmem_instance_t *slot, unsigned int item_id, unsigned char *src, apr_size_t src_len)</dt>
      <dd>&eacute;crit dans ce slot la m&eacute;moire en provenance de src</dd>

      <dt>unsigned int num_slots(ap_slotmem_instance_t *s)</dt>
      <dd>renvoie le nombre total de slots contenus dans ce segment</dd>

      <dt>apr_size_t slot_size(ap_slotmem_instance_t *s)</dt>
      <dd>renvoie la taille totale des donn&eacute;es, en octets, contenues
      dans un slot de ce segment</dd>

      <dt>apr_status_t grab(ap_slotmem_instance_t *s, unsigned int *item_id);</dt>
      <dd>alloue ou s'approprie le premier slot disponible et le marque comme utilis&eacute; (n'effectue aucune
      copie de donn&eacute;es)</dd>

      <dt>apr_status_t fgrab(ap_slotmem_instance_t *s, unsigned int item_id);</dt>
      <dd>force l'allocation ou l'attribution du slot sp&eacute;cifi&eacute; et le marque comme utilis&eacute; (n'effectue aucune
      copie de donn&eacute;es)</dd>

      <dt>apr_status_t release(ap_slotmem_instance_t *s, unsigned int item_id);</dt>
      <dd>lib&egrave;re un slot et le marque comme non utilis&eacute; (n'effectue aucune
      copie de donn&eacute;es)</dd>
    </dl>

</summary>

</modulesynopsis>
