<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1432445 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_imagemap.xml.meta">

<name>mod_imagemap</name>
<description>Traitement des cartes des zones interactives d'une image
(imagemaps) au niveau du serveur</description>
<status>Base</status>
<sourcefile>mod_imagemap.c</sourcefile>
<identifier>imagemap_module</identifier>

<summary>
    <p>Ce module traite les fichiers <code>.map</code>, et remplace
    ainsi la fonctionnalité du programme CGI <code>imagemap</code>. Tout
    répertoire ou type de document configuré pour utiliser le
    gestionnaire <code>imap-file</code> (à l'aide des directives
    <directive module="mod_mime">AddHandler</directive> ou <directive
    module="core">SetHandler</directive>), sera traité par ce
    module.</p>

    <p>La directive suivante confère aux fichiers possèdant l'extension
    <code>.map</code> le statut de fichiers imagemap :</p>

    <highlight language="config">AddHandler imap-file map</highlight>

    <p>Notez que la syntaxe suivante reste encore supportée :</p>

    <highlight language="config">AddType application/x-httpd-imap map</highlight>

    <p>Cependant, nous essayons d'abandonner progressivement les "types
    MIME magiques", et cette syntaxe est sur le point de devenir
    obsolète.</p>
</summary>

<section id="features"><title>Nouvelles fonctionnalités</title>

    <p>Le module imagemap propose quelques nouvelles fonctionnalités qui
    n'étaient pas disponibles avec les programmes imagemap précédemment
    distribués.</p>

    <ul>
      <li>Références d'URLs relatives à l'information contenue dans
      l'en-tête Referer: .</li>

      <li>Assignement <code>&lt;base&gt;</code> par défaut via la
      nouvelle directive <code>base</code>.</li>

      <li>Fichier <code>imagemap.conf</code> non requis.</li>

      <li>Références à des points.</li>

      <li>Génération configurable de menus d'images interactives.</li>
    </ul>
</section>

<section id="imapfile"><title>Fichier imagemap</title>

    <p>Les lignes d'un fichier imagemap peuvent se présenter sous
    plusieurs formats :</p>

    <example>
      directive valeur [<var>x</var>,<var>y</var> ...]<br />
      directive valeur "<var>Texte de menu</var>" [<var>x</var>,<var>y</var>
      ...]<br />
      directive valeur <var>x</var>,<var>y</var> ... "<var>Texte de menu</var>"
    </example>

    <p>Les directives sont <code>base</code>, <code>default</code>,
    <code>poly</code>, <code>circle</code>, <code>rect</code>, ou
    <code>point</code>. valeur est une URL absolue ou relative, ou une
    des valeurs spéciales énumérées ci-dessous. Les coordonnées sont des
    paires <code><var>x</var>,<var>y</var></code> séparées par des
    espaces. Le texte entre guillemets est le texte du lien si un menu
    imagemap est généré. Les lignes commençant par '#' sont des
    commentaires.</p>

    <section id="imapfile.directives"><title>Directives d'un fichier
    imagemap</title>
      <p>Les directives autorisées dans un fichier imagemap sont au
      nombre de six. Elles peuvent se trouver à n'importe quelle
      position dans le fichier, mais sont traitées dans l'ordre selon
      lequel elles sont enregistrées dans le fichier imagemap.</p>

      <dl>
      <dt>Directive <code>base</code></dt>

      <dd><p>Elle a le même effet que <code>&lt;base
      href="<var>valeur</var>"&gt;</code>. Les URLs non absolues du
      fichier imagemap sont considérées comme relatives à cette valeur.
      La directive <code>base</code> l'emporte sur une directive
      <directive module="mod_imagemap">ImapBase</directive> définie dans
      un fichier <code>.htaccess</code> ou dans le fichier de
      configuration du serveur. En l'absence de directive de
      configuration <directive>ImapBase</directive>, la valeur par
      défaut de <code>base</code> est
      <code>http://nom_serveur/</code>.</p>
      <p><code>base_uri</code> est un synonyme de <code>base</code>.
      Notez que la présence ou l'absence d'un slash de fin dans l'URL
      est importante.</p></dd>

      <dt>Directive <code>default</code></dt>

      <dd>La décision à prendre si les coordonnées fournies ne
      correspondent à aucune des directives <code>poly</code>,
      <code>circle</code>, ou <code>rect</code>, et si aucune directive
      <code>point</code> n'est présente. En l'absence de définition
      d'une directive de configuration <directive module="mod_imagemap"
      >ImapDefault</directive>, la valeur par défaut est
      <code>nocontent</code> et provoque l'envoi d'un code de statut
      <code>204 No Content</code>. Le client verra toujours la même
      page s'afficher.</dd>

      <dt>Directive <code>poly</code></dt>

      <dd>Accepte comme arguments trois à cent points, et est actionnée
      si les coordonnées sélectionnées par l'utilisateur tombent dans le
      polygone défini par ces points.</dd>

      <dt>Directive <code>circle</code></dt>

      <dd>Accepte comme arguments les coordonnées du centre d'un cercle
      et celles d'un point de ce cercle. Elle est actionnée si les
      coordonnées sélectionnées par l'utilisateur tombent dans ce
      cercle.</dd>

      <dt>Directive <code>rect</code></dt>

      <dd>Accepte comme arguments les coordonnées des sommets de deux
      angles opposés d'un rectangle. Elle est actionnée si les
      coordonnées sélectionnées par l'utilisateur tombent dans ce
      rectangle.</dd>

      <dt>Directive <code>point</code></dt>

      <dd>Elle n'accepte qu'un seul point comme argument. Si aucune
      autre directive ne correspond, c'est la directive
      dont le point spécifié est le plus près du point sélectionné par
      l'utilisateur qui est actionnée. Notez que la directive
      <code>default</code> ne sera pas suivie si une directive
      <code>point</code> est présente et si des coordonnées valides sont
      fournies.</dd>
      </dl>
    </section>

    <section id="imapfile.values"><title>Valeurs</title>

      <p>Les valeurs passées aux directives peuvent contenir :</p>

      <dl>
      <dt>une URL</dt>

      <dd><p>L'URL peut être absolue ou relative. Les URLs relatives
      peuvent contenir '..' et seront considérées comme relatives à la
      valeur de <code>base</code>.</p>
      <p><code>base</code> en lui-même, ne sera pas résolu en fonction
      de la valeur courante. Cependant, une directive <code>base
      mailto:</code> fonctionnera correctement.</p></dd>

      <dt><code>map</code></dt>

      <dd>Équivalent à l'URL du fichier imagemap lui-même. Aucune
      coordonnée n'est spécifiée, et un menu sera donc généré, à moins
      qu'une directive <directive
      module="mod_imagemap">ImapMenu</directive> n'ait été définie à
      <code>none</code>.</dd>

      <dt><code>menu</code></dt>
      <dd>Équivalent à <code>map</code>.</dd>

      <dt><code>referer</code></dt>

      <dd>Équivalent à l'URL du document référant. La valeur par défaut
      est <code>http://nom_serveur/</code> si aucun en-tête
      <code>Referer:</code> n'est présent.</dd>

      <dt><code>nocontent</code></dt>

      <dd>Envoie un code de statut <code>204 No Content</code>,
      indiquant au client qu'il doit continuer à afficher la même page.
      Valide pour toutes les directives, sauf <code>base</code>.</dd>

      <dt><code>error</code></dt>

      <dd>Envoie un code de statut d'échec <code>500 Server
      Error</code>. Valide pour toutes les directives, sauf
      <code>base</code>, mais n'a de sens qu'avec la directive
      <code>default</code>.</dd>
      </dl>
    </section>

    <section id="imapfile.coords"><title>Coordonnées</title>

      <dl>
      <dt><code>0,0 200,200</code></dt>

      <dd>Une coordonnée se compose de deux valeurs,  <var>x</var> et
      <var>y</var>, séparées par une virgule. Les coordonnées sont
      séparées entre elles par des espaces. Pour s'adapter à la manière
      dont Lynx traite les images interactives, la sélection par un
      utilisateur de la coordonnée <code>0,0</code> a le même effet que
      si aucune coordonnée n'a été sélectionnée.</dd>
      </dl>

    </section>

    <section id="imapfile.quotedtext"><title>Texte entre
    guillemets</title>

      <dl>
      <dt><code>"<var>Texte du menu</var>"</code></dt>

      <dd><p>Après la valeur ou les coordonnées, la ligne peut
      éventuellement contenir un texte entre guillemets. Cette chaîne
      constitue le texte du lien si un menu est généré :</p>

      <example>
        &lt;a href="http://example.com/"&gt;<var>Texte de
	menu</var>&lt;/a&gt;
      </example>

      <p>Si aucun texte entre guillemets n'est présent, le texte sera
      constitué du nom du lien :</p>

      <example>
        &lt;a href="http://example.com/"&gt;http://example.com&lt;/a&gt;
      </example>

      <p>Si vous voulez insérer des guillemets dans le texte, vous devez
      les inscrire sous la forme <code>&amp;quot;</code>.</p></dd>
      </dl>

    </section>
</section>

<section id="example"><title>Exemple de fichier imagemap</title>

    <example>
      #Les commentaires sont affichés dans un menu 'formaté' ou
      #'semi-formaté'.<br />
      #Et peuvent contenir des balises html. &lt;hr&gt;<br />
      base referer<br />
      poly map "Puis-je avoir un menu, s'il vous plait ?" 0,0 0,10 10,10 10,0<br />
      rect .. 0,0 77,27 "le répertoire du référant"<br />
      circle http://www.inetnebr.example.com/lincoln/feedback/ 195,0 305,27<br />
      rect autre_fichier "dans le même répertoire que le référant" 306,0 419,27<br />
      point http://www.zyzzyva.example.com/ 100,100<br />
      point http://www.tripod.example.com/ 200,200<br />
      rect mailto:nate@tripod.example.com 100,150 200,0 "Bogues?"<br />
    </example>

</section>

<section id="referencing"><title>Référencement de votre fichier
imagemap</title>

    <example><title>Exemple HTML</title>
      &lt;a href="/maps/imagemap1.map"&gt;<br />
      <indent>
        &lt;img ismap src="/images/imagemap1.gif"&gt;<br />
      </indent>
      &lt;/a&gt;
    </example>

    <example><title>Exemple XHTML</title>
      &lt;a href="/maps/imagemap1.map"&gt;<br />
      <indent>
        &lt;img ismap="ismap" src="/images/imagemap1.gif" /&gt;<br />
      </indent>
      &lt;/a&gt;
    </example>

</section>

<directivesynopsis>
<name>ImapMenu</name>
<description>Action à entreprendre si aucune coordonnée n'est fournie
lorsqu'on invoque un fichier imagemap</description>
<syntax>ImapMenu none|formatted|semiformatted|unformatted</syntax>
<default>ImapMenu formatted</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>

<usage>
    <p>La directive <directive>ImapMenu</directive> permet de spécifier
    l'action à entreprendre lorsqu'un fichier imagemap est invoqué sans
    coordonnées valides.</p>

    <dl>
      <dt><code>none</code></dt>
      <dd>Si l'argument d'ImapMenu est <code>none</code>, aucun menu
      n'est généré, et l'action <code>default</code> est effectuée.</dd>

      <dt><code>formatted</code></dt>
      <dd>Le menu <code>formatted</code> est le menu le plus simple. Les
      commentaires du fichier imagemap sont ignorés. Un en-tête de
      niveau un est affiché, puis un séparateur horizontal, puis chacun
      des liens sur une ligne séparée. L'aspect du menu est similaire à
      celui d'un listing de répertoire.</dd>

      <dt><code>semiformatted</code></dt>
      <dd>Dans le menu <code>semiformatted</code>, les commentaires sont
      affichés au moment où ils apparaissent dans le fichier imagemap.
      Les lignes vides sont interprètées comme des lignes de séparation
      HTML. Aucun en-tête ni séparateur horizontal n'est affiché. À part
      ces différences, le menu <code>semiformatted</code> est identique
      au menu <code>formatted</code>.</dd>

      <dt><code>unformatted</code></dt>
      <dd>Les commentaires sont affichés et les lignes vides sont
      ignorées. N'est affiché que ce qui apparait dans le fichier
      imagemap. Toutes les lignes de séparation HTML et les
      en-têtes doivent être inclus en tant que commentaires dans le
      fichier imagemap. Cela vous procure une grande souplesse pour
      définir l'apparence de vos menus, mais vous oblige à rédiger vos
      fichiers imagemap en HTML, et non en texte plat.</dd>
    </dl>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ImapDefault</name>
<description>Action à entreprendre par défaut lorsqu'un fichier imagemap
est invoqué avec des coordonnées qui ne correspondent à aucune
cible</description>
<syntax>ImapDefault error|nocontent|map|referer|<var>URL</var></syntax>
<default>ImapDefault nocontent</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>

<usage>
    <p>La directive <directive>ImapDefault</directive> permet de définir
    la valeur par défaut de la directive <code>default</code> utilisée
    dans les fichiers imagemap. Sa valeur est écrasée par la présence
    éventuelle d'une directive <code>default</code> dans le fichier
    imagemap. Si cette directive est absente, l'action associée à
    <code>default</code> est <code>nocontent</code>, ce qui implique
    l'envoi d'un code de statut <code>204 No Content</code> au client.
    Dans ce cas, le client doit continuer à afficher la même page.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ImapBase</name>
<description>Valeur par défaut de la directive <code>base</code> des
fichiers imagemap</description>
<syntax>ImapBase map|referer|<var>URL</var></syntax>
<default>ImapBase http://nom_serveur/</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>Indexes</override>

<usage>
    <p>La directive <directive>ImapBase</directive> permet de définir la
    valeur par défaut de la directive <code>base</code> des fichiers
    imagemap. Sa valeur est écrasée par la présence éventuelle d'une
    directive <code>base</code> dans le fichier imagemap. Si cette
    directive est absente, la valeur par défaut de la directive
    <code>base</code> est
    <code>http://<var>nom_serveur</var>/</code>.</p>
</usage>
<seealso><directive module="core">UseCanonicalName</directive></seealso>
</directivesynopsis>

</modulesynopsis>
