<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1673563 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2015053001 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_dav_fs.xml.meta">

<name>mod_dav_fs</name>
<description>Implémente le fournisseur filesystem pour
<module>mod_dav</module></description>
<status>Extension</status>
<sourcefile>mod_dav_fs.c</sourcefile>
<identifier>dav_fs_module</identifier>

<summary>
    <p>L'activation de ce module <em>nécessite</em> l'utilisation de
    <module>mod_dav</module>. C'est un module de support pour <module
    >mod_dav</module> et à ce titre, il permet l'accès à des ressources
    situées dans le système de fichiers du serveur. Le nom formel de ce
    fournisseur est <code>filesystem</code>. Les fournisseurs supports
    de <module>mod_dav</module> sont invoqués via la directive
    <directive module="mod_dav">Dav</directive> :</p>

    <example><title>Exemple</title>
    <highlight language="config">
      Dav filesystem
      </highlight>
    </example>

    <p>Comme <code>filesystem</code> est le fournisseur par défaut de
    <module>mod_dav</module>, vous pouvez vous contenter d'utiliser la
    valeur <code>On</code> comme argument de Dav.</p>
</summary>
<seealso><module>mod_dav</module></seealso>

<directivesynopsis>
<name>DavLockDB</name>
<description>Chemin de la base de données des verrous DAV</description>
<syntax>DavLockDB <var>chemin fichier</var></syntax>
<contextlist><context>server config</context><context>virtual
host</context>
</contextlist>

<usage>
    <p>La directive <directive>DavLockDB</directive> permet de spécifier
    le chemin complet de la base de données des verrous, sans extension.
    Si le chemin n'est pas absolu, il sera considéré comme relatif au
    répertoire défini par la directive <directive
    module="core">ServerRoot</directive>. L'implémentation de
    <module>mod_dav_fs</module> utilise une base de données SDBM pour
    surveiller les verrous utilisateurs.</p>

    <!-- XXX: someone should add that tool to the support directory...
    The utility <code>modules/dav/util/lockview</code> can be used from
    the server to display all locks in a lock database.</p> -->

    <example><title>Exemple</title>
    <highlight language="config">
      DavLockDB "var/DavLock"
      </highlight>
    </example>

    <p>Les utilisateur et groupe sous lesquels Apache s'exécute et qui
    sont respectivement définis par les directives <directive
    module="mod_unixd">User</directive> et <directive
    module="mod_unixd">Group</directive> doivent pouvoir écrire dans le
    répertoire qui contient le fichier de la base de données des
    verrous. Pour des raisons de sécurité, il est recommandé de créer un
    répertoire dédié à la base de données des verrous, plutôt que de
    modifier les permissions d'un répertoire existant. Dans l'exemple
    ci-dessus, Apache va créer des fichiers dans le répertoire
    <code>var/</code>, lui-même sous-répertoire du répertoire défini par
    la directive <directive
    module="core">ServerRoot</directive>, avec le nom de base
    <code>DavLock</code> suivi d'une extension choisie par le
    serveur.</p>

</usage>
</directivesynopsis>

</modulesynopsis>

