<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1780218 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authnz_ldap.xml.meta">

<name>mod_authnz_ldap</name>
<description>Permet d'utiliser un annuaire LDAP pour l'authentification
HTTP de base.</description>
<status>Extension</status>
<sourcefile>mod_authnz_ldap.c</sourcefile>
<identifier>authnz_ldap_module</identifier>
<compatibility>Dosponible depuis les versions 2.1 et supérieures
d'Apache</compatibility>

<summary>
    <p>Ce module permet aux frontaux d'authentification comme
    <module>mod_auth_basic</module> d'authentifier les utilisateurs via
    un annuaire ldap.</p>

    <p><module>mod_authnz_ldap</module> supporte les fonctionnalités
    suivantes :</p>

    <ul>
      <li>Support vérifié du <a
      href="http://www.openldap.org/">OpenLDAP SDK</a> (versions 1.x et
      2.x), du <a href="http://developer.novell.com/ndk/cldap.htm">
      Novell LDAP SDK</a> et du SDK <a
      href="http://www.iplanet.com/downloads/developer/">iPlanet
      (Netscape)</a>.</li>

      <li>Implémentation de politiques d'autorisation complexes en les
      définissant via des filtres LDAP.</li>

      <li>Mise en oeuvre d'une mise en cache des opérations LDAP
      élaborée via <a href="mod_ldap.html">mod_ldap</a>.</li>

      <li>Support de LDAP via SSL (nécessite le SDK Netscape) ou TLS
      (nécessite le SDK OpenLDAP 2.x ou le SDK LDAP Novell).</li>
    </ul>

    <p>Lorsqu'on utilise <module>mod_auth_basic</module>, ce module est
    invoqué en affectant la valeur <code>ldap</code> à la directive
    <directive module="mod_auth_basic">AuthBasicProvider</directive>.</p>
</summary>

<seealso><module>mod_ldap</module></seealso>
<seealso><module>mod_auth_basic</module></seealso>
<seealso><module>mod_authz_user</module></seealso>
<seealso><module>mod_authz_groupfile</module></seealso>

<section id="contents"><title>Sommaire</title>

    <ul>
    <li> <a href="#gcaveats">Mises en garde à caractère général</a> </li>
      <li> <a href="#operation">Mode opératoire</a>

        <ul>
          <li><a href="#authenphase">La phase
	  d'authentification</a></li>

          <li><a href="#authorphase">La phase d'autorisation</a></li>
        </ul>
      </li>

      <li>
        <a href="#requiredirectives">Les directives requises</a>

        <ul>
          <li><a href="#requser">Require ldap-user</a></li>
          <li><a href="#reqgroup">Require ldap-group</a></li>
          <li><a href="#reqdn">Require ldap-dn</a></li>
          <li><a href="#reqattribute">Require ldap-attribute</a></li>
          <li><a href="#reqfilter">Require ldap-filter</a></li>
        </ul>
      </li>

      <li><a href="#examples">Exemples</a></li>
      <li><a href="#usingtls">Utilisation de TLS</a></li>
      <li><a href="#usingssl">Utilisation de SSL</a></li>
      <li><a href="#exposed">Mise à disposition des informations de
      connexion</a></li>
      <li><a href="#activedirectory">Utilisation d'Active Directory</a></li>
      <li>
        <a href="#frontpage">Utilisation de Microsoft FrontPage avec
        <module>mod_authnz_ldap</module></a>

        <ul>
          <li><a href="#howitworks">Comment ça marche</a></li>
          <li><a href="#fpcaveats">Mises en garde</a></li>
        </ul>
      </li>
    </ul>
</section>

<section id="gcaveats"><title>Mises en garde à caractère général</title>
<p>Ce module effectue une mise en cache des résultats du processus
d'authentification et d'autorisation en fonction de la configuration du
module <module>mod_ldap</module>. Les modifications effectuées au niveau
du serveur LDAP d'arrière-plan comme les
verrouillages ou révocations d'utilisateurs, les changements de mot de
passe, ou les changements d'appartenance à un groupe (et cette liste
n'est pas exhaustive), ne seront pas immédiatement propagées jusqu'au
serveur HTTP. Consultez les directives du module
<module>mod_ldap</module> pour plus de détails à propos de la
configuration de la mise en cache.
</p>
</section>

<section id="operation"><title>Mode opératoire</title>

    <p>L'utilisateur se voit accorder l'accès selon un processus en deux
    phases. La première phase est l'authentification, au cours de
    laquelle le fournisseur d'authentification
    <module>mod_authnz_ldap</module> vérifie que les informations de
    connexion de l'utilisateur sont valides. Elle est aussi connue sous
    le nom de phase de <em>recherche/connexion</em> (NdT : en anglais ou
    dans le code source : <em>search/bind</em>). La deuxième
    phase est l'autorisation, au cours de laquelle
    <module>mod_authnz_ldap</module> détermine si l'utilisateur
    authentifié a la permission d'accéder à la ressource considérée.
    Elle est aussi connue sous le nom de phase de
    <em>comparaison</em> (<em>compare</em>).</p>

    <p><module>mod_authnz_ldap</module> comporte un fournisseur
    d'authentification authn_ldap et un gestionnaire d'autorisation
    authz_ldap. Le fournisseur d'authentification authn_ldap peut être
    invoqué en affectant la valeur <code>ldap</code> à la directive
    <directive module="mod_auth_basic">AuthBasicProvider</directive>. Le
    gestionnaire d'autorisation authz_ldap enrichit la liste des types
    d'autorisations de la directive <directive
    module="mod_authz_core">Require</directive> en y ajoutant les
    valeurs <code>ldap-user</code>, <code>ldap-dn</code> et
    <code>ldap-group</code>.</p>

<section id="authenphase"><title>La phase d'authentification</title>

    <p>Au cours de la phase d'authentification,
    <module>mod_authnz_ldap</module> recherche une entrée de l'annuaire
    LDAP qui correspond au nom d'utilisateur fourni par le client HTTP.
    Si une correspondance unique est trouvée,
    <module>mod_authnz_ldap</module> tente de se connecter au serveur
    hébergeant l'annuaire LDAP en utilisant le DN de l'entrée et le mot
    de passe fourni par le client HTTP. Comme ce processus effectue tout
    d'abord une recherche, puis une connexion, il est aussi connu sous
    le nom de phase de recherche/connexion. Voici le détail des étapes
    constituant la phase de recherche/connexion :</p>

    <ol>
      <li>Confection d'un filtre de recherche en combinant les attribut
      et filtre définis par la directive <directive module="mod_authnz_ldap"
      >AuthLDAPURL</directive> avec le nom d'utilisateur et le mot de
      passe fournis par le client HTTP.</li>

      <li>Recherche dans l'annuaire LDAP en utilisant le filtre
      confectionné précédemment. Si le résultat de la recherche est
      négatif ou comporte plusieurs entrées, refus ou restriction de
      l'accès.</li>

      <li>Extraction du DN (distinguished name) de l'entrée issue du
      résultat de la recherche, et tentative de connexion au serveur
      LDAP en utilisant ce DN et le mot de passe fournis par le client
      HTTP. Si la connexion échoue, refus ou restriction de
      l'accès.</li>
    </ol>

    <p>Les directives utilisées durant la phase de recherche/connexion
    sont les suivantes :</p>

    <table>
      <columnspec><column width=".3"/><column width=".7"/></columnspec>
      <tr>
        <td><directive
	module="mod_authnz_ldap">AuthLDAPURL</directive></td>

        <td>Spécifie le serveur LDAP, le DN de base, l'attribut à
	utiliser pour la recherche, ainsi que les filtres de recherche
	supplémentaires.</td>
      </tr>

      <tr>
        <td><directive
	module="mod_authnz_ldap">AuthLDAPBindDN</directive></td>

        <td>Un DN optionnel pour se connecter durant la phase de
	recherche.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPBindPassword</directive></td>

        <td>Un mot de passe optionnel pour se connecter durant la phase
	de recherche.</td>
      </tr>
    </table>
</section>

<section id="authorphase"><title>La phase d'autorisation</title>

    <p>Au cours de la phase d'autorisation,
    <module>mod_authnz_ldap</module> tente de déterminer si
    l'utilisateur est autorisé à accéder à la ressource considérée. Une
    grande partie de cette vérification consiste pour
    <module>mod_authnz_ldap</module> en des opérations de comparaison au
    niveau du serveur LDAP. C'est pourquoi cette phase est aussi connue
    sous le nom de phase de comparaison.
    <module>mod_authnz_ldap</module> accepte les directives <directive
    module="mod_authz_core">Require</directive> suivantes pour
    déterminer si les informations de connexion permettent d'accorder
    l'accès à l'utilisateur :</p>

    <ul>
      <li>Avec la directive <a
      href="#reqgroup"><code>Require ldap-user</code></a>,
      l'autorisation d'accès est accordée si le nom d'utilisateur
      spécifié par la directive correspond au nom d'utilisateur fourni
      par le client.</li>

      <li>Avec la directive <a href="#reqdn"><code>Require
      ldap-dn</code></a>, l'autorisation d'accès est accordée si le DN
      spécifié par la directive correspond au DN extrait du résultat de
      la recherche dans l'annuaire LDAP.</li>

      <li>Avec la directive <a
      href="#reqgroup"><code>Require ldap-group</code></a>,
      l'autorisation d'accès est accordée si le DN extrait du résultat de
      la recherche dans l'annuaire LDAP (ou le nom d'utilisateur fourni
      par le client) appartient au groupe LDAP spécifié par la
      directive, ou éventuellement à un de ses sous-groupes.</li>

      <li>Avec la directive <a href="#reqattribute">
      <code>Require ldap-attribute</code></a>, l'autorisation d'accès
      est accordée si la valeur de l'attribut extraite de la recherche
      dans l'annuaire LDAP correspond à la valeur spécifiée par la
      directive.</li>

      <li>Avec la directive <a href="#reqfilter">
      <code>Require ldap-filter</code></a>, l'autorisation d'accès
      est accordée si le filtre de recherche renvoie un objet
      utilisateur unique qui corresponde au DN de l'utilisateur
      authentifié.</li>

      <li>dans tous les autres cas, refus ou restriction de
      l'accès.</li>
    </ul>

    <p>Sous réserve du chargement de modules d'autorisation
    supplémentaires, d'autres valeurs de la directive <directive
    module="mod_authz_core">Require</directive> peuvent être
    spécifiées.</p>

    <ul>
        <li>L'accès est accordé à tous les utilisateurs authentifiés si
	une directive <a href="#requser"><code>Require
	valid-user</code></a> est présente (nécessite le module
	<module>mod_authz_user</module>).</li>

        <li>Avec la directive <a
        href="#reqgroup"><code>Require group</code></a>, l'autorisation
	d'accès est accordée si le module
	<module>mod_authz_groupfile</module> a été chargé et si la
	directive <directive
	module="mod_authz_groupfile">AuthGroupFile</directive> a été
	définie.</li>

        <li>etc...</li>
     </ul>


    <p>Durant la phase de comparaison, <module>mod_authnz_ldap</module>
    utilise les directives suivantes :</p>

    <table>
      <columnspec><column width=".4"/><column width=".6"/></columnspec>
      <tr>
        <td><directive module="mod_authnz_ldap">AuthLDAPURL</directive>
	</td>

        <td>On utilise l'attribut spécifié dans l'URL pour les
	opérations de comparaison initiées par la directive
	<code>Require ldap-user</code>.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPCompareDNOnServer</directive></td>

        <td>Détermine le comportement de la directive <code>Require
	ldap-dn</code>.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPGroupAttribute</directive></td>

        <td>Détermine l'attribut utilisé pour les opérations de
	comparaison initiées par la directive <code>Require
	ldap-group</code>.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPGroupAttributeIsDN</directive></td>

        <td>Spécifie si l'on doit utiliser le DN ou le nom de
	l'utilisateur lors des opérations de comparaison initiées par la
	directive <code>Require ldap-group</code>.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPMaxSubGroupDepth</directive></td>

        <td>Détermine la profondeur maximale de l'arborescence des
	sous-groupes qui seront évalués au cours des opérations de
	comparaisons initiées par la directive <code>Require
	ldap-group</code>.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPSubGroupAttribute</directive></td>

        <td>Détermine l'attribut à utiliser lors de l'extraction de
	membres de sous-groupes du groupe courant au cours des
	opérations de comparaison initiées par la directive
	<code>Require ldap-group</code>.</td>
      </tr>

      <tr>
        <td><directive
        module="mod_authnz_ldap">AuthLDAPSubGroupClass</directive></td>

        <td>Spécifie les valeurs de classe d'objet LDAP à utiliser pour
	déterminer si les objets extraits de l'annuaire sont bien des
	objets de type groupe (et non des objets de type utilisateur),
	au cours du traitement des sous-groupes initié par la directive
	<code>Require ldap-group</code>.</td>
      </tr>
    </table>
</section>
</section>

<section id="requiredirectives"><title>Les directives requises</title>

    <p>Les directives <directive
    module="mod_authz_core">Require</directive> d'Apache sont utilisées
    au cours de la phase d'autorisation afin de s'assurer que
    l'utilisateur est autorisé à accéder à une ressource.
    mod_authnz_ldap enrichit la liste des types d'autorisations avec les
    valeurs <code>ldap-user</code>, <code>ldap-dn</code>,
    <code>ldap-group</code>, <code>ldap-attribute</code> et
    <code>ldap-filter</code>. D'autres types d'autorisations sont
    disponibles, sous réserve du chargement de modules d'autorisation
    supplémentaires.</p>

    <p>Depuis la version 2.4.8, les directives require LDAP supportent
    les <a href="../expr.html">expressions</a>.</p>

<section id="requser"><title>Require ldap-user</title>

    <p>La directive <code>Require ldap-user</code> permet de spécifier
    les noms des utilisateurs autorisés à accéder à la ressource.
    Lorsque <module>mod_authnz_ldap</module> a extrait un DN unique de
    l'annuaire LDAP, il effectue une opération de comparaison LDAP en
    utilisant le nom d'utilisateur spécifié par la directive
    <code>Require ldap-user</code>, pour vérifier si ce nom
    d'utilisateur correspond à l'entrée LDAP extraite. On peut accorder
    l'accès à plusieurs utilisateurs en plaçant plusieurs nom
    d'utilisateurs sur la même ligne séparés par des espaces. Si un nom
    d'utilisateur contient des espaces, il doit être entouré de
    guillemets. On peut aussi accorder l'accès à plusieurs utilisateurs
    en utilisant une directive <code>Require ldap-user</code> par
    utilisateur. Par exemple, avec la directive <directive
    module="mod_authnz_ldap">AuthLDAPURL</directive> définie à
    <code>ldap://ldap/o=Example?cn</code> (spécifiant donc que l'attribut
    <code>cn</code> sera utilisé pour les recherches), on pourra
    utiliser les directives Require suivantes pour restreindre l'accès
    :</p>
<highlight language="config">
Require ldap-user "Barbara Jenson"
Require ldap-user "Fred User"
Require ldap-user "Joe Manager"
</highlight>

    <p>De par la manière dont <module>mod_authnz_ldap</module> traite
    cette directive, Barbara Jenson peut s'authentifier comme
    <em>Barbara Jenson</em>, <em>Babs Jenson</em> ou tout autre
    <code>cn</code> sous lequel elle est enregistrée dans l'annuaire
    LDAP. Une seule ligne <code>Require ldap-user</code> suffit pour
    toutes les valeurs de l'attribut dans l'entrée LDAP de
    l'utilisateur.</p>

    <p>Si l'attribut <code>uid</code> avait été spécifié à la place de
    l'attribut <code>cn</code> dans l'URL précédente, les trois lignes
    ci-dessus auraient pû être condensées en une seule ligne :</p>
<highlight language="config">
Require ldap-user bjenson fuser jmanager
</highlight>
</section>

<section id="reqgroup"><title>Require ldap-group</title>

    <p>Cette directive permet de spécifier un groupe LDAP dont les
    membres auront l'autorisation d'accès. Elle prend comme argument le
    DN du groupe LDAP. Note : n'entourez pas le nom du groupe avec des
    guillemets. Par exemple, supposons que l'entrée suivante existe dans
    l'annuaire LDAP :</p>
<example><pre>
dn: cn=Administrators, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Barbara Jenson, o=Example
uniqueMember: cn=Fred User, o=Example
</pre></example>

    <p>La directive suivante autoriserait alors l'accès à Fred et
    Barbara :</p>
<highlight language="config">
Require ldap-group cn=Administrators, o=Example
</highlight>

    <p>Les membres peuvent aussi se trouver dans les sous-groupes du
    groupe LDAP spécifié si la directive <directive
    module="mod_authnz_ldap">AuthLDAPMaxSubGroupDepth</directive> a été
    définie à une valeur supérieure à 0. Par exemple, supposons que les
    entrées suivantes existent dans l'annuaire LDAP :</p>
<example><pre>
dn: cn=Employees, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Managers, o=Example
uniqueMember: cn=Administrators, o=Example
uniqueMember: cn=Users, o=Example

dn: cn=Managers, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Bob Ellis, o=Example
uniqueMember: cn=Tom Jackson, o=Example

dn: cn=Administrators, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Barbara Jenson, o=Example
uniqueMember: cn=Fred User, o=Example

dn: cn=Users, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Allan Jefferson, o=Example
uniqueMember: cn=Paul Tilley, o=Example
uniqueMember: cn=Temporary Employees, o=Example

dn: cn=Temporary Employees, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Jim Swenson, o=Example
uniqueMember: cn=Elliot Rhodes, o=Example
</pre></example>

    <p>Les directives suivantes autoriseraient alors l'accès à Bob
    Ellis, Tom Jackson, Barbara Jenson, Fred User, Allan Jefferson, et
    Paul Tilley, mais l'interdiraient à Jim Swenson, ou Elliot Rhodes
    (car ils sont situés dans un sous-groupe de niveau de profondeur 2)
    :</p>
<highlight language="config">
Require ldap-group cn=Employees, o=Example
AuthLDAPMaxSubGroupDepth 1
</highlight>

    <p>Le comportement de cette directive est modifié par les directives
    <directive
    module="mod_authnz_ldap">AuthLDAPGroupAttribute</directive>,
    <directive
    module="mod_authnz_ldap">AuthLDAPGroupAttributeIsDN</directive>,
    <directive
    module="mod_authnz_ldap">AuthLDAPMaxSubGroupDepth</directive>,
    <directive
    module="mod_authnz_ldap">AuthLDAPSubGroupAttribute</directive>, et
    <directive
    module="mod_authnz_ldap">AuthLDAPSubGroupClass</directive>.</p>
</section>

<section id="reqdn"><title>Require ldap-dn</title>

    <p>La directive <code>Require ldap-dn</code> permet à
    l'administrateur d'accorder l'utorisation d'accès en fonction du DN.
    Elle permet de spécifier un DN pour lequel l'accès est autorisé. Si
    le DN extrait de
    l'annuaire correspond au DN spécifié par la directive <code>Require
    ldap-dn</code>, l'autorisation d'accès est accordée. Note :
    n'entourez pas Le DN de guillemets.</p>

    <p>La directive suivante accorderait l'accès à un DN spécifique
    :</p>
<highlight language="config">
Require ldap-dn cn=Barbara Jenson, o=Example
</highlight>

    <p>Le comportement ce cette directive est modifié par la directive
    <directive
    module="mod_authnz_ldap">AuthLDAPCompareDNOnServer</directive>.</p>
</section>

<section id="reqattribute"><title>Require ldap-attribute</title>

    <p>La directive <code>Require ldap-attribute</code> permet à
    l'administrateur d'accorder l'autorisation d'accès en fonction des
    attributs de l'utilisateur authentifié dans l'annuaire LDAP. Si la
    valeur de l'attribut dans l'annuaire correspond à la valeur
    spécifiée par la directive, l'autorisation d'accès est accordée.</p>

    <p>La directive suivante accorderait l'autorisation d'accès à tout
    utilisateur dont l'attribut employeeType a pour valeur "actif" :</p>

    <highlight language="config">
    Require ldap-attribute employeeType=active
    </highlight>

    <p>Plusieurs paires attribut/valeur peuvent être spécifiées par une
    même directive en les séparant par des espaces, ou en définissant
    plusieurs directives <code>Require ldap-attribute</code>. La logique
    sous-jacente à une liste de paires attribut/valeur est une opération
    OU. L'autorisation d'accès sera accordée si au moins une paire
    attribut/valeur de la liste spécifiée correspond à la paire
    attribut/valeur de l'utilisateur authentifié. Si elle contient des
    espaces, la valeur, et seulement la valeur, doit être entourée de
    guillemets.</p>

    <p>La directive suivante accorderait l'autorisation d'accès à tout
    utilisateur dont l'attribut city aurait pour valeur "San Jose", ou
    donc l'attribut status aurait pour valeur "actif" :</p>

    <highlight language="config">
    Require ldap-attribute city="San Jose" status=active
    </highlight>

</section>

<section id="reqfilter"><title>Require ldap-filter</title>

    <p>La directive <code>Require ldap-filter</code> permet à
    l'administrateur d'accorder l'autorisation d'accès en fonction d'un
    filtre de recherche LDAP complexe. L'autorisation d'accès est
    accordée si le DN renvoyé par le filtre de recherche correspond au
    DN de l'utilisateur authentifié.</p>

    <p>La directive suivante accorderait l'autorisation d'accès à tout
    utilisateur possédant un téléphone cellulaire et faisant partie du
    département "marketing" :</p>

    <highlight language="config">
    Require ldap-filter &amp;(cell=*)(department=marketing)
    </highlight>

    <p>Alors que la directive <code>Require ldap-attribute</code> se
    contente d'une simple comparaison d'attributs, la directive
    <code>Require ldap-filter</code> effectue une opération de recherche
    dans l'annuaire LDAP en utilisant le filtre de recherche spécifié.
    Si une simple comparaison d'attributs suffit, l'opération de
    comparaison effectuée par <code>ldap-attribute</code> sera plus
    rapide que l'opération de recherche effectuée par
    <code>ldap-filter</code>, en particulier dans le cas d'un annuaire
    LDAP de grande taille.</p>

</section>

</section>

<section id="examples"><title>Exemples</title>

    <ul>
      <li>
        Accorde l'autorisation d'accès à tout utilisateur présent dans
	l'annuaire LDAP, en utilisant son UID pour effectuer la
	recherche :
<highlight language="config">
AuthLDAPURL "ldap://ldap1.example.com:389/ou=People, o=Example?uid?sub?(objectClass=*)"
Require valid-user
</highlight>
      </li>

      <li>
        L'exemple suivant est similaire au précédent, mais les champs
	dont les valeurs par défaut conviennent sont omis. Notez aussi
	la présence d'un annuaire LDAP redondant :
<highlight language="config">
AuthLDAPURL "ldap://ldap1.example.com ldap2.example.com/ou=People, o=Example"
Require valid-user
</highlight>
      </li>

      <li>
        Encore un exemple similaire aux précédents, mais cette fois,
	c'est l'attribut cn qui est utilisé pour la recherche à la place
	de l'UID. Notez que ceci peut poser problème si plusieurs
	utilisateurs de l'annuaire partagent le même <code>cn</code>,
	car une recherche sur le <code>cn</code> <strong>doit</strong>
	retourner une entrée et une seule. C'est pourquoi cette
	approche n'est pas recommandée : il est préférable de choisir un
	attribut de votre annuaire dont l'unicité soit garantie, comme
	<code>uid</code>.
<highlight language="config">
AuthLDAPURL "ldap://ldap.example.com/ou=People, o=Example?cn"
Require valid-user
</highlight>
      </li>

      <li>
        Accorde l'autorisation d'accès à tout utilisateur appartenant au
	groupe Administrateurs. Les utilisateurs doivent s'authentifier
	en utilisant leur UID :
<highlight language="config">
AuthLDAPURL ldap://ldap.example.com/o=Example?uid
Require ldap-group cn=Administrators, o=Example
</highlight>
      </li>

      <li>
      Accorde l'accès à tout utilisateur appartenant au groupe dont le
      nom correspond au nom d'hôte du serveur virtuel. Dans cet exemple,
      on utilise une <a href="../expr.html">expression</a> pour
      construire le filtre.
<highlight language="config">
AuthLDAPURL ldap://ldap.example.com/o=Example?uid
Require ldap-group cn=%{SERVER_NAME}, o=Example
</highlight>
      </li>

      <li>
        Pour l'exemple suivant, on suppose que tout utilisateur de chez
	Example qui dispose d'un bippeur alphanumérique possèdera un
	attribut LDAP <code>qpagePagerID</code>. Seuls ces utilisateurs
	(authentifiés via leur UID) se verront accorder l'autorisation
	d'accès :
<highlight language="config">
AuthLDAPURL ldap://ldap.example.com/o=Example?uid??(qpagePagerID=*)
Require valid-user
</highlight>
      </li>

      <li>
        <p>L'exemple suivant illustre la puissance des filtres pour
	effectuer des requêtes complexes. Sans les filtres, il aurait
	été nécessaire de créer un nouveau groupe LDAP et de s'assurer
	de la synchronisation des membres du groupe avec les
	utilisateurs possédant un bippeur. Tout devient limpide avec les
	filtres. Nous avons pour but d'accorder l'autorisation d'accès à
	tout utilisateur disposant d'un bippeur ainsi qu'à Joe Manager
	qui ne possède pas de bippeur, mais doit tout de même pouvoir
	accéder à la ressource :</p>
<highlight language="config">
AuthLDAPURL ldap://ldap.example.com/o=Example?uid??(|(qpagePagerID=*)(uid=jmanager))
Require valid-user
</highlight>

        <p>Ce dernier exemple peut sembler confus au premier abord ; en
	fait, il permet de mieux comprendre à quoi doit ressembler le
	filtre en fonction de l'utilisateur qui se connecte. Si Fred
	User se connecte en tant que <code>fuser</code>, le filtre devra
	ressembler à :</p>

        <example>(&amp;(|(qpagePagerID=*)(uid=jmanager))(uid=fuser))</example>

        <p>Un recherche avec le filtre ci-dessus ne retournera un
	résultat positif que si <em>fuser</em> dispose d'un bippeur. Si
	Joe Manager se connecte en tant que <em>jmanager</em>, le filtre
	devra ressembler à :</p>

        <example>(&amp;(|(qpagePagerID=*)(uid=jmanager))(uid=jmanager))</example>

        <p>Un recherche avec le filtre ci-dessus retournera un
	résultat positif que <em>jmanager</em> dispose d'un
	bippeur ou non</p>
      </li>
    </ul>
</section>

<section id="usingtls"><title>Utilisation de TLS</title>

    <p>Pour l'utilisation de TLS, voir les directives du module
    <module>mod_ldap</module> <directive
    module="mod_ldap">LDAPTrustedClientCert</directive>, <directive
    module="mod_ldap">LDAPTrustedGlobalCert</directive> et <directive
    module="mod_ldap">LDAPTrustedMode</directive>.</p>

    <p>Un second paramètre optionnel peut être ajouté à la directive
    <directive module="mod_authnz_ldap">AuthLDAPURL</directive> pour
    remplacer le type de connexion par défaut défini par la directive
    <directive module="mod_ldap">LDAPTrustedMode</directive>. Ceci
    permettra de promouvoir la connexion établie via une URL du type
    <em>ldap://</em> au statut de connection sécurisée sur le même
    port.</p>
</section>

<section id="usingssl"><title>Utilisation de SSL</title>

    <p>Pour l'utilisation de SSL, voir les directives du module
    <module>mod_ldap</module> <directive
    module="mod_ldap">LDAPTrustedClientCert</directive>, <directive
    module="mod_ldap">LDAPTrustedGlobalCert</directive> et <directive
    module="mod_ldap">LDAPTrustedMode</directive>.</p>

    <p>Pour spécifier un serveur LDAP sécurisé, utilisez
    <em>ldaps://</em> au lieu de
    <em>ldap://</em> dans la directive <directive
    module="mod_authnz_ldap">AuthLDAPURL</directive>.</p>
</section>

<section id="exposed"><title>Mise à disposition des informations de
connexion</title>

    <p>Au cours du processus d'<em>authentification</em>, les attributs LDAP
    spécifiés par la directive <directive
    module="mod_authnz_ldap">authldapurl</directive> sont enregistrés
    dans des variables d'environnement préfixées par la chaîne
    "AUTHENTICATE_".</p>

    <p>Au cours du processus d'<em>autorisation</em>, les attributs LDAP
    spécifiés par la directive <directive
    module="mod_authnz_ldap">authldapurl</directive> sont enregistrés
    dans des variables d'environnement préfixées par la chaîne
    "AUTHORIZE_".</p>

    <p>Si les champs attribut contiennent le nom, le CN et le numéro de
    téléphone d'un utilisateur, un programme CGI pourra accéder à ces
    informations sans devoir effectuer une autre requête LDAP pour
    les extraire de l'annuaire.</p>

    <p>Ceci a pour effet de simplifier considérablement le code et la
    configuration nécessaire de certaines applications web.</p>

</section>

<section id="activedirectory"><title>Utilisation d'Active
Directory</title>

    <p>Active Directory peut supporter plusieurs domaines à la fois.
    Pour faire la distinction entre les utilisateurs de plusieurs
    domaines, on peut ajouter à l'entrée de l'utilisateur dans
    l'annuaire un identifiant appelé Nom
    Principal d'Utilisateur (User Principle Name ou UPN). Cet UPN se
    compose en général du nom de compte de l'utilisateur, suivi du nom
    du domaine considéré, par exemple <em>untel@nz.example.com</em>.</p>

    <p>Vous voudrez probablement configurer le module
    <module>mod_authnz_ldap</module> afin de pouvoir authentifier les
    utilisateurs de n'importe quel domaine de la forêt Active Directory.
    Ainsi, <em>untel@nz.example.com</em> et
    <em>untel@au.example.com</em> pourront être authentifiés en une
    seule fois par la même requête.</p>

    <p>Pour y parvenir, on utilise le concept de Catalogue Global
    d'Active Directory. Ce Catalogue Global est une copie en lecture
    seule des attributs sélectionnés de tous les serveurs de la forêt
    Active Directory. Une requête vers le
    Catalogue Global permet donc d'atteindre tous les domaines en une
    seule fois, sans avoir à se connecter aux différents serveurs, via
    des liaisons dont certaines peuvent être lentes.</p>

    <p>Lorsqu'il est activé, la Catalogue Global est un serveur
    d'annuaire indépendant accessible sur le port 3268 (3269 pour SSL).
    Pour rechercher un utilisateur, effectuez une recherche sur
    l'attribut <em>userPrincipalName</em>, avec une base de recherche
    vide, comme suit :</p>

<highlight language="config">
AuthLDAPBindDN apache@example.com
AuthLDAPBindPassword password
AuthLDAPURL ldap://10.0.0.1:3268/?userPrincipalName?sub
</highlight>

    <p>Les utilisateurs devront s'authentifier en entrant leur UPN, de
    la forme<em>untel@nz.example.com</em>.</p>

</section>

<section id="frontpage"><title>Utilisation de Microsoft
    FrontPage avec mod_authnz_ldap</title>

    <p>Normalement, FrontPage utilise des fichiers utilisateur/groupe
    spécifiques à FrontPage-web (c'est à dire les modules
    <module>mod_authn_file</module> et
    <module>mod_authz_groupfile</module>) pour effectuer toute
    l'authentification. Malheureusement, il ne suffit pas de modifier
    l'authentification LDAP en ajoutant les directives appropriées, car
    ceci corromprait les formulaires de <em>Permissions</em> dans le
    client FrontPage, qui sont censés modifier les fichiers
    d'autorisation standards au format texte.</p>

    <p>Lorsqu'un site web FrontPage a été créé, lui adjoindre
    l'authentification LDAP consiste à ajouter les directives suivantes
    à <em>chaque</em> fichier <code>.htaccess</code> qui sera créé dans
    le site web :</p>
<highlight language="config">
AuthLDAPURL       "the url"
AuthGroupFile     "mygroupfile"
Require group     "mygroupfile"
</highlight>

<section id="howitworks"><title>Comment ça marche</title>

    <p>FrontPage restreint l'accès à un site web en ajoutant la
    directive <code>Require valid-user</code> aux fichiers
    <code>.htaccess</code>. La directive <code>Require valid-user</code>
    permettra l'accès à tout utilisateur valide <em>du point de vue
    LDAP</em>. Cela signifie que tout utilisateur possédant une entrée
    dans l'annuaire LDAP sera considéré comme valide, alors que
    FrontPage ne considère comme valides que les utilisateurs
    enregistrés dans le fichier des utilisateurs local. En remplaçant
    l'autorisation par groupe LDAP par une autorisation par fichier de
    groupe, Apache sera en mesure de consulter le fichier des
    utilisateurs local (géré par FrontPage) - au lieu de l'annuaire LDAP
    - lors du processus d'autorisation des utilisateurs.</p>

    <p>Une fois les directives ajoutées selon ce qui précède, les
    utilisateurs FrontPage pourront effectuer toutes les opérations de
    gestion à partir du client FrontPage.</p>
</section>

<section id="fpcaveats"><title>Avertissements</title>

    <ul>
      <li>Lors du choix de l'URL LDAP, l'attribut à utiliser pour
      l'authentification doit aussi être valide pour le fichier des
      utilisateurs de <module>mod_authn_file</module>. A cette fin,
      l'UID est idéal.</li>

      <li>Lorsqu'ils ajoutent des utilisateurs via FrontPage, les
      administrateurs de FrontPage doivent choisir des noms
      d'utilisateurs qui existent déjà dans l'annuaire LDAP (pour des
      raisons évidentes). De même, le mot de passe que l'administrateur
      entre dans le formulaire est ignoré, car pour l'authentification,
      Apache utilise le mot de passe de l'annuaire LDAP, et non le mot
      de passe enregistré dans le fichier des utilisateurs, ce qui peut
      semer la confusion parmi les administrateurs web.</li>

      <!-- XXX is that true? was mod_auth before the aaa change -->
      <li>Pour supporter FrontPage, Apache doit être compilé avec
      <module>mod_auth_basic</module>, <module>mod_authn_file</module>
      et <module>mod_authz_groupfile</module>. Ceci est dû au fait
      qu'Apache doit utiliser le fichier de groupes de
      <module>mod_authz_groupfile</module> pour déterminer le niveau
      d'accès d'un utilisateur au site web FrontPage.</li>

      <li>Les directives doivent être placées dans les fichiers
      <code>.htaccess</code>. Elles ne fonctionneront pas si vous les
      placez dans une section <directive module="core"
      type="section">Location</directive> ou <directive module="core"
      type="section">Directory</directive>. Ceci est dû au fait que pour savoir
      où se trouve la liste des utilisateurs valides,
      <module>mod_authnz_ldap</module> doit être en mesure d'atteindre
      la directive <directive
      module="mod_authz_groupfile">AuthGroupFile</directive> qui se trouve
      dans les fichiers <code>.htaccess</code> de FrontPage. Si les directives
      de <module>mod_authnz_ldap</module> ne sont pas situées dans le
      même fichier <code>.htaccess</code> que les directives FrontPage,
      la configuration ne fonctionnera pas, car
      <module>mod_authnz_ldap</module> ne sera jamais en mesure de
      traiter le fichier <code>.htaccess</code>, et par conséquent ne
      pourra jamais trouver le fichier des utilisateurs géré par
      FrontPage.</li>
    </ul>
</section>
</section>

<directivesynopsis>
<name>AuthLDAPAuthorizePrefix</name>
<description>Spécifie le préfixe ajouté aux variables d'environnement
durant la phase d'autorisation</description>
<syntax>AuthLDAPAuthorizePrefix <em>préfixe</em></syntax>
<default>AuthLDAPAuthorizePrefix AUTHORIZE_</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible depuis la version 2.3.6</compatibility>
<usage>
    <p>Cette directive permet de spécifier le préfixe ajouté aux
    variables d'environnement durant la phase d'autorisation. Si la
    valeur spécifiée est <em>AUTHENTICATE_</em>, les utilisateurs de ces
    variables d'environnement verront les mêmes informations, que le
    serveur effectue une authentification, une autorisation, ou les
    deux.</p>

    <note><title>Note</title>
    Aucune variable d'autorisation n'est définie lorsqu'un utilisateur
    s'est vu autoriser l'accès via la directive <code>Require
    valid-user</code>.
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPBindAuthoritative</name>
<description>Détermine si l'on doit utiliser d'autres fournisseurs
d'authentification lorsque le serveur ne peut pas valider les données
d'authentification de l'utilisateur, alors que ce dernier possède un
DN.</description>
<syntax>AuthLDAPBindAuthoritative off|on</syntax>
<default>AuthLDAPBindAuthoritative on</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<usage>
    <p>Par défaut, des fournisseurs d'authentification sont appelés
    si un utilisateur ne possède pas de DN, mais ne le sont pas si
    l'utilisateur possède un DN et si son mot de passe ne peut pas être
    vérifié lors d'une connexion au serveur LDAP. Si la directive
    <directive>AuthLDAPBindAuthoritative</directive> est
    définie à <em>off</em>, d'autres modules d'authentification
    configurés auront une chance de valider le mot de passe de
    l'utilisateur si la tentative de connexion au serveur LDAP échoue
    pour une raison quelconque (avec les données d'authentification
    fournies).</p>
    <p>Ceci permet aux utilisateurs présent à la fois dans l'annuaire
    LDAP et dans un fichier <directive
    module="mod_authn_file">AuthUserFile</directive> de s'authentifier
    lorsque le serveur LDAP est disponible, alors que le compte de
    l'utilisateur est verrouillé ou que son mot de passe est
    inutilisable pour une raison quelconque.</p>
</usage>
<seealso><directive module="mod_authn_file">AuthUserFile</directive></seealso>
<seealso><directive module="mod_auth_basic">AuthBasicProvider</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPInitialBindAsUser</name>
<description>Détermine si le serveur effectue la recherche initiale du
DN en utilisant le nom propre de l'utilisateur pour l'authentification
de base
et non de manière anonyme, ou en utilisant des données d'authentification
codées en dur pour le serveur</description>
<syntax>AuthLDAPInitialBindAsUser off|on</syntax>
<default>AuthLDAPInitialBindAsUser off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible depuis la version 2.3.6</compatibility>
<usage>
    <p>Par défaut, le serveur convertit le nom d'utilisateur pour
    l'authentification de base en nom distinctif LDAP (DN) soit de
    manière anonyme, soit avec un couple nom/mot de passe dédié. Cette
    directive permet de forcer le serveur à utiliser les véritables nom
    d'utilisateur et mot de passe fournis par l'utilisateur pour
    effectuer la recherche initiale du DN.</p>

     <p>Si le nom d'utilisateur ne peut pas s'authentifier directement
     et nécessite de légères modifications, voir la directive <directive
     module="mod_authnz_ldap">AuthLDAPInitialBindPattern</directive>.</p>

     <p>Cette directive ne doit être utilisée que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur dédié via la directive <directive
     module="mod_authnz_ldap">AuthLDAPBindDN</directive>.
     </p>

     <note><title>Non disponible dans la cas d'une autorisation seule</title>
         On ne peut utiliser cette directive que si ce module
	 effectue une authentification, et n'a aucun effet si ce module
	 n'est utilisé que pour les processus d'autorisation.
     </note>
</usage>
<seealso><directive module="mod_authnz_ldap">AuthLDAPInitialBindPattern</directive></seealso>
<seealso><directive module="mod_authnz_ldap">AuthLDAPBindDN</directive></seealso>
<seealso><directive module="mod_authnz_ldap">AuthLDAPCompareAsUser</directive></seealso>
<seealso><directive module="mod_authnz_ldap">AuthLDAPSearchAsUser</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPInitialBindPattern</name>
<description>Spécifie la modification a apporter au nom d'utilisateur
pour l'authentification de base lors de l'authentification auprès du
serveur LDAP pour effectuer une recherche de DN</description>
<syntax>AuthLDAPInitialBindPattern <em><var>regex</var> <var>substitution</var></em></syntax>
<default>AuthLDAPInitialBindPattern (.*) $1 (nom de l'utilisateur
distant utilisé tel quel)</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible depuis la version 2.3.6</compatibility>
<usage>
    <p>Si la directive <directive
    module="mod_authnz_ldap">AuthLDAPInitialBindAsUser</directive> est
    définie à <em>ON</em>, le nom utilisateur pour l'authentification de
    base sera transformé selon l'expression rationnelle
    <var>regex</var> et l'argument <var>substitution</var> spécifiés.</p>

    <p>L'expression rationnelle est comparée au nom d'utilisateur pour
    l'authentification de base courant. L'argument
    <var>substitution</var> peut contenir des références arrières, mais
    n'effectue aucune autre interpolation de variable.</p>

    <p>Cette directive ne doit être utilisée que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur dédié via la directive <directive
     module="mod_authnz_ldap">AuthLDAPBindDN</directive>.
     </p>

    <highlight language="config">
    AuthLDAPInitialBindPattern (.+) $1@example.com
    </highlight>
    <highlight language="config">
    AuthLDAPInitialBindPattern (.+) cn=$1,dc=example,dc=com
    </highlight>

    <note><title>Non disponible dans la cas d'une autorisation seule</title>
         On ne peut utiliser cette directive que si ce module
	 effectue une authentification, et n'a aucun effet si ce module
	 n'est utilisé que pour les processus d'autorisation.
     </note>
    <note><title>Débogage</title>
        Le DN de substitution est enregistré dans la variable
	d'environnement <em>LDAP_BINDASUSER</em>. Si l'expression
	rationnelle ne convient pas, le nom d'utilisateur est utilisé
	tel quel.
    </note>
</usage>
<seealso><directive module="mod_authnnz_ldap">AuthLDAPInitialBindAsUser</directive></seealso>
<seealso><directive module="mod_authnnz_ldap">AuthLDAPBindDN</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPBindDN</name>
<description>Un DN optionnel pour se connecter au serveur
LDAP</description>
<syntax>AuthLDAPBindDN <em>dn</em></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Cette directive permet de définir un DN optionnel pour se
    connecter au serveur afin d'y rechercher des entrées. Si aucun DN
    n'est spécifié, <module>mod_authnz_ldap</module> tentera une
    connexion anonyme.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPBindPassword</name>
<description>Mot de passe à utiliser en conjonction avec le DN de
connexion</description>
<syntax>AuthLDAPBindPassword <em>mot-de-passe</em></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility><em>exec:</em> est disponible depuis la version 2.4.5 du
serveur HTTP Apache.</compatibility>

<usage>
    <p>Cette directive permet de spécifier un mot de passe à utiliser en
    conjonction avec le DN de connexion. Notez que ce mot de passe
    constitue en général une donnée sensible, et doit donc être protégé
    de manière appropriée. Vous ne devez utiliser les directives
    <directive
    module="mod_authnz_ldap">AuthLDAPBindDN</directive> et
    <directive>AuthLDAPBindPassword</directive> que si
    vous en avez vraiment besoin pour effectuer une recherche dans
    l'annuaire.</p>

    <p>Si la valeur spécifiée débute par "exec:", la commande qui suit sera
    exécutée, et la première ligne renvoyée par la commande sur la
    sortie standard sera utilisée comme mot de passe.</p>
<highlight language="config">
# Mot de passe spécifié directement
AuthLDAPBindPassword secret

# Exécution de /path/to/program pour obtenir le mot de passe
AuthLDAPBindPassword exec:/path/to/program

# Exécution de /path/to/otherProgram avec un argument pour obtenir le mot de passe
AuthLDAPBindPassword "exec:/path/to/otherProgram argument1"
</highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPCharsetConfig</name>
<description>Chemin du fichier de configuration de la correspondance
langage/jeu de caractères</description>
<syntax>AuthLDAPCharsetConfig <em>chemin-fichier</em></syntax>
<contextlist><context>server config</context>
</contextlist>

<usage>
    <p>La directive <directive>AuthLDAPCharsetConfig</directive> permet
    de définir le chemin du fichier de configuration de la
    correspondance langage/jeu de caractères. <var>chemin-fichier</var>
    est un chemin relatif au répertoire défini par la directive
    <directive
    module="core">ServerRoot</directive>. Ce fichier contient une liste
    de correspondances extension de langage/jeu de caractères. La
    plupart des administrateurs utilisent le fichier
    <code>charset.conv</code> fourni qui associe les extensions de
    langage courantes à leurs jeux de caractères.</p>

    <p>Le fichier contient des lignes au format suivant :</p>

    <example>
      <var>extension de langage</var> <var>jeu de caractères</var>
      [<var>Nom du langage</var>] ...
    </example>

    <p>L'extension est insensible à la casse. Les lignes vides et les
    lignes commençant par un dièse (<code>#</code>) sont ignorées.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPCompareAsUser</name>
<description>Utilisation des données d'authentification de l'utilisateur
pour effectuer les comparaisons pour l'attribution des autorisations</description>
<syntax>AuthLDAPCompareAsUser on|off</syntax>
<default>AuthLDAPCompareAsUser off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible depuis la version version 2.3.6</compatibility>

<usage>
    <p>Lorsque cette directive est définie, et si
    <module>mod_authnz_ldap</module> a authentifié l'utilisateur, les
    recherches LDAP pour les autorisations utilisent le nom distinctif
    trouvé (DN) et le mot de passe d'authentification basique HTTP de
    l'utilisateur authentifié au lieu des données d'authentification
    configurées au niveau du serveur.</p>

    <p>Les vérifications d'autorisation <em>ldap-attribute</em>,
    <em>ldap-user</em>, et <em>ldap-group</em> (niveau simple seulement)
    utilisent des comparaisons.</p>

    <p>Cette directive n'a d'effet sur les comparaisons effectuées au
    cours des traitements de groupe imbriqués, et lorsque la directive
    <directive module="mod_authnz_ldap">AuthLDAPSearchAsUser</directive>
    est aussi activée.</p>

    <p>Cette directive ne doit être utilisée que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur dédié via la directive <directive
     module="mod_authnz_ldap">AuthLDAPBindDN</directive>.
     </p>
</usage>
<seealso><directive module="mod_authnz_ldap">AuthLDAPInitialBindAsUser</directive></seealso>
<seealso><directive module="mod_authnz_ldap">AuthLDAPSearchAsUser</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPCompareDNOnServer</name>
<description>Utilise le serveur LDAP pour comparer les DNs</description>
<syntax>AuthLDAPCompareDNOnServer on|off</syntax>
<default>AuthLDAPCompareDNOnServer on</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque cette directive est définie à on,
    <module>mod_authnz_ldap</module> utilise le serveur LDAP pour
    comparer les DNs. Il s'agit de la seule méthode infaillible pour
    comparer les DNs. <module>mod_authnz_ldap</module> va rechercher
    dans l'annuaire le DN spécifié par la directive <a
    href="#reqdn"><code>Require dn</code></a>, puis extraire ce DN et le
    comparer avec le DN extrait de l'entrée de l'utilisateur. Si cette
    directive est à off, <module>mod_authnz_ldap</module> effectue une
    simple comparaison de chaînes. Cette dernière approche peut produire
    des faux négatifs, mais elle est beaucoup plus rapide. Notez
    cependant que le cache de <module>mod_ldap</module> peut accélérer
    la comparaison de DNs dans la plupart des situations.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPDereferenceAliases</name>
<description>À quel moment le module va déréférencer les
alias</description>
<syntax>AuthLDAPDereferenceAliases never|searching|finding|always</syntax>
<default>AuthLDAPDereferenceAliases always</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Cette directive permet de spécifier à quel moment
    <module>mod_authnz_ldap</module> va déréférencer les alias au cours
    des opérations liées à LDAP. La valeur par défaut est
    <code>always</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPGroupAttribute</name>
<description>L'attribut LDAP utilisé pour vérifier l'appartenance d'un
utilisateur à un groupe.</description>
<syntax>AuthLDAPGroupAttribute <em>attribut</em></syntax>
<default>AuthLDAPGroupAttribute member uniquemember</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Cette directive permet de spécifier quel attribut LDAP est
    utilisé pour vérifier l'appartenance d'un utilisateur à un
    groupe. On peut spécifier plusieurs attributs en répétant cette
    directive plusieurs fois. Si la directive n'est pas définie,
    <module>mod_authnz_ldap</module> utilise les attributs
    <code>member</code> et <code>uniquemember</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPGroupAttributeIsDN</name>
<description>Utilise le DN de l'utilisateur pour vérifier son
appartenance à un groupe</description>
<syntax>AuthLDAPGroupAttributeIsDN on|off</syntax>
<default>AuthLDAPGroupAttributeIsDN on</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsqu'elle est définie à <code>on</code>, cette directive
    indique que c'est le DN de l'utilisateur qui doit être utilisé pour
    vérifier son appartenance à un groupe. Dans le cas contraire, c'est
    le nom de l'utilisateur qui sera utilisé. Par exemple, supposons que
    le client envoie le nom d'utilisateur <code>bjenson</code>, qui
    correspond au DN LDAP <code>cn=Babs Jenson,o=Example</code>. Si la
    directive est à <code>on</code>, <module>mod_authnz_ldap</module> va
    vérifier si <code>cn=Babs Jenson, o=Example</code> est un membre du
    groupe. Dans le cas contraire, <module>mod_authnz_ldap</module>
    vérifiera si <code>bjenson</code> est un membre du groupe.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPMaxSubGroupDepth</name>
<description>Spécifie la profondeur d'imbrication des sous-groupes
maximale prise en compte avant l'abandon de la recherche de
l'utilisateur.</description>
<syntax>AuthLDAPMaxSubGroupDepth <var>Nombre</var></syntax>
<default>AuthLDAPMaxSubGroupDepth 10</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible à partir de la version 2.3.0 du serveur HTTP
Apache</compatibility>

<usage>
   <p>Lorsque cette directive est définie à une valeur <code>X</code>
   non nulle, en combinaison avec l'utilisation de la directive
   <code>Require ldap-group DN-groupe</code>, les données de connexion
   fournies seront utilisées pour vérifier l'appartenance de
   l'utilisateur à l'objet de l'annuaire <code>DN-groupe</code> ou à
   tout sous-groupe du groupe courant en tenant compte de la profondeur
   d'imbrication maximale <code>X</code> spécifiée par la directive.</p>
   <p>Se référer à la section <a href="#reqgroup"><code>Require
   ldap-group</code></a> pour un exemple plus détaillé.</p>

   <note><title>Performances dans le cas des groupes imbriqués</title>
   <p>Lorsque les directives
   <directive>AuthLDAPSubGroupAttribute</directive> et
   <directive>AuthLDAPGroupAttribute</directive> se recouvrent (comme
   c'est le cas par défaut et requis par les schémas LDAP courants), la
   recherche de sous-groupes au sein de grands groupes peut être très
   longue. Si vos groupes sont très grands et non imbriqués, définissez
   la directive <directive>AuthLDAPMaxSubGroupDepth</directive> à 0.</p>
   </note>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPRemoteUserAttribute</name>
<description>Spécifie l'attribut dont la valeur renvoyée au cours de la
requête de l'utilisateur sera utilisée pour définir la variable
d'environnement REMOTE_USER</description>
<syntax>AuthLDAPRemoteUserAttribute uid</syntax>
<default>none</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque cette directive est définie, la variable d'environnement
    <code>REMOTE_USER</code> sera définie à la valeur de l'attribut
    spécifié. Assurez-vous que cet attribut soit bien inclus dans la
    liste d'attributs spécifiés dans la définition de AuthLDAPUrl ; dans
    le cas contraire, cette directive n'aurait aucun effet. Si elle est
    présente, cette directive l'emporte sur <directive
    module="mod_authnz_ldap">AuthLDAPRemoteUserIsDN</directive>. Elle
    peut s'avérer utile par exemple, si vous souhaitez que les
    utilisateurs se connectent à un site web en utilisant leur adresse
    email, alors qu'une application sous-jacente nécessite un nom
    d'utilisateur comme identifiant.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPRemoteUserIsDN</name>
<description>Utilise le DN de l'utilisateur pour définir la variable
d'environnement REMOTE_USER</description>
<syntax>AuthLDAPRemoteUserIsDN on|off</syntax>
<default>AuthLDAPRemoteUserIsDN off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque cette directive est à on, la variable d'environnement
    <code>REMOTE_USER</code> sera définie avec la valeur du DN complet
    de l'utilisateur authentifié, et non plus avec simplement le nom
    d'utilisateur fourni par le client. Elle est définie à off par
    défaut.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPSearchAsUser</name>
<description>Utilise les données d'authentification de l'utilisateur
pour la recherche des autorisations</description>
<syntax>AuthLDAPSearchAsUser on|off</syntax>
<default>AuthLDAPSearchAsUser off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible depuis la version 2.3.6</compatibility>

<usage>
    <p>Lorsque cette directive est définie, et si
    <module>mod_authnz_ldap</module> a authentifié l'utilisateur, les
    recherches LDAP pour définir les autorisations utilisent le nom
    distinctif (DN) trouvé et le mot de passe pour l'authentification de
    base HTTP de l'utilisateur authentifié, au lieu des données
    d'authentification configurées au niveau du serveur.</p>

    <p>Les vérifications d'autorisation <em>ldap-filter</em> et
    <em>ldap-dn</em> utilisent des recherches.</p>

    <p>Cette directive n'a d'effet sur les comparaisons effectuées au
    cours des traitements de groupe imbriqués, et lorsque la directive
    <directive
    module="mod_authnz_ldap">AuthLDAPCompareAsUser</directive>
    est aussi activée.</p>

     <p>Cette directive ne doit être utilisée que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur dédié via la directive <directive
     module="mod_authnz_ldap">AuthLDAPBindDN</directive>.
     </p>

</usage>
<seealso><directive module="mod_authnz_ldap">AuthLDAPInitialBindAsUser</directive></seealso>
<seealso><directive module="mod_authnz_ldap">AuthLDAPCompareAsUser</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPSubGroupAttribute</name>
<description>Spécifie les noms d'attribut, un par directive, utilisés
pour différencier les membres du groupe courant qui sont eux-mêmes des
groupes.</description>
<syntax>AuthLDAPSubGroupAttribute <em>attribut</em></syntax>
<default>AuthLDAPSubgroupAttribute member uniquemember</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible à partir de la version 2.3.0 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Un objet groupe LDAP peut contenir des membres qui sont des
    utilisateurs et des membres qui sont eux-mêmes des groupes (appelés
    sous-groupes ou groupes imbriqués). La directive
    <directive>AuthLDAPSubGroupAttribute</directive> spécifie l'attribut utilisé
    pour identifier les groupes, alors que la directive
    <directive module="mod_authnz_ldap">AuthLDAPGroupAttribute</directive>
    spécifie l'attribut utilisé pour identifier les utilisateurs. On peut
    spécifier plusieurs attributs en répétant la directive plusieurs fois. Si
    elle n'est pas définie, <module>mod_authnz_ldap</module> utilise les
    attributs <code>member</code> et <code>uniqueMember</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPSubGroupClass</name>
<description>Spécifie quelles valeurs d'objectClass LDAP identifient les
objets de l'annuaire qui sont des groupes au cours du traitement des
sous-groupes.</description>
<syntax>AuthLDAPSubGroupClass <em>ObjectClass-LDAP</em></syntax>
<default>AuthLDAPSubGroupClass groupOfNames groupOfUniqueNames</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Disponible à partir de la version 2.3.0 du serveur HTTP
Apache</compatibility>

<usage>
    <p>Un objet groupe LDAP peut contenir des membres qui sont des
    utilisateurs et des membres qui sont eux-mêmes des groupes (appelés
    sous-groupes ou groupes imbriqués). La directive
    <directive module="mod_authnz_ldap">AuthLDAPSubGroupAttribute</directive>
    permet d'identifier les
    membres qui sont des sous-groupes du groupe courant (à l'opposé des
    membres utilisateurs). La directive
    <directive>AuthLDAPSubGroupClass</directive> permet de spécifier les valeurs
    d'objectClass LDAP utilisées pour vérifier que certains membres sont
    en fait des objets groupe. Les sous-groupes ainsi identifiés peuvent
    alors faire l'objet d'une recherche d'autres membres utilisateurs ou
    sous-groupes. On peut spécifier plusieurs attributs en répétant
    cette directive plusieurs fois. Si cette directive n'est pas
    définie, <module>mod_authnz_ldap</module> utilise les attributs
    <code>groupOfNames</code> et <code>groupOfUniqueNames</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthLDAPUrl</name>
<description>L'URL permettant de spécifier les paramètres de la
recherche LDAP</description>
<syntax>AuthLDAPUrl <em>url [NONE|SSL|TLS|STARTTLS]</em></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Une URL conforme à la RFC 2255 qui permet de spécifier les
    paramètres à utiliser pour la recherche dans l'annuaire LDAP. La
    syntaxe de l'URL est :</p>
<example>ldap://hôte:port/DN-de-base?attribut?portée?filtre</example>
    <p>Si vous souhaitez mettre à la disposition d'Apache plusieurs URLs
    LDAP, la syntaxe sera :</p>
<highlight language="config">
AuthLDAPUrl "ldap://ldap1.example.com ldap2.example.com/dc=..."
</highlight>
<p><em><strong>Mise en garde : </strong>Si vous spécifiez plusieurs
serveurs, vous devez en entourer la liste avec des guillemets ; dans le
cas contraire, vous générerez une erreur : "AuthLDAPURL takes one
argument, URL to define LDAP connection..".</em> Vous pouvez bien
entendu ajouter des paramètres de recherche à chacun des serveurs
spécifiés.</p>

<dl>
<dt>ldap</dt>

        <dd>Pour ldap non sécurisé, utilisez la chaîne
	<code>ldap</code>. Pour ldap sécurisé, utilisez à la place la
	chaîne <code>ldaps</code>. LDAP sécurisé n'est disponible que si
	Apache a été lié avec une bibliothèque LDAP supportant SSL.</dd>

<dt>hôte:port</dt>

        <dd>
          <p>Il s'agit du nom/port du serveur ldap
	  (dont la valeur par défaut est
	  <code>localhost:389</code> pour <code>ldap</code>, et
	  <code>localhost:636</code> pour <code>ldaps</code>). Pour
	  spécifier plusieurs serveurs LDAP redondants, indiquez
	  simplement leur liste en les séparant par des espaces.
	  <module>mod_authnz_ldap</module> tentera alors de se connecter
	  à chacun des serveurs jusqu'à ce qu'il parvienne à se
	  connecter avec succès. Notez qu'en cas de multiples serveurs
	  LDAP, l'ensemble de l'URL LDAP doit être entourée de
	  guillemets.</p>

          <p>lorsqu'une connection a été établie avec un serveur, elle
	  reste active pendant toute la durée de vie du processus
	  <program>httpd</program>, ou jusqu'à ce que le serveur LDAP
	  cesse de fonctionner.</p>

          <p>Si le serveur LDAP cesse de fonctionner, et ainsi
	  interrompt une
	  connexion existante, <module>mod_authnz_ldap</module> tentera
	  de se reconnecter en commençant par le premier serveur de la
	  liste, et ainsi de suite avec les serveurs redondants
	  suivants. Notez que ce processus n'a rien à voir avec une
	  véritable recherche de type round-robin.</p>
        </dd>

<dt>DN-de-base</dt>
        <dd>Le DN de la branche de l'annuaire à partir de laquelle
	toutes les recherches seront lancées. Il doit au moins
	correspondre à la racine de votre annuaire, mais vous pouvez
	aussi indiquer une branche plus spécifique.</dd>

<dt>attribut</dt>

        <dd>Il s'agit de l'attribut à utiliser pour la recherche.
	Bien que la RFC
	2255 autorise une liste d'attributs séparés par des virgules,
	seul le premier sera retenu, sans tenir compte des autres
	attributs fournis. Si aucun attribut n'est fourni, l'attribut
	par défaut est <code>uid</code>. Il est judicieux de choisir un
	attribut dont la valeur sera unique parmi toutes les entrées de
	la branche de l'annuaire que vous aurez définie. Tous les
	attributs spécifiés seront enregistrés dans des variables
	d'environnement avec le préfixe AUTHENTICATE_, afin de pouvoir
	être utilisés par d'autres modules.</dd>

<dt>portée</dt>

        <dd>Il s'agit de la portée de la recherche. Elle peut prendre
	les valeurs <code>one</code> ou <code>sub</code>. Notez que la
	RFC 2255 supporte aussi une portée de valeur <code>base</code>,
	mais cette dernière n'est pas supportée par le module. Si la
	portée n'est pas définie, ou si elle est définie à
	<code>base</code>, c'est la valeur de portée par défaut
	<code>sub</code> qui sera utilisée.</dd>

<dt>filtre</dt>

        <dd>Il s'agit d'un filtre de recherche LDAP valide. Si aucun
	filtre n'est spécifié, le filtre par défaut
	<code>(objectClass=*)</code> sera utilisé, ce qui corrspond à
	une recherche de tous les types d'objets de l'arborescence. La
	taille des filtres est limitée à environ 8000 caractères (valeur
	de la macro <code>MAX_STRING_LEN</code> dans le code source
	d'Apache), ce qui s'avère plus que suffisant pour la plupart des
	applications. Depuis la version 2.4.10, il est possible
	d'utiliser le paramètre <code>none</code> pour spécifier qu'aucun filtre
	n'est activé ; ce paramètre est obligatoire avec certains
	serveurs LDAP primitifs.</dd>
</dl>

    <p>Pour une recherche, les attribut, filtre et nom d'utilisateur
    fournis par le client HTTP sont combinés pour créer un filtre de
    recherche du style :
    <code>(&amp;(<em>filtre</em>)(<em>attribut</em>
    =<em>nom-utilisateur</em>))</code>.</p>

    <p>Par exemple, considérons l'URL
    <code>ldap://ldap.example.com/o=Example?cn?sub?(posixid=*)</code>.
    Lorsqu'un client tentera de se connecter en utilisant le nom
    d'utilisateur <code>Babs Jenson</code>, le filtre de recherche sera
    : <code>(&amp;(posixid=*)(cn=Babs Jenson))</code>.</p>

    <p>On peut encore ajouter un paramètre optionnel pour permettre à
    l'URL LDAP de surcharger le type de connexion. Ce paramètre peut
    prendre l'une des valeurs suivantes :</p>

<dl>
    <dt>NONE</dt>
        <dd>Établit une connexion non sécurisée sur le port LDAP par
	défaut, ce qui est équivalent à <code>ldap://</code> sur le port
	389.</dd>
    <dt>SSL</dt>
        <dd>Établit une connexion sécurisée sur le port LDAP sécurisé
	par défaut, ce qui est équivalent à <code>ldaps://</code>.</dd>
    <dt>TLS | STARTTLS</dt>
        <dd>Établit une connexion sécurisée par élévation de niveau sur
	le port LDAP par défaut. Cette connexion sera initialisée sur le
	port 389 par défaut, puis élevée à un niveau de connexion
	sécurisée sur le même port.</dd>
</dl>

    <p>Voir plus haut pour des exemples d'URLs définies par la directive
    <directive module="mod_authnz_ldap">AuthLDAPUrl</directive>.</p>
</usage>
</directivesynopsis>

</modulesynopsis>
