<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1738542 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_access_compat.xml.meta">

<name>mod_access_compat</name>
<description>Autorisations de groupe à base de nom d'hôte (nom ou
adresse IP)</description>
<status>Extension</status>
<sourcefile>mod_access_compat.c</sourcefile>
<identifier>access_compat_module</identifier>
<compatibility>Disponible dans la version 2.3 du serveur HTTP Apache
à des fins de compatibilité
avec les précédentes versions d'Apache httpd 2.x. Les directives fournies par
ce module sont devenues obsolètes depuis la refonte d'authz. Voir
<module>mod_authz_host</module></compatibility>

<summary>
    <p>Les directives fournies par le module
    <module>mod_access_compat</module> s'utilisent dans les sections
    <directive module="core" type="section">Directory</directive>,
    <directive module="core" type="section">Files</directive> et
    <directive module="core" type="section">Location</directive>, ainsi
    que dans les fichiers <code><a
    href="core.html#accessfilename">.htaccess</a></code> et permettent
    de contrôler l'accès à certaines parties du serveur. On peut
    contrôler cet accès en fonction du nom d'hôte du client, de son
    adresse IP ou d'autres caractéristiques de la requête, telles
    qu'elles sont enregistrées dans les <a href="../env.html">variables
    d'environnement</a>. Les directives <directive
    module="mod_access_compat">Allow</directive> et <directive
    module="mod_access_compat">Deny</directive> permettent de spécifier
    quels clients sont ou ne sont pas autorisés à accéder au serveur,
    alors que la directive <directive
    module="mod_access_compat">Order</directive> définit le statut
    d'accès par défaut, et détermine la manière dont les directives
    <directive module="mod_access_compat">Allow</directive> et
    <directive module="mod_access_compat">Deny</directive> interagissent
    entre elles.</p>

    <p>Les restrictions d'accès à base de nom d'hôte et
    l'authentification à base de mot de passe peuvent être implémentées
    simultanément. Dans ce cas, on utilise la directive <directive
    module="mod_access_compat">Satisfy</directive> pour déterminer la
    manière dont ces deux modes de restrictions interagissent.</p>

    <note type="warning"><title>Note</title>
      <p>Les directives fournies par le module
      <module>mod_access_compat</module> sont devenues obsolètes depuis
      la refonte du module <module>mod_authz_host</module>. Mélanger d'anciennes
      directives comme <directive
      module="mod_access_compat">Order</directive>, <directive
      module="mod_access_compat">Allow</directive> ou <directive
      module="mod_access_compat">Deny</directive> avec des nouvelles comme
      <directive module="mod_authz_core">Require</directive> est techniquement
      possible mais déconseillé. En effet, <module>mod_access_compat</module> a
      été conçu pour supporter des configurations ne contenant que des anciennes
      directives afin de faciliter le passage à la version 2.4. Voir le document
      <a href="../upgrading.html">upgrading</a> pour plus de détails.
      </p>
    </note>

    <p>En général, les directives de restriction d'accès s'appliquent à
    toutes les méthodes d'accès (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de restreindre
    certaines méthodes, alors que les autres méthodes ne se verront
    imposée aucune restriction, en regroupant les directives à
    l'intérieur d'une section <directive module="core"
    type="section">Limit</directive>.</p>

    <note><title>Fusion des sections de configuration</title>
      <p>Lorsqu'une directive fournie par ce module est utilisée dans
      une nouvelle section de configuration, cette dernière n'hérite
      d'aucune directive définie dans une section précédente.</p>
    </note>
</summary>

<seealso><directive module="mod_authz_core">Require</directive></seealso>
<seealso><module>mod_authz_host</module></seealso>
<seealso><module>mod_authz_core</module></seealso>

<directivesynopsis>
<name>Allow</name>
<description>Spécifie quels hôtes peuvent accéder à une certaine zone du
serveur</description>
<syntax> Allow from all|<var>hôte</var>|env=[!]<var>variable
d'environnement</var>
[<var>hôte</var>|env=[!]<var>variable d'environnement</var>] ...</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>Limit</override>

<usage>
    <p>La directive <directive>Allow</directive> permet de définir quels
    hôtes ont le droit d'accéder à une certaine partie du serveur. On
    peut contrôler l'accès par nom d'hôte, adresse IP, intervalle
    d'adresses IP, ou toute autre caractéristique de la requête client
    enregistrée dans les variables d'environnement.</p>

    <p>Le premier argument de cette directive est toujours
    <code>from</code>. Les arguments suivants peuvent prendre trois
    formes différentes. Si <code>Allow from all</code> est spécifié,
    tout hôte se voit accordé l'accès, en tenant compte des directives
    <directive module="mod_access_compat">Deny</directive> et <directive
    module="mod_access_compat">Order</directive> comme décrit plus loin.
    Pour ne permettre l'accès au serveur qu'à un hôte ou un groupe
    d'hôtes particuliers, on peut spécifier un <em>nom d'hôte</em> sous
    une des formes suivantes :</p>

    <dl>
      <dt>Un nom de domaine (partiel)</dt>

      <dd>
      <highlight language="config">
Allow from example.org
Allow from .net example.edu
      </highlight>
      <p>Les hôtes dont les noms correspondent ou se terminent par la
      chaîne spécifiée ont l'autorisation d'accès. Seules les
      composantes entières du nom d'hôte doivent correspondre ; ainsi,
      dans l'exemple ci-dessus, <code>foo.example.org</code>
      correspondra, mais <code>fooexample.org</code> ne conviendra pas.
      Avec cette configuration, Apache httpd va effectuer une double recherche
      DNS sur l'adresse IP du client, sans tenir compte de la
      définition de la directive <directive
      module="core">HostnameLookups</directive>. Tout d'abord, une
      recherche DNS inverse sur l'adresse IP est effectuée pour
      déterminer le nom d'hôte associé, puis une recherche directe sur
      le nom d'hôte est effectuée afin de s'assurer qu'il correspond
      bien à l'adresse IP originale. L'accès ne sera accordé que si le
      nom d'hôte correspond et si les recherches DNS inverse et directe
      concordent.</p></dd>

      <dt>Une adresse IP complète</dt>

      <dd>
      <highlight language="config">
Allow from 10.1.2.3
Allow from 192.168.1.104 192.168.1.205
      </highlight>
      <p>L'adresse IP d'un hôte auquel on a accordé l'accès</p></dd>

      <dt>Une adresse IP partielle</dt>

      <dd>
      <highlight language="config">
Allow from 10.1
Allow from 10 172.20 192.168.2
      </highlight>
      <p>De un à trois des premiers octets d'une adresse IP, afin de
      restreindre l'accès à un sous-réseau.</p></dd>

      <dt>Une paire réseau/masque de sous-réseau</dt>

      <dd>
      <highlight language="config">
        Allow from 10.1.0.0/255.255.0.0
      </highlight>
      <p>Un réseau a.b.c.d, et un masque de sous-réseau w.x.y.z, pour
      une définition plus précise de la restriction d'accès imposée à un
      sous-réseau.</p></dd>

      <dt>Une spécification CIDR réseau/nnn</dt>

      <dd>
      <highlight language="config">
        Allow from 10.1.0.0/16
      </highlight>
      <p>Identique au cas précédent, mis à part que le masque est
      constitué des nnn bits de poids fort.</p></dd>
    </dl>

    <p>Notez que les trois derniers exemples désignent le même ensemble
    d'hôtes.</p>

    <p>On peut spécifier des adresses et sous-réseaux IPv6 de la manière
    suivante :</p>

    <highlight language="config">
Allow from 2001:db8::a00:20ff:fea7:ccea
Allow from 2001:db8::a00:20ff:fea7:ccea/10
    </highlight>

    <p>Le troisième format d'argument de la directive
    <directive>Allow</directive> permet de contrôler l'accès au serveur
    en fonction de l'existence d'une <a
    href="../env.html">variable d'environnement</a>. Lorsque <code>Allow
    from env=<var>variable d'environnement</var></code> est spécifié, la
    requête est autorisée si la variable d'environnement <var>variable
    d'environnement</var> existe. En revanche, lorsque <code>Allow from
    env=!<var>env-variable</var></code> est spécifié, la
    requête est autorisée si la variable d'environnement <var>variable
    d'environnement</var> n'existe pas. Le serveur permet de définir
    avec souplesse des variables d'environnement en se basant sur les
    caractéristiques de la requête client et en utilisant les directives
    fournies par le module <module>mod_setenvif</module>. Ainsi, on peut
    utiliser la directive <directive>Allow</directive> pour permettre
    l'accès en fonction de paramètres comme le <code>User-Agent</code>
    (type de navigateur) des clients, le <code>Referer</code>, ou
    d'autres champs d'en-tête de la requête HTTP.</p>

    <highlight language="config">
SetEnvIf User-Agent ^KnockKnock/2\.0 let_me_in
&lt;Directory "/docroot"&gt;
    Order Deny,Allow
    Deny from all
    Allow from env=let_me_in
&lt;/Directory&gt;
    </highlight>

    <p>Dans cet exemple, les navigateurs dont la chaîne user-agent
    commence par <code>KnockKnock/2.0</code> se verront accorder
    l'accès, alors que tous les autres seront rejetés.</p>

    <note><title>Fusion des sections de configuration</title>
      <p>Lorsqu'une directive fournie par ce module est utilisée dans
      une nouvelle section de configuration, cette dernière n'hérite
      d'aucune directive définie dans une section précédente.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Deny</name>
<description>Définit quels hôtes ne sont pas autorisés à accéder au
serveur</description>
<syntax> Deny from all|<var>hôte</var>|env=[!]<var>variable
d'environnement</var>
[<var>hôte</var>|env=[!]<var>variable d'environnement</var>] ...</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>Limit</override>

<usage>
    <p>Cette directive permet de restreindre l'accès au serveur en
    fonction du nom d'hôte, de l'adresse IP ou de variables
    d'environnement. Les arguments de la directive
    <directive>Deny</directive> sont identiques aux arguments de la
    directive <directive
    module="mod_access_compat">Allow</directive>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Order</name>
<description>Définit le statut d'accès par défaut et l'ordre dans lequel
les directives <directive>Allow</directive> et
<directive>Deny</directive> sont évaluées.</description>
<syntax> Order <var>ordre</var></syntax>
<default>Order Deny,Allow</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>Limit</override>

<usage>

    <p>La directive <directive>Order</directive>, associée aux
    directives <directive module="mod_access_compat">Allow</directive>
    et <directive module="mod_access_compat">Deny</directive>,
    implémente un système de contrôle d'accès en trois passes. Au cours
    de la première passe, ce sont soit toutes les directives <directive
    module="mod_access_compat">Allow</directive>, soit toutes les
    directives <directive
    module="mod_access_compat">Deny</directive> qui sont traitées, selon
    la définition de la directive <directive
    module="mod_access_compat">Order</directive>. Le reste des
    directives (<directive module="mod_access_compat">Deny</directive>
    ou <directive module="mod_access_compat">Allow</directive>) est
    traité au cours de la seconde passe. La troisième passe s'applique à
    toutes les requêtes qui ne sont concernées par aucune des deux
    premières passes.</p>

    <p>Notez que toutes les directives <directive
    module="mod_access_compat">Allow</directive> et <directive
    module="mod_access_compat">Deny</directive> sont traitées, à la
    différence d'un pare-feu classique où seule la première règle qui
    correspond est utilisée. La dernière directive qui correspond
    s'applique ( à la différence là encore d'un pare-feu classique). De
    plus, l'ordre dans lequel les lignes apparaissent dans le fichier de
    configuration n'a pas d'incidence -- toutes les lignes <directive
    module="mod_access_compat">Allow</directive> sont considérées comme
    un groupe, toutes les lignes <directive
    module="mod_access_compat">Deny</directive> comme un autre, et le
    statut par défaut a son existence propre.</p>

    <p><em>Ordre</em> peut être :</p>

    <dl>
      <dt><code>Allow,Deny</code></dt>

      <dd>Dans un premier temps, toutes les directives <directive
      module="mod_access_compat">Allow</directive> sont évaluées ; au
      moins une d'entre elles doit correspondre, sinon la requête est
      rejetée. Ensuite, toutes les directives <directive
      module="mod_access_compat">Deny</directive> sont évaluées. Si au
      moins l'une d'entre elles correspond, la requête est rejetée.
      Enfin, toute requête qui ne correspond à aucune directive
      <directive module="mod_access_compat">Allow</directive> ou
      <directive module="mod_access_compat">Deny</directive> est rejetée
      par défaut.</dd>

      <dt><code>Deny,Allow</code></dt>

      <dd>Dans un premier temps, toutes les directives <directive
      module="mod_access_compat">Deny</directive> sont évaluées ; Si au
      moins une d'entre elles correspond, la requête est rejetée,
      <strong>à moins</strong> qu'elle corresponde aussi à une directive
      <directive module="mod_access_compat">Allow</directive>. Toute
      requête qui ne correspond à aucune directive <directive
      module="mod_access_compat">Allow</directive> ou <directive
      module="mod_access_compat">Deny</directive> est autorisée.</dd>

      <dt><code>Mutual-failure</code></dt>

      <dd>Cet argument a le même effet que <code>Allow,Deny</code> et
      est devenu de ce fait obsolète.</dd>
    </dl>

    <p>Les mots-clés ne peuvent être séparés que par des virgules ;
    <em>aucun espace</em> ne doit s'intercaler entre eux.</p>

    <table border="1">
      <tr>
        <th>Match</th>
        <th>Résultat Allow,Deny</th>
        <th>Résultat Deny,Allow</th>
      </tr><tr>
        <th>Correspond à Allow seulement</th>
        <td>Requête autorisée</td>
        <td>Requête autorisée</td>
      </tr><tr>
        <th>Correspond à Deny seulement</th>
        <td>Requête rejetée</td>
        <td>Requête rejetée</td>
      </tr><tr>
        <th>Aucune correspondance</th>
        <td>Par défaut la seconde directive : rejet</td>
        <td>Par défaut la seconde directive : autorisation</td>
      </tr><tr>
        <th>Correspond à Allow &amp; Deny</th>
        <td>La dernière correspondance l'emporte : rejet</td>
        <td>La dernière correspondance l'emporte : autorisation</td>
      </tr>
    </table>

    <p>Dans cet exemple, tous les hôtes du domaine example.org ont
    l'autorisation d'accès ; tous les autres voient leur accès
    refusé.</p>

    <highlight language="config">
Order Deny,Allow
Deny from all
Allow from example.org
    </highlight>

    <p>Dans l'exemple suivant, tous les hôtes du domaine example.org ont
    l'autorisation d'accès, sauf ceux du sous-domaine foo.example.org qui
    voient leur accès refusé. Tous les hôtes qui ne sont pas dans le
    domaine example.org sont rejetés car le statut par défaut est positionné
    sur <directive
    module="mod_access_compat">Deny</directive>, et consiste donc en un
    refus d'accès.</p>

    <highlight language="config">
Order Allow,Deny
Allow from example.org
Deny from foo.example.org
    </highlight>

    <p>Par contre, si la valeur de la directive
    <directive>Order</directive>, dans l'exemple précédent, est
    <code>Deny,Allow</code>, tout le monde a l'autorisation d'accès.
    Ceci est dû au fait que <code>Allow from example.org</code> sera
    évalué en dernier, sans tenir compte de l'ordre réel dans lequel les
    directives apparaissent dans le fichier de configuration, et va
    l'emporter sur <code>Deny from foo.example.org</code>. Tout hôte qui
    n'est pas dans le domaine <code>example.org</code> aura aussi
    l'autorisation d'accès car le statut par défaut est positionné sur
    <directive
    module="mod_access_compat">Allow</directive> et constitue donc une
    autorisation d'accès.</p>

    <p>La présence d'une directive <directive>Order</directive> peut
    affecter le contrôle d'accès à une partie du serveur même en
    l'abscence de directives <directive
    module="mod_access_compat">Allow</directive> et <directive
    module="mod_access_compat">Deny</directive> associées, à cause de
    son influence sur le statut par défaut. Par exemple,</p>

    <highlight language="config">
&lt;Directory "/www"&gt;
    Order Allow,Deny
&lt;/Directory&gt;
    </highlight>

    <p>va interdire tout accès au répertoire <code>/www</code> à cause
    du statut d'accès par défaut qui est défini à <directive
    module="mod_access_compat">Deny</directive>.</p>

    <p>La directive <directive>Order</directive> ne contrôle l'ordre
    dans lequel sont traitées les directives d'accès qu'au cours de
    chaque phase du traitement de la configuration du serveur. Ceci
    implique, par exemple, qu'une directive <directive
    module="mod_access_compat">Allow</directive> ou <directive
    module="mod_access_compat">Deny</directive> située dans une section
    <directive module="core" type="section">Location</directive> sera
    toujours évaluée après une directive <directive
    module="mod_access_compat">Allow</directive> ou <directive
    module="mod_access_compat">Deny</directive> située dans une section
    <directive module="core" type="section">Directory</directive> ou un
    fichier <code>.htaccess</code>, sans tenir compte de la
    définition de la directive <directive>Order</directive>. Pour plus
    de détails à propos de la fusion des sections de configuration, voir
    le document <a
    href="../sections.html">Comment fonctionnent les sections Directory,
    Location et Files</a>.</p>

    <note><title>Fusion des sections de configuration</title>
      <p>Lorsqu'une directive fournie par ce module est utilisée dans
      une nouvelle section de configuration, cette dernière n'hérite
      d'aucune directive définie dans une section précédente.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Satisfy</name>
<description>Interaction entre le contrôle d'accès en fonction de l'hôte
et l'authentification utilisateur</description>
<syntax>Satisfy Any|All</syntax>
<default>Satisfy All</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>
<compatibility>Affecté par <directive module="core" type="section"
>Limit</directive> et <directive module="core"
type="section">LimitExcept</directive> à partir de la version
2.0.51</compatibility>
<usage>
    <p>Politique d'accès dans le cas où on utilise à la fois <directive
    module="mod_access_compat">Allow</directive> et <directive
    module="mod_authz_core">Require</directive>. L'argument est soit
    <code>All</code>, soit <code>Any</code>. L'utilisation de cette
    directive n'a de sens que si l'accès à une zone particulière du
    serveur est restreinte par utilisateur/mot de passe et en fonction
    de l'adresse IP de l'hôte client. Dans ce cas, par
    défaut (<code>All</code>), le client doit satisfaire à la
    restriction d'adresse, <em>et</em> fournir un couple
    utilisateur/mot de passe valide. Avec l'argument <code>Any</code>,
    le client se verra accorder l'accès s'il satisfait à la restriction
    d'adresse ou fournit un couple utilisateur/mot de passe valide. On
    peut utiliser cette dernière définition pour restreindre l'accès à
    une zone par mot de passe, mais accorder l'accès aux clients
    possédant certaines adresses IP sans qu'ils aient à fournir de mot
    de passe.</p>

    <p>Par exemple, si vous souhaitez que les utilisateurs de votre
    réseau accèdent à une zone de votre site web sans restriction, mais
    que l'accès à cette zone nécessite un mot de passe pour les autres
    utilisateurs, vous pouvez utiliser une configuration du style :</p>

    <highlight language="config">
Require valid-user
Allow from 192.168.1
Satisfy Any
    </highlight>

    <p>
    Une autre utilisation fréquente de la directive
    <directive>Satisfy</directive> est l'allègement des restrictions
    d'accès à un sous-répertoire par rapport aux restrictions d'accès au
    répertoire parent :
    </p>

    <highlight language="config">
&lt;Directory "/var/www/private"&gt;
    Require valid-user
&lt;/Directory&gt;

&lt;Directory "/var/www/private/public"&gt;
    Allow from all
    Satisfy Any
&lt;/Directory&gt;
    </highlight>

    <p>Dans l'exemple ci-dessus, l'accès au répertoire
    <code>/var/www/private</code> nécessitera une authentification,
    alors que l'accès au répertoire <code>/var/www/private/public</code>
    sera accordé sans restriction.</p>


    <p>Depuis la version 2.0.51, les directives
    <directive>Satisfy</directive> peuvent être restreintes à certaines
    méthodes particulières à l'aide des sections <directive
    module="core" type="section">Limit</directive> et <directive
    module="core" type="section">LimitExcept</directive>.</p>

    <note><title>Fusion des sections de configuration</title>
      <p>Lorsqu'une directive fournie par ce module est utilisée dans
      une nouvelle section de configuration, cette dernière n'hérite
      d'aucune directive définie dans une section précédente.</p>
    </note>
</usage>
   <seealso><directive module="mod_access_compat">Allow</directive></seealso>
   <seealso><directive module="mod_authz_core">Require</directive></seealso>
</directivesynopsis>

</modulesynopsis>
