<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1494953 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="apxs.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>apxs - Utilitaire pour les extensions d'Apache</title>

<summary>
    <p><code>apxs</code> est un utilitaire permettant de compiler et
    d'installer des modules en tant qu'extensions du serveur HTTP
    Apache. A cet effet, un objet dynamique partagé (DSO) est compilé à
    partir d'un ou plusieurs <var>fichiers</var> sources ou objets et
    peut être chargé pendant l'exécution du serveur Apache via la
    directive <directive module="mod_so">LoadModule</directive> du
    module <module>mod_so</module>.</p>

    <p>Pour pouvoir utiliser ce mécanisme d'extensions, votre
    plate-forme doit supporter la fonctionnalité DSO, et votre binaire
    <program>httpd</program> Apache doit être compilé avec le module
    <module>mod_so</module>. Si ce n'est pas le cas, l'utilitaire
    <code>apxs</code> vous le signalera. Vous pouvez aussi vérifier
    vous-même ces prérequis en exécutant manuellement la commande :</p>

    <example>
      $ httpd -l
    </example>

    <p>Le module <module>mod_so</module> doit faire partie de la liste
    des modules affichée. Si ces prérequis sont présents, vous pouvez
    facilement étendre les fonctionnalités de votre serveur Apache en
    installant vos propres modules à l'aide de l'utilitaire
    <code>apxs</code>, via le mécanisme DSO :</p>

    <example>
      $ apxs -i -a -c mod_foo.c<br />
      gcc -fpic -DSHARED_MODULE -I/chemin/vers/apache/include -c mod_foo.c<br />
      ld -Bshareable -o mod_foo.so mod_foo.o<br />
      cp mod_foo.so /chemin/vers/apache/modules/mod_foo.so<br />
      chmod 755 /chemin/vers/apache/modules/mod_foo.so<br />
      [activation du module `foo' dans /chemin/vers/apache/etc/httpd.conf]<br />
      $ apachectl restart<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd not running, trying to start<br />
      [Tue Mar 31 11:27:55 1998] [debug] mod_so.c(303): loaded module foo_module<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd started<br />
      $ _
    </example>

    <p>Les arguments <var>fichiers</var> peuvent correspondre à un
    fichier source C (.c), un fichier objet (.o) ou même une archive de
    bibliothèques (.a). L'utilitaire <code>apxs</code> reconnaît
    automatiquement ces extensions et utilise automatiquement les
    fichiers source C pour la compilation, et les fichiers objets et
    archives pour l'édition de liens. Cependant, si vous utilisez des
    fichiers objets précompilés, assurez-vous que leur code soit
    indépendant de la position (PIC), afin de pouvoir les utiliser avec
    un objet partagé chargé dynamiquement. Avec GCC, par exemple, il
    vous suffit de toujours utiliser l'option de compilation
    <code>-fpic</code>. Pour les autres compilateurs C, consultez leur
    page de manuel, ou vérifiez les drapeaux qu'<code>apxs</code>
    utilise pour compiler les fichiers objets.</p>

    <p>Pour plus de détails à propos du support DSO dans Apache, lire la
    documentation du module <module>mod_so</module>, ou même, consultez
    le fichier source <code>src/modules/standard/mod_so.c</code>.</p>
</summary>
<seealso><program>apachectl</program></seealso>
<seealso><program>httpd</program></seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>apxs</strong> -<strong>g</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    -<strong>n</strong> <var>nom-module</var></code></p>

    <p><code><strong>apxs</strong> -<strong>q</strong>
    [ -<strong>v</strong> ]
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    <var>requête</var> ...</code></p>

    <p><code><strong>apxs</strong> -<strong>c</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>o</strong> <var>fichier-dso</var> ]
    [ -<strong>I</strong> <var>répertoire-inc</var> ]
    [ -<strong>D</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>L</strong> <var>répertoire-lib</var> ]
    [ -<strong>l</strong> <var>nom-bibliothèque</var> ]
    [ -<strong>Wc,</strong><var>options-compilation</var> ]
    [ -<strong>Wl,</strong><var>options-edition-liens</var> ]
    <var>fichiers</var> ...</code></p>

    <p><code><strong>apxs</strong> -<strong>i</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>n</strong> <var>nom-module</var> ]
    [ -<strong>a</strong> ]
    [ -<strong>A</strong> ]
    <var>fichier-dso</var> ...</code></p>

    <p><code><strong>apxs</strong> -<strong>e</strong>
    [ -<strong>S</strong> <var>nom</var>=<var>valeur</var> ]
    [ -<strong>n</strong> <var>nom-module</var> ]
    [ -<strong>a</strong> ]
    [ -<strong>A</strong> ]
    <var>fichier-dso</var> ...</code></p>
</section>

<section id="options"><title>Options</title>
    <section id="options.common"><title>Options courantes</title>
      <dl>
      <dt><code>-n <var>nom-module</var></code></dt>
      <dd>Définit explicitement le nom du module pour les options
      <code>-i</code> (install) et <code>-g</code> (génération de
      modèles). Utilisez cette option pour spécifier de manière
      explicite le nom du module. Pour l'option <code>-g</code>, cette
      option est nécessaire ; pour l'option <code>-i</code>,
      l'utilitaire <code>apxs</code> tente de déterminer le nom du
      module à partir des sources, ou (à défaut) en le déduisant du nom
      de fichier.</dd>
      </dl>
    </section>

    <section id="options.query"><title>Options de requête</title>
      <dl>
      <dt><code>-q</code></dt>
      <dd>Effectue une requête à propos des variables et de
      l'environnement utilisés pour compiler <code>httpd</code>.
      Lorsqu'elle est invoquée sans paramètre <var>requête</var>, cette
      option affiche toutes les variables connues, ainsi que leurs
      valeurs. Le paramètre optionnel <code>-v</code> formate la liste
      affichée.

      <p>Utilisez cette option pour déterminer manuellement les options
      utilisées pour compiler le binaire <code>httpd</code> qui chargera
      votre module. Ajoutez par exemple</p>
      <example>
        INC=-I`apxs -q INCLUDEDIR`
      </example>

      <p>dans vos propres Makefiles si vous devez accéder manuellement
      aux fichiers d'en-têtes C d'Apache.</p></dd>
      </dl>
    </section>

    <section id="options.conf"><title>Options de configuration</title>
      <dl>
      <dt><code>-S <var>nom</var>=<var>valeur</var></code></dt>
      <dd>Cette option permet de modifier la configuration d'apxs
      décrite ci-dessus.</dd>
      </dl>
    </section>

    <section id="options.template"><title>Option de génération des
    modèles</title>
      <dl>
      <dt><code>-g</code></dt>
      <dd>Cette option permet de générer un sous-répertoire
      <var>nom</var> (voir option <code>-n</code>) contenant deux
      fichiers : le premier fichier est un exemple de fichier source de
      module nommé <code>mod_<var>nom</var>.c</code> que l'on peut
      utiliser comme modèle pour créer ses propres modules, ou comme
      point de départ pour se familiariser avec le mécanisme apxs ; le
      second fichier est le <code>Makefile</code> correspondant
      facilitant la compilation et l'installation de ce module.</dd>
      </dl>
    </section>
    <section id="options.dso"><title>Options de compilation DSO</title>
      <dl>
      <dt><code>-c</code></dt>
      <dd>Cette option indique une opération de compilation. Tout
      d'abord, les fichiers sources (.c) spécifiés par
      <var>fichiers</var> sont compilés en fichiers objets
      correspondants (.o), puis un objet dynamiquement partagé
      <var>fichier-dso</var> est compilé via une édition de liens de ces
      fichiers objets avec les autres fichiers objets (.o and .a)
      spécifiés par <var>fichiers</var>. Si l'option <code>-o</code>
      n'est pas spécifiée, le nom du fichier résultant est déduit du
      premier nom de fichier spécifié par <var>fichiers</var>, et ainsi
      prend en général pour valeur par défaut
      <code>mod_<var>nom</var>.so</code>.</dd>

      <dt><code>-o <var>fichier-dso</var></code></dt>
      <dd>Spécifie de manière explicite le nom de fichier de l'objet
      partagé dynamiquement créé. Sans cette option, et si le nom ne
      peut pas être déduit de la liste <var>fichiers</var>, c'est le nom
      par défaut <code>mod_unknown.so</code> qui sera utilisé.</dd>

      <dt><code>-D <var>nom</var>=<var>valeur</var></code></dt>
      <dd>Cette option est transmise directement à la commande de
      compilation. Vous pouvez l'utiliser pour ajouter vos propres
      définitions au processus de compilation. </dd>

      <dt><code>-I <var>répertoire-inc</var></code></dt>
      <dd>Cette option est transmise directement à la commande de
      compilation. Vous pouvez l'utiliser pour ajouter vos propres
      chemins de recherche des répertoires <code>include</code> au processus de
      compilation.</dd>

      <dt><code>-L <var>répertoire-lib</var></code></dt>
      <dd>Cette option est transmise directement à la commande d'édition
      de liens. Vous pouvez l'utiliser pour ajouter vos propres
      chemins de recherche des répertoires de bibliothèques au processus
      de compilation.</dd>

      <dt><code>-l <var>nom-bibliothèque</var></code></dt>
      <dd>Cette option est transmise directement à la commande d'édition
      de liens. Vous pouvez l'utiliser pour ajouter vos propres
      bibliothèques à rechercher au processus de compilation.</dd>

      <dt><code>-Wc,<var>options-compilation</var></code></dt>
      <dd>Cette option transmet les <var>options-compilation</var> en
      tant qu'options supplémentaires à la commande <code>libtool
      --mode=compile</code>. Vous pouvez l'utiliser pour ajouter des
      options locales spécifiques au compilateur.</dd>

      <dt><code>-Wl,<var>options-edition-liens</var></code></dt>
      <dd>Cette option transmet les <var>options-edition-liens</var> en
      tant qu'options supplémentaires à la commande <code>libtool
      --mode=link</code>. Vous pouvez l'utiliser pour ajouter des
      options locales spécifiques à l'éditeur de liens.</dd>
      
      <dt><code>-p</code></dt>
      <dd>Avec cette option, apxs effectue l'édition de liens avec les
      bibliothèques apr/apr-util. Elle permet de compiler les programmes
      helper qui utilisent les bibliothèques apr/apr-util.</dd>
      </dl>
    </section>

    <section id="options.dsoinstall">
    <title>Options d'installation et de configuration DSO</title>
      <dl>
      <dt><code>-i</code></dt>
      <dd>Cette option indique une opération d'installation et installe
      un ou plusieurs objets dynamiquement partagés dans le répertoire
      <var>modules</var> du serveur.</dd>

      <dt><code>-a</code></dt>
      <dd>Cette option active le module en ajoutant automatiquement une
      directive <directive module="mod_so">LoadModule</directive>
      correspondante au fichier de configuration d'Apache
      <code>httpd.conf</code>, ou en l'activant s'il existe déjà.</dd>

      <dt><code>-A</code></dt>
      <dd>Identique à l'option <code>-a</code>, à la différence que la
      directive <directive module="mod_so">LoadModule</directive> créée
      est préfixée par un caractère dièse (<code>#</code>) ; le module
      est ainsi préparé pour une activation ultérieure, mais est
      désactivé dans un premier temps.</dd>

      <dt><code>-e</code></dt>
      <dd>Cette option indique une opération d'édition de liens et peut
      être utilisée avec les options <code>-a</code> et <code>-A</code>
      de la même manière qu'au cours de l'opération d'installation pour
      éditer le fichier de configuration d'Apache
      <code>httpd.conf</code>, sans toutefois installer le module.</dd>
      </dl>
    </section>
</section>

<section id="examples"><title>Exemples</title>
    <p>Supposons que vous disposiez d'un module Apache nommé
    <code>mod_foo.c</code> et destiné à étendre les fonctionnalités du
    serveur. Pour ce faire, vous devez tout d'abord compiler le fichier
    source C en un objet partagé pouvant être chargé dans le serveur
    Apache à l'exécution, via la commande suivante :</p>

    <example>
      $ apxs -c mod_foo.c<br />
      /chemin/vers/libtool --mode=compile gcc ... -c mod_foo.c<br />
      /chemin/vers/libtool --mode=link gcc ... -o mod_foo.la mod_foo.slo<br />
      $ _
    </example>

    <p>Vous devez ensuite vérifier la configuration d'Apache en vous
    assurant qu'une directive <directive
    module="mod_so">LoadModule</directive> est bien présente pour
    charger cet objet partagé. Pour simplifier cette étape,
    <code>apxs</code> propose une méthode automatique d'installation de
    l'objet partagé dans son répertoire "modules", et de mise à jour du
    fichier <code>httpd.conf</code> en conséquence. Pour bénéficier de
    cette automatisation, utilisez la commande suivante :</p>

    <example>
      $ apxs -i -a mod_foo.la<br />
      /chemin/vers/instdso.sh mod_foo.la /chemin/vers/apache/modules<br />
      /chemin/vers/libtool --mode=install cp mod_foo.la /chemin/vers/apache/modules
      ...
      chmod 755 /chemin/vers/apache/modules/mod_foo.so<br />
      [activation du module `foo' dans /chemin/vers/apache/conf/httpd.conf]<br />
      $ _
    </example>

    <p>Une ligne contenant</p>

    <example>
      LoadModule foo_module modules/mod_foo.so
    </example>

    <p>est alors ajoutée au fichier de configuration si ce n'est pas
    déjà fait. Si vous voulez que le module soit désactivé par défaut,
    utilisez l'option <code>-A</code> comme suit :</p>

    <example>
      $ apxs -i -A mod_foo.c
    </example>

    <p>Pour un test rapide du mécanisme apxs, vous pouvez créer un
    exemple de modèle de module Apache, ainsi que le Makefile
    correspondant via :</p>

    <example>
      $ apxs -g -n foo<br />
      Creating [DIR]  foo<br />
      Creating [FILE] foo/Makefile<br />
      Creating [FILE] foo/modules.mk<br />
      Creating [FILE] foo/mod_foo.c<br />
      Creating [FILE] foo/.deps<br />
      $ _
    </example>

    <p>Vous pouvez ensuite compiler immédiatement ce module exemple en
    objet partagé et le charger dans le serveur Apache :</p>

    <example>
      $ cd foo<br />
      $ make all reload<br />
      apxs -c mod_foo.c<br />
      /chemin/vers/libtool --mode=compile gcc ... -c mod_foo.c<br />
      /chemin/vers/libtool --mode=link gcc ... -o mod_foo.la mod_foo.slo<br />
      apxs -i -a -n "foo" mod_foo.la<br />
      /chemin/vers/instdso.sh mod_foo.la /chemin/vers/apache/modules<br />
      /chemin/vers/libtool --mode=install cp mod_foo.la /chemin/vers/apache/modules
      ...
      chmod 755 /chemin/vers/apache/modules/mod_foo.so<br />
      [activation du module `foo' dans /chemin/vers/apache/conf/httpd.conf]<br />
      apachectl restart<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd not running, trying to start<br />
      [Tue Mar 31 11:27:55 1998] [debug] mod_so.c(303): loaded module foo_module<br />
      /chemin/vers/apache/sbin/apachectl restart: httpd started<br />
      $ _
    </example>

</section>
</manualpage>
