<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1645865 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="rotatelogs.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

  <title>rotatelogs - Rotation des journaux d'Apache par redirection de
  ces derniers dans un "pipe"</title>

<summary>
     <p><code>rotatelogs</code> est un programme simple à utiliser en
     conjonction avec la fonctionnalité d'Apache de redirection dans un
     "pipe" des fichiers journaux. Il supporte une rotation basée sur un
     intervalle de temps ou une taille maximale du journal.</p>
</summary>

<section id="synopsis"><title>Syntaxe</title>

     <p><code><strong>rotatelogs</strong>
     [ -<strong>l</strong> ]
     [ -<strong>L</strong> <var>nom-lien</var> ]
     [ -<strong>p</strong> <var>programme</var> ]
     [ -<strong>f</strong> ]
     [ -<strong>t</strong> ]
     [ -<strong>v</strong> ]
     [ -<strong>e</strong> ]
     [ -<strong>c</strong> ]
     [ -<strong>n</strong> <var>nombre-de-fichiers</var> ]
     <var>fichier-journal</var>
     <var>heure-de-rotation</var>|<var>taille-fichier</var>(B|K|M|G)
     [ <var>décalage</var> ]</code></p>
</section>

<section id="options"><title>Options</title>

<dl>

<dt><code>-l</code></dt>
<dd>Utilise le temps local plutôt que GMT comme base pour l'intervalle
de temps ou pour le formatage de <code>strftime(3)</code> avec une
rotation basée sur la taille.</dd>

<dt><code>-L</code> <var>nom-lien</var></dt>
<dd>Etablit un lien physique entre le fichier journal courant et le lien
spécifié. Cette option permet de consulter le journal de manière
continue malgré les rotations via une commande du style <code>tail -F
nom-lien</code>.</dd>

<dt><code>-p</code> <var>programme</var></dt>
<dd>Avec cette option, <code>rotatelogs</code> exécutera le programme
<var>programme</var> chaque fois qu'un nouveau fichier journal sera
ouvert. Le nom du fichier nouvellement ouvert est passé comme premier
argument au programme. Si l'exécution se produit après une rotation,
l'ancien nom du fichier journal est passé au programme comme second
argument. <code>rotatelogs</code>
n'attend pas la fin du <var>programme</var> pour continuer son
exécution, et cessera tout enregistrement de codes d'erreur lorsqu'il
aura terminé son processus. Le <var>programme</var> utilise les mêmes
canaux stdin, stdout, et stderr que rotatelogs, et hérite de son
environnement.</dd>

<dt><code>-f</code></dt>
<dd>Ouvre le fichier journal immédiatement, dès que
<code>rotatelogs</code> démarre, au lieu d'attendre la lecture de la
première entrée de journal (pour les sites peu chargés, il peut
s'écouler un temps substantiel entre le démarrage du serveur et le
traitement de la première requête, temps pendant lequel le fichier
journal associé n'"existe" pas, ce qui peut causer des problèmes à
certains utilitaires de journalisation automatiques).</dd>

<dt><code>-t</code></dt>
<dd>Provoque une troncature du fichier journal au lieu d'une rotation.
Cela peut s'avérer utile lorsqu'un journal est élaboré en temps réel par
une commande telle que tail, l'archivage des données n'étant ici pas
nécessaire. Si aucun suffixe n'est ajouté au nom de fichier, les
chaînes de format contenant des caractères '%' sont cependant
respectées.
</dd>

<dt><code>-v</code></dt>
<dd>Affiche une sortie verbeuse sur STDERR. La sortie contient le
résultat de l'interprétation de la configuration, ainsi que toutes les
opérations d'ouverture et de fermeture de fichiers.</dd>

<dt><code>-c</code></dt>
<dd>Crée un fichier journal pour chaque intervalle, même s'il est vide.</dd>

<dt><code>-e</code></dt>
<dd>Envoie les messages de journalisation vers stdout. Ceci s'avère
utile lorsque les journaux doivent être traités par un autre programme.</dd>

<dt><code>-n <var>nombre-de-fichiers</var></code></dt>
<dd>Utilise une liste circulaire de fichiers sans repères de temps. Avec
-n 3, la série de fichiers conservés sera "logfile",
"logfile.1", "logfile.2" avec écrasement de "logfile".
Disponible à partir de la version 2.4.5 du serveur HTTP Apache.</dd>

<dt><code><var>fichier-journal</var></code></dt>
<dd><p>Le chemin et le nom de base du fichier journal. Si
<var>fichier-journal</var> contient des caractères '%', il est considéré
comme une chaîne de formatage pour <code>strftime(3)</code>. Dans le cas
contraire, le suffixe <var>.nnnnnnnnnn</var> est automatiquement ajouté
et correspond au temps en secondes (sauf si l'option -t est spécifiée).
Les deux formats calculent le temps
de démarrage depuis le début de la période courante. Par exemple, si un
temps de rotation de 86400 est spécifié, les champs heure, minute et
seconde créés à partir du format <code>strftime(3)</code> auront tous
pour valeur 0, en référence au début de la période de 24 heures courante
(minuit).</p>
<p>Si vous utilisez le formatage de noms de fichiers
<code>strftime(3)</code>, assurez-vous que le format du fichier journal
possède une granularité suffisamment importante pour générer un nom de
fichier différent à chaque rotation des journaux. Si ce n'est pas le
cas, la rotation va écraser le fichier existant au lieu d'en générer un
nouveau. Par exemple, si <var>fichier-journal</var> était
<code>/var/log/errorlog.%Y-%m-%d</code> avec une rotation à 5
mégaoctets, et si la limite de 5 mégaoctets a été atteinte deux fois
dans la même journée, le même nom de fichier va être généré, et la
rotation va écraser le fichier existant.</p>
</dd>

<dt><code><var>temps-rotation</var></code></dt>

<dd>Le temps entre deux rotations des fichiers journaux en secondes. La
rotation intervient au début de cet intervalle. Par exemple, si le temps
de rotation est de 3600, la rotation des fichiers journaux s'effectuera
au début de chaque heure ; si le temps de rotation est de 86400, la
rotation des fichiers journaux s'effectuera chaque nuit à minuit. (Si
aucune donnée n'est enregistrée au cours d'un intervalle, aucun fichier
ne sera créé).</dd>

<dt><code><var>taille-fichier</var>(B|K|M|G)</code></dt>

<dd>La taille maximale du fichier suivie par une des lettres
<code>B</code> (Octets), <code>K</code> (KOctets), <code>M</code> (MOctets)
ou <code>G</code> (GOctets).
<p>
Lorsque temps et taille sont spécifiés, la taille doit l'être après le
temps. La rotation interviendra alors aussitôt que l'une des deux limites
(temps ou taille) sera atteinte.
</p>
</dd>

<dt><code><var>décalage</var></code></dt>

<dd>Le décalage en minutes par rapport au temps UTC. Par défaut, le
décalage est considéré comme nul et c'est le temps UTC qui est utilisé.
Par exemple, pour utiliser le temps local de la zone UTC -5 heures,
spécifiez une valeur de <code>-300</code> pour cette option. Dans la
plupart des cas, il vaut mieux utiliser l'option <code>-l</code> que
spécifier un décalage.</dd>

</dl>
</section>

<section id="examples"><title>Exemples</title>

<example>
     CustomLog "|bin/rotatelogs /var/log/fichier-journal 86400" common
</example>

     <p>Cette directive crée les fichiers /var/log/fichier-journal.nnnn
     où nnnn correspond au temps système auquel la journalisation
     démarre effectivement (ce temps sera toujours un multiple du temps
     de rotation, si bien que vous pouvez synchroniser les scripts cron
     avec lui). A la fin de chaque temps de rotation (ici après 24
     heures), une nouvelle journalisation démarre.</p>

<example>
     CustomLog "|bin/rotatelogs -l /var/log/fichier-journal.%Y.%m.%d 86400" common
</example>

     <p>Cette directive crée les fichiers
     /var/log/fichier-journal.yyyy.mm.dd où yyyy correspond à l'année,
     mm au mois et dd au jour du mois. La journalisation basculera vers
     un nouveau fichier chaque jour à minuit, temps local.</p>

<example>
     CustomLog "|bin/rotatelogs /var/log/fichier-journal 5M" common
</example>

     <p>Cette directive va effectuer une rotation du fichier journal
     chaque fois que la taille de ce dernier atteindra 5 MOctets.</p>

<example>
     ErrorLog "|bin/rotatelogs /var/log/journal-erreurs.%Y-%m-%d-%H_%M_%S 5M"
</example>
     <p>Cette directive va effectuer une rotation du fichier journal des
     erreurs chaque fois que la taille de ce dernier atteindra 5
     MOctets, et le nom du fichier journal se présentera sous
     la forme <code>journal-erreurs.YYYY-mm-dd-HH_MM_SS</code>.</p>

<example>
     CustomLog "|bin/rotatelogs -t /var/log/journal 86400" common
</example>

     <p>Cet exemple crée le fichier /var/log/journal en le tronquant
     au démarrage, puis une fois par jour. Ce scénario implique qu'un
     processus séparé (tel que tail) traite le fichier en temps
     réel.</p>

</section>

<section id="portability"><title>Portabilité</title>

<p>Les substitutions des chaînes de format du fichier journal suivantes
doivent être supportées par toutes les implémentations de
<code>strftime(3)</code> ; voir la page de manuel de
<code>strftime(3)</code> pour les extensions spécifiques à une
bibliothèque.</p>

<table border="1" style="zebra">
<tr><td><code>%A</code></td><td>nom du jour de la semaine en entier
(localisé)</td></tr>
<tr><td><code>%a</code></td><td>nom du jour de la semaine sur 3
caractères (localisé)</td></tr>
<tr><td><code>%B</code></td><td>nom du mois en entier (localisé)</td></tr>
<tr><td><code>%b</code></td><td>nom du mois sur 3 caractères (localisé)</td></tr>
<tr><td><code>%c</code></td><td>date et heure (localisé)</td></tr>
<tr><td><code>%d</code></td><td>jour du mois sur 2 chiffres</td></tr>
<tr><td><code>%H</code></td><td>heure sur 2 chiffres (de 0 à 24h)</td></tr>
<tr><td><code>%I</code></td><td>heure sur 2 chiffres (de 0 à 12h)</td></tr>
<tr><td><code>%j</code></td><td>jour de l'année sur 3 chiffres</td></tr>
<tr><td><code>%M</code></td><td>minutes sur 2 chiffres</td></tr>
<tr><td><code>%m</code></td><td>mois sur 2 chiffres</td></tr>
<tr><td><code>%p</code></td><td>suffixe am/pm pour l'heure de 0 à 12h
(localisé)</td></tr>
<tr><td><code>%S</code></td><td>secondes sur 2 chiffres</td></tr>
<tr><td><code>%U</code></td><td>semaine de l'année sur 2 chiffres
(Dimanche est le premier jour de la semaine)</td></tr>
<tr><td><code>%W</code></td><td> semaine de l'année sur 2 chiffres
(Lundi est le premier jour de la semaine)</td></tr>
<tr><td><code>%w</code></td><td>jour de la semaine sur 1 chiffre
(Dimanche est le premier jour de la semaine)</td></tr>
<tr><td><code>%X</code></td><td>heure (localisée)</td></tr>
<tr><td><code>%x</code></td><td>date (localisée)</td></tr>
<tr><td><code>%Y</code></td><td>année sur 4 chiffres</td></tr>
<tr><td><code>%y</code></td><td>année sur 2 chiffres</td></tr>
<tr><td><code>%Z</code></td><td>nom de la zone de temps</td></tr>
<tr><td><code>%%</code></td><td>caractère littéral `%'</td></tr>
</table>

</section>
</manualpage>
