<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1678567 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_mime.xml.meta">

<name>mod_mime</name>
<description>Associe les extensions des fichiers demandés avec l'action
déclenchée par ces fichiers et avec leur contenu (type MIME, langue,
jeu de caractère et codage)</description>
<status>Base</status>
<sourcefile>mod_mime.c</sourcefile>
<identifier>mime_module</identifier>

<summary>
    <p>Ce module permet d'assigner des métadonnées aux contenus
    sélectionnés pour une réponse HTTP, en associant des modèles d'URI
    ou de noms de fichiers aux valeurs des métadonnées. Par exemple, les
    extensions de noms de fichiers définissent souvent le type de médium
    Internet, la langue, le jeu de caractères et le codage du contenu.
    Ces informations sont relayées par les messages HTTP véhiculant ces
    contenus, et utilisées au cours de la négociation de contenu lors de
    la sélection des différentes possibilités, de manière à ce que les
    préférences des utilisateurs soient respectées lors du choix d'un
    contenu à servir parmi plusieurs autres contenus. Voir
    <module>mod_negotiation</module> pour plus d'informations à propos
    de la <a href="../content-negotiation.html">négociation de
    contenu</a>.</p>

    <p>Les directives <directive
    module="mod_mime">AddCharset</directive>, <directive
    module="mod_mime">AddEncoding</directive>, <directive
    module="mod_mime">AddLanguage</directive> et <directive
    module="mod_mime">AddType</directive> permettent d'associer des
    extensions de fichiers aux métadonnées de ces fichiers. Elles
    définissent respectivement le jeu de caractères, le codage du
    contenu, la langue du contenu et le <glossary>type de
    médium</glossary> (content-type) des documents. La directive
    <directive module="mod_mime">TypesConfig</directive> permet de
    spécifier un fichier qui contient lui-même des associations entre
    extensions et types de media.</p>

    <p>De plus, <module>mod_mime</module> peut définir le <a
    href="../handler.html">gestionnaire</a> et les <a
    href="../filter.html">filtres</a> qui sont à l'origine du contenu et
    le traitent. Les directives <directive
    module="mod_mime">AddHandler</directive>, <directive
    module="mod_mime">AddOutputFilter</directive>, et <directive
    module="mod_mime">AddInputFilter</directive> permettent de contrôler
    les modules ou les scripts qui vont servir le document. La directive
    <directive module="mod_mime">MultiviewsMatch</directive> permet à
    <module>mod_negotiation</module> de déterminer les extensions de
    fichiers à inclure lors des tests de correspondances multivues.</p>

    <p>Alors que <module>mod_mime</module> associe des métadonnées avec
    des extensions de fichiers, le serveur de base <module>core</module>
    fournit des directives permettant d'associer tous les fichiers d'un
    conteneur donné (par exemple <directive type="section"
    module="core">Location</directive>, <directive type="section"
    module="core">Directory</directive>, ou <directive type="section"
    module="core">Files</directive>) avec des métadonnées particulières.
    Parmi ces directives, on trouve <directive
    module="core">ForceType</directive>, <directive
    module="core">SetHandler</directive>, <directive
    module="core">SetInputFilter</directive>, et <directive
    module="core">SetOutputFilter</directive>. Les directives du serveur
    de base l'emportent sur toute directive d'association d'extensions
    de noms de fichiers définie par <module>mod_mime</module>.</p>

    <p>Notez que la modification des métadonnées d'un fichier ne modifie
    pas la valeur de l'en-tête <code>Last-Modified</code>. Ainsi,
    certaines copies de documents préalablement mises en cache peuvent
    encore être utilisées par un client ou un mandataire avec les
    anciens en-têtes. Si vous modifiez les métadonnées (langue, type de
    contenu, jeu de caractère ou codage), vous devez donc enregistrer
    une modification du fichier concerné (afin de mettre à jour sa date
    de dernière modification), pour être sûr que tous les visiteurs
    recevront le documents avec les en-têtes corrects. </p>
</summary>
<seealso><directive
module="mod_mime_magic">MimeMagicFile</directive></seealso>
<seealso><directive module="core">AddDefaultCharset</directive></seealso>
<seealso><directive module="core">ForceType</directive></seealso>
<seealso><directive module="core">SetHandler</directive></seealso>
<seealso><directive module="core">SetInputFilter</directive></seealso>
<seealso><directive module="core">SetOutputFilter</directive></seealso>

<section id="multipleext"><title>Fichiers avec extensions
multiples</title>
    <p>Les fichiers peuvent posséder plusieurs extensions dont l'ordre
    est <em>normalement</em> sans importance. Par exemple, si
    le fichier <code>welcome.html.fr</code> est associé au type de
    contenu <code>text/html</code> et à la langue française, le fichier
    <code>welcome.fr.html</code> possèdera exactement les même
    métadonnées. Si le fichier possède plusieurs extensions associées
    au même type de métadonnée, c'est celle de ces extensions la plus à
    droite qui sera utilisée, excepté pour ce qui concerne les langues
    et les codages de contenu. Par exemple, si <code>.gif</code> est
    associé au <glossary>type de médium</glossary>
    <code>image/gif</code>, et <code>.html</code> au type de médium
    <code>text/html</code>, le fichier <code>welcome.gif.html</code>
    sera associé au type de médium <code>text/html</code>.</p>

    <p>Les <a href="#charset-lang">Languages</a> et les <a
    href="#contentencoding">codages de contenu</a> sont traités de
    manière cumulative, car il est possible d'assigner plusieurs
    langues ou codages à une ressource particulière. Par exemple, le
    fichier <code>welcome.html.en.de</code> sera servi avec les en-têtes
    <code>Content-Language: en, de</code> et <code>Content-Type:
    text/html</code>.</p>

    <p>Des précautions doivent être prises lorsqu'un fichier avec
    extensions multiples est associé à la fois à un <glossary>type de
    médium</glossary> et à un gestionnaire. En général, cela impliquera
    la gestion de la requête par le module associé au gestionnaire. Par
    exemple, si l'extension <code>.imap</code> est associée au
    gestionnaire <code>imap-file</code> (du module
    <module>mod_imagemap</module>), et si l'extension <code>.html</code>
    est associée au type de médium <code>text/html</code>, le fichier
    <code>world.imap.html</code> sera à la fois associé au gestionnaire
    <code>imap-file</code> et au type de médium <code>text/html</code>.
    Pour son traitement, c'est le gestionnaire <code>imap-file</code>
    qui sera utilisé, et il sera donc traité en tant que fichier
    imagemap.</p>

    <p>Si vous préférez que seule la dernière partie d'un nom de fichier
    séparée du reste du nom par un point soit associée à une métadonnée
    particulière, n'utilisez pas les directives <code>Add*</code>. Par
    exemple, si vous souhaitez que le fichier <code>foo.html.cgi</code>
    soit traité en tant que script CGI, mais pas le fichier
    <code>bar.cgi.html</code>, alors, au lieu d'utiliser
    <code>AddHandler cgi-script .cgi</code>, utilisez plutôt :</p>

    <example><title>Configuration du gestionnaire en se basant seulement
    sur la dernière extension</title>
    <highlight language="config">
&lt;FilesMatch "[^.]+\.cgi$"&gt;
  SetHandler cgi-script
&lt;/FilesMatch&gt;
    </highlight>
    </example>

</section>

<section id="contentencoding"><title>Codage du contenu</title>
    <p>Un fichier d'un <glossary>type de médium</glossary> particulier
    peut être également codé d'une certaine manière pour simplifier sa
    transmission sur Internet. Alors que cela concerne en général la
    compression, comme <code>gzip</code>, il peut aussi s'agir de
    chiffrement, comme <code>pgp</code> ou d'un codage comme UUencoding,
    qui est conçu pour transmettre un fichier binaire sous un format
    ASCII (texte).</p>

    <p>La <a href="http://www.ietf.org/rfc/rfc2616.txt">RFC
    HTTP/1.1</a>, section 14.11 stipule à ce titre :</p>

    <blockquote cite="http://www.ietf.org/rfc/rfc2616.txt">
      <p>Le champ d'en-tête Content-Encoding de l'entité est utilisé en
      tant que modificateur du type de médium. Lorsqu'il est présent, sa
      valeur indique quels codages de contenu additionnels ont été
      appliqués au corps de l'entité, et ainsi quels mécanismes de
      décodage doivent être appliqués afin de retrouver le type de
      médium référencé par le champ d'en-tête Content-Type. Le codage de
      contenu est principalement utilisé pour permettre la compression
      d'un document sans perdre l'information concernant le type de
      médium sous-jacent.</p>
    </blockquote>

    <p>En utilisant plusieurs extensions (voir la <a
    href="#multipleext">section ci-dessus à propos des extensions de
    fichiers multiples</a>), vous pouvez indiquer qu'un fichier est d'un
    <em>type</em>, particulier, et possède aussi un <em>codage</em>
    particulier.</p>

    <p>Considérons par exemple un fichier contenant un document
    Microsoft Word et compressé par pkzip pour réduire sa taille. Si
    l'extension <code>.doc</code> est associée au type de fichier
    Microsoft Word, et si l'extension <code>.zip</code> est associée au
    codage de fichier pkzip, alors le fichier
    <code>Resume.doc.zip</code> sera identifié comme document Word
    compressé par pkzip.</p>

    <p>Apache joint un en-tête <code>Content-encoding</code> à la
    ressource afin d'informer le navigateur client à propos de la
    méthode de codage.</p>

    <highlight language="config">Content-encoding: pkzip</highlight>
</section>

<section id="charset-lang"><title>Jeux de caractères et langues</title>
    <p>En plus du type de fichier et du codage, un autre élément
    important d'information est la langue dans laquelle le document est
    écrit, et avec quel jeu de caractères le contenu du fichier doit
    être affiché. Par exemple, un document peut être écrit en alphabet
    vietnamien ou cyrillique, et doit être affiché en conséquence. Cette
    information est également transmise via des en-têtes HTTP.</p>

    <p>Les jeu de caractères, langue, codage et type MIME sont tous
    utilisés au cours du processus de négociation de contenu (voir
    <module>mod_negotiation</module>) afin de déterminer quel document
    servir au client, lorsque plusieurs choix sont possibles en fonction
    du jeu de caractères, de la langue, du codage ou du type MIME. Toutes
    les associations d'extensions de noms de fichiers créées via les
    directives <directive module="mod_mime">AddCharset</directive>,
    <directive module="mod_mime">AddEncoding</directive>, <directive
    module="mod_mime">AddLanguage</directive> et <directive
    module="mod_mime">AddType</directive> (ainsi que les associations
    d'extensions listées dans le fichier défini par la directive
    <directive module="mod_mime_magic">MimeMagicFile</directive>),
    participent à ce processus de sélection. Les extensions de noms de
    fichiers qui n'ont été associés que par des directives <directive
    module="mod_mime">AddHandler</directive>, <directive
    module="mod_mime" >AddInputFilter</directive> ou <directive
    module="mod_mime">AddOutputFilter</directive>, peuvent être incluses
    ou exclues du processus de sélection en utilisant la directive
    <directive module="mod_mime">MultiviewsMatch</directive>.</p>

    <section id="charset"><title>Jeu de caractères</title>
      <p>Pour transmettre cette information supplémentaire, Apache peut
      ajouter un en-tête <code>Content-Language</code>, afin de
      spécifier la langue dans laquelle le document est écrit, et peut
      ajouter des informations additionnelles à l'en-tête
      <code>Content-Type</code> pour indiquer le jeu de caractères
      particulier qui doit être utilisé pour restituer correctement le
      document.</p>

      <example>
        Content-Language: en, fr
Content-Type: text/plain; charset=ISO-8859-1
      </example>

      <p>La langue est spécifiée via son abréviation en deux lettres. Le
      <code>jeu de caractères</code> est le nom du jeu de caractères
      particulier qui doit être utilisé.</p>
    </section>
</section>

<directivesynopsis>
<name>AddCharset</name>
<description>Associe les extensions de noms de fichiers spécifiées au
jeu de caractères spécifié</description>
<syntax>AddCharset <var>jeu-car</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddCharset</directive> permet d'associer
    les extensions de noms de fichiers spécifiées au jeu de caractères
    spécifié (le nom enregistré sur l'Internet d'un codage de caractères
    donné). <var>jeu-car</var> est le <a
    href="http://www.iana.org/assignments/character-sets">paramètre jeu
    de caractères du type de médium</a> pour les ressources dont le nom
    de fichier contient <var>extension</var>. Cette association est
    ajoutée à toutes les autres déjà en vigueur, et écrase toute
    association préexistante pour la même <var>extension</var>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
AddLanguage ja .ja
AddCharset EUC-JP .euc
AddCharset ISO-2022-JP .jis
AddCharset SHIFT_JIS .sjis
      </highlight>
    </example>

    <p>Avec cet exemple, le document <code>xxxx.ja.jis</code> sera
    traité en tant que document japonais dont le jeu de caractère est
    <code>ISO-2022-JP</code> (idem pour le document
    <code>xxxx.jis.ja</code>). La directive
    <directive>AddCharset</directive> sert à la fois à informer le
    client sur le codage des caractères du document afin que ce dernier
    puisse être interprété et affiché correctement, et à la <a
    href="../content-negotiation.html">négociation de contenu</a>, au
    cours de laquelle le serveur décide lequel parmi plusieurs
    documents possibles il renvoie au client en fonction des préférences
    de ce dernier en matière de jeu de caractères.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>

</usage>
<seealso><module>mod_negotiation</module></seealso>
<seealso><directive module="core">AddDefaultCharset</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddEncoding</name>
<description>Associe les extensions de noms de fichiers données au type
de codage spécifié</description>
<syntax>AddEncoding <var>codage</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddEncoding</directive> permet d'associer
    les extensions de noms de fichiers données au codage de contenu HTTP
    spécifié. <var>codage</var> est le codage de contenu HTTP à ajouter
    à la valeur du champ d'en-tête Content-Encoding pour les documents
    possédant l'<var>extension</var> spécifiée. Cette association est
    ajoutée à toutes les autres déjà en vigueur, et écrase toute
    association préexistante pour la même <var>extension</var>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
AddEncoding x-gzip .gz
AddEncoding x-compress .Z
      </highlight>
    </example>

    <p>Avec cet exemple, les noms de fichiers possédant l'extension
    <code>.gz</code> seront marqués comme codés à l'aide du codage
    <code>x-gzip</code>, et les noms de fichiers possédant l'extension
    <code>.Z</code> comme codés avec <code>x-compress</code>.</p>

    <p>Les clients anciens n'acceptent que <code>x-gzip</code> et
    <code>x-compress</code>, bien que les standards stipulent qu'ils
    sont respectivement équivalents à <code>gzip</code> et
    <code>compress</code>. Apache effectue ses comparaisons de codages
    de contenu en ignorant tout préfixe <code>x-</code>. Lorsqu'il
    répond avec un codage, Apache utilise l'une ou l'autre forme (c'est
    à dire <code>x-foo</code> ou <code>foo</code>) selon les besoins du
    client. Si le client n'a pas besoin d'une forme particulière, Apache
    utilisera la forme employée par la directive
    <code>AddEncoding</code>. Pour résumer, vous devez toujours utiliser
    <code>x-gzip</code> et <code>x-compress</code> pour ces deux
    codages spécifiques. Certains codages plus récents, comme
    <code>deflate</code>, doivent être spécifiés sans le préfixe
    <code>x-</code>.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>AddHandler</name>
<description>Associe les extensions de noms de fichiers données au
gestionnaire spécifié</description>
<syntax>AddHandler <var>nom-gestionnaire</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Les fichiers dont le nom a pour extension <var>extension</var>
    seront servis par le <var><a
    href="../handler.html">nom-gestionnaire</a></var> spécifié. Cette
    association est ajoutée à toutes les autres déjà en vigueur, et
    écrase toute association préexistante pour la même
    <var>extension</var>. Par exemple, pour associer les scripts CGI
    avec l'extension de fichier <code>.cgi</code>, vous pouvez utiliser
    :</p>

    <highlight language="config">
      AddHandler cgi-script .cgi
    </highlight>

    <p>Une fois cette ligne insérée dans votre fichier httpd.conf, tout
    fichier possédant l'extension <code>.cgi</code> sera traité en tant
    que programme CGI.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>
</usage>
<seealso><directive module="core">SetHandler</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddInputFilter</name>
<description>Associe les extensions de noms de fichiers aux
filtres spécifiés qui traiteront les requêtes clients</description>
<syntax>AddInputFilter <var>filtre</var>[;<var>filtre</var>...]
<var>extension</var> [<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddInputFilter</directive> permet
    d'associer l'extension de nom de fichier <var>extension</var> aux <a
    href="../filter.html">filtres</a> spécifiés qui traiteront les
    requêtes clients et les entrées POST à leur réception par le
    serveur. Ceci s'ajoute à toute définition de filtre préexistante, y
    compris la directive <directive
    module="core">SetInputFilter</directive>. Cette
    association est ajoutée à toutes les autres déjà en vigueur, et
    écrase toute association préexistante pour la même
    <var>extension</var>.</p>

    <p>Si plusieurs <var>filtres</var> sont spécifiés, ils doivent être
    séparés par des points-virgules et inscrits dans l'ordre selon
    lequel ils devront traiter le contenu. L'argument <var>filtre</var>
    est insensible à la casse.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>

</usage>
<seealso><directive module="mod_mime">RemoveInputFilter</directive></seealso>
<seealso><directive module="core">SetInputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddLanguage</name>
<description>Associe l'extension de nom de fichier donnée à la langue
spécifié</description>
<syntax>AddLanguage <var>symbole-langue</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddLanguage</directive> permet d'associer
    l'extension de nom de fichier donnée à la langue spécifiée. Les
    fichiers dont l'extension correspond à la valeur
    de l'argument <var>extension</var> se voient attribuer la valeur de
    l'argument <var>symbole-langue</var> comme en-tête HTTP
    Content-Language en accord avec les identifiants de langues définis
    par la RFC 3066. Cette directive l'emporte sur toute association
    préexistante pour la même <var>extension</var>.</p>

    <example><title>Exemple</title>
      <highlight language="config">
AddEncoding x-compress .Z
AddLanguage en .en
AddLanguage fr .fr
      </highlight>
    </example>

    <p>Avec cet exemple, le document <code>xxxx.en.Z</code> sera traité
    en tant que document compressé de langue anglaise (idem pour le
    document <code>xxxx.Z.en</code>). Bien que la langue soit fournie au
    client, le navigateur n'utilise habituellement pas cette
    information. La directive <directive>AddLanguage</directive> est
    principalement utilisée au cours de la <a
    href="../content-negotiation.html">négociation de contenu</a>, où le
    serveur choisit d'envoyer un document parmi plusieurs documents
    possibles en fonction de la préférence du client en matière de
    langue.</p>

    <p>Si une extension fait l'objet de plusieurs associations de
    langues, c'est la dernière qui sera utilisée. Ainsi, dans le cas
    suivant,</p>

    <highlight language="config">
AddLanguage en .en
AddLanguage en-gb .en
AddLanguage en-us .en
    </highlight>

    <p>les documents possédant l'extension <code>.en</code> seront
    traités en tant que documents de langue <code>en-us</code>.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>
</usage>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddOutputFilter</name>
<description>Associe les extensions de noms de fichiers aux
filtres spécifiés qui traiteront les réponses en provenance du
serveur</description>
<syntax>AddOutputFilter <var>filtre</var>[;<var>filtre</var>...]
<var>extension</var> [<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddOutputFilter</directive> permet
    d'associer l'extension de nom de fichier définie par l'argument
    <var>extension</var> aux <a
    href="../filter.html">filtres</a> qui traiteront les réponses en
    provenance du serveur avant de les envoyer au client. Ces filtres
    s'ajoutent à tout filtre défini par d'autres directives comme
    <directive module="core">SetOutputFilter</directive> et <directive
    module="mod_filter">AddOutputFilterByType</directive>. Cette association
    est fusionnée avec toute autre association en vigueur, et l'emporte
    sur toute association préexistante pour la même
    <var>extension</var>.</p>

    <p>Avec l'exemple suivant, tous les fichiers <code>.shtml</code>
    seront traités en tant qu'inclusions côté serveur (SSI), et la
    sortie sera compressée à l'aide du module
    <module>mod_deflate</module>.</p>

    <highlight language="config">
      AddOutputFilter INCLUDES;DEFLATE shtml
    </highlight>

    <p>Si plusieurs <var>filtres</var> sont spécifiés, ils doivent être
    séparés par des points-virgules et inscrits dans l'ordre selon
    lequel il devront traiter le contenu. L'argument <var>filtre</var>
    est insensible à la casse.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>

    <p>Notez que toute définition de filtres via la directive <directive
    module="mod_mime">AddOutputFilter</directive> remplace toutes les
    définitions précédentes effectuées via cette même directive.</p>

    <highlight language="config">
# Filtre spécifié "DEFLATE"
AddOutputFilter DEFLATE shtml
&lt;Location "/foo"&gt;
  # Filtre spécifié "INCLUDES", remplace "DEFLATE"
  AddOutputFilter INCLUDES shtml
&lt;/Location&gt;
&lt;Location "/bar"&gt;
  # Filtre spécifié "INCLUDES;DEFLATE", remplace "DEFLATE"
  AddOutputFilter INCLUDES;DEFLATE shtml
&lt;/Location&gt;
&lt;Location "/bar/baz"&gt;
  # Filtre spécifié "BUFFER", remplace "INCLUDES;DEFLATE"
  AddOutputFilter BUFFER shtml
&lt;/Location&gt;
&lt;Location "/bar/baz/buz"&gt;
  # Pas de filtre spécifié, suppression de "BUFFER"
  RemoveOutputFilter shtml
&lt;/Location&gt;
    </highlight>
</usage>
<seealso><directive module="mod_mime">RemoveOutputFilter</directive></seealso>
<seealso><directive module="core">SetOutputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>AddType</name>
<description>Associe les extensions de noms de fichiers au type de
contenu spécifié</description>
<syntax>AddType <var>type-médium</var> <var>extension</var>
[<var>extension</var>] ...</syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>AddType</directive> permet d'associer les
    extensions de noms de fichiers données au type de contenu spécifié.
    <var>type-médium</var> est le <glossary ref="media-type">Type
    MIME</glossary> à utiliser pour les fichiers dont le nom possède
    l'extension <var>extension</var>. Cette association s'ajoute à toute
    autre association en vigueur, et l'emporte sur toute association
    préexistante pour la même <var>extension</var>.</p>

    <note>
      Plutôt que d'éditer directement le fichier <directive
      module="mod_mime">TypesConfig</directive>, il est recommandé
      d'utiliser la directive <directive>AddType</directive> pour
      ajouter de nouveaux types de médias.
    </note>

    <example><title>Exemple</title>
    <highlight language="config">
      AddType image/gif .gif
      </highlight>
    </example>

    <p>Ou, pour spécifier plusieurs extensions dans une seule directive
    :</p>

    <example><title>Exemple</title>
    <highlight language="config">
      AddType image/jpeg jpeg jpg jpe
      </highlight>
    </example>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial. Les noms de fichiers
    peuvent posséder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera comparé à chacune d'entre
    elles.</p>

    <p>Il est possible d'obtenir un effet similaire à celui de la
    directive <directive
    module="mod_negotiation">LanguagePriority</directive> du module
    <module>mod_negotiation</module> en qualifiant un <var>type de
    média</var> avec <code>qs</code> :</p>

    <example><title>Exemple</title>
      <highlight language="config">
      AddType application/rss+xml;qs=0.8 .xml
      </highlight>
    </example>

    <p>Ceci peut s'avérer utile dans certaines situations, par exemple
    lorsqu'un client qui a ajouté un en-tête <code>Accept: */*</code> à
    sa requête n'est pas en mesure de traiter le contenu renvoyé par le
    serveur.</p>

    <p>À la base, cette directive configure le type de contenu généré
    pour les fichiers statiques servis à partir du système de fichiers.
    Dans le cas des ressources autres que les fichiers statiques pour
    lesquelles le générateur de la réponse spécifie en général un
    Content-Type, cette directive n'a aucun effet.</p>

    <note><title>Note</title>
    <p>Si aucun gestionnaire n'est explicitement défini pour une
    requête, le type de contenu spécifié sera aussi utilisé comme nom du
    gestionnaire.</p>

    <p>Lorsqu'aucune directive comme <directive
    module="core">SetHandler</directive> ou
    <directive module="mod_mime">AddHandler</directive> ne s'applique à
    une requête, le nom de gestionnaire interne normalement défini
    par une de ces directives est en fait défini par le type de contenu
    spécifié par la présente directive.</p>
    <p>
    Pour des raisons historiques, certains modules tiers comme mod_php
    peuvent adopter ce type de comportement pour prendre en compte la
    requête concernée.
    </p>
    <p>Il est conseillé d'éviter les configurations qui reposent sur de
    tels types "synthétiques". En outre, les configurations qui
    limitent l'accès aux directives <directive
    module="core">SetHandler</directive> ou <directive
    module="mod_mime">AddHandler</directive> doivent aussi limiter
    l'accès à la directive AddType.</p>
    </note>

</usage>
<seealso><directive module="core">ForceType</directive></seealso>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>MultiviewsMatch</name>
<description>Les types de fichiers qui seront inclus lors d'une
recherche de correspondance de fichier avec les vues multiples
(MultiViews)</description>
<syntax>MultiviewsMatch Any|NegotiatedOnly|Filters|Handlers
[Handlers|Filters]</syntax>
<default>MultiviewsMatch NegotiatedOnly</default>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>MultiviewsMatch</directive> permet trois
    comportements différents pour la fonctionnalité Multiviews du module
    <a href="mod_negotiation.html">mod_negotiation</a>. Les vues
    multiples permettent d'associer une requête pour un fichier, par
    exemple <code>index.html</code>, à toute extension négociée
    s'ajoutant à la requête de base, par exemple
    <code>index.html.en</code>, <code>index.html.fr</code>, ou
    <code>index.html.gz</code>.</p>

    <p>L'option <code>NegotiatedOnly</code> implique que toute extension
    s'ajoutant au nom de base doit correspondre à une extension de
    <module>mod_mime</module> reconnue pour la négociation de contenu,
    par exemple Charset, Content-Type, Language, ou Encoding. C'est la
    valeur d'option par défaut, et la contrainte la plus stricte
    dont les effets de bord inattendus sont les moins nombreux.</p>

    <p>Pour inclure des extensions associées avec des gestionnaires
    et/ou des filtres, définissez la directive
    <directive>MultiviewsMatch</directive> avec les mots-clés
    <code>Handlers</code>, <code>Filters</code>, ou les deux. Si tous
    les autres facteurs sont égaux, c'est le fichier de plus petite
    taille qui sera servi ; par exemple, si le choix doit s'opérer entre
    <code>index.html.cgi</code> de 500 octets et
    <code>index.html.pl</code> de 1000 octets, c'est le fichier
    <code>.cgi</code> qui l'emportera dans cet exemple. Les utilisateurs
    de fichiers <code>.asis</code> auront avantage à utiliser l'option
    Handler, si les fichiers <code>.asis</code> sont associés au
    gestionnaire <code>asis-handler</code>.</p>

    <p>Vous pouvez enfin autoriser l'association de toute extension avec
    l'option <code>Any</code>, même si <module>mod_mime</module> ne
    reconnaît pas l'extension. Ceci
    peut conduire à des résultats imprévisibles, comme l'envoi de
    fichiers .old ou .bak contrairement aux souhaits du webmaster.</p>

    <p>Par exemple, la configuration suivante va permettre l'inclusion
    des extensions associées aux gestionnaires et aux filtres dans les
    vues multiples, tout en excluant les fichiers de type inconnu :</p>

    <highlight language="config">
      MultiviewsMatch Handlers Filters
    </highlight>

    <p>L'utilisation de la directive
    <directive>MultiviewsMatch</directive> dans une section <directive
    type="section" module="core">Location</directive> ou <directive
    type="section" module="core">LocationMatch</directive> n'est pas
    permise.</p>

</usage>
<seealso><directive module="core">Options</directive></seealso>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>DefaultLanguage</name>
<description>Définit un symbole de langue par défaut à affecter au champ
d'en-tête Content-Language pour toutes les ressources dans le contexte
courant auxquelles aucun symbole de langue n'a été
associé.</description>
<syntax>DefaultLanguage <var>symbole-langue</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>DefaultLanguage</directive> permet
    d'indiquer à Apache que toutes les ressources du contexte courant
    (par exemple, toutes les ressources concernées par le conteneur
    <directive module="core" type="section">Directory</directive>
    courant) qui ne possèdent pas d'extension de langue explicite
    (comme <code>.fr</code> ou <code>.de</code> tel que défini par la
    directive <directive module="mod_mime">AddLanguage</directive>),
    verront leur en-tête HTTP Content-Language affecté de la langue
    <var>symbole-langue</var>. Ceci permet de marquer des arborescences
    de répertoires entières comme contenant des documents en français,
    par exemple, sans avoir à renommer chaque fichier. Notez qu'à la
    différence de l'utilisation des extensions pour spécifier des
    langues, <directive>DefaultLanguage</directive> ne permet de
    spécifier qu'une seule langue.</p>

    <p>Si aucune directive <directive>DefaultLanguage</directive> n'est
    en vigueur, et si un fichier ne possède pas d'extension configurée
    par la directive <directive
    module="mod_mime">AddLanguage</directive>, aucun champ d'en-tête
    Content-Language ne sera généré.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      DefaultLanguage en
      </highlight>
    </example>
</usage>
<seealso><module>mod_negotiation</module></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ModMimeUsePathInfo</name>
<description>Indique à <module>mod_mime</module> de traiter les éléments
de <code>path_info</code> en tant que parties du nom de
fichier</description>
<syntax>ModMimeUsePathInfo On|Off</syntax>
<default>ModMimeUsePathInfo Off</default>
<contextlist><context>directory</context></contextlist>

<usage>
    <p>La directive <directive>ModMimeUsePathInfo</directive> permet de
    combiner le nom de fichier avec la partie <code>path_info</code> de
    l'URL pour appliquer les directives <module>mod_mime</module> à la
    requête. La valeur par défaut est <code>Off</code> - situation dans
    laquelle l'élément <code>path_info</code> est ignoré.</p>

    <p>L'utilisation de cette directive est conseillée si vous utilisez
    un système de fichiers virtuel.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ModMimeUsePathInfo On
      </highlight>
    </example>

    <p>Considérons une requête pour <code>/index.php/foo.shtml</code>,
    <module>mod_mime</module> ne traitera pas la requête entrante comme
    <code>/index.php/foo.shtml</code> et les directives comme
    <code>AddOutputFilter INCLUDES .shtml</code> ajouteront le filtre
    <code>INCLUDES</code> à la requête. Si la directive
    <directive>ModMimeUsePathInfo</directive> n'est pas définie, le
    filtre <code>INCLUDES</code> ne sera pas ajouté. Le fonctionnement
    sera identique dans le cas des chemins virtuels, tels que ceux
    définis par la directive <directive type="section">Location</directive></p>
</usage>
<seealso><directive module="core">AcceptPathInfo</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RemoveCharset</name>
<description>Supprime toute association de jeu de caractères pour un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveCharset <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveCharset</directive> permet de
    supprimer toute association de jeu de caractères pour les fichiers
    dont les noms possèdent les extensions spécifiées. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      RemoveCharset .html .shtml
      </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveEncoding</name>
<description>Supprime toute association de codage de contenu pour un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveEncoding <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveEncoding</directive> permet de
    supprimer toute association de codage pour les fichiers dont les
    noms possèdent les extensions spécifiées. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <example><title>/foo/.htaccess:</title>
      <highlight language="config">
AddEncoding x-gzip .gz
AddType text/plain .asc
&lt;Files "*.gz.asc"&gt;
    RemoveEncoding .gz
&lt;/Files&gt;
      </highlight>
    </example>

    <p>Avec cette configuration, le fichier <code>foo.gz</code> sera
    marqué comme codé avec gzip, mais <code>foo.gz.asc</code> sera
    marqué comme fichier texte non codé.</p>

    <note><title>Note</title>
      <p>Les directives <directive>RemoveEncoding</directive> étant
      traitées <em>après</em> toute directive <directive
      module="mod_mime">AddEncoding</directive>, il est possible
      qu'elles annulent les effets de ces dernières si les deux
      apparaissent dans la configuration du même répertoire.</p>
    </note>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveHandler</name>
<description>Supprime toute association de gestionnaire à un ensemble
d'extensions de noms de fichiers</description>
<syntax>RemoveHandler <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveHandler</directive> permet de
    supprimer toute association de gestionnaire à des fichiers dont le
    nom possède l'extension donnée. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <example><title>/foo/.htaccess:</title>
    <highlight language="config">
      AddHandler server-parsed .html
      </highlight>
    </example>

    <example><title>/foo/bar/.htaccess:</title>
    <highlight language="config">
      RemoveHandler .html
      </highlight>
    </example>

    <p>Avec cette dernière ligne, les fichiers <code>.html</code> du
    répertoire <code>/foo/bar</code> seront traités en tant que fichiers
    normaux, au lieu d'être traités en tant que candidats à
    l'interprétation (voir le module <module>mod_include</module>
    module).</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveInputFilter</name>
<description>Supprime toute association de filtre en entrée à un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveInputFilter <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveInputFilter</directive> permet de
    supprimer toute association de <a href="../filter.html">filtre</a>
    en entrée à des fichiers dont le nom possède l'extension donnée.
    Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>
</usage>
<seealso><directive module="mod_mime">AddInputFilter</directive></seealso>
<seealso><directive module="core">SetInputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RemoveLanguage</name>
<description>Supprime toute association de langue à un ensemble
d'extensions de noms de fichiers</description>
<syntax>RemoveLanguage <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveLanguage</directive> permet de
    supprimer toute association de langue à des fichiers dont le nom
    possède l'extension donnée. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RemoveOutputFilter</name>
<description>Supprime toute association de filtre en sortie à un
ensemble d'extensions de noms de fichiers</description>
<syntax>RemoveOutputFilter <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveOutputFilter</directive> permet de
    supprimer toute association de <a href="../filter.html">filtre</a>
    en sortie à des fichiers dont le nom possède l'extension donnée. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      RemoveOutputFilter shtml
      </highlight>
    </example>
</usage>
<seealso><directive module="mod_mime">AddOutputFilter</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>RemoveType</name>
<description>Supprime toute association de type de contenu à un ensemble
d'extensions de noms de fichiers</description>
<syntax>RemoveType <var>extension</var> [<var>extension</var>]
...</syntax>
<contextlist><context>virtual host</context><context>directory</context>
<context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>RemoveType</directive> permet de
    supprimer toute association de <glossary ref="media-type">type de
    médium</glossary> à des fichiers dont le nom possède l'extension
    donnée. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association héritée du répertoire parent ou de la configuration du
    serveur pour un répertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <example><title>/foo/.htaccess:</title>
    <highlight language="config">
      RemoveType .cgi
      </highlight>
    </example>

    <p>Cette ligne aura pour effet de supprimer tout traitement
    spécifique des fichiers <code>.cgi</code> dans le répertoire
    <code>/foo/</code> et ses sous-répertoires, et les réponses
    contenant ce type de fichier ne possèderont pas de champ d'en-tête
    HTTP Content-Type.</p>

    <note><title>Note</title>
      <p>Les directives <directive>RemoveType</directive> sont traitées
      <em>après</em> toutes les directives <directive
      module="mod_mime">AddType</directive>, et il est possible que les
      effets de ces dernières soient annulés si les deux types de
      directives sont présents au sein de la configuration du même
      répertoire.</p>
    </note>

    <p>L'argument <var>extension</var> est insensible à la casse et peut
    être spécifié avec ou sans le point initial.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>TypesConfig</name>
<description>Le chemin du fichier <code>mime.types</code></description>
<syntax>TypesConfig <var>chemin-fichier</var></syntax>
<default>TypesConfig conf/mime.types</default>
<contextlist><context>server config</context></contextlist>

<usage>
    <p>La directive <directive>TypesConfig</directive> permet de définir
    le chemin du fichier de configuration des <glossary
    ref="media-type">types de média</glossary>. L'argument
    <var>chemin-fichier</var> est un chemin relatif au répertoire défini
    par la directive <directive module="core">ServerRoot</directive>. Ce
    fichier contient la liste des associations par défaut des extensions
    de noms de fichiers aux types de contenus. La plupart des
    administrateurs utilisent le fichier <code>mime.types</code> fourni
    par leur système d'exploitation,
    qui associe les extensions de noms de fichiers courantes à la liste
    officielle des types de média enregistrés par l'IANA et maintenue à
    <a href=
    "http://www.iana.org/assignments/media-types/index.html"
    >http://www.iana.org/assignments/media-types/index.html</a>, ainsi
    qu'un grand nombre de types non officiels. Ce fichier permet de
    simplifier le fichier <code>httpd.conf</code> en fournissant la
    majorité des définitions de types de média, et ses définitions
    peuvent être écrasées par des directives <directive
    module="mod_mime">AddType</directive>, selon les besoins. Il est
    déconseillé de modifier le contenu du fichier
    <code>mime.types</code> car il peut être remplacé lors d'une mise à
    jour du serveur.</p>

    <p>Le fichier contient des lignes dont le format est identique à
    celui des arguments d'une directive <directive
    module="mod_mime">AddType</directive> :</p>

    <example>
      <var>type-médium</var> [<var>extension</var>] ...
    </example>

    <p>Les extensions sont insensibles à la casse. Les lignes vides et
    les lignes commençant par un dièse (<code>#</code>) sont
    ignorées. Les lignes vides servent à compléter le fichier
    mime.types. Apache httpd peut encore déterminer ces types via le
    module <module>mod_mime_magic</module>.</p>

    <note>
      Merci de <strong>ne pas</strong> soumettre de requêtes au Projet
      de Serveur HTTP Apache pour ajouter une entrée dans le fichier
      <code>mime.types</code> fourni, sauf si :
      1) le type de médium est déjà enregistré à l'IANA
      2) et si l'extension est largement acceptée et ne provoque pas de
      conflits d'extensions entre les différentes plate-formes. Les
      requêtes du type <code>catégorie/x-sous-type</code> seront
      systématiquement rejetées, ainsi que toute nouvelle extension de
      deux lettres, car elle ont de fortes chances d'entrer en conflit
      par la suite avec les inombrables langues préexistantes et les
      espaces de nommage des jeux de caractères.
    </note>
</usage>
<seealso><module>mod_mime_magic</module></seealso>
</directivesynopsis>

</modulesynopsis>
