"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_CHE_IMAGE = 'registry.redhat.io/codeready-workspaces/server-rhel8:2.4-14';
exports.DEFAULT_CHE_OPERATOR_IMAGE = 'registry.redhat.io/codeready-workspaces/crw-2-rhel8-operator:2.4-5';
// This image should be updated manually when needed.
// Repository location: https://github.com/che-dockerfiles/che-cert-manager-ca-cert-generator-image
exports.CA_CERT_GENERATION_JOB_IMAGE = 'quay.io/eclipse/che-cert-manager-ca-cert-generator:671342c';
exports.CERT_MANAGER_NAMESPACE_NAME = 'cert-manager';
exports.CHE_TLS_SECRET_NAME = 'che-tls';
exports.CHE_ROOT_CA_SECRET_NAME = 'self-signed-certificate';
exports.DEFAULT_CA_CERT_FILE_NAME = 'cheCA.crt';
exports.CHE_CLUSTER_CR_NAME = 'codeready-workspaces';
exports.CHE_CLUSTER_CRD = 'checlusters.org.eclipse.che';
// OLM
exports.DEFAULT_CHE_OLM_PACKAGE_NAME = 'codeready-workspaces';
exports.OLM_STABLE_CHANNEL_NAME = 'latest';
exports.DEFAULT_OPENSHIFT_MARKET_PLACE_NAMESPACE = 'openshift-marketplace';
exports.DEFAULT_OLM_KUBERNETES_NAMESPACE = 'olm';
exports.CUSTOM_CATALOG_SOURCE_NAME = 'codeready-custom-catalog-source';
exports.SUBSCRIPTION_NAME = 'codeready-subscription';
exports.OPERATOR_GROUP_NAME = 'codeready-operator-group';
exports.KUBERNETES_OLM_CATALOG = 'operatorhubio-catalog';
exports.OPENSHIFT_OLM_CATALOG = 'redhat-operators';
exports.CVS_PREFIX = 'crwoperator';
// Documentation links
exports.DOCS_LINK_INSTALL_TLS_WITH_SELF_SIGNED_CERT = 'https://www.eclipse.org/che/docs/che-7/installing-che-in-tls-mode-with-self-signed-certificates/';
exports.DOCS_LINK_IMPORT_CA_CERT_INTO_BROWSER = 'https://www.eclipse.org/che/docs/che-7/installing-che-in-tls-mode-with-self-signed-certificates/#using-che-with-tls_installing-che-in-tls-mode-with-self-signed-certificates';
exports.DOCS_LINK_AUTH_TO_CHE_SERVER_VIA_OPENID = ' https://www.eclipse.org/che/docs/che-7/authenticating-users/#authenticating-to-the-che-server-using-openid_authenticating-to-the-che-server';
exports.DOCS_LINK_HOW_TO_ADD_IDENTITY_PROVIDER_OS4 = 'https://docs.openshift.com/container-platform/latest/authentication/understanding-identity-provider.html#identity-provider-overview_understanding-identity-provider';
exports.DOCS_LINK_HOW_TO_CREATE_USER_OS3 = 'https://docs.openshift.com/container-platform/3.11/install_config/configuring_authentication.html';
//# sourceMappingURL=constants.js.map