"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash");
// eslint-disable-next-line valid-jsdoc
/**
 * mocks an object's property
 */
function default_1(object, path, value) {
    if (object === undefined || path === undefined)
        throw new Error('should not be undefined');
    return {
        run(ctx) {
            ctx.stubs = ctx.stubs || [];
            const descriptor = Object.getOwnPropertyDescriptor(object, path);
            if (descriptor && descriptor.get) {
                ctx.stubs.push(descriptor.get);
                descriptor.get = value;
                Object.defineProperty(object, path, descriptor);
            }
            else {
                ctx.stubs.push(_.get(object, path));
                _.set(object, path, value);
            }
        }, finally(ctx) {
            const stub = ctx.stubs.pop();
            const descriptor = Object.getOwnPropertyDescriptor(object, path);
            if (descriptor && descriptor.get) {
                descriptor.get = stub;
                Object.defineProperty(object, path, descriptor);
            }
            else {
                _.set(object, path, stub);
            }
        },
    };
}
exports.default = default_1;
