# Korean (ko) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987번째                                             | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5번째                                                | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987번째                                             | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5번째                                                | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1번째                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2번째                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1분기                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2분기                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1번째                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2번째                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1분기                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2분기                                                | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2번째                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7번째                                                | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | 2월                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7월                                                  | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | 2월                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7월                                                  | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2번째                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7번째                                                | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | 2월                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7월                                                  | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | 2월                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7월                                                  | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | 2                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                    | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1번째                                                | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49번째                                               | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1번째                                                | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48번째                                               | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11번째                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28번째                                               | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42번째                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365번째                                              | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | 월요일                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금요일                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1번째                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5번째                                                | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | 월요일                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금요일                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2번째                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6번째                                                | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | 월요일                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금요일                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2번째                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6번째                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | 월요일                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금요일                                               | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | 월                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 금                                                   | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 오전                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | 아침                                                 | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 저녁                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 밤                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | 아침                                                 | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 저녁                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 밤                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | 아침                                                 | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 저녁                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 밤                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | 아침                                                 | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 저녁                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 밤                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | 아침                                                 | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 오후                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 저녁                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 밤                                                   | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11번째                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11번째                                               | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11번째                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23번째                                               | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11번째                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11번째                                               | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11번째                                               | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23번째                                               | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                    | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                   | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                    | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                   | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 1987.02.11                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453.05.29                                           | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 1987.02.11                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453.05.29                                           | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 1987년 2월 11일                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453년 5월 29일                                      | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | 1987년 2월 11일 수요일                               | 1987-02-04T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453년 5월 29일 일요일                               | 1453-05-01T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                             | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 오후 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 오후 23:59:59 GMT+0                                  | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 오후 12시 13분 14초 GMT+00:00                        | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 오후 23시 59분 59초 GMT+00:00                        | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 1987.02.11 12:13                                     | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453.05.29 23:59                                     | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 1987.02.11 12:13:14                                  | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453.05.29 23:59:59                                  | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 1987년 2월 11일 오후 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453년 5월 29일 오후 23:59:59 GMT+0                  | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | 1987년 2월 11일 수요일 오후 12시 13분 14초 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453년 5월 29일 일요일 오후 23시 59분 59초 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `includeSeconds: true` | `addSuffix: true` |
| ------------------------ | -------- | ---------------------- | ----------------- |
| 2006-01-01T00:00:00.000Z | 약 6년   | 약 6년                 | 약 6년 후         |
| 2005-01-01T00:00:00.000Z | 약 5년   | 약 5년                 | 약 5년 후         |
| 2004-01-01T00:00:00.000Z | 약 4년   | 약 4년                 | 약 4년 후         |
| 2003-01-01T00:00:00.000Z | 약 3년   | 약 3년                 | 약 3년 후         |
| 2002-01-01T00:00:00.000Z | 약 2년   | 약 2년                 | 약 2년 후         |
| 2001-06-01T00:00:00.000Z | 1년 이상 | 1년 이상               | 1년 이상 후       |
| 2001-02-01T00:00:00.000Z | 약 1년   | 약 1년                 | 약 1년 후         |
| 2001-01-01T00:00:00.000Z | 약 1년   | 약 1년                 | 약 1년 후         |
| 2000-06-01T00:00:00.000Z | 5개월    | 5개월                  | 5개월 후          |
| 2000-03-01T00:00:00.000Z | 2개월    | 2개월                  | 2개월 후          |
| 2000-02-01T00:00:00.000Z | 약 1개월 | 약 1개월               | 약 1개월 후       |
| 2000-01-15T00:00:00.000Z | 14일     | 14일                   | 14일 후           |
| 2000-01-02T00:00:00.000Z | 1일      | 1일                    | 1일 후            |
| 2000-01-01T06:00:00.000Z | 약 6시간 | 약 6시간               | 약 6시간 후       |
| 2000-01-01T01:00:00.000Z | 약 1시간 | 약 1시간               | 약 1시간 후       |
| 2000-01-01T00:45:00.000Z | 약 1시간 | 약 1시간               | 약 1시간 후       |
| 2000-01-01T00:30:00.000Z | 30분     | 30분                   | 30분 후           |
| 2000-01-01T00:15:00.000Z | 15분     | 15분                   | 15분 후           |
| 2000-01-01T00:01:00.000Z | 1분      | 1분                    | 1분 후            |
| 2000-01-01T00:00:25.000Z | 1분 미만 | 30초                   | 1분 미만 후       |
| 2000-01-01T00:00:15.000Z | 1분 미만 | 20초 미만              | 1분 미만 후       |
| 2000-01-01T00:00:05.000Z | 1분 미만 | 10초 미만              | 1분 미만 후       |
| 2000-01-01T00:00:00.000Z | 1분 미만 | 5초 미만               | 1분 미만 전       |
| 1999-12-31T23:59:55.000Z | 1분 미만 | 10초 미만              | 1분 미만 전       |
| 1999-12-31T23:59:45.000Z | 1분 미만 | 20초 미만              | 1분 미만 전       |
| 1999-12-31T23:59:35.000Z | 1분 미만 | 30초                   | 1분 미만 전       |
| 1999-12-31T23:59:00.000Z | 1분      | 1분                    | 1분 전            |
| 1999-12-31T23:45:00.000Z | 15분     | 15분                   | 15분 전           |
| 1999-12-31T23:30:00.000Z | 30분     | 30분                   | 30분 전           |
| 1999-12-31T23:15:00.000Z | 약 1시간 | 약 1시간               | 약 1시간 전       |
| 1999-12-31T23:00:00.000Z | 약 1시간 | 약 1시간               | 약 1시간 전       |
| 1999-12-31T18:00:00.000Z | 약 6시간 | 약 6시간               | 약 6시간 전       |
| 1999-12-30T00:00:00.000Z | 2일      | 2일                    | 2일 전            |
| 1999-12-15T00:00:00.000Z | 17일     | 17일                   | 17일 전           |
| 1999-12-01T00:00:00.000Z | 약 1개월 | 약 1개월               | 약 1개월 전       |
| 1999-11-01T00:00:00.000Z | 2개월    | 2개월                  | 2개월 전          |
| 1999-06-01T00:00:00.000Z | 7개월    | 7개월                  | 7개월 전          |
| 1999-01-01T00:00:00.000Z | 약 1년   | 약 1년                 | 약 1년 전         |
| 1998-12-01T00:00:00.000Z | 약 1년   | 약 1년                 | 약 1년 전         |
| 1998-06-01T00:00:00.000Z | 1년 이상 | 1년 이상               | 1년 이상 전       |
| 1998-01-01T00:00:00.000Z | 약 2년   | 약 2년                 | 약 2년 전         |
| 1997-01-01T00:00:00.000Z | 약 3년   | 약 3년                 | 약 3년 전         |
| 1996-01-01T00:00:00.000Z | 약 4년   | 약 4년                 | 약 4년 전         |
| 1995-01-01T00:00:00.000Z | 약 5년   | 약 5년                 | 약 5년 전         |
| 1994-01-01T00:00:00.000Z | 약 6년   | 약 6년                 | 약 6년 전         |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------ | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6년    | 6년 후            | 52608시간                      |
| 2005-01-01T00:00:00.000Z | 5년    | 5년 후            | 43848시간                      |
| 2004-01-01T00:00:00.000Z | 4년    | 4년 후            | 35064시간                      |
| 2003-01-01T00:00:00.000Z | 3년    | 3년 후            | 26304시간                      |
| 2002-01-01T00:00:00.000Z | 2년    | 2년 후            | 17544시간                      |
| 2001-06-01T00:00:00.000Z | 1년    | 1년 후            | 12408시간                      |
| 2001-02-01T00:00:00.000Z | 1년    | 1년 후            | 9528시간                       |
| 2001-01-01T00:00:00.000Z | 1년    | 1년 후            | 8784시간                       |
| 2000-06-01T00:00:00.000Z | 5개월  | 5개월 후          | 3648시간                       |
| 2000-03-01T00:00:00.000Z | 2개월  | 2개월 후          | 1440시간                       |
| 2000-02-01T00:00:00.000Z | 1개월  | 1개월 후          | 744시간                        |
| 2000-01-15T00:00:00.000Z | 14일   | 14일 후           | 336시간                        |
| 2000-01-02T00:00:00.000Z | 1일    | 1일 후            | 24시간                         |
| 2000-01-01T06:00:00.000Z | 6시간  | 6시간 후          | 6시간                          |
| 2000-01-01T01:00:00.000Z | 1시간  | 1시간 후          | 1시간                          |
| 2000-01-01T00:45:00.000Z | 45분   | 45분 후           | 1시간                          |
| 2000-01-01T00:30:00.000Z | 30분   | 30분 후           | 1시간                          |
| 2000-01-01T00:15:00.000Z | 15분   | 15분 후           | 0시간                          |
| 2000-01-01T00:01:00.000Z | 1분    | 1분 후            | 0시간                          |
| 2000-01-01T00:00:25.000Z | 25초   | 25초 후           | 0시간                          |
| 2000-01-01T00:00:15.000Z | 15초   | 15초 후           | 0시간                          |
| 2000-01-01T00:00:05.000Z | 5초    | 5초 후            | 0시간                          |
| 2000-01-01T00:00:00.000Z | 0초    | 0초 전            | 0시간                          |
| 1999-12-31T23:59:55.000Z | 5초    | 5초 전            | 0시간                          |
| 1999-12-31T23:59:45.000Z | 15초   | 15초 전           | 0시간                          |
| 1999-12-31T23:59:35.000Z | 25초   | 25초 전           | 0시간                          |
| 1999-12-31T23:59:00.000Z | 1분    | 1분 전            | 0시간                          |
| 1999-12-31T23:45:00.000Z | 15분   | 15분 전           | 0시간                          |
| 1999-12-31T23:30:00.000Z | 30분   | 30분 전           | 1시간                          |
| 1999-12-31T23:15:00.000Z | 45분   | 45분 전           | 1시간                          |
| 1999-12-31T23:00:00.000Z | 1시간  | 1시간 전          | 1시간                          |
| 1999-12-31T18:00:00.000Z | 6시간  | 6시간 전          | 6시간                          |
| 1999-12-30T00:00:00.000Z | 2일    | 2일 전            | 48시간                         |
| 1999-12-15T00:00:00.000Z | 17일   | 17일 전           | 408시간                        |
| 1999-12-01T00:00:00.000Z | 1개월  | 1개월 전          | 744시간                        |
| 1999-11-01T00:00:00.000Z | 2개월  | 2개월 전          | 1464시간                       |
| 1999-06-01T00:00:00.000Z | 7개월  | 7개월 전          | 5136시간                       |
| 1999-01-01T00:00:00.000Z | 1년    | 1년 전            | 8760시간                       |
| 1998-12-01T00:00:00.000Z | 1년    | 1년 전            | 9504시간                       |
| 1998-06-01T00:00:00.000Z | 2년    | 2년 전            | 13896시간                      |
| 1998-01-01T00:00:00.000Z | 2년    | 2년 전            | 17520시간                      |
| 1997-01-01T00:00:00.000Z | 3년    | 3년 전            | 26280시간                      |
| 1996-01-01T00:00:00.000Z | 4년    | 4년 전            | 35064시간                      |
| 1995-01-01T00:00:00.000Z | 5년    | 5년 전            | 43824시간                      |
| 1994-01-01T00:00:00.000Z | 6년    | 6년 전            | 52584시간                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result            |
| ------------------------ | ----------------- |
| 2000-01-10T00:00:00.000Z | 2000.01.10        |
| 2000-01-05T00:00:00.000Z | 다음 수요일 00:00 |
| 2000-01-02T00:00:00.000Z | 내일 00:00        |
| 2000-01-01T00:00:00.000Z | 오늘 00:00        |
| 1999-12-31T00:00:00.000Z | 어제 00:00        |
| 1999-12-27T00:00:00.000Z | 지난 월요일 00:00 |
| 1999-12-21T00:00:00.000Z | 1999.12.21        |
