/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jboss.ant.types.Compatible;
import org.jboss.ant.types.ComponentRef;
import org.jboss.ant.types.Import;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.graph.ComponentRefVertex;
import org.jboss.ant.util.graph.Edge;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.Vertex;
import org.jboss.ant.util.graph.Visitor;
import org.jboss.ant.util.graph.VisitorListener;

public class ComponentRefDependencyVisitor
implements Visitor,
VisitorListener {
    private HashMap components = new HashMap();
    private String componentRef;

    public void beforeVisit(Graph graph, Visitor visitor, Project project) {
        project.log("beforeVisit", 3);
        this.componentRef = project.getProperty("componentRef");
    }

    public void afterVisit(Graph graph, Visitor visitor, Project project) throws BuildException {
        project.log("afterVisit, components.size=" + this.components.size() + ", keys=" + this.components.keySet(), 2);
        try {
            Iterator iter = this.components.values().iterator();
            while (iter.hasNext()) {
                Component comp = (Component)((Object)iter.next());
                Vector imports = comp.getImports();
                for (int i = 0; i < imports.size(); ++i) {
                    Import imp = (Import)((Object)imports.get(i));
                    String importRef = imp.getComponentRef();
                    if (!importRef.equalsIgnoreCase(this.componentRef)) continue;
                    project.log("Component, name: " + comp.getName() + " isCompatible with: ");
                    SortedSet versions = imp.getCompatibleVersions();
                    if (versions == null) continue;
                    Iterator viter = versions.iterator();
                    while (viter.hasNext()) {
                        Compatible c = (Compatible)viter.next();
                        project.log(c.getVersion().toString(), 2);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void visit(Graph g, Vertex v) {
        if (v instanceof ComponentRefVertex) {
            ComponentRefVertex currentVertex = (ComponentRefVertex)v;
            ComponentRef compRef = currentVertex.getComponentRef();
            Component comp = compRef.getComponent();
            this.components.put(comp.getName(), comp);
        }
    }

    public void visit(Graph g, Vertex v, Edge e) {
    }
}

