/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.jboss.ant.util.ObjectUtil;

public abstract class LoggerUtil {
    private static boolean determinedVerbose = false;
    private static boolean verbose = false;

    private static boolean isVerbose(ProjectComponent projectComponent) {
        Project project;
        if (!determinedVerbose && (project = projectComponent.getProject()) != null) {
            determinedVerbose = true;
            verbose = Boolean.valueOf(project.getProperty("org.jboss.ant.verbose"));
        }
        return verbose;
    }

    public static void info(ProjectComponent projectComponent, Object message) {
        projectComponent.log(message.toString());
    }

    public static void warn(ProjectComponent projectComponent, Object message) {
        projectComponent.log(message.toString(), 1);
    }

    public static void trace(ProjectComponent projectComponent, Object object, Object message) {
        StringBuffer buffer = new StringBuffer();
        ObjectUtil.appendObjectId(buffer, object);
        buffer.append(": ");
        buffer.append(message.toString());
        projectComponent.log(buffer.toString(), 3);
    }

    private LoggerUtil() {
    }

    public static class Logger {
        private ProjectComponent projectComponent;
        private Object object;

        public Logger(ProjectComponent projectComponent) {
            this(projectComponent, projectComponent);
        }

        public Logger(ProjectComponent projectComponent, Object object) {
            this.projectComponent = projectComponent;
            this.object = object;
        }

        public void info(Object message) {
            LoggerUtil.info(this.projectComponent, message);
        }

        public void warn(Object message) {
            LoggerUtil.warn(this.projectComponent, message);
        }

        public void trace(Object message) {
            LoggerUtil.trace(this.projectComponent, this.object, message);
        }

        public boolean isTraceEnabled() {
            return LoggerUtil.isVerbose(this.projectComponent);
        }
    }
}

