/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.build;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.jboss.ant.targets.ArtifactTarget;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.build.ArtifactType;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.util.FileUtil;

public class Artifact
extends Source {
    private Component component;
    private URL location;
    private String artifactType;
    private String release;
    private String outputPath;
    private String relativePath;
    private String filename;
    private String tofile;
    private String requiredJDK = "default";
    private boolean overwrite = false;
    private boolean exploded = false;

    public Component getComponent() {
        return this.component;
    }

    public URL getLocation() throws MalformedURLException {
        if (this.location == null) {
            URL componentLocation = this.component.getLocation();
            String path = this.getOutputPath();
            if (path != null) {
                return new URL(componentLocation + "/" + path + "/" + this.getFilename());
            }
            return new URL(componentLocation + "/" + this.getFilename());
        }
        return this.location;
    }

    public void setLocation(URL location) {
        this.location = location;
        if (this.log.isTraceEnabled()) {
            this.log.trace("SET location=" + location);
        }
    }

    public String getRelease() {
        StringBuffer sb = new StringBuffer();
        if (this.release == null) {
            return null;
        }
        String[] releases = this.release.split(", ");
        for (int i = 0; i < releases.length; ++i) {
            File root = FileUtil.resolve(this.component.getBuild().getReleaseDir(), releases[i]);
            sb.append(FileUtil.resolve(this.component.getBuild().getReleaseDir(), releases[i]));
            if (i == releases.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setRelease(String release) {
        this.release = release;
        if (this.log.isTraceEnabled()) {
            this.log.trace("SET release=" + release);
        }
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public ArtifactType getArtifactType() {
        if (this.artifactType != null) {
            return this.resolve(this.artifactType);
        }
        String name = this.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1 && dot < name.length() - 1) {
            throw new BuildException("type not set for " + this.toShortString());
        }
        String type = name.substring(dot + 1);
        return this.resolve(type);
    }

    public ArtifactType resolve(String type) {
        ArtifactType currentType = (ArtifactType)((Object)ArtifactType.getArtifactTypes().get(type));
        return currentType;
    }

    public void setType(String artifactType) {
        this.artifactType = artifactType;
    }

    public String getRelativePath() {
        if (this.relativePath != null) {
            return this.relativePath;
        }
        String componentRelativePath = this.component.getRelativePath();
        String outputPath = this.getOutputPath();
        return componentRelativePath + "/" + outputPath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public File getOutput() {
        File result = super.getOutput();
        if (result != null) {
            return result;
        }
        if (this.outputPath != null) {
            result = FileUtil.resolve(this.component.getOutput(), this.outputPath);
            return FileUtil.resolve(result, this.getFilename());
        }
        int outputType = this.getArtifactType().getOutputType();
        switch (outputType) {
            case 0: {
                return this.getOutputDir();
            }
            case 1: {
                return this.getLibraryDir();
            }
            case 2: {
                return this.getAPIDir();
            }
            case 3: {
                return this.getResourceDir();
            }
            case 4: {
                return this.getBinDir();
            }
            case 5: {
                return this.getDTDDir();
            }
            case 6: {
                return this.getSchemaDir();
            }
        }
        throw new BuildException("Unrecognised output type " + outputType);
    }

    public String getOutputPath() {
        if (this.outputPath != null) {
            return this.outputPath;
        }
        int outputType = this.getArtifactType().getOutputType();
        switch (outputType) {
            case 0: {
                return null;
            }
            case 1: {
                return this.component.getLibPath();
            }
            case 2: {
                return this.component.getAPIPath();
            }
            case 3: {
                return this.component.getResourceOutputPath();
            }
            case 4: {
                return this.component.getBinPath();
            }
            case 5: {
                return this.component.getDTDPath();
            }
            case 6: {
                return this.component.getSchemaPath();
            }
        }
        throw new BuildException("Unrecognised output type " + outputType);
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean isExploded() {
        return this.exploded;
    }

    public void setExploded(boolean exploded) {
        this.exploded = exploded;
    }

    public String getTofile() {
        return this.tofile;
    }

    public void setTofile(String tofile) {
        this.tofile = tofile;
    }

    public String getRequiredJDK() {
        return this.requiredJDK;
    }

    public void setRequiredJDK(String requiredJDK) {
        this.requiredJDK = requiredJDK;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    protected void doValidate() {
        this.component.validate();
        if (this.getId() == null) {
            throw new BuildException("Artifact has no id/name");
        }
        this.getArtifactType().validate();
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        buffer.append(" type=").append(this.artifactType);
        if (this.location != null) {
            buffer.append(" location=").append(this.location);
        }
        if (this.release != null) {
            buffer.append(" release=").append(this.release);
        }
    }

    protected void generateTargets() {
        Build build = this.component.getBuild();
        if (build.isBuild() || this.component.isStandalone()) {
            Vector definitions = build.getTargetDefinitions();
            block0: for (int i = 0; i < definitions.size(); ++i) {
                TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
                ArrayList dynamicTypes = definition.getElement("artifact");
                if (dynamicTypes == null) continue;
                for (int j = 0; j < dynamicTypes.size(); ++j) {
                    DynamicType type = (DynamicType)((Object)dynamicTypes.get(j));
                    if (!type.applies((Object)this)) continue;
                    build.addDependency(new ArtifactTarget(this, definition));
                    continue block0;
                }
            }
        }
    }

    protected void setComponent(Component component) {
        this.component = component;
    }

    protected File getOutputDir() {
        return FileUtil.resolve(this.component.getOutput(), this.getFilename());
    }

    protected File getLibraryDir() {
        return FileUtil.resolve(this.component.getLibraryDir(), this.getFilename());
    }

    protected File getAPIDir() {
        return FileUtil.resolve(this.component.getAPIDir(), this.getFilename());
    }

    protected File getResourceDir() {
        return FileUtil.resolve(this.component.getResourceDir(), this.getFilename());
    }

    protected File getBinDir() {
        return FileUtil.resolve(this.component.getBinDir(), this.getFilename());
    }

    protected File getDTDDir() {
        return FileUtil.resolve(this.component.getDTDDir(), this.getFilename());
    }

    protected File getSchemaDir() {
        return FileUtil.resolve(this.component.getSchemaDir(), this.getFilename());
    }

    protected String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        return this.getId();
    }
}

