/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.rules;

import java.util.Stack;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class XmlRule
extends MultiLineRule {
    private int LT = 60;
    private int LB = 91;
    private int GT = 62;

    public XmlRule(IToken token) {
        super("<", ">", token);
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int c = scanner.read();
        if (sequence[0] == '<') {
            if (c == 63) {
                scanner.unread();
                return false;
            }
            if (c == 33) {
                scanner.unread();
                return false;
            }
            if (c == 35) {
                scanner.unread();
                return false;
            }
        } else if (sequence[0] == '>') {
            scanner.unread();
        }
        return super.sequenceDetected(scanner, sequence, eofAllowed);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        Stack<String> stack = new Stack<String>();
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, true)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                int i = 0;
                while (i < delimiters.length) {
                    if (!(c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter)) {
                        return true;
                    }
                    ++i;
                }
            } else if (c == 34) {
                if (stack.size() > 0 && stack.peek().equals("\"")) {
                    stack.pop();
                }
            } else {
                if (c == this.LT || c == this.LB) break;
                if (c == 36) {
                    int cNext = scanner.read();
                    if (cNext == -1) break;
                    if (cNext == 123) {
                        stack.push(new String(new char[]{(char)c}));
                        scanner.unread();
                    }
                    if (stack.size() == 0) {
                        break;
                    }
                } else if (c == 125 && stack.size() > 0 && stack.peek().equals("{")) {
                    stack.pop();
                }
            }
            boolean bl = previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }
}

