/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.control;

import java.lang.annotation.Annotation;
import javax.enterprise.event.ObserverException;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.solder.exception.control.ExceptionHandled;
import org.jboss.solder.exception.control.ExceptionToCatch;

@Interceptor
@ExceptionHandled
public class ExceptionHandledInterceptor {
    @Inject
    private BeanManager bm;

    @AroundInvoke
    public Object passExceptionsToSolderCatch(InvocationContext ctx) throws Throwable {
        block7: {
            try {
                ctx.proceed();
            }
            catch (Throwable e) {
                try {
                    this.bm.fireEvent((Object)new ExceptionToCatch(e), new Annotation[0]);
                }
                catch (Exception ex) {
                    if (!ex.getClass().equals(ObserverException.class)) break block7;
                    throw ex.getCause();
                }
            }
        }
        if (ctx.getMethod().getReturnType().equals(Integer.TYPE) || ctx.getMethod().getReturnType().equals(Short.TYPE) || ctx.getMethod().getReturnType().equals(Long.TYPE) || ctx.getMethod().getReturnType().equals(Float.TYPE) || ctx.getMethod().getReturnType().equals(Byte.TYPE) || ctx.getMethod().getReturnType().equals(Double.TYPE)) {
            return 0;
        }
        if (ctx.getMethod().getReturnType().equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (ctx.getMethod().getReturnType().equals(Boolean.TYPE)) {
            return false;
        }
        return null;
    }
}

