/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.bus.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Singleton;
import org.jboss.forge.bus.cdi.BusManaged;
import org.jboss.forge.bus.event.BusEvent;
import org.jboss.forge.bus.util.Annotations;

@Singleton
public class ObserverCaptureExtension
implements Extension {
    private final Map<Class<?>, List<BusManaged>> eventQualifierMap = new HashMap();
    private int rollingIdentifier = 0;

    public void scan(@Observes ProcessAnnotatedType<Object> event) {
        AnnotatedType originalType = event.getAnnotatedType();
        ArrayList<AnnotatedMethod> obsoleteMethods = new ArrayList<AnnotatedMethod>();
        ArrayList<AnnotatedMethod> replacementMethods = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod<? super Object> method : this.getOrderedMethods((AnnotatedType<Object>)originalType)) {
            block1: for (AnnotatedParameter param : method.getParameters()) {
                if (!param.isAnnotationPresent(Observes.class)) continue;
                Set typeClosure = param.getTypeClosure();
                for (Type type : typeClosure) {
                    Type rawType;
                    if (type instanceof Class) {
                        if (!Annotations.isAnnotationPresent((Class)type, BusEvent.class)) continue;
                        replacementMethods.add(this.qualifyObservedEvent(method, param));
                        obsoleteMethods.add(method);
                        continue block1;
                    }
                    if (!(type instanceof ParameterizedType) || !((rawType = ((ParameterizedType)type).getRawType()) instanceof Class) || !Annotations.isAnnotationPresent((Class)rawType, BusEvent.class)) continue;
                    replacementMethods.add(this.qualifyObservedEvent(method, param));
                    obsoleteMethods.add(method);
                    continue block1;
                }
            }
        }
        AnnotatedType<Object> newType = this.removeMethodsFromType(originalType, obsoleteMethods);
        newType = this.addReplacementMethodsToType(newType, replacementMethods);
        event.setAnnotatedType(newType);
    }

    private List<AnnotatedMethod<? super Object>> getOrderedMethods(AnnotatedType<Object> originalType) {
        Set methods = originalType.getMethods();
        ArrayList<AnnotatedMethod<? super Object>> result = new ArrayList<AnnotatedMethod<? super Object>>();
        result.addAll(methods);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object left, Object right) {
                String lid = ((AnnotatedMethod)left).getJavaMember().toGenericString();
                String rid = ((AnnotatedMethod)right).getJavaMember().toGenericString();
                return lid.compareTo(rid);
            }
        });
        return result;
    }

    private AnnotatedType<Object> removeMethodsFromType(final AnnotatedType type, List<AnnotatedMethod> targetedMethods) {
        final HashSet methods = new HashSet();
        methods.addAll(type.getMethods());
        methods.removeAll(targetedMethods);
        return new AnnotatedType(){

            public Class getJavaClass() {
                return type.getJavaClass();
            }

            public Set<AnnotatedConstructor> getConstructors() {
                return type.getConstructors();
            }

            public Set<AnnotatedMethod> getMethods() {
                return methods;
            }

            public Set<AnnotatedField> getFields() {
                return type.getFields();
            }

            public Type getBaseType() {
                return type.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return type.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                return (T)type.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                return type.getAnnotations();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return type.isAnnotationPresent(annotationType);
            }
        };
    }

    private AnnotatedType<Object> addReplacementMethodsToType(AnnotatedType newType, List<AnnotatedMethod> replacementMethods) {
        newType.getMethods().addAll(replacementMethods);
        return newType;
    }

    private AnnotatedMethod<Object> qualifyObservedEvent(final AnnotatedMethod method, AnnotatedParameter param) {
        final ArrayList<AnnotatedParameter> parameters = new ArrayList<AnnotatedParameter>();
        parameters.addAll(method.getParameters());
        parameters.set(parameters.indexOf(param), this.addUniqueQualifier(method, param));
        parameters.remove(param);
        return new AnnotatedMethod(){

            public List<AnnotatedParameter> getParameters() {
                return parameters;
            }

            public AnnotatedType<Object> getDeclaringType() {
                return method.getDeclaringType();
            }

            public boolean isStatic() {
                return method.isStatic();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotation) {
                return (T)method.getAnnotation(annotation);
            }

            public Set<Annotation> getAnnotations() {
                return method.getAnnotations();
            }

            public Type getBaseType() {
                return method.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return method.getTypeClosure();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
                return method.isAnnotationPresent(annotation);
            }

            public Method getJavaMember() {
                return method.getJavaMember();
            }
        };
    }

    private AnnotatedParameter addUniqueQualifier(AnnotatedMethod method, final AnnotatedParameter param) {
        final String identifier = String.valueOf(this.rollingIdentifier++);
        final String methodName = method.getJavaMember().getName();
        final BusManaged qualifier = new BusManaged(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return BusManaged.class;
            }

            @Override
            public String value() {
                return identifier;
            }

            @Override
            public String method() {
                return methodName;
            }
        };
        this.addQualifierToMap(method, param, qualifier);
        final HashSet<4> annotations = new HashSet<4>();
        annotations.addAll(param.getAnnotations());
        annotations.add(qualifier);
        return new AnnotatedParameter<Object>(){

            public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                if (BusManaged.class.isAssignableFrom(clazz)) {
                    return (T)qualifier;
                }
                return (T)param.getAnnotation(clazz);
            }

            public Set<Annotation> getAnnotations() {
                return annotations;
            }

            public Type getBaseType() {
                return param.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return param.getTypeClosure();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
                if (BusManaged.class.isAssignableFrom(clazz)) {
                    return true;
                }
                return param.isAnnotationPresent(clazz);
            }

            public AnnotatedCallable<Object> getDeclaringCallable() {
                return param.getDeclaringCallable();
            }

            public int getPosition() {
                return param.getPosition();
            }
        };
    }

    private void addQualifierToMap(AnnotatedMethod annotatedMethod, AnnotatedParameter param, BusManaged qualifier) {
        Method method = annotatedMethod.getJavaMember();
        Class<?> clazz = method.getParameterTypes()[param.getPosition()];
        List<BusManaged> qualifiers = this.eventQualifierMap.get(clazz);
        if (qualifiers == null) {
            qualifiers = new ArrayList<BusManaged>();
        }
        qualifiers.add(qualifier);
        this.eventQualifierMap.put(clazz, qualifiers);
    }

    public List<BusManaged> getEventQualifiers(Class<?> clazz) {
        ArrayList<BusManaged> result = new ArrayList<BusManaged>();
        for (Map.Entry<Class<?>, List<BusManaged>> entry : this.eventQualifierMap.entrySet()) {
            Class<?> key = entry.getKey();
            List<BusManaged> value = entry.getValue();
            if (!key.isAssignableFrom(clazz)) continue;
            result.addAll(value);
        }
        return result;
    }

    public Map<Class<?>, List<BusManaged>> getEventQualifierMap() {
        return this.eventQualifierMap;
    }
}

