/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.validation;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.spec.javaee.ValidationFacet;
import org.jboss.forge.spec.javaee.validation.completer.PropertyCompleter;
import org.jboss.forge.spec.javaee.validation.util.JavaHelper;
import org.jboss.forge.spec.javaee.validation.util.ResourceHelper;

@Alias(value="constraint")
@RequiresResource(value={JavaResource.class})
@RequiresFacet(value={ValidationFacet.class, JavaSourceFacet.class})
public class PropertyConstraintPlugin
implements Plugin {
    private final JavaSourceFacet javaSourceFacet;
    private final Shell shell;

    @Inject
    public PropertyConstraintPlugin(Project project, Shell shell) {
        this.javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.shell = shell;
    }

    @Command(value="Valid", help="Adds @Valid constraint on the specified property")
    public void addValidConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor) throws FileNotFoundException {
        Annotation<JavaClass> constraint = this.addConstraintOnProperty(property, onAccessor, Valid.class);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraint.getOrigin());
        this.outputConstraintAdded(property, Valid.class);
    }

    @Command(value="Null", help="Adds @Null constraint on the specified property")
    public void addNullConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraint = this.addConstraintOnProperty(property, onAccessor, Null.class);
        this.setConstraintMessage(constraint, message);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraint.getOrigin());
        this.outputConstraintAdded(property, Null.class);
    }

    @Command(value="NotNull", help="Adds @NotNull constraint on the specified property")
    public void addNotNullConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, NotNull.class);
        this.setConstraintMessage(constraintAnnotation, message);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, NotNull.class);
    }

    @Command(value="AssertTrue", help="Adds @AssertTrue constraint on the specified property")
    public void addAssertTrueConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, AssertTrue.class);
        this.setConstraintMessage(constraintAnnotation, message);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, AssertTrue.class);
    }

    @Command(value="AssertFalse", help="Adds @AssertFalse constraint on the specified property")
    public void addAssertFalseConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, AssertFalse.class);
        this.setConstraintMessage(constraintAnnotation, message);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, AssertFalse.class);
    }

    @Command(value="Min", help="Adds @Min constraint on the specified property")
    public void addMinConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="min", required=true) long min, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Min.class);
        this.setConstraintMessage(constraintAnnotation, message);
        constraintAnnotation.setLiteralValue(String.valueOf(min));
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Min.class);
    }

    @Command(value="Max", help="Adds @Max constraint on the specified property")
    public void addMaxConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="max", required=true) long max, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Max.class);
        this.setConstraintMessage(constraintAnnotation, message);
        constraintAnnotation.setLiteralValue(String.valueOf(max));
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Max.class);
    }

    @Command(value="DecimalMin", help="Adds @DecimalMin constraint on the specified property")
    public void addDecimalMinConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="min", required=true) String min, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, DecimalMin.class);
        this.setConstraintMessage(constraintAnnotation, message);
        constraintAnnotation.setStringValue(min);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, DecimalMin.class);
    }

    @Command(value="DecimalMax", help="Adds @DecimalMax constraint on the specified property")
    public void addDecimalMaxConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="max", required=true) String max, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, DecimalMax.class);
        this.setConstraintMessage(constraintAnnotation, message);
        constraintAnnotation.setStringValue(max);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, DecimalMax.class);
    }

    @Command(value="Size", help="Adds @Size constraint on the specified property")
    public void addSizeConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="min") Integer min, @Option(name="max") Integer max, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Size.class);
        this.setConstraintMessage(constraintAnnotation, message);
        if (min != null) {
            constraintAnnotation.setLiteralValue("min", String.valueOf(min));
        }
        if (max != null) {
            constraintAnnotation.setLiteralValue("max", String.valueOf(max));
        }
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Size.class);
    }

    @Command(value="Digits", help="Adds @Digits constraint on the specified property")
    public void addDigitsConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="integer", required=true) int integer, @Option(name="fraction", required=true) int fraction, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Digits.class);
        this.setConstraintMessage(constraintAnnotation, message);
        constraintAnnotation.setLiteralValue("integer", String.valueOf(integer));
        constraintAnnotation.setLiteralValue("fraction", String.valueOf(fraction));
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Digits.class);
    }

    @Command(value="Past", help="Adds @Past constraint on the specified property")
    public void addPastConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Past.class);
        this.setConstraintMessage(constraintAnnotation, message);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Past.class);
    }

    @Command(value="Future", help="Adds @Future constraint on the specified property")
    public void addFutureConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Future.class);
        this.setConstraintMessage(constraintAnnotation, message);
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Future.class);
    }

    @Command(value="Pattern", help="Adds @Pattern constraint on the specified property")
    public void addPatternConstraint(@Option(name="onProperty", completer=PropertyCompleter.class, required=true) String property, @Option(name="onAccessor", flagOnly=true) boolean onAccessor, @Option(name="regexp", required=true) String regexp, @Option(name="flags") Pattern.Flag[] flags, @Option(name="message") String message, @Option(name="groups", type=PromptType.JAVA_CLASS) String[] groups) throws FileNotFoundException {
        Annotation<JavaClass> constraintAnnotation = this.addConstraintOnProperty(property, onAccessor, Pattern.class);
        this.setConstraintMessage(constraintAnnotation, message);
        constraintAnnotation.setStringValue("regexp", regexp);
        if (flags != null) {
            ((JavaClass)constraintAnnotation.getOrigin()).addImport(Pattern.Flag.class);
            String flagPrefix = Pattern.Flag.class.getSimpleName() + ".";
            StringBuilder flagsLiteral = new StringBuilder().append('{');
            for (int i = 0; i < flags.length; ++i) {
                flagsLiteral.append(flagPrefix + flags[i]);
                if (i >= flags.length - 1) continue;
                flagsLiteral.append(",");
            }
            flagsLiteral.append('}');
            constraintAnnotation.setStringValue("flags", flagsLiteral.toString());
        }
        this.javaSourceFacet.saveJavaSource((JavaSource)constraintAnnotation.getOrigin());
        this.outputConstraintAdded(property, Pattern.class);
    }

    private Annotation<JavaClass> addConstraintOnProperty(String property, boolean onAccessor, Class<? extends java.lang.annotation.Annotation> annotationClass) throws FileNotFoundException {
        Resource currentResource = this.shell.getCurrentResource();
        JavaClass clazz = ResourceHelper.getJavaClassFromResource(currentResource);
        Method<JavaClass> field = clazz.getField(property);
        if (field == null) {
            throw new IllegalStateException("The current class has no property named '" + property + "'");
        }
        Method<JavaClass> member = field;
        if (onAccessor) {
            Method<JavaClass> accessor = JavaHelper.getFieldAccessor((Field<JavaClass>)field);
            if (accessor == null) {
                throw new IllegalStateException("The property named '" + property + "' has no accessor");
            }
            member = accessor;
        }
        if (member.hasAnnotation(annotationClass)) {
            throw new IllegalStateException("The element '" + member.getName() + "' is already annotated with @" + annotationClass.getSimpleName());
        }
        return member.addAnnotation(annotationClass);
    }

    private void setConstraintMessage(Annotation<JavaClass> annotation, String message) {
        if (message != null) {
            annotation.setStringValue("message", message);
        }
    }

    private void outputConstraintAdded(String property, Class<? extends java.lang.annotation.Annotation> constraintClass) {
        this.shell.println("Constraint " + constraintClass.getSimpleName() + " has been successfully added on property named '" + property + "'\n");
    }
}

