/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.UiPlugin;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ElementsFactory;
import org.jboss.tools.hibernate.ui.diagram.editors.model.MessageShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramRuler;
import org.jboss.tools.hibernate.ui.view.OrmLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmDiagram
extends BaseElement {
    public static final String HIBERNATE_MAPPING_LAYOUT_FOLDER_NAME = "hibernateMapping";
    public static final String DIRTY = "dirty";
    public static final String AUTOLAYOUT = "autolayout";
    public static final String DEEPINTOSORT = "deepIntoSort";
    protected String consoleConfigName;
    protected ArrayList<RootClass> roots = new ArrayList();
    protected ArrayList<String> entityNames = new ArrayList();
    private boolean dirty = false;
    protected HashMap<String, OrmShape> elements = new HashMap();
    protected ArrayList<Connection> connections = new ArrayList();
    protected OrmLabelProvider labelProvider = new OrmLabelProvider();
    protected boolean connectionsVisibilityClassMapping = true;
    protected boolean connectionsVisibilityPropertyMapping = true;
    protected boolean connectionsVisibilityAssociation = true;
    protected boolean connectionsVisibilityForeignKeyConstraint = true;
    protected DiagramRuler leftRuler;
    protected DiagramRuler topRuler;
    protected boolean rulersVisibility = false;
    protected boolean snapToGeometry = false;
    protected boolean gridEnabled = false;
    protected double zoom = 1.0;
    protected int width = 0;
    protected int height = 0;
    protected float fontHeight = 8.5f;
    protected boolean deepIntoSort = false;
    protected boolean flagManhattanConnectionRouter = true;
    private boolean fileLoadSuccessfull = false;
    private IMemento memento = null;
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_WIDTH = "width";
    private static final String PROPERTY_HEIGHT = "height";
    private static final String PROPERTY_ZOOM = "zoom";
    private static final String PROPERTY_ITEMS = "items";
    private static final String PROPERTY_ENTITIES = "entities";
    private static final String PROPERTY_TABLES = "tables";
    private static final String PROPERTY_INVISIBLE = "invisible";
    private static IPropertyDescriptor[] descriptors_diagram = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", "name"), new TextPropertyDescriptor((Object)"width", "width"), new TextPropertyDescriptor((Object)"height", "height"), new TextPropertyDescriptor((Object)"zoom", "zoom"), new TextPropertyDescriptor((Object)"items", "items"), new TextPropertyDescriptor((Object)"entities", "entities"), new TextPropertyDescriptor((Object)"tables", "tables"), new TextPropertyDescriptor((Object)"invisible", "invisible")};

    public OrmDiagram(String consoleConfigName, ArrayList<RootClass> rts) {
        this.initFontHeight();
        this.createRulers();
        this.consoleConfigName = consoleConfigName;
        this.getConsoleConfig();
        this.labelProvider.setConsoleConfigName(consoleConfigName);
        this.roots.addAll(rts);
        Collections.sort(this.roots, new RootClassComparator());
        this.entityNames.clear();
        int i = 0;
        while (i < this.roots.size()) {
            this.entityNames.add(this.getItemFullName(this.roots.get(i)));
            ++i;
        }
        this.recreateChildren();
        this.sortChildren(this.deepIntoSort);
        if (consoleConfigName.length() > 0) {
            this.loadFromXmlFile();
        }
        this.refreshDiagramElements();
        this.setDirty(false);
    }

    public String getDiagramName() {
        String name = "";
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < this.entityNames.size()) {
            names.add(this.getItemName(this.entityNames.get(i)));
            ++i;
        }
        Collections.sort(names);
        name = String.valueOf(this.consoleConfigName) + ":";
        name = String.valueOf(name) + (names.size() > 0 ? " " + (String)names.get(0) : "");
        if (names.size() > 1) {
            name = names.size() == 2 ? String.valueOf(name) + " and " + (String)names.get(1) : String.valueOf(name) + " and " + (names.size() - 1) + " others";
        }
        return name;
    }

    protected String getItemFullName(RootClass rootClass) {
        if (rootClass == null) {
            return "";
        }
        String res = rootClass.getEntityName();
        if (res == null) {
            res = rootClass.getClassName();
        }
        if (res == null) {
            res = rootClass.getNodeName();
        }
        return res;
    }

    protected String getItemName(String name) {
        String res = name;
        return res.substring(res.lastIndexOf(".") + 1);
    }

    protected String getItemName(RootClass rootClass) {
        return this.getItemName(this.getItemFullName(rootClass));
    }

    public void recreateChildren() {
        this.deleteChildren();
        this.elements.clear();
        this.connections.clear();
        StringBuilder errorMessage = new StringBuilder();
        Configuration config = this.getConfig(errorMessage);
        ElementsFactory factory = new ElementsFactory(this.consoleConfigName, this.elements, this.connections);
        int i = 0;
        while (i < this.roots.size()) {
            RootClass rc = this.roots.get(i);
            if (rc != null) {
                factory.getOrCreatePersistentClass((PersistentClass)rc, null);
            }
            ++i;
        }
        this.updateChildrenList();
        factory.createChildren(this);
        factory.createForeingKeyConnections();
        this.updateChildrenList();
        if (this.getChildrenNumber() == 0) {
            String error = DiagramViewerMessages.MessageShape_warning;
            if (config != null && this.consoleConfigName != null && this.consoleConfigName.length() > 0) {
                error = this.consoleConfigName;
                error = String.valueOf(error) + ": ";
                error = String.valueOf(error) + DiagramViewerMessages.Diagram_no_items_or_incorrect_state;
            }
            if (errorMessage.length() > 0) {
                error = errorMessage.toString();
            }
            this.addChild(new MessageShape(error, this.getConsoleConfigName()));
        }
    }

    protected void updateChildrenList() {
        for (OrmShape ormShape : this.elements.values()) {
            this.addChild(ormShape);
        }
    }

    protected void refreshDiagramElements() {
        for (OrmShape ormShape : this.elements.values()) {
            ormShape.refresh();
        }
        int i = 0;
        while (i < this.connections.size()) {
            this.connections.get(i).refresh();
            ++i;
        }
    }

    @Override
    public void cleanupSelection() {
        for (OrmShape ormShape : this.elements.values()) {
            ormShape.cleanupSelection();
        }
        int i = 0;
        while (i < this.connections.size()) {
            this.connections.get(i).cleanupSelection();
            ++i;
        }
    }

    protected void createRulers() {
        this.leftRuler = new DiagramRuler(false);
        this.topRuler = new DiagramRuler(true);
    }

    @Override
    public BaseElement getParent() {
        return null;
    }

    public IPath getStoreFolderPath() {
        IPath storePath = null;
        ConsoleConfiguration consoleConfig = this.getConsoleConfig();
        IJavaProject javaProject = ProjectUtils.findJavaProject((ConsoleConfiguration)consoleConfig);
        storePath = javaProject != null && javaProject.getProject() != null ? javaProject.getProject().getLocation() : UiPlugin.getDefault().getStateLocation();
        return storePath.append(".settings").append(HIBERNATE_MAPPING_LAYOUT_FOLDER_NAME);
    }

    public IPath getStoreFilePath() {
        return this.getStoreFolderPath().append(this.getStoreFileName());
    }

    public String getStoreFileName() {
        StringBuilder name = new StringBuilder();
        int i = 0;
        while (i < this.entityNames.size()) {
            name.append("_");
            name.append(this.getItemName(this.entityNames.get(i)));
            ++i;
        }
        String res = String.valueOf(this.getConsoleConfigName()) + name.toString();
        if (res.length() > 64) {
            res = String.valueOf(this.getConsoleConfigName()) + "_" + OrmDiagram.md5sum(name.toString());
        }
        return res;
    }

    public static final String md5sum(String input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        if (md == null || input == null) {
            return input;
        }
        StringBuffer sbuf = new StringBuffer();
        byte[] raw = md.digest(input.getBytes());
        int i = 0;
        while (i < raw.length) {
            int c = raw[i];
            if (c < 0) {
                c = Math.abs(c) - 1 ^ 0xFF;
            }
            String block = String.valueOf(OrmDiagram.toHex(c >>> 4)) + OrmDiagram.toHex(c & 0xF);
            sbuf.append(block);
            ++i;
        }
        return sbuf.toString();
    }

    private static final String toHex(int s) {
        if (s < 10) {
            return String.valueOf((char)(48 + s));
        }
        return String.valueOf((char)(97 + (s - 10)));
    }

    public HashMap<String, OrmShape> getCloneElements() {
        return (HashMap)this.elements.clone();
    }

    public RootClass getOrmElement(int idx) {
        if (idx < 0 || idx >= this.roots.size()) {
            return null;
        }
        return this.roots.get(idx);
    }

    public boolean refreshRootsFromNames() {
        Configuration config = this.getConfig();
        if (config == null) {
            return false;
        }
        int i = 0;
        while (i < this.roots.size()) {
            RootClass newOrmElement = (RootClass)config.getClassMapping(this.entityNames.get(i));
            if (!(this.roots.get(i) == null ? newOrmElement == null : this.roots.get(i).equals(newOrmElement))) {
                this.roots.set(i, newOrmElement);
            }
            ++i;
        }
        return true;
    }

    @Override
    public void refresh() {
        this.refreshRootsFromNames();
        Properties properties = new Properties();
        if (this.memento == null) {
            this.saveInProperties(properties);
        }
        this.recreateChildren();
        this.sortChildren(this.deepIntoSort);
        if (this.memento == null) {
            this.loadFromProperties(properties);
        } else {
            this.loadState(this.memento);
        }
        this.refreshDiagramElements();
        this.updateDirty(this.memento == null);
        if (this.memento != null && this.getConsoleConfig() != null) {
            this.memento = null;
        }
        super.refresh();
    }

    public void collapseAll() {
        this.toggleModelExpandState(this, false);
    }

    public void expandAll() {
        this.toggleModelExpandState(this, true);
    }

    private void toggleModelExpandState(BaseElement element, boolean expandState) {
        OrmShape ormShape;
        if (element instanceof OrmShape && expandState != (ormShape = (OrmShape)element).isExpanded()) {
            if (expandState) {
                ormShape.expand();
            } else {
                ormShape.collapse();
            }
        }
        Iterator<Shape> it = element.getChildrenList().iterator();
        while (it.hasNext()) {
            this.toggleModelExpandState(it.next(), expandState);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(DIRTY, null, null);
        }
    }

    public void updateDirty(boolean dirtyUpdate) {
        if (dirtyUpdate) {
            this.setDirty(true);
        }
    }

    public void autolayout() {
        this.firePropertyChange(AUTOLAYOUT, null, null);
    }

    public boolean getConnectionsVisibilityAssociation() {
        return this.connectionsVisibilityAssociation;
    }

    public void setConnectionsVisibilityAssociation(boolean connectionsVisibilityAssociation) {
        if (this.connectionsVisibilityAssociation == connectionsVisibilityAssociation) {
            return;
        }
        this.connectionsVisibilityAssociation = connectionsVisibilityAssociation;
        for (Connection connection : this.connections) {
            Connection.ConnectionType ct = connection.getConnectionType();
            if (ct != Connection.ConnectionType.Association) continue;
            connection.setVisible(connectionsVisibilityAssociation);
        }
    }

    public boolean getConnectionsVisibilityClassMapping() {
        return this.connectionsVisibilityClassMapping;
    }

    public void setConnectionsVisibilityClassMapping(boolean connectionsVisibilityClassMapping) {
        if (this.connectionsVisibilityClassMapping == connectionsVisibilityClassMapping) {
            return;
        }
        this.connectionsVisibilityClassMapping = connectionsVisibilityClassMapping;
        for (Connection connection : this.connections) {
            Connection.ConnectionType ct = connection.getConnectionType();
            if (ct != Connection.ConnectionType.ClassMapping) continue;
            connection.setVisible(connectionsVisibilityClassMapping);
        }
    }

    public boolean getConnectionsVisibilityForeignKeyConstraint() {
        return this.connectionsVisibilityForeignKeyConstraint;
    }

    public void setConnectionsVisibilityForeignKeyConstraint(boolean connectionsVisibilityForeignKeyConstraint) {
        if (this.connectionsVisibilityForeignKeyConstraint == connectionsVisibilityForeignKeyConstraint) {
            return;
        }
        this.connectionsVisibilityForeignKeyConstraint = connectionsVisibilityForeignKeyConstraint;
        for (Connection connection : this.connections) {
            Connection.ConnectionType ct = connection.getConnectionType();
            if (ct != Connection.ConnectionType.ForeignKeyConstraint) continue;
            connection.setVisible(connectionsVisibilityForeignKeyConstraint);
        }
    }

    public boolean getConnectionsVisibilityPropertyMapping() {
        return this.connectionsVisibilityPropertyMapping;
    }

    public void setConnectionsVisibilityPropertyMapping(boolean connectionsVisibilityPropertyMapping) {
        if (this.connectionsVisibilityPropertyMapping == connectionsVisibilityPropertyMapping) {
            return;
        }
        this.connectionsVisibilityPropertyMapping = connectionsVisibilityPropertyMapping;
        for (Connection connection : this.connections) {
            Connection.ConnectionType ct = connection.getConnectionType();
            if (ct != Connection.ConnectionType.PropertyMapping) continue;
            connection.setVisible(connectionsVisibilityPropertyMapping);
        }
    }

    public static String getConsoleConfigName(IMemento memento) {
        String str = memento.getString("consoleConfig_name");
        if (str == null) {
            str = "";
        }
        return str;
    }

    @Override
    public void loadState(IMemento memento) {
        super.loadState(memento);
        this.consoleConfigName = this.getPrValue(memento, "consoleConfig_name", "");
        this.getConsoleConfig();
        this.labelProvider.setConsoleConfigName(this.consoleConfigName);
        int size = this.getPrValue(memento, "entityNames_size", 0);
        this.roots.clear();
        this.entityNames.clear();
        int i = 0;
        while (i < size) {
            this.roots.add(null);
            this.entityNames.add(this.getPrValue(memento, "entityNames_" + Integer.toString(i), ""));
            ++i;
        }
        this.rulersVisibility = this.getPrValue(memento, "rulersVisibility", false);
        this.snapToGeometry = this.getPrValue(memento, "snapToGeometry", false);
        this.gridEnabled = this.getPrValue(memento, "gridEnabled", false);
        this.zoom = this.getPrValue(memento, PROPERTY_ZOOM, 1.0);
        this.deepIntoSort = this.getPrValue(memento, DEEPINTOSORT, false);
        this.flagManhattanConnectionRouter = this.getPrValue(memento, "flagManhattanConnectionRouter", true);
        this.connectionsVisibilityAssociation = this.getPrValue(memento, "connectionsVisibilityAssociation", true);
        this.connectionsVisibilityClassMapping = this.getPrValue(memento, "connectionsVisibilityClassMapping", true);
        this.connectionsVisibilityForeignKeyConstraint = this.getPrValue(memento, "connectionsVisibilityForeignKeyConstraint", true);
        this.connectionsVisibilityPropertyMapping = this.getPrValue(memento, "connectionsVisibilityPropertyMapping", true);
        this.refreshRootsFromNames();
    }

    @Override
    protected void loadFromProperties(Properties properties) {
        super.loadFromProperties(properties);
        this.consoleConfigName = this.getPrValue(properties, "consoleConfig_name", "");
        this.getConsoleConfig();
        this.labelProvider.setConsoleConfigName(this.consoleConfigName);
        int size = this.getPrValue(properties, "entityNames_size", 0);
        this.roots.clear();
        this.entityNames.clear();
        int i = 0;
        while (i < size) {
            this.roots.add(null);
            this.entityNames.add(this.getPrValue(properties, "entityNames_" + Integer.toString(i), ""));
            ++i;
        }
        this.rulersVisibility = this.getPrValue(properties, "rulersVisibility", false);
        this.snapToGeometry = this.getPrValue(properties, "snapToGeometry", false);
        this.gridEnabled = this.getPrValue(properties, "gridEnabled", false);
        this.zoom = this.getPrValue(properties, PROPERTY_ZOOM, 1.0);
        this.deepIntoSort = this.getPrValue(properties, DEEPINTOSORT, false);
        this.flagManhattanConnectionRouter = this.getPrValue(properties, "flagManhattanConnectionRouter", true);
        this.connectionsVisibilityAssociation = this.getPrValue(properties, "connectionsVisibilityAssociation", true);
        this.connectionsVisibilityClassMapping = this.getPrValue(properties, "connectionsVisibilityClassMapping", true);
        this.connectionsVisibilityForeignKeyConstraint = this.getPrValue(properties, "connectionsVisibilityForeignKeyConstraint", true);
        this.connectionsVisibilityPropertyMapping = this.getPrValue(properties, "connectionsVisibilityPropertyMapping", true);
        this.refreshRootsFromNames();
    }

    @Override
    public void saveState(IMemento memento) {
        this.setPrValue(memento, "consoleConfig_name", this.consoleConfigName);
        this.setPrValue(memento, "entityNames_size", "" + this.entityNames.size());
        int i = 0;
        while (i < this.entityNames.size()) {
            this.setPrValue(memento, "entityNames_" + Integer.toString(i), this.entityNames.get(i));
            ++i;
        }
        this.setPrValue(memento, "rulersVisibility", "" + this.rulersVisibility);
        this.setPrValue(memento, "snapToGeometry", "" + this.snapToGeometry);
        this.setPrValue(memento, "gridEnabled", "" + this.gridEnabled);
        this.setPrValue(memento, PROPERTY_ZOOM, "" + this.zoom);
        this.setPrValue(memento, DEEPINTOSORT, "" + this.deepIntoSort);
        this.setPrValue(memento, "flagManhattanConnectionRouter", "" + this.flagManhattanConnectionRouter);
        this.setPrValue(memento, "connectionsVisibilityAssociation", "" + this.connectionsVisibilityAssociation);
        this.setPrValue(memento, "connectionsVisibilityClassMapping", "" + this.connectionsVisibilityClassMapping);
        this.setPrValue(memento, "connectionsVisibilityForeignKeyConstraint", "" + this.connectionsVisibilityForeignKeyConstraint);
        this.setPrValue(memento, "connectionsVisibilityPropertyMapping", "" + this.connectionsVisibilityPropertyMapping);
        super.saveState(memento);
    }

    @Override
    protected void saveInProperties(Properties properties) {
        this.setPrValue(properties, "consoleConfig_name", this.consoleConfigName);
        this.setPrValue(properties, "entityNames_size", "" + this.entityNames.size());
        int i = 0;
        while (i < this.entityNames.size()) {
            this.setPrValue(properties, "entityNames_" + Integer.toString(i), this.entityNames.get(i));
            ++i;
        }
        this.setPrValue(properties, "rulersVisibility", "" + this.rulersVisibility);
        this.setPrValue(properties, "snapToGeometry", "" + this.snapToGeometry);
        this.setPrValue(properties, "gridEnabled", "" + this.gridEnabled);
        this.setPrValue(properties, PROPERTY_ZOOM, "" + this.zoom);
        this.setPrValue(properties, DEEPINTOSORT, "" + this.deepIntoSort);
        this.setPrValue(properties, "flagManhattanConnectionRouter", "" + this.flagManhattanConnectionRouter);
        this.setPrValue(properties, "connectionsVisibilityAssociation", "" + this.connectionsVisibilityAssociation);
        this.setPrValue(properties, "connectionsVisibilityClassMapping", "" + this.connectionsVisibilityClassMapping);
        this.setPrValue(properties, "connectionsVisibilityForeignKeyConstraint", "" + this.connectionsVisibilityForeignKeyConstraint);
        this.setPrValue(properties, "connectionsVisibilityPropertyMapping", "" + this.connectionsVisibilityPropertyMapping);
        super.saveInProperties(properties);
    }

    public void saveInWorkspaceFile(IPath path, boolean format) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file.exists()) {
            try {
                file.delete(true, null);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't delete file.", (Throwable)e);
            }
        }
        if (file.exists()) {
            return;
        }
        byte[] arrSave = new byte[]{};
        try {
            if (format) {
                XMLMemento memento = XMLMemento.createWriteRoot((String)"OrmDiagram");
                this.saveState((IMemento)memento);
                StringWriter strWriter = new StringWriter();
                memento.save((Writer)strWriter);
                arrSave = strWriter.toString().getBytes();
            } else {
                Properties properties = new Properties();
                this.saveInProperties(properties);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                properties.store(baos, "");
                arrSave = baos.toByteArray();
            }
        }
        catch (IOException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Can't save layout of mapping.", (Throwable)e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(arrSave);
        try {
            file.create((InputStream)inputStream, true, null);
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Can't save layout of mapping.", (Throwable)e);
        }
    }

    public void saveInFile(IPath path, boolean format) {
        block17: {
            FileOutputStream fos = null;
            try {
                try {
                    File file = new File(path.toOSString());
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    fos = new FileOutputStream(file);
                    if (format) {
                        XMLMemento memento = XMLMemento.createWriteRoot((String)"OrmDiagram");
                        this.saveState((IMemento)memento);
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "utf-8");
                        memento.save((Writer)writer);
                        writer.close();
                    } else {
                        Properties properties = new Properties();
                        this.saveInProperties(properties);
                        properties.store(fos, "");
                    }
                }
                catch (IOException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't save layout of mapping.", (Throwable)e);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveInXmlFile() {
        File folder = new File(this.getStoreFolderPath().toOSString());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.saveInFile(this.getStoreFilePath(), true);
    }

    public void saveInFile() {
        File folder = new File(this.getStoreFolderPath().toOSString());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.saveInFile(this.getStoreFilePath(), false);
    }

    public IFile createLayoutFile(InputStream source) {
        IFile file = null;
        IPath path = this.getStoreFolderPath();
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
                file = folder.getFile(this.getStoreFileName());
                if (!file.exists()) {
                    file.create(source, true, null);
                }
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", (Throwable)e);
            }
        }
        return file;
    }

    public void loadFromFile(IPath path, boolean format) {
        block19: {
            this.fileLoadSuccessfull = false;
            FileInputStream fis = null;
            try {
                try {
                    File file = new File(path.toOSString());
                    if (file.exists()) {
                        fis = new FileInputStream(file);
                        if (format) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
                            try {
                                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                                this.loadState((IMemento)memento);
                                this.fileLoadSuccessfull = true;
                            }
                            catch (WorkbenchException e) {
                                HibernateConsolePlugin.getDefault().logErrorMessage("Can't load layout of mapping.", (Throwable)e);
                            }
                        } else {
                            Properties properties = new Properties();
                            properties.load(fis);
                            this.loadFromProperties(properties);
                            this.fileLoadSuccessfull = true;
                        }
                    }
                }
                catch (IOException ex) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't load layout of mapping.", (Throwable)ex);
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadFromXmlFile() {
        this.loadFromFile(this.getStoreFilePath(), true);
    }

    public void loadFromFile() {
        this.loadFromFile(this.getStoreFilePath(), false);
    }

    public boolean isFileLoadSuccessfull() {
        return this.fileLoadSuccessfull;
    }

    public String getConsoleConfigName() {
        return this.consoleConfigName;
    }

    protected Configuration getConfig() {
        return this.getConfig(null);
    }

    protected Configuration getConfig(StringBuilder error) {
        ConsoleConfiguration consoleConfig;
        if (error != null) {
            error.delete(0, error.length());
        }
        if ((consoleConfig = this.getConsoleConfig()) != null) {
            block6: {
                if (!consoleConfig.hasConfiguration()) {
                    try {
                        consoleConfig.build();
                        consoleConfig.buildMappings();
                    }
                    catch (HibernateException he) {
                        if (error == null) break block6;
                        error.append(this.consoleConfigName);
                        error.append(": ");
                        error.append(he.getMessage());
                        if (error.length() != 0) break block6;
                        error.append(he.getCause());
                    }
                }
            }
            return consoleConfig.getConfiguration();
        }
        if (error != null && this.consoleConfigName != null && this.consoleConfigName.length() > 0) {
            error.append(this.consoleConfigName);
            error.append(": ");
            error.append(DiagramViewerMessages.Diagram_incorrect_state);
        }
        return null;
    }

    public ConsoleConfiguration getConsoleConfig() {
        KnownConfigurations knownConfigurations = KnownConfigurations.getInstance();
        ConsoleConfiguration consoleConfig = knownConfigurations.find(this.consoleConfigName);
        return consoleConfig;
    }

    public DiagramRuler getRuler(int orientation) {
        DiagramRuler result = null;
        switch (orientation) {
            case 1: {
                result = this.topRuler;
                break;
            }
            case 8: {
                result = this.leftRuler;
            }
        }
        return result;
    }

    public void setRulerVisibility(boolean newValue) {
        this.rulersVisibility = newValue;
    }

    public boolean getRulerVisibility() {
        return this.rulersVisibility;
    }

    public void setGridEnabled(boolean isEnabled) {
        this.gridEnabled = isEnabled;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setSnapToGeometry(boolean isEnabled) {
        this.snapToGeometry = isEnabled;
    }

    public boolean isSnapToGeometryEnabled() {
        return this.snapToGeometry;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    protected void initFontHeight() {
        FontData[] fontData = Display.getCurrent().getSystemFont().getFontData();
        if (fontData.length > 0) {
            this.fontHeight = fontData[0].height;
        }
    }

    public void setFontHeight(float fontHeight) {
        this.fontHeight = fontHeight;
    }

    public float getFontHeight() {
        return this.fontHeight;
    }

    @Override
    public String getKey() {
        return null;
    }

    public OrmLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isDeepIntoSort() {
        return this.deepIntoSort;
    }

    public void setDeepIntoSort(boolean deepIntoSort) {
        if (this.deepIntoSort != deepIntoSort) {
            this.deepIntoSort = deepIntoSort;
            this.firePropertyChange(DEEPINTOSORT, null, null);
        }
    }

    public boolean equals(Object obj) {
        boolean res = false;
        if (!(obj instanceof OrmDiagram)) {
            return res;
        }
        OrmDiagram od = (OrmDiagram)obj;
        if (this.consoleConfigName == null ? od.getConsoleConfigName() != null : !this.consoleConfigName.equals(od.getConsoleConfigName())) {
            return res;
        }
        ArrayList<RootClass> rootsOd = od.roots;
        if (this.roots.size() != rootsOd.size()) {
            return res;
        }
        res = true;
        int i = 0;
        while (i < this.roots.size()) {
            RootClass rc = this.roots.get(i);
            if (rc == null) {
                if (rc != rootsOd.get(i)) {
                    res = false;
                    break;
                }
            } else if (!rc.equals(rootsOd.get(i))) {
                res = false;
                break;
            }
            ++i;
        }
        return res;
    }

    public int hashCode() {
        if (this.consoleConfigName == null) {
            return this.roots.hashCode();
        }
        return this.roots.hashCode() + this.consoleConfigName.hashCode();
    }

    public void setMemento(IMemento memento) {
        this.memento = memento;
    }

    public HashMap<String, Point> getElementsLocations() {
        HashMap<String, Point> elLocations = new HashMap<String, Point>();
        for (Map.Entry<String, OrmShape> entry : this.elements.entrySet()) {
            elLocations.put(entry.getKey(), entry.getValue().getLocation());
        }
        return elLocations;
    }

    public void setElementsLocations(HashMap<String, Point> elLocations) {
        for (Map.Entry<String, Point> entry : elLocations.entrySet()) {
            this.elements.get(entry.getKey()).setLocation(entry.getValue());
        }
    }

    public HashMap<String, Boolean> getElementsExpState() {
        HashMap<String, Boolean> elExpState = new HashMap<String, Boolean>();
        for (Map.Entry<String, OrmShape> entry : this.elements.entrySet()) {
            elExpState.put(entry.getKey(), entry.getValue().isExpanded());
        }
        return elExpState;
    }

    public void setElementsExpState(HashMap<String, Boolean> elExpState) {
        for (Map.Entry<String, Boolean> entry : elExpState.entrySet()) {
            this.elements.get(entry.getKey()).setExpanded(entry.getValue());
        }
    }

    public boolean isManhattanConnectionRouter() {
        return this.flagManhattanConnectionRouter;
    }

    public boolean isFanConnectionRouter() {
        return !this.flagManhattanConnectionRouter;
    }

    public void setupManhattanConnectionRouter() {
        this.flagManhattanConnectionRouter = true;
    }

    public void setupFanConnectionRouter() {
        this.flagManhattanConnectionRouter = false;
    }

    public void updateWidthAndHeight(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors_diagram;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        Object res = null;
        if (PROPERTY_NAME.equals(propertyId)) {
            res = this.getDiagramName();
        } else if (PROPERTY_WIDTH.equals(propertyId)) {
            res = Integer.valueOf(this.width).toString();
        } else if (PROPERTY_HEIGHT.equals(propertyId)) {
            res = Integer.valueOf(this.height).toString();
        } else if (PROPERTY_ZOOM.equals(propertyId)) {
            res = Double.valueOf(this.zoom).toString();
        } else if (PROPERTY_ITEMS.equals(propertyId)) {
            res = Integer.valueOf(this.elements.size()).toString();
        } else if (PROPERTY_ENTITIES.equals(propertyId)) {
            int nEntities = 0;
            for (OrmShape shape : this.elements.values()) {
                Object ormElement = shape.getOrmElement();
                if (!(ormElement instanceof RootClass)) continue;
                ++nEntities;
            }
            res = Integer.valueOf(nEntities).toString();
        } else if (PROPERTY_TABLES.equals(propertyId)) {
            int nTables = 0;
            for (OrmShape shape : this.elements.values()) {
                Object ormElement = shape.getOrmElement();
                if (!(ormElement instanceof Table)) continue;
                ++nTables;
            }
            res = Integer.valueOf(nTables).toString();
        } else if (PROPERTY_INVISIBLE.equals(propertyId)) {
            int nInvisible = 0;
            for (OrmShape shape : this.elements.values()) {
                if (shape.isVisible()) continue;
                ++nInvisible;
            }
            res = Integer.valueOf(nInvisible).toString();
        }
        if (res == null) {
            res = super.getPropertyValue(propertyId);
        }
        return this.toEmptyStr(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OrmElCompare
    implements Comparator<RootClass> {
        protected OrmElCompare() {
        }

        @Override
        public int compare(RootClass o1, RootClass o2) {
            return o1.getNodeName().compareTo(o2.getNodeName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RootClassComparator
    implements Comparator<RootClass> {
        @Override
        public int compare(RootClass o1, RootClass o2) {
            return OrmDiagram.this.getItemName(o1).compareTo(OrmDiagram.this.getItemName(o2));
        }
    }
}

