/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.command;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;

public class MoveGuideCommand
extends Command {
    private int pDelta;
    private DiagramGuide guide;

    public MoveGuideCommand(DiagramGuide guide, int positionDelta) {
        super(DiagramViewerMessages.MoveGuideCommand_Label);
        this.guide = guide;
        this.pDelta = positionDelta;
    }

    public void execute() {
        this.guide.setPosition(this.guide.getPosition() + this.pDelta);
        for (OrmShape part : this.guide.getParts()) {
            Point location = part.getLocation().getCopy();
            if (this.guide.isHorizontal()) {
                location.y += this.pDelta;
            } else {
                location.x += this.pDelta;
            }
            part.setLocation(location);
        }
    }

    public void undo() {
        this.guide.setPosition(this.guide.getPosition() - this.pDelta);
        for (OrmShape part : this.guide.getParts()) {
            Point location = part.getLocation().getCopy();
            if (this.guide.isHorizontal()) {
                location.y -= this.pDelta;
            } else {
                location.x -= this.pDelta;
            }
            part.setLocation(location);
        }
    }
}

