/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder.spring;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;
import org.springframework.web.servlet.tags.form.CheckboxTag;
import org.springframework.web.servlet.tags.form.InputTag;
import org.springframework.web.servlet.tags.form.OptionTag;
import org.springframework.web.servlet.tags.form.OptionsTag;
import org.springframework.web.servlet.tags.form.PasswordInputTag;
import org.springframework.web.servlet.tags.form.SelectTag;
import org.springframework.web.servlet.tags.form.TextareaTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWidgetBuilder
implements WidgetBuilder<Tag, MetawidgetTag> {
    private static final List<Boolean> LIST_BOOLEAN_VALUES = CollectionUtils.unmodifiableList(Boolean.TRUE, Boolean.FALSE);

    @Override
    public Tag buildWidget(String elementName, Map<String, String> attributes, MetawidgetTag metawidget) {
        Class<?> clazz;
        if ("true".equals(attributes.get("hidden"))) {
            attributes.put("metawidget-needs-hidden-field", "true");
            return new HtmlStubTag();
        }
        if ("action".equals(elementName)) {
            return new HtmlStubTag();
        }
        String type = WidgetBuilderUtils.getActualClassOrType(attributes);
        if (type == null) {
            type = String.class.getName();
        }
        if (Boolean.class.equals(clazz = ClassUtils.niceForName(type)) && "true".equals(attributes.get("required"))) {
            return new CheckboxTag();
        }
        String springLookup = attributes.get("spring-lookup");
        if (springLookup != null && !"".equals(springLookup)) {
            return this.createSelectTag(springLookup, attributes);
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            return this.createSelectTag(CollectionUtils.fromString(lookup), CollectionUtils.fromString(attributes.get("lookup-labels")), attributes);
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckboxTag();
                }
                if (Character.TYPE.equals(clazz)) {
                    InputTag inputTag = new InputTag();
                    inputTag.setMaxlength("1");
                    return inputTag;
                }
                return this.createInputTag(attributes);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("masked"))) {
                    PasswordInputTag passwordInputTag = new PasswordInputTag();
                    String maximumLength = attributes.get("maximum-length");
                    if (maximumLength != null) {
                        passwordInputTag.setMaxlength(maximumLength);
                    }
                    return passwordInputTag;
                }
                if ("true".equals(attributes.get("large"))) {
                    return new TextareaTag();
                }
                return this.createInputTag(attributes);
            }
            if (Character.class.equals(clazz)) {
                InputTag inputTag = new InputTag();
                inputTag.setMaxlength("1");
                return inputTag;
            }
            if (Date.class.equals(clazz)) {
                return this.createInputTag(attributes);
            }
            if (Boolean.class.equals(clazz)) {
                return this.createSelectTag(LIST_BOOLEAN_VALUES, null, attributes);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createInputTag(attributes);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new HtmlStubTag();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createInputTag(attributes);
        }
        return null;
    }

    private InputTag createInputTag(Map<String, String> attributes) {
        InputTag inputTag = new InputTag();
        String maximumLength = attributes.get("maximum-length");
        if (maximumLength != null) {
            inputTag.setMaxlength(maximumLength);
        }
        return inputTag;
    }

    private Tag createSelectTag(String expression, Map<String, String> attributes) {
        String itemLabel;
        SelectTag select = new SelectTag();
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            OptionTag emptyOption = new OptionTag();
            emptyOption.setValue((Object)"");
            JspUtils.addDeferredChild((TagSupport)select, (Tag)emptyOption);
        }
        OptionsTag optionsTag = new OptionsTag();
        optionsTag.setItems((Object)expression);
        String itemValue = attributes.get("spring-lookup-item-value");
        if (itemValue != null) {
            optionsTag.setItemValue(itemValue);
        }
        if ((itemLabel = attributes.get("spring-lookup-item-label")) != null) {
            optionsTag.setItemLabel(itemLabel);
        }
        JspUtils.addDeferredChild((TagSupport)select, (Tag)optionsTag);
        return select;
    }

    private Tag createSelectTag(List<?> values, List<String> labels, Map<String, String> attributes) {
        if (labels != null && !labels.isEmpty() && labels.size() != values.size()) {
            throw WidgetBuilderException.newException("Labels list must be same size as values list");
        }
        SelectTag select = new SelectTag();
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            OptionTag emptyOption = new OptionTag();
            emptyOption.setValue((Object)"");
            JspUtils.addDeferredChild((TagSupport)select, (Tag)emptyOption);
        }
        int length = values.size();
        for (int loop = 0; loop < length; ++loop) {
            OptionTag optionTag = new OptionTag();
            optionTag.setValue(values.get(loop));
            if (labels != null && !labels.isEmpty()) {
                optionTag.setLabel(labels.get(loop));
            }
            JspUtils.addDeferredChild((TagSupport)select, (Tag)optionTag);
        }
        return select;
    }
}

