/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.jsp.tagext.LiteralTag;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.jsp.tagext.html.widgetbuilder.HtmlWidgetBuilderUtils;
import org.metawidget.jsp.tagext.layout.SimpleLayout;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyWidgetBuilder
implements WidgetBuilder<Tag, MetawidgetTag> {
    @Override
    public Tag buildWidget(String elementName, Map<String, String> attributes, MetawidgetTag metawidget) {
        Class<?> clazz;
        if (!WidgetBuilderUtils.isReadOnly(attributes)) {
            return null;
        }
        if ("true".equals(attributes.get("hidden"))) {
            attributes.put("metawidget-needs-hidden-field", "true");
            return new HtmlStubTag();
        }
        if ("action".equals(elementName)) {
            return this.createReadOnlyButton(attributes, metawidget);
        }
        if ("true".equals(attributes.get("masked"))) {
            return new LiteralTag("");
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
        }
        String jspLookup = attributes.get("jsp-lookup");
        if (jspLookup != null && !"".equals(jspLookup)) {
            return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
        }
        String type = WidgetBuilderUtils.getActualClassOrType(attributes);
        if (type == null) {
            type = String.class.getName();
        }
        if ((clazz = ClassUtils.niceForName(type)) != null) {
            if (clazz.isPrimitive()) {
                return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
            }
            if (ClassUtils.isPrimitiveWrapper(clazz)) {
                return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
            }
            if (String.class.equals(clazz)) {
                return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new HtmlStubTag();
            }
        }
        if ("true".equals(attributes.get("dont-expand")) || metawidget.getLayout() instanceof SimpleLayout) {
            return this.setAttributeAndCreateReadOnlyLabelTag(attributes, metawidget);
        }
        return null;
    }

    protected Tag createReadOnlyLabelTag(Map<String, String> attributes, MetawidgetTag metawidget) {
        List<String> lookupLabelsList;
        List<String> lookupList;
        int indexOf;
        String value = HtmlWidgetBuilderUtils.evaluateAsText(attributes, metawidget);
        String lookupLabels = attributes.get("lookup-labels");
        if (lookupLabels != null && (indexOf = (lookupList = CollectionUtils.fromString(attributes.get("lookup"))).indexOf(value)) != -1 && indexOf < (lookupLabelsList = CollectionUtils.fromString(lookupLabels)).size()) {
            value = lookupLabelsList.get(indexOf);
        }
        return new LiteralTag(value);
    }

    protected Tag createReadOnlyButton(Map<String, String> attributes, MetawidgetTag metawidget) {
        StringBuilder builder = new StringBuilder();
        builder.append("<input type=\"submit\" value=\"");
        builder.append(metawidget.getLabelString(attributes));
        builder.append("\"");
        builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
        builder.append(" disabled=\"disabled\"/>");
        return new LiteralTag(builder.toString());
    }

    protected Tag setAttributeAndCreateReadOnlyLabelTag(Map<String, String> attributes, MetawidgetTag metawidget) {
        attributes.put("metawidget-needs-hidden-field", "true");
        return this.createReadOnlyLabelTag(attributes, metawidget);
    }
}

