/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.preferences;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.editor.IVisualEditor;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.jsp.preferences.IVpePreferencesPage;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.preferences.SliderFieldEditor;
import org.jboss.tools.vpe.editor.preferences.VpeBooleanFieldEditor;
import org.jboss.tools.vpe.editor.preferences.VpeComboFieldEditor;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class VpePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IVpePreferencesPage {
    private static final String[][] DEFAULT_VPE_TAB_COMBO_BOX_VALUES = new String[][]{{VpeUIMessages.DEFAULT_VPE_TAB_VISUAL_SOURCE, "0"}, {VpeUIMessages.DEFAULT_VPE_TAB_SOURCE, "1"}, {VpeUIMessages.DEFAULT_VPE_TAB_PREVIEW, "2"}};
    private static final String[][] SPLITTING_COMBO_BOX_VALUES = new String[][]{{VpeUIMessages.SPLITTING_VERT_TOP_SOURCE, "1"}, {VpeUIMessages.SPLITTING_VERT_TOP_VISUAL, "2"}, {VpeUIMessages.SPLITTING_HORIZ_LEFT_SOURCE, "3"}, {VpeUIMessages.SPLITTING_HORIZ_LEFT_VISUAL, "4"}};
    private Composite pageContainer;
    private Group visualAppearanceGroup;
    private Group confirmationGroup;
    private Group tabsGroup;
    private Group visualEditorToolbarGroup;
    private ICommandService commandService = null;

    public VpePreferencesPage() {
        this.setPreferenceStore(this.getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public String getTitle() {
        return VpeUIMessages.GENERAL_TAB_TITLE;
    }

    protected Control createContents(Composite parent) {
        this.pageContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        this.pageContainer.setLayout((Layout)layout);
        this.pageContainer.setLayoutData((Object)gd);
        this.visualEditorToolbarGroup = VpePreferencesPage.createLayoutGroup(this.pageContainer, 16, VpeUIMessages.VISUAL_EDITOR_TOOLBAR_BEHAVIOR);
        this.visualAppearanceGroup = VpePreferencesPage.createLayoutGroup(this.pageContainer, 16, VpeUIMessages.VISUAL_APPEARANCE_GROUP_TITLE);
        this.confirmationGroup = VpePreferencesPage.createLayoutGroup(this.pageContainer, 16, VpeUIMessages.CONFIRMATION_GROUP_TITLE);
        this.tabsGroup = VpePreferencesPage.createLayoutGroup(this.pageContainer, 16, VpeUIMessages.TABS_GROUP_TITLE);
        this.createFieldEditors();
        this.initialize();
        this.checkState();
        return this.pageContainer;
    }

    protected Composite getFieldEditorParent() {
        return this.pageContainer;
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Show VPE Toolbar", VpeUIMessages.SHOW_VPE_TOOLBAR, (Composite)this.visualEditorToolbarGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Show Border for Unknown Tags", VpeUIMessages.SHOW_BORDER_FOR_UNKNOWN_TAGS, (Composite)this.visualAppearanceGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Show non-visual tags", VpeUIMessages.SHOW_NON_VISUAL_TAGS, (Composite)this.visualAppearanceGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Show Selection Tag Bar", VpeUIMessages.SHOW_SELECTION_TAG_BAR, (Composite)this.visualAppearanceGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Show Text Formatting bar", VpeUIMessages.SHOW_TEXT_FORMATTING, (Composite)this.visualAppearanceGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Show Resource Bundles Usage as EL Expressions", VpeUIMessages.SHOW_RESOURCE_BUNDLES_USAGE_AS_EL, (Composite)this.visualAppearanceGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Ask for tag attributes during tag insert", VpeUIMessages.ASK_TAG_ATTRIBUTES_ON_TAG_INSERT, (Composite)this.confirmationGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Inform when a project might not be configured properly for Visual Page Editor", VpeUIMessages.INFORM_WHEN_PROJECT_MIGHT_NOT_BE_CONFIGURED_PROPERLY_FOR_VPE, (Composite)this.confirmationGroup));
        this.addField((FieldEditor)new VpeBooleanFieldEditor("Synchronize scrolling between source and visual panes", VpeUIMessages.SYNCHRONIZE_SCROLLING_BETWEEN_SOURCE_VISUAL_PANES, (Composite)this.tabsGroup));
        this.addField(new VpeComboFieldEditor("Default VPE Tab", VpeUIMessages.DEFAULT_VPE_TAB, DEFAULT_VPE_TAB_COMBO_BOX_VALUES, (Composite)this.tabsGroup));
        this.addField(new VpeComboFieldEditor("Visual/Source Editors Splitting", VpeUIMessages.VISUAL_SOURCE_EDITORS_SPLITTING, SPLITTING_COMBO_BOX_VALUES, (Composite)this.tabsGroup));
        this.addField(new SliderFieldEditor("Size of Visual Editor Pane 0-100%", VpeUIMessages.VISUAL_SOURCE_EDITORS_WEIGHTS, (Composite)this.tabsGroup));
    }

    public boolean performOk() {
        IEditorReference[] editors;
        super.performOk();
        IEditorReference[] iEditorReferenceArray = editors = VpePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            JSPMultiPageEditor mpe;
            IVisualEditor visualEditor;
            IEditorReference editor = iEditorReferenceArray[n2];
            IEditorPart editorPart = editor.getEditor(false);
            if (editorPart != null && editorPart instanceof JSPMultiPageEditor && (visualEditor = (mpe = (JSPMultiPageEditor)editorPart).getVisualEditor()) instanceof VpeEditorPart) {
                VpeEditorPart vep = (VpeEditorPart)visualEditor;
                vep.updatePartAccordingToPreferences();
                boolean presfShowBorderForUnknownTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Border for Unknown Tags");
                boolean prefsShowNonVisualTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show non-visual tags");
                boolean prefsShowSelectionBar = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Selection Tag Bar");
                boolean prefsShowTextFormattingBar = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Text Formatting bar");
                boolean prefsShowBundlesAsEL = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Resource Bundles Usage as EL Expressions");
                boolean prefsSynchronizeScrolling = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Synchronize scrolling between source and visual panes");
                this.setCommandToggleState("org.jboss.tools.vpe.commands.showBorderCommand", presfShowBorderForUnknownTags);
                this.setCommandToggleState("org.jboss.tools.vpe.commands.showNonVisualTagsCommand", prefsShowNonVisualTags);
                this.setCommandToggleState("org.jboss.tools.jst.jsp.commands.showSelectionBar", prefsShowSelectionBar);
                this.setCommandToggleState("org.jboss.tools.vpe.commands.showTextFormattingCommand", prefsShowTextFormattingBar);
                this.setCommandToggleState("org.jboss.tools.vpe.commands.showBundleAsELCommand", prefsShowBundlesAsEL);
                this.setCommandToggleState("org.jboss.tools.vpe.commands.scrollLockSourceVisual", prefsSynchronizeScrolling);
            }
            ++n2;
        }
        return true;
    }

    private void setCommandToggleState(String commandId, boolean newState) {
        Command command;
        State state;
        boolean oldState;
        if (this.commandService == null) {
            this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        }
        if ((oldState = ((Boolean)(state = (command = this.commandService.getCommand(commandId)).getState("org.eclipse.ui.commands.toggleState")).getValue()).booleanValue()) != newState) {
            state.setValue((Object)new Boolean(newState));
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return JspEditorPlugin.getDefault().getPreferenceStore();
    }

    private static Group createLayoutGroup(Composite parent, int style, String groupTitle) {
        Group prefGroup = new Group(parent, style);
        prefGroup.setText(groupTitle);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        prefGroup.setLayout((Layout)layout);
        GridData gd = new GridData(4, 0, true, false, 1, 1);
        prefGroup.setLayoutData((Object)gd);
        return prefGroup;
    }
}

