/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.hibernate.eclipse.mapper.editors.CFGXMLStructuredTextViewerConfiguration;
import org.hibernate.eclipse.mapper.editors.HBMXMLHyperlink;
import org.hibernate.eclipse.mapper.editors.xpl.BaseXMLHyperlinkSupport;
import org.hibernate.eclipse.mapper.extractor.HBMInfoExtractor;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class HBMXMLHyperlinkDetector
extends BaseXMLHyperlinkSupport
implements IHyperlinkDetector {
    HBMInfoExtractor infoExtractor = new HBMInfoExtractor();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String path;
        HBMInfoHandler handler;
        Attr currentAttrNode;
        short nodeType;
        if (region == null || textViewer == null) {
            return null;
        }
        IJavaProject jp = CFGXMLStructuredTextViewerConfiguration.findJavaProject(textViewer);
        if (jp == null) {
            return new IHyperlink[0];
        }
        IDocument document = textViewer.getDocument();
        Node currentNode = this.getCurrentNode(document, region.getOffset());
        if (currentNode != null && (nodeType = currentNode.getNodeType()) != 2 && nodeType == 1 && (currentAttrNode = this.getCurrentAttrNode(currentNode, region.getOffset())) != null && (handler = this.infoExtractor.getAttributeHandler(path = String.valueOf(currentNode.getNodeName()) + ">" + currentAttrNode.getName())) != null) {
            IJavaProject project = CFGXMLStructuredTextViewerConfiguration.findJavaProject(document);
            IJavaElement element = handler.getJavaElement(project, currentNode, currentAttrNode);
            if (element != null) {
                return new IHyperlink[]{new HBMXMLHyperlink(this.getHyperlinkRegion(currentAttrNode), element)};
            }
            return null;
        }
        return null;
    }
}

