/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.java;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.FieldHolder;
import org.jboss.forge.parser.java.Import;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.MethodHolder;
import org.jboss.forge.parser.java.SyntaxError;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.events.PickupResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.util.JavaColorizer;

@Alias(value="java")
@RequiresFacet(value={JavaSourceFacet.class})
public class JavaPlugin
implements Plugin {
    @Inject
    @Current
    private JavaResource resource;
    @Inject
    private Project project;
    @Inject
    private ShellPrompt prompt;
    @Inject
    private ShellPrintWriter writer;
    @Inject
    private Event<PickupResource> pickUp;

    @DefaultCommand(help="Prints all Java system property information.")
    public void info(PipeOut out) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!entry.getKey().toString().startsWith("java")) continue;
            out.print(ShellColor.BOLD, entry.getKey().toString() + ": ");
            out.println(entry.getValue().toString());
        }
    }

    @Command(value="new-class")
    public void newClass(@PipeIn InputStream in, @Option(required=false, help="the package in which to build this Class", description="source package", type=PromptType.JAVA_PACKAGE, name="package") String pckg, String ... def) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaClass jc = null;
        if (def != null) {
            String classDef = Strings.join(Arrays.asList(def), (String)" ");
            jc = (JavaClass)JavaParser.parse(JavaClass.class, (String)classDef);
        } else if (in != null) {
            jc = (JavaClass)JavaParser.parse(JavaClass.class, (InputStream)in);
        } else {
            throw new RuntimeException("arguments required");
        }
        if (pckg != null) {
            jc.setPackage(pckg);
        }
        if (!jc.hasSyntaxErrors()) {
            java.saveJavaSource((JavaSource)jc);
        } else {
            this.writer.println(ShellColor.RED, "Syntax Errors:");
            for (SyntaxError error : jc.getSyntaxErrors()) {
                this.writer.println(error.toString());
            }
            this.writer.println();
            if (this.prompt.promptBoolean("Your class has syntax errors, create anyway?", true)) {
                java.saveJavaSource((JavaSource)jc);
            }
        }
        this.pickUp.fire((Object)new PickupResource((Resource)java.getJavaResource((JavaSource)jc)));
    }

    @Command(value="new-enum-type")
    public void newEnumType(@PipeIn InputStream in, @Option(required=false, help="the package in which to build this Class", description="source package", type=PromptType.JAVA_PACKAGE, name="package") String pckg, String ... def) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaEnum je = null;
        if (def != null) {
            String classDef = Strings.join(Arrays.asList(def), (String)" ");
            je = (JavaEnum)JavaParser.parse(JavaEnum.class, (String)classDef);
        } else if (in != null) {
            je = (JavaEnum)JavaParser.parse(JavaEnum.class, (InputStream)in);
        } else {
            throw new RuntimeException("arguments required");
        }
        if (pckg != null) {
            je.setPackage(pckg);
        }
        if (!je.hasSyntaxErrors()) {
            java.saveEnumTypeSource(je);
        } else {
            this.writer.println(ShellColor.RED, "Syntax Errors:");
            for (SyntaxError error : je.getSyntaxErrors()) {
                this.writer.println(error.toString());
            }
            this.writer.println();
            if (this.prompt.promptBoolean("Your class has syntax errors, create anyway?", true)) {
                java.saveEnumTypeSource(je);
            }
        }
        this.pickUp.fire((Object)new PickupResource((Resource)java.getEnumTypeResource(je)));
    }

    @Command(value="new-enum-const")
    @RequiresResource(value={JavaResource.class})
    public void newEnumConst(@PipeIn String in, PipeOut out, String ... def) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        String enumConstDef = null;
        if (def != null) {
            enumConstDef = Strings.join(Arrays.asList(def), (String)" ");
        } else if (in != null) {
            enumConstDef = in;
        } else {
            throw new RuntimeException("arguments required");
        }
        JavaEnum source = (JavaEnum)this.resource.getJavaSource();
        source.addEnumConstant(enumConstDef);
        java.saveEnumTypeSource(source);
    }

    @Command(value="list-imports")
    @RequiresResource(value={JavaResource.class})
    public void listImports(PipeOut out) throws FileNotFoundException {
        List imports = this.resource.getJavaSource().getImports();
        for (Import i : imports) {
            String str = "import " + (i.isStatic() ? "static " : "") + i.getQualifiedName() + ";";
            str = JavaColorizer.format((ShellPrintWriter)out, (String)str);
            out.println(str);
        }
    }

    @Command(value="new-field")
    @RequiresResource(value={JavaResource.class})
    public void newField(@PipeIn String in, PipeOut out, String ... def) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        String fieldDef = null;
        if (def != null) {
            fieldDef = Strings.join(Arrays.asList(def), (String)" ");
        } else if (in != null) {
            fieldDef = in;
        } else {
            throw new RuntimeException("arguments required");
        }
        JavaSource source = this.resource.getJavaSource();
        if (source instanceof FieldHolder) {
            FieldHolder clazz = (FieldHolder)source;
            String name = ((JavaClass)JavaParser.parse(JavaClass.class, (String)"public class Temp{}")).addField(fieldDef).getName();
            if (clazz.hasField(name)) {
                throw new IllegalStateException("Field named [" + name + "] already exists.");
            }
            clazz.addField(fieldDef);
            java.saveJavaSource(source);
        }
    }

    @Command(value="new-method")
    @RequiresResource(value={JavaResource.class})
    public void newMethod(@PipeIn String in, PipeOut out, String ... def) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        String methodDef = null;
        if (def != null) {
            methodDef = Strings.join(Arrays.asList(def), (String)" ");
        } else if (in != null) {
            methodDef = in;
        } else {
            throw new RuntimeException("arguments required");
        }
        JavaSource source = this.resource.getJavaSource();
        if (source instanceof MethodHolder) {
            MethodHolder clazz = (MethodHolder)source;
            Method method = ((JavaClass)JavaParser.parse(JavaClass.class, (String)"public class Temp{}")).addMethod(methodDef);
            if (clazz.hasMethodSignature(method)) {
                throw new IllegalStateException("Method with signature [" + method.toSignature() + "] already exists.");
            }
            clazz.addMethod(methodDef);
            java.saveJavaSource(source);
        }
    }
}

