/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types;

import java.util.Hashtable;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.DataType;
import org.jboss.ant.util.LoggerUtil;
import org.jboss.ant.util.ObjectUtil;

public abstract class AbstractDataType
extends DataType
implements DynamicAttribute {
    protected LoggerUtil.Logger log;
    private String id;
    private Hashtable attributes = new Hashtable();
    private boolean validated = false;

    public AbstractDataType() {
        this.log = new LoggerUtil.Logger((ProjectComponent)this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.getId();
    }

    public void setName(String id) {
        this.setId(id);
    }

    public void validate() {
        if (!this.validated) {
            this.validated = true;
            this.doValidate();
        }
    }

    public String toShortString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ObjectUtil.getObjectId((Object)this));
        buffer.append('{');
        this.appendIdentity(buffer);
        buffer.append("}");
        return buffer.toString();
    }

    public String getDynamicAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void setDynamicAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        ObjectUtil.appendObjectId(buffer, (Object)this);
        buffer.append('{');
        this.toString(buffer);
        buffer.append('}');
        return buffer.toString();
    }

    protected AbstractDataType resolve(String context, String refid, Class clazz) {
        if (refid == null) {
            throw new BuildException(context + " not set for " + this.toShortString());
        }
        Object object = this.getProject().getReference(refid);
        if (object == null) {
            throw new BuildException(context + " not found for " + this.toShortString() + " with refid " + refid);
        }
        if (!clazz.isInstance(object)) {
            throw new BuildException(refid + " for " + context + " is not the correct type " + object.getClass().getName());
        }
        return (AbstractDataType)((Object)object);
    }

    protected abstract void doValidate();

    protected void validate(List vector) {
        for (int i = 0; i < vector.size(); ++i) {
            AbstractDataType type = (AbstractDataType)((Object)vector.get(i));
            type.validate();
        }
    }

    protected void appendIdentity(StringBuffer buffer) {
        buffer.append("id=").append(this.id);
    }

    protected void toString(StringBuffer buffer) {
        buffer.append("id=").append(this.id);
        if (this.attributes.size() != 0) {
            buffer.append(" atts=").append(this.attributes);
        }
    }
}

